/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.proto;

import android.os.SystemClock;
import com.squareup.wire.AndroidMessage;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.websocket.WsClient;
import com.yy.base.utils.SettingFlagBaseKeys;
import com.yy.hiyo.proto.IMonitor;
import com.yy.hiyo.proto.WsCIMRequest;
import com.yy.hiyo.proto.WsRequest;
import common.Header;
import ikxd.cproxy.InnerV2;
import ikxd.cproxy.Uri;

public class ProtoMonitor {
    private static final String TAG = "ProtoMonitor";
    private static volatile IMonitor mMonitor;

    public static void setMonitor(IMonitor monitor) {
        mMonitor = monitor;
    }

    private static boolean needMonitor(String sName, int uri) {
        return (!"ikxd_cproxy_d".equals(sName) || uri != Uri.kUriHeartbeatReq.getValue()) && (!"ikxd_room_d".equals(sName) || uri != Uri.kUriHeartbeatReq.getValue());
    }

    static void monitorRequest(long seqId, int requestLength, String wsUrl, String sName, String sMethod, int uri, long queueSize, AndroidMessage proto) {
        if (!ProtoMonitor.needMonitor(sName, uri)) {
            return;
        }
        IMonitor monitor = mMonitor;
        if (monitor != null) {
            monitor.onRequestStart(seqId, requestLength, wsUrl, sName, sMethod, uri, queueSize, proto);
        }
    }

    static void onHttpRpcRequestStart(String roomId, String url, String protoServiceName, String method, AndroidMessage proto) {
        IMonitor monitor = mMonitor;
        if (monitor != null) {
            monitor.onHttpRpcRequestStart(roomId, url, protoServiceName, method, proto);
        }
    }

    static void monitorResponse(String sName, int uri, long seqId, int size) {
        if (!ProtoMonitor.needMonitor(sName, uri)) {
            return;
        }
        IMonitor monitor = mMonitor;
        if (monitor != null) {
            monitor.onResponse(seqId, size);
        }
    }

    static void monitorTimeout(String sName, int uri, long seqId) {
        if (!ProtoMonitor.needMonitor(sName, uri)) {
            return;
        }
        IMonitor monitor = mMonitor;
        if (monitor != null) {
            monitor.onTimeout(seqId);
        }
    }

    static void monitorError(String sName, int uri, long seqId, String reason, int code) {
        if (!ProtoMonitor.needMonitor(sName, uri)) {
            return;
        }
        IMonitor monitor = mMonitor;
        if (monitor != null) {
            monitor.onError(seqId, reason, code);
        }
    }

    static void monitorNotify(String wsUrl, byte[] bytes, Header header) {
        IMonitor monitor = mMonitor;
        if (monitor != null) {
            monitor.onNotify(wsUrl, header.sname, bytes != null ? bytes.length : 0);
        }
    }

    static void monitorMsgConsumeTime(String reasonStatStr, WsRequest request) {
        IMonitor monitor = mMonitor;
        InnerV2 inner = null;
        if (RuntimeContext.sIsDebuggable && request != null && (inner = request.inner) != null) {
            request.statKey = request.statKey + reasonStatStr;
            long consume = System.currentTimeMillis() - request.time;
            if (consume > 1000L && monitor != null) {
                Header header = inner.header;
                if (header != null) {
                    monitor.onMsgConsumeTime(request.seqId, header.sname, inner.uri != null ? inner.uri : 0, consume, request.retryCount, request.statKey);
                } else {
                    monitor.onMsgConsumeTime(request.seqId, "", -1, consume, request.retryCount, request.statKey);
                }
            }
        }
    }

    static void monitorMsgConsumeTime(String reasonStatStr, WsCIMRequest request) {
        IMonitor monitor = mMonitor;
        InnerV2 inner = null;
        if (RuntimeContext.sIsDebuggable && request != null && (inner = request.inner) != null) {
            request.statKey = request.statKey + reasonStatStr;
            long consume = System.currentTimeMillis() - request.time;
            if (consume > 1000L && monitor != null) {
                Header header = inner.header;
                if (header != null) {
                    monitor.onMsgConsumeTime(request.seqId, header.sname, inner.uri != null ? inner.uri : 0, consume, request.retryCount, request.statKey);
                } else {
                    monitor.onMsgConsumeTime(request.seqId, "", -1, consume, request.retryCount, request.statKey);
                }
            }
        }
    }

    static void monitorResponseTimeGap(long receiveTime, InnerV2 inner) {
        if (inner == null || inner.header == null) {
            return;
        }
        Header header = inner.header;
        long seqId = header.seqid;
        if (RuntimeContext.sIsDebuggable) {
            long consumeTime = SystemClock.uptimeMillis() - receiveTime;
            MLog.info((Object)TAG, (String)"response execute: %s receive time:%s consume time:%s", (Object[])new Object[]{String.valueOf(seqId), String.valueOf(receiveTime), String.valueOf(consumeTime)});
            if (mMonitor != null) {
                mMonitor.onResponseTimeGap(seqId, header.sname, inner.uri, consumeTime);
            }
        }
    }

    static void monitorResponseExecuteTime(long startTime, InnerV2 inner) {
        if (inner == null || inner.header == null) {
            return;
        }
        Header header = inner.header;
        if (RuntimeContext.sIsDebuggable || RuntimeContext.isInGray() && SettingFlagBaseKeys.isNormalMetricSwitchOn()) {
            long consumeTime = SystemClock.uptimeMillis() - startTime;
            if (consumeTime > 300L && mMonitor != null) {
                mMonitor.onResponseExcuteTime(header.seqid, header.sname, inner.uri, consumeTime);
            }
            MLog.info((Object)TAG, (String)"response execute time:%s", (Object[])new Object[]{String.valueOf(consumeTime)});
        }
    }

    static void onCheckOutExe(long consume, String lastTimeoutCheckStr) {
        if (mMonitor != null) {
            mMonitor.onCheckOutExe((int)consume, lastTimeoutCheckStr);
        }
    }

    static boolean isEnableWsClientBackgroundReconnect(WsClient socket, String wsUrl) {
        if (mMonitor != null) {
            return mMonitor.isEnableWsClientBackgroundReconnect(socket, wsUrl);
        }
        return false;
    }
}

