/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.proto;

import android.content.Context;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.squareup.wire.ProtoAdapter;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.websocket.WsClient;
import com.yy.base.okhttp.websocket.ws.RpcStat;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.SingleToastUtil;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.VersionUtil;
import com.yy.hiyo.proto.AbsProtoDispatch;
import com.yy.hiyo.proto.IDispatchCallback;
import com.yy.hiyo.proto.IProtoInnerCallback;
import com.yy.hiyo.proto.ProtoExtendDelegate;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.ProtoMonitor;
import com.yy.hiyo.proto.ProtoUtils;
import com.yy.hiyo.proto.RouteTransmission;
import com.yy.hiyo.proto.WsRequest;
import com.yy.hiyo.proto.metric.MetricData;
import com.yy.hiyo.proto.rpc.RpcMethod;
import common.Detail;
import common.DetailTypeURI;
import common.Header;
import common.Response;
import common.Result;
import ikxd.cproxy.InnerV2;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import okio.ByteString;

public class ProtoDispatchRpc
extends AbsProtoDispatch {
    private static final String TAG = "ProtoDispatchRpc";
    private final Map<Long, WsRequest> mRequestMap = new Hashtable<Long, WsRequest>();

    <REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> void send(final String wsUrl, final REQ proto, final @Nullable IProtoInnerCallback<RES> callback, final RpcMethod<REQ, RES> rpcMethod) {
        if (YYTaskExecutor.isMainThread()) {
            this.mDispatchCallback.execute(new Runnable(){

                @Override
                public void run() {
                    ProtoDispatchRpc.this.sendAsync(wsUrl, "", proto, callback, rpcMethod);
                }
            }, 0L);
        } else {
            this.sendAsync(wsUrl, "", proto, callback, rpcMethod);
        }
    }

    <REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> void send(final String wsUrl, final String roomId, final REQ proto, final @Nullable IProtoInnerCallback<RES> callback, final RpcMethod<REQ, RES> rpcMethod) {
        if (YYTaskExecutor.isMainThread()) {
            this.mDispatchCallback.execute(new Runnable(){

                @Override
                public void run() {
                    ProtoDispatchRpc.this.sendAsync(wsUrl, roomId, proto, callback, rpcMethod);
                }
            }, 0L);
        } else {
            this.sendAsync(wsUrl, roomId, proto, callback, rpcMethod);
        }
    }

    @Override
    public int getCurTaskSize() {
        return this.mRequestMap.size();
    }

    @Override
    protected boolean onResend(WsClient wsClient, WsRequest request) {
        InnerV2 innerV2;
        if (request == null || (innerV2 = request.inner) == null) {
            MLog.error((Object)TAG, (String)"onResend error, request == null: %b", (Object[])new Object[]{request == null});
            return false;
        }
        InnerV2.Builder builder = innerV2.newBuilder();
        long newSeqId = ProtoUtils.uniqueSeq();
        Header newHeader = innerV2.header.newBuilder().seqid(newSeqId).build();
        boolean success = this.setHeaderReflect(builder, newHeader);
        if (success) {
            long oldSeqId = request.seqId;
            request.seqId = newSeqId;
            request.inner = (InnerV2)builder.build();
            request.setData(request.inner.encode());
            this.removeAndUpdate(oldSeqId, request);
        }
        return wsClient.send(request.getData());
    }

    private <REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> void sendAsync(String wsUrl, String roomId, REQ proto, @Nullable IProtoInnerCallback<RES> callback, RpcMethod<REQ, RES> rpcMethod) {
        WsClient wsClient = this.mDispatchCallback.getWsClient(wsUrl);
        if (wsClient == null) {
            MLog.warn((Object)TAG, (String)"sendAsync ws maybe not connect", (Object[])new Object[0]);
            if (RuntimeContext.sIsDebuggable) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"\u957f\u8fde\u63a5\u53ef\u80fd\u8fd8\u672a\u8fde\u63a5\u6210\u529f\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u65f6\u673a", (int)0);
                MLog.error((Object)TAG, (String)"send web socket before connect", (Throwable)new Throwable(), (Object[])new Object[0]);
            }
            if (callback != null) {
                callback.retryWhenError(false, "ws maybe not connect", -1);
            }
            return;
        }
        Header.Builder headerBuilder = ProtoUtils.getHeaderBuilder(rpcMethod.sName, true).method(rpcMethod.methodName).roomid(roomId == null ? "" : roomId);
        String pcid = ProtoExtendDelegate.getPcid();
        if (StringUtils.isNotEmpty((String)pcid)) {
            HashMap<String, ByteString> extend = new HashMap<String, ByteString>(1);
            extend.put("X-Pcid", ByteString.encodeUtf8((String)pcid));
            headerBuilder.extend(extend);
        }
        Header header = headerBuilder.build();
        InnerV2 innerV2 = new InnerV2.Builder().header(headerBuilder.build()).payload(ByteString.of((byte[])proto.encode())).build();
        MLog.debug((Object)TAG, (String)"proto rpc sendAsync inner: %s", (Object[])new Object[]{ProtoUtils.innerString(innerV2)});
        byte[] bs = innerV2.encode();
        long seqId = header.seqid;
        ProtoMonitor.monitorRequest(seqId, bs.length, wsUrl, header.sname, header.method, innerV2.uri == null ? 0 : innerV2.uri, wsClient.queueSize(), proto);
        WsRequest request = WsRequest.obtain();
        request.wsUrl = wsUrl;
        request.wsQueueLength = wsClient.queueLength();
        request.seqId = seqId;
        request.callback = callback;
        request.setData(bs);
        request.proto = proto;
        request.time = System.currentTimeMillis();
        request.inner = innerV2;
        request.rpcMethod = rpcMethod;
        MLog.debug((Object)TAG, (String)"proto rpc sendAsync inner request: %s", (Object[])new Object[]{request.proto});
        this.addRequest(seqId, request);
        boolean resendSuccess = wsClient.send(bs);
        if (resendSuccess && request.firstSendTime <= 0L) {
            request.firstSendTime = request.time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void onResponse(String wsUrl, @NonNull byte[] resData, @NonNull InnerV2 inner, int originSize, long networkRt) {
        InnerV2 reqInner;
        if (RuntimeContext.sIsDebuggable && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"proto rpc onResponse inner: %s", (Object[])new Object[]{ProtoUtils.innerString(inner)});
        }
        long receiveTime = -1L;
        if (RuntimeContext.sIsDebuggable) {
            receiveTime = SystemClock.uptimeMillis();
        }
        long fReceiveTime = receiveTime;
        Header header = inner.header;
        if (header == null) {
            return;
        }
        super.onResponse(wsUrl, resData, inner, originSize, networkRt);
        if (header.code != 0L) {
            MLog.error((Object)TAG, (String)"code: %d, some error in service, inner: %s, tid:%s", (Object[])new Object[]{header.code, ProtoUtils.innerString(inner), header.tid});
            long seqId = header.seqid;
            WsRequest request = this.mRequestMap.get(seqId);
            boolean remove = this.checkoutRetryWhenError(true, request, "some error in service", FP.orInt((Long)header.code));
            if (request == null || !remove) return;
            this.mRequestMap.remove(seqId);
            request.recycle();
            return;
        }
        WsRequest request = this.removeRequest(this.mRequestMap, header.seqid, " response");
        if (request != null && request.callback != null && header.msgtype == Header.MSGTYPE.MSGTYPE_RESP && (reqInner = request.inner) != null && reqInner.header != null && header.method.equals(reqInner.header.method) && header.sname.equals(reqInner.header.sname)) {
            try {
                RouteTransmission.setCproxyRoutingKey(header.sname, header.routing_key);
                ProtoAdapter adapter = ProtoUtils.getResProtoAdapter(request.proto);
                AndroidMessage response = null;
                byte[] payload = inner.payload.toByteArray();
                if (adapter != null) {
                    response = ProtoUtils.parseBytes(adapter, payload);
                }
                if (ProtoUtils.isResultRes(request.rpcMethod)) {
                    Response resultRes = ProtoUtils.parseBytes(Response.ADAPTER, payload);
                    MLog.debug((Object)TAG, (String)ProtoUtils.resultString(resultRes), (Object[])new Object[0]);
                    if (ProtoUtils.isResultLegal(resultRes)) {
                        MetricData metricData = MetricData.buildMetricData(request.time, resData.length, request.length, networkRt, System.currentTimeMillis(), request.wsQueueLength, request.retryCount);
                        this.responseCallback(inner, response, resultRes.result, request.callback, metricData, request.proto);
                    } else {
                        MLog.info((Object)TAG, (String)"parse error,  response: %s ", (Object[])new Object[]{new String(resData)});
                        String msg = "\u54cd\u5e94result\u975e\u6cd5,\u5d29\u6e83\uff0c\u627e\u540e\u53f0\u68c0\u67e5\u3002sName: " + header.sname + ", methodName: " + header.method;
                        MLog.error((Object)TAG, (String)msg, (Object[])new Object[0]);
                        this.onRetryWhenError(request.callback, header.sname, reqInner.uri, request.seqId, false, msg, -1, System.currentTimeMillis() - request.time, request.retryCount, header.method);
                    }
                } else {
                    MetricData metricData = MetricData.buildMetricData(request.time, resData.length, request.length, networkRt, System.currentTimeMillis(), request.wsQueueLength, request.retryCount);
                    this.responseCallback(inner, response, null, request.callback, metricData, request.proto);
                }
                ProtoMonitor.monitorResponseTimeGap(fReceiveTime, inner);
                return;
            }
            catch (Exception e) {
                String sName = "";
                int uri = 0;
                if (reqInner.header != null) {
                    sName = reqInner.header.sname;
                    uri = reqInner.uri;
                }
                this.onRetryWhenError(request.callback, sName, uri, request.seqId, false, "parse proto failed", -1, System.currentTimeMillis() - request.time, request.retryCount, header.method);
                MLog.error((Object)TAG, (Throwable)e);
                if (!RuntimeContext.sIsDebuggable) return;
                throw e;
            }
            finally {
                request.recycle();
            }
        } else if (request != null) {
            String msg = StringUtils.formatWitUSLocal((String)"onResponse same seqId but header or sname or method not equals. request.inner: %s \n response.inner: %s", (Object[])new Object[]{ProtoUtils.innerString(request.inner), ProtoUtils.innerString(inner)});
            if (RuntimeContext.sIsDebuggable) {
                throw new IllegalStateException(msg);
            }
            MLog.error((Object)TAG, (String)msg, (Object[])new Object[0]);
            if (request.callback != null) {
                this.onSomeError(true, msg, FP.orInt((Long)header.code));
            }
            request.recycle();
            return;
        } else {
            MLog.info((Object)TAG, (String)"response timeout response.inner: %s", (Object[])new Object[]{ProtoUtils.innerString(inner)});
        }
    }

    private <RES extends AndroidMessage<RES, ?>> void responseCallback(InnerV2 inner, RES response, @Nullable Result result, IProtoInnerCallback<RES> callback, MetricData metricData, Object req) {
        if (callback == null) {
            return;
        }
        if (VersionUtil.isLocalDevBuild() && result != null && result.errcode != 0L) {
            SingleToastUtil.showToast((Context)RuntimeContext.sApplicationContext, (String)("ErrMsg:" + result.errmsg + " ErrCode: " + result.errcode));
        }
        long handleEndTime = System.currentTimeMillis() - metricData.startTime;
        Runnable callbackRunnable = () -> {
            long tempStartTime;
            block8: {
                tempStartTime = -1L;
                if (RuntimeContext.sIsDebuggable) {
                    tempStartTime = SystemClock.uptimeMillis();
                }
                if (response == null) {
                    this.onRetryWhenError(callback, inner.header.sname, inner.uri, inner.header.seqid, false, "parse proto failed", -100000, handleEndTime, metricData.retryTimes, inner.header.method);
                    metricData.recycle();
                    MLog.error((Object)TAG, (String)"response null, sname:%s, seqid:%s", (Object[])new Object[]{inner.header.sname, String.valueOf(inner.header.method)});
                } else {
                    this.statAndMetricReport(inner, handleEndTime, metricData.sendSize, metricData.contentLength, metricData.retryTimes, result);
                    try {
                        if (result == null) {
                            callback.onResponse(response, metricData);
                        } else {
                            if (this.mDispatchCallback != null && this.mDispatchCallback.getResponseInterceptor() != null) {
                                this.mDispatchCallback.getResponseInterceptor().interceptWsOnResponse(response, result.errcode, req);
                            }
                            callback.onResponse(response, result.errcode, this.paresResultMsgTip(result), metricData);
                        }
                    }
                    catch (Exception e) {
                        MLog.error((Object)TAG, (Throwable)e);
                        if (!RuntimeContext.sIsDebuggable) break block8;
                        throw e;
                    }
                }
            }
            ProtoMonitor.monitorResponseExecuteTime(tempStartTime, inner);
        };
        if (YYTaskExecutor.isMainThread()) {
            callbackRunnable.run();
        } else {
            YYTaskExecutor.postToMainThread((Runnable)callbackRunnable);
        }
    }

    private void statAndMetricReport(InnerV2 inner, long useTime, int sendSize, int receiveSize, int retryTimes, Result result) {
        boolean success;
        long errorCode = -1L;
        if (result == null) {
            success = true;
        } else {
            success = ProtoManager.isSuccessCode(result.errcode);
            errorCode = result.errcode;
        }
        if (inner != null) {
            Header header = inner.header;
            if (header != null && success) {
                ProtoMonitor.monitorResponse(header.sname, inner.uri, header.seqid, receiveSize);
                RpcStat.statRpcSuccess((String)header.sname, (String)(header.method + inner.uri), (long)useTime, (int)sendSize, (int)receiveSize, (int)retryTimes);
            } else if (header != null) {
                ProtoMonitor.monitorError(header.sname, inner.uri, header.seqid, "", (int)errorCode);
                RpcStat.statRpcFail((String)header.sname, (String)(header.method + inner.uri), (long)useTime, (String)("result code " + errorCode), (int)retryTimes, (int)96);
            }
        }
    }

    @Override
    @NonNull
    protected Map<Long, WsRequest> getRequestMap() {
        return this.mRequestMap;
    }

    private void addRequest(Long key, WsRequest request) {
        if (RuntimeContext.sIsDebuggable) {
            request.statKey = request.statKey + " add";
        }
        this.mRequestMap.put(key, request);
    }

    protected ProtoDispatchRpc(IDispatchCallback callback) {
        super(callback);
    }

    private void removeAndUpdate(long oldSeqId, WsRequest request) {
        this.mRequestMap.remove(oldSeqId);
        this.mRequestMap.put(request.seqId, request);
    }

    private String paresResultMsgTip(@Nullable Result result) {
        if (result == null) {
            return "";
        }
        if (StringUtils.isNotEmpty((String)result.errmsg) || result.errcode > 0L) {
            MLog.info((Object)TAG, (String)"paraseResultMsgTip errmsg:%s,  ErrCode:%d", (Object[])new Object[]{result.errmsg, result.errcode});
            MLog.debug((Object)TAG, (String)"paraseResultMsgTip result.details:%s", (Object[])new Object[]{result.details});
        }
        for (Detail detail : result.details) {
            MLog.debug((Object)TAG, (String)"paraseResultMsgTip detail.type_uri:%d", (Object[])new Object[]{detail.type_uri});
            if (DetailTypeURI.DETAIL_TYPE_URI_LOCALIZE_MESSAGE.getValue() != detail.type_uri.intValue()) continue;
            MLog.info((Object)TAG, (String)"paraseResultMsgTip msgTip:%s", (Object[])new Object[]{detail.localize_message.message});
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)detail.localize_message.message, (int)0);
            return detail.localize_message.message;
        }
        return "";
    }
}

