/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.proto;

import android.os.SystemClock;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IFrequencyLimitExecutor;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.hiyo.proto.notify.INotifyMonitor;
import com.yy.hiyo.proto.notify.NotifyData;
import ikxd.cproxy.InnerV2;
import java.util.ArrayList;
import java.util.List;

public class OneNotifyFrequencyHandler {
    private static IQueueTaskExecutor sQueueTaskExecutor = YYTaskExecutor.createAQueueExcuter((boolean)true);
    private String tag;
    protected INotifySender notifySender;
    private IFrequencyLimitExecutor frequencyLimitExecutor;
    private final ArrayList<NotifyData> notifys = new ArrayList();
    private ArrayList<NotifyData> notifysCopy = new ArrayList();
    private Runnable command;
    private ArrayList<NotifyData> oneSecondCacheNotifys;
    private long lastSecondStart = 0L;
    private String serviceName;
    private int uri = -1;

    public OneNotifyFrequencyHandler(String name, int uri, INotifySender notifySender, long time) {
        this.notifySender = notifySender;
        this.frequencyLimitExecutor = YYTaskExecutor.createAFrequencyLimitExecut((long)time, (IQueueTaskExecutor)sQueueTaskExecutor);
        this.tag = uri >= 0 ? "NotifyFrequency_" + name + "_" + uri : "NotifyFrequency_" + name;
        this.serviceName = name;
        this.uri = uri;
        MLog.info((Object)this.tag, (String)"frequencyTime:%s", (Object[])new Object[]{String.valueOf(time)});
        if (notifySender == null) {
            throw new RuntimeException("notifySender can not be null!");
        }
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public int getUri() {
        return this.uri;
    }

    public void updateTime(long time) {
        this.frequencyLimitExecutor.updateTime(time);
        MLog.info((Object)this.tag, (String)"updateTime:%s", (Object[])new Object[]{String.valueOf(time)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotify(final InnerV2 innerV2, byte[] payload) {
        ArrayList<NotifyData> arrayList = this.notifys;
        synchronized (arrayList) {
            if (this.notifySender.isReplaceable(this.serviceName, this.uri)) {
                for (NotifyData item : this.notifys) {
                    if (item.innerV2().uri != innerV2.uri || !StringUtils.equal((String)innerV2.header.sname, (String)item.innerV2().header.sname)) continue;
                    this.notifys.remove(item);
                    MLog.info((Object)this.tag, (String)"remove dumplite item:%d, seqid:%d", (Object[])new Object[]{innerV2.uri, innerV2.header.seqid});
                    break;
                }
            }
            this.notifys.add(new NotifyData(innerV2, payload));
            if (this.lastSecondStart == 0L && this.notifySender.isNeedStatCacheExceedNumLimit()) {
                this.lastSecondStart = SystemClock.elapsedRealtime();
            }
            if (SystemUtils.isShowEnvSetting()) {
                if (this.notifys.size() > 1) {
                    MLog.info((Object)this.tag, (String)"cache size:%d, uri:%d", (Object[])new Object[]{this.notifys.size(), innerV2.uri, innerV2.header.seqid});
                } else {
                    MLog.info((Object)this.tag, (String)"cache size above one:%d, uri:%d", (Object[])new Object[]{this.notifys.size(), innerV2.uri, innerV2.header.seqid});
                }
            }
        }
        if (this.command == null) {
            this.command = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ArrayList arrayList = OneNotifyFrequencyHandler.this.notifys;
                    synchronized (arrayList) {
                        OneNotifyFrequencyHandler.this.notifysCopy.clear();
                        OneNotifyFrequencyHandler.this.notifysCopy.addAll(OneNotifyFrequencyHandler.this.notifys);
                        OneNotifyFrequencyHandler.this.notifys.clear();
                    }
                    List<NotifyData> notifyDataToHandler = OneNotifyFrequencyHandler.this.notifySender.intercept(OneNotifyFrequencyHandler.this.notifysCopy);
                    if (notifyDataToHandler != null && notifyDataToHandler.size() > 0) {
                        if (notifyDataToHandler.size() > 1 && OneNotifyFrequencyHandler.this.notifySender.canNotifyList(OneNotifyFrequencyHandler.this.serviceName, OneNotifyFrequencyHandler.this.uri)) {
                            int forceClearNum = OneNotifyFrequencyHandler.this.notifySender.getForceClearThreshold(OneNotifyFrequencyHandler.this.serviceName, OneNotifyFrequencyHandler.this.uri);
                            if (notifyDataToHandler.size() > forceClearNum) {
                                notifyDataToHandler = notifyDataToHandler.subList(notifyDataToHandler.size() - forceClearNum, notifyDataToHandler.size());
                            }
                            OneNotifyFrequencyHandler.this.notifySender.notify(OneNotifyFrequencyHandler.this.serviceName, notifyDataToHandler);
                        } else if (SystemUtils.isShowEnvSetting() && OneNotifyFrequencyHandler.this.notifySender.canNotifyList(OneNotifyFrequencyHandler.this.serviceName, OneNotifyFrequencyHandler.this.uri)) {
                            OneNotifyFrequencyHandler.this.notifySender.notify(OneNotifyFrequencyHandler.this.serviceName, notifyDataToHandler);
                        } else {
                            for (NotifyData item : notifyDataToHandler) {
                                OneNotifyFrequencyHandler.this.notifySender.notify(item.innerV2(), item.payload());
                            }
                        }
                    }
                    if (OneNotifyFrequencyHandler.this.notifySender.isNeedStatCacheExceedNumLimit()) {
                        long curTime = SystemClock.elapsedRealtime();
                        if (OneNotifyFrequencyHandler.this.oneSecondCacheNotifys == null) {
                            OneNotifyFrequencyHandler.this.oneSecondCacheNotifys = new ArrayList();
                        }
                        OneNotifyFrequencyHandler.this.oneSecondCacheNotifys.addAll(OneNotifyFrequencyHandler.this.notifysCopy);
                        if (curTime - OneNotifyFrequencyHandler.this.lastSecondStart > 1000L) {
                            OneNotifyFrequencyHandler.this.lastSecondStart = curTime;
                            int size = OneNotifyFrequencyHandler.this.oneSecondCacheNotifys.size();
                            if (size >= OneNotifyFrequencyHandler.this.notifySender.getCacheNumLimit(innerV2.header.sname)) {
                                MLog.info((Object)OneNotifyFrequencyHandler.this.tag, (String)"cacheExceedNumLimit:%d!", (Object[])new Object[]{size});
                                OneNotifyFrequencyHandler.this.notifySender.onCacheExceedNumLimit(innerV2.header.sname, size, OneNotifyFrequencyHandler.this.obtainUris(OneNotifyFrequencyHandler.this.oneSecondCacheNotifys));
                            }
                            OneNotifyFrequencyHandler.this.oneSecondCacheNotifys.clear();
                        }
                    }
                    OneNotifyFrequencyHandler.this.notifysCopy.clear();
                }
            };
        }
        this.frequencyLimitExecutor.execute(this.command);
    }

    private List<Integer> obtainUris(ArrayList<NotifyData> notifys) {
        ArrayList<Integer> uris = new ArrayList<Integer>(notifys.size());
        for (NotifyData notifyData : notifys) {
            uris.add(notifyData.innerV2().uri);
        }
        return uris;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNotifyNotHandler() {
        ArrayList<NotifyData> arrayList = this.notifys;
        synchronized (arrayList) {
            return this.notifys.size() > 0;
        }
    }

    public static interface INotifySender
    extends INotifyMonitor {
        public void notify(InnerV2 var1, byte[] var2);

        public void notify(String var1, List<NotifyData> var2);
    }
}

