/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.proto;

import android.content.Context;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.websocket.WsClient;
import com.yy.base.okhttp.websocket.ws.RpcStat;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ToastUtils;
import com.yy.hiyo.proto.AbsCIMProtoDispatch;
import com.yy.hiyo.proto.IDispatchCallback;
import com.yy.hiyo.proto.ProtoMonitor;
import com.yy.hiyo.proto.ProtoUtils;
import com.yy.hiyo.proto.WsCIMRequest;
import com.yy.hiyo.proto.callback.ICIMProtoCallback;
import com.yy.hiyo.proto.callback.ICIMProtoNotify;
import common.Header;
import ikxd.cproxy.InnerV2;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import okio.ByteString;

public class CIMProtoDispatchRpc
extends AbsCIMProtoDispatch {
    private static final String TAG = "CIMProtoDispatchRpc";
    private final Map<Long, WsCIMRequest> mRequestMap = new Hashtable<Long, WsCIMRequest>();
    private final Map<Integer, Set<ICIMProtoNotify>> mNotifyListeners = new ConcurrentHashMap<Integer, Set<ICIMProtoNotify>>();

    @Override
    protected boolean onResend(WsClient wsClient, WsCIMRequest request) {
        InnerV2 innerV2;
        if (request == null || (innerV2 = request.inner) == null) {
            MLog.error((Object)TAG, (String)"onResend error, request == null: %b", (Object[])new Object[]{request == null});
            return false;
        }
        InnerV2.Builder builder = innerV2.newBuilder();
        long newSeqId = ProtoUtils.uniqueSeq();
        Header newHeader = innerV2.header.newBuilder().seqid(newSeqId).build();
        boolean success = this.setHeaderReflect(builder, newHeader);
        if (success) {
            long oldSeqId = request.seqId;
            request.seqId = newSeqId;
            request.inner = (InnerV2)builder.build();
            request.setData(request.inner.encode());
            this.removeAndUpdate(oldSeqId, request);
        }
        return wsClient.send(request.getData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void onResponse(String wsUrl, @NonNull byte[] resData, @NonNull InnerV2 inner, int originSize) {
        InnerV2 reqInner;
        MLog.debug((Object)TAG, (String)"proto rpc onResponse inner: %s", (Object[])new Object[]{ProtoUtils.innerString(inner)});
        long receiveTime = -1L;
        if (RuntimeContext.sIsDebuggable) {
            receiveTime = SystemClock.uptimeMillis();
        }
        long fReceiveTime = receiveTime;
        Header header = inner.header;
        if (header == null) {
            return;
        }
        super.onResponse(wsUrl, resData, inner, originSize);
        if (header.code != 0L) {
            MLog.error((Object)TAG, (String)"code: %d, some error in service, inner: %s", (Object[])new Object[]{header.code, ProtoUtils.innerString(inner)});
            this.onSomeError(true, "some error in service", FP.orInt((Long)header.code));
            return;
        }
        WsCIMRequest request = this.removeRequest(this.mRequestMap, header.seqid, " response");
        if (request != null && request.callback != null && header.msgtype == Header.MSGTYPE.MSGTYPE_RESP && (reqInner = request.inner) != null && reqInner.header != null && header.method.equals(reqInner.header.method) && header.sname.equals(reqInner.header.sname)) {
            long useTime = System.currentTimeMillis() - request.time;
            try {
                byte[] response = inner.payload.toByteArray();
                ProtoMonitor.monitorResponseTimeGap(fReceiveTime, inner);
                this.responseCallback(inner, response, request.callback, useTime, request.length, originSize, request.retryCount);
            }
            catch (Exception e) {
                String sName = "";
                int uri = 0;
                if (reqInner.header != null) {
                    sName = reqInner.header.sname;
                    uri = reqInner.uri;
                }
                this.onRetryWhenError(request.callback, sName, uri, request.seqId, false, "parse proto failed", -1, useTime, request.retryCount, header.method);
                MLog.error((Object)TAG, (Throwable)e);
            }
            finally {
                request.recycle();
            }
        } else if (request != null) {
            request.recycle();
        }
    }

    private <RES> void responseCallback(InnerV2 inner, RES response, ICIMProtoCallback<RES> callback, long useTime, int sendSize, int receiveSize, int retryTimes) {
        if (callback == null) {
            return;
        }
        Runnable callbackRunnable = () -> {
            long startTime;
            block5: {
                startTime = -1L;
                if (RuntimeContext.sIsDebuggable) {
                    startTime = SystemClock.uptimeMillis();
                }
                if (response == null) {
                    this.onRetryWhenError(callback, inner.header.sname, inner.uri, inner.header.seqid, false, "parse proto failed", -1, useTime, retryTimes, inner.header.method);
                } else {
                    RpcStat.statRpcSuccess((String)inner.header.sname, (String)(inner.header.method + inner.uri), (long)useTime, (int)sendSize, (int)receiveSize, (int)retryTimes);
                    try {
                        callback.onResponse(response);
                    }
                    catch (Exception e) {
                        MLog.error((Object)TAG, (Throwable)e);
                        if (!RuntimeContext.sIsDebuggable) break block5;
                        throw e;
                    }
                }
            }
            ProtoMonitor.monitorResponseExecuteTime(startTime, inner);
        };
        if (YYTaskExecutor.isMainThread()) {
            callbackRunnable.run();
        } else {
            YYTaskExecutor.postToMainThread((Runnable)callbackRunnable);
        }
    }

    @Override
    @NonNull
    protected Map<Long, WsCIMRequest> getRequestMap() {
        return this.mRequestMap;
    }

    private void addRequest(Long key, WsCIMRequest request) {
        if (RuntimeContext.sIsDebuggable) {
            request.statKey = request.statKey + " add";
        }
        this.mRequestMap.put(key, request);
    }

    protected CIMProtoDispatchRpc(IDispatchCallback callback) {
        super(callback);
    }

    private void removeAndUpdate(long oldSeqId, WsCIMRequest request) {
        this.mRequestMap.remove(oldSeqId);
        this.mRequestMap.put(request.seqId, request);
    }

    void sendCIM(final String wsUrl, final String sName, final String methodName, final byte[] requestBytes, final @Nullable ICIMProtoCallback<byte[]> callback) {
        if (YYTaskExecutor.isMainThread()) {
            this.mDispatchCallback.execute(new Runnable(){

                @Override
                public void run() {
                    CIMProtoDispatchRpc.this.sendCIMAsync(wsUrl, sName, methodName, requestBytes, callback);
                }
            }, 0L);
        } else {
            this.sendCIMAsync(wsUrl, sName, methodName, requestBytes, callback);
        }
    }

    void sendCIMAsync(String wsUrl, String sName, String methodName, byte[] requestBytes, @Nullable ICIMProtoCallback<byte[]> callback) {
        WsClient wsClient = this.mDispatchCallback.getWsClient(wsUrl);
        if (wsClient == null) {
            MLog.warn((Object)TAG, (String)"sendCIMAsync ws maybe not connect", (Object[])new Object[0]);
            if (RuntimeContext.sIsDebuggable) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"\u957f\u8fde\u63a5\u53ef\u80fd\u8fd8\u672a\u8fde\u63a5\u6210\u529f\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u65f6\u673a", (int)0);
                MLog.error((Object)TAG, (String)"send web socket before connect", (Throwable)new Throwable(), (Object[])new Object[0]);
            }
            if (callback != null) {
                callback.retryWhenError(false, "ws maybe not connect", -1);
            }
            return;
        }
        Header.Builder headerBuilder = ProtoUtils.getHeaderBuilder(sName, true).method(methodName).roomid("");
        Header header = headerBuilder.build();
        InnerV2 innerV2 = new InnerV2.Builder().header(header).payload(ByteString.of((byte[])requestBytes)).build();
        if (RuntimeContext.sIsDebuggable) {
            MLog.debug((Object)TAG, (String)"proto rpc sendCIMAsync inner: %s", (Object[])new Object[]{ProtoUtils.innerString(innerV2)});
        }
        byte[] bs = innerV2.encode();
        long seqId = header.seqid;
        ProtoMonitor.monitorRequest(seqId, requestBytes.length, wsUrl, header.sname, header.method, innerV2.uri != null ? innerV2.uri : 0, wsClient.queueSize(), null);
        WsCIMRequest request = WsCIMRequest.obtain();
        request.wsUrl = wsUrl;
        request.seqId = seqId;
        request.callback = callback;
        request.proto = requestBytes;
        request.time = System.currentTimeMillis();
        request.inner = innerV2;
        request.setData(bs);
        this.addRequest(seqId, request);
        wsClient.send(bs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void registerCIMNotify(ICIMProtoNotify<T> notify) {
        if (notify == null) {
            return;
        }
        Map<Integer, Set<ICIMProtoNotify>> map = this.mNotifyListeners;
        synchronized (map) {
            Set<ICIMProtoNotify> listeners = this.mNotifyListeners.get(notify.uri());
            if (listeners == null) {
                listeners = new CopyOnWriteArraySet<ICIMProtoNotify>();
                this.mNotifyListeners.put(notify.uri(), listeners);
            }
            listeners.add(notify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void unregisterCIMNotify(ICIMProtoNotify<T> notify) {
        if (notify == null) {
            return;
        }
        Map<Integer, Set<ICIMProtoNotify>> map = this.mNotifyListeners;
        synchronized (map) {
            Set<ICIMProtoNotify> listeners = this.mNotifyListeners.get(notify.uri());
            if (listeners != null) {
                listeners.remove(notify);
            }
        }
    }

    void onNotify(final @NonNull InnerV2 innerV2, final byte[] payload) {
        if (RuntimeContext.isInGray()) {
            MLog.info((Object)TAG, (String)"on new cim msg notify (%s),", (Object[])new Object[]{ProtoUtils.innerString(innerV2)});
        }
        if (YYTaskExecutor.isMainThread()) {
            this.notifySafe(innerV2.uri != null ? innerV2.uri : 0, payload);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    CIMProtoDispatchRpc.this.notifySafe(innerV2.uri != null ? innerV2.uri : 0, payload);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySafe(int uri, Object msg) {
        ArrayList<ICIMProtoNotify> copys = new ArrayList<ICIMProtoNotify>();
        Map<Integer, Set<ICIMProtoNotify>> map = this.mNotifyListeners;
        synchronized (map) {
            Set<ICIMProtoNotify> tmp = this.mNotifyListeners.get(uri);
            if (tmp != null) {
                copys.addAll(tmp);
            }
        }
        for (ICIMProtoNotify listener : copys) {
            listener.onNotify(msg);
        }
    }
}

