/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.proto.callback;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SystemUtils;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;

public class SimpleProtoCallback<T extends AndroidMessage<?, ?>>
extends IProtoCallback<T> {
    private String TAG = "SimpleProtoCallback";
    private boolean mockDataIfError = false;

    public SimpleProtoCallback() {
    }

    public SimpleProtoCallback(String tag) {
        this(tag, false);
    }

    public SimpleProtoCallback(String tag, boolean mockDataIfError) {
        this.TAG = tag + " SimpleProtoCallback";
        this.mockDataIfError = mockDataIfError;
    }

    @Override
    public void onResponse(@Nullable T message) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)this.TAG, (String)"onResponse %s", (Object[])new Object[]{message});
        } else if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)this.TAG, (String)"onResponse!", (Object[])new Object[0]);
        }
    }

    @Override
    public void onResponse(@NonNull T res, long code, String msgTip) {
        if (SystemUtils.isShowEnvSetting()) {
            MLog.debug((Object)this.TAG, (String)"onResponse %s, code: %d, msg: %s", (Object[])new Object[]{res, code, msgTip});
        } else if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)this.TAG, (String)"onResponse code:%s, msgTip:%s!", (Object[])new Object[]{String.valueOf(code), msgTip != null ? msgTip : ""});
        }
    }

    @Override
    public boolean retryWhenTimeout(boolean canRetry) {
        YYTaskExecutor.postToMainThread(() -> {
            if (this.canMockData()) {
                this.doMock("retryWhenTimeout", -1);
            } else {
                this.onError("retryWhenTimeout", -1);
            }
        });
        return false;
    }

    @Override
    public boolean retryWhenError(boolean canRetry, String reason, int code) {
        YYTaskExecutor.postToMainThread(() -> {
            if (this.canMockData()) {
                this.doMock(reason, code);
            } else {
                this.onError("retryWhenError " + reason, code);
            }
        });
        return false;
    }

    public void onError(String reason, int code) {
        MLog.error((Object)this.TAG, (String)"onError reason: %s, code: %d", (Object[])new Object[]{reason, code});
    }

    protected boolean isSuccess(long code) {
        return ProtoManager.isSuccessCode(code);
    }

    private boolean canMockData() {
        return RuntimeContext.isLocalBuild() && this.mockDataIfError;
    }

    private void doMock(String reason, int code) {
        MLog.error((Object)this.TAG, (String)"doMock reason %s, code %d", (Object[])new Object[]{reason, code});
        T data = this.mock();
        if (data != null) {
            this.onResponse(data, 0L, "");
        } else {
            this.onError(reason, code);
        }
    }

    protected T mock() {
        return null;
    }
}

