/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.proto;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.logger.perf.PerfActionLog;
import com.yy.base.okhttp.OkHttpUtils;
import com.yy.base.okhttp.websocket.StatInitDelegate;
import com.yy.base.okhttp.websocket.WsClient;
import com.yy.base.okhttp.websocket.WsStatus;
import com.yy.base.okhttp.websocket.ws.RpcStat;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.grace.networkinterceptor.flowdispatcher.util.HostUtil;
import com.yy.hiyo.proto.GlobalBanInterface;
import com.yy.hiyo.proto.HttpRpcImp;
import com.yy.hiyo.proto.IHeartMonitor;
import com.yy.hiyo.proto.IProtoInnerCallback;
import com.yy.hiyo.proto.ProtoInnerImp;
import com.yy.hiyo.proto.ProtoUtils;
import com.yy.hiyo.proto.ReliableBroadcastStrategy;
import com.yy.hiyo.proto.RpcRequestStrategy;
import com.yy.hiyo.proto.callback.ICIMProtoCallback;
import com.yy.hiyo.proto.callback.ICIMProtoNotify;
import com.yy.hiyo.proto.callback.ICheckTokenListener;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.IProtoNotify;
import com.yy.hiyo.proto.callback.ISocketStateChangeListener;
import com.yy.hiyo.proto.metric.MetricData;
import com.yy.hiyo.proto.notify.INotifyInterceptor;
import com.yy.hiyo.proto.notify.INotifyMonitor;
import com.yy.hiyo.proto.preventduplicater.IProtoRequestPreventDuplicater;
import com.yy.hiyo.proto.preventduplicater.IProtoRequestRealSender;
import com.yy.hiyo.proto.rpc.RpcMethod;
import com.yy.hiyo.proto.thirdnotify.IThirdNotify;
import common.Header;
import common.Page;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProtoManager
implements INotify {
    private static final String TAG = "ProtoManager";
    private static final int BIZ_CALLBACK_TIME_MIN = 500;
    private static final String RPC_HTTP_API = "/ymicro/api";
    private static volatile boolean hasUpdate = false;
    static final ProxyParser curParse = new ProxyParser("http://172.27.132.6:11000", null);
    private static ICheckTokenListener mICheckTokenListener;
    private static IProtoRequestPreventDuplicater sProtoRequestPreventDuplicater;
    private static IProtoRequestRealSender sProtoRequestRealSender;
    public static boolean sNeedCheckToken;
    private int mTokenSwitch = 0;
    private volatile long mUid = 0L;
    private volatile String mCurToken = "";
    private volatile String mCurWSURL = "";
    private long mSeq = System.currentTimeMillis();

    public static void setCheckTokenListener(ICheckTokenListener checkTokenListener) {
        mICheckTokenListener = checkTokenListener;
    }

    public static void setProtoRequestPreventDuplicater(IProtoRequestPreventDuplicater preventDuplicater) {
        sProtoRequestPreventDuplicater = preventDuplicater;
    }

    public static void updateWsUrl(String curWSURL) {
        String url = new String(curWSURL);
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        if (url.regionMatches(true, 0, "ws:", 0, 3)) {
            url = "http:" + url.substring(3);
        } else if (url.regionMatches(true, 0, "wss:", 0, 4)) {
            url = "https:" + url.substring(4);
        }
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            url = "https://" + url;
        }
        if (hasUpdate && StringUtils.equal((String)url, (String)ProtoManager.curParse.mUrl)) {
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"parse url: %s oldUrl:%s", (Object[])new Object[]{url, ProtoManager.curParse.mUrl != null ? ProtoManager.curParse.mUrl : ""});
        }
        hasUpdate = true;
        ProtoManager.curParse.mUrl = url;
        ProtoManager.curParse.mRpcUrl = url + RPC_HTTP_API;
        ProtoManager.getInstance().reLaunchConnectIfChangeEnv();
    }

    public static void setDefaultUrl(String url) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"setDefaultUrl url: %s oldUrl:%s", (Object[])new Object[]{url, ProtoManager.curParse.mUrl != null ? ProtoManager.curParse.mUrl : ""});
        }
        ProtoManager.curParse.mUrl = url;
        ProtoManager.curParse.mRpcUrl = url + RPC_HTTP_API;
    }

    public String getResponseError(int code) {
        switch (code) {
            case 2: {
                return "cookie\u9519\u8bef";
            }
            case 1: {
                return "\u53c2\u6570\u9519\u8bef";
            }
            case 3: {
                return "\u672a\u6388\u6743";
            }
            case 4: {
                return "\u670d\u52a1\u5668\u4e0d\u652f\u6301\u7684uri";
            }
            case 5: {
                return "\u4e0d\u518d\u652f\u6301\u8be5\u7248\u672c";
            }
            case 6: {
                return "\u8d26\u53f7\u88ab\u5c01\u7981";
            }
            case 7: {
                return "\u670d\u52a1\u5668\u5fd9";
            }
            case 0: {
                return "\u6210\u529f";
            }
        }
        return "\u7cfb\u7edf\u9519\u8bef";
    }

    public static ProxyParser parser() {
        return curParse;
    }

    public void addSocketStateChangeListener(ISocketStateChangeListener socketStateChangeListener) {
        ProtoInnerImp.getInstance().addSocketStateChangeListener(socketStateChangeListener);
    }

    public void removeSocketStateChangeListener(ISocketStateChangeListener socketStateChangeListener) {
        ProtoInnerImp.getInstance().removeSocketStateChangeListener(socketStateChangeListener);
    }

    private ProtoManager() {
        YYTaskExecutor.postToMainThread(() -> NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this));
    }

    public void notify(Notification notification) {
        if (notification.id == NotificationDef.N_FOREGROUND_CHANGE) {
            if (((Boolean)notification.extObj).booleanValue()) {
                ProtoInnerImp.getInstance().changeToForeground();
            } else {
                ProtoInnerImp.getInstance().changeToBackground();
            }
        }
    }

    public static ProtoManager getInstance() {
        return Holder.instance;
    }

    public static void setDns(OkHttpUtils.IOkHttpClientInitCallBack callBack) {
        WsClient.setDns((OkHttpUtils.IOkHttpClientInitCallBack)callBack);
    }

    public synchronized void setCurToken(long uid, String token) {
        MLog.info((Object)TAG, (String)"setCurToken: (%d, token length %d); (Old: %d, old token length %s)", (Object[])new Object[]{uid, token != null ? token.length() : 0, this.mUid, this.mCurToken != null ? this.mCurToken.length() : 0});
        if (uid == this.mUid) {
            this.mCurToken = token;
            boolean wsTokenProtect = SettingFlags.getBoolean((String)"wsTokenProtectNew", (boolean)true);
            WsStatus wsStatus = ProtoInnerImp.getInstance().getWsStatus(this.getCurWSURL(), WsStatus.CONNECT_NONE);
            if (!wsTokenProtect || wsStatus != WsStatus.CONNECT_FAIL) {
                return;
            }
        }
        if (!TextUtils.isEmpty((CharSequence)this.mCurWSURL)) {
            ProtoInnerImp.getInstance().disconnect(this.mCurWSURL);
            this.mCurWSURL = "";
            this.mUid = 0L;
        }
        this.mCurToken = token;
        this.mUid = uid;
        boolean tokenEmpty = TextUtils.isEmpty((CharSequence)this.mCurToken);
        RpcRequestStrategy.setRpcHttpTokenStatus(tokenEmpty);
        if (!tokenEmpty) {
            this.connect();
        }
    }

    private void testWs() {
    }

    private void connect() {
        if (hasUpdate) {
            ReliableBroadcastStrategy.setCurUid(this.mUid);
            this.mCurWSURL = StringUtils.formatWitUSLocal((String)"%s/ikxd_cproxy?token=%s", (Object[])new Object[]{ProtoManager.curParse.mUrl, this.mUid});
            this.testWs();
            ProtoInnerImp.getInstance().connect(this.mCurWSURL);
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)("mcur url xx:" + this.mCurWSURL), (Object[])new Object[0]);
            }
        }
    }

    public void reLaunchConnectIfChangeEnv() {
        if (TextUtils.isEmpty((CharSequence)this.mCurToken)) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mCurWSURL)) {
            ProtoInnerImp.getInstance().disconnect(this.mCurWSURL);
            this.mCurWSURL = "";
        }
        this.connect();
    }

    public long getServiceTime() {
        return ProtoInnerImp.getInstance().getServiceTime();
    }

    public long getClientRealTime() {
        return ProtoInnerImp.getInstance().getClientRealTime();
    }

    public Header getHeader(String sName) {
        return ProtoUtils.getHeader(sName);
    }

    public Header.Builder getHeaderBuilder(String sName) {
        return ProtoUtils.getHeaderBuilder(sName, false);
    }

    public WsStatus getCurrentStatus() {
        WsStatus wsStatus = WsStatus.CONNECT_FAIL;
        if (!TextUtils.isEmpty((CharSequence)this.mCurWSURL)) {
            wsStatus = ProtoInnerImp.getInstance().getWsStatus(this.mCurWSURL);
        }
        return wsStatus;
    }

    public boolean isWSConnected() {
        return !TextUtils.isEmpty((CharSequence)this.mCurWSURL) && ProtoInnerImp.getInstance().getWsStatus(this.mCurWSURL) == WsStatus.CONNECT_SUCCESS;
    }

    public WsStatus getWsStatus() {
        if (TextUtils.isEmpty((CharSequence)this.mCurWSURL)) {
            return WsStatus.CONNECT_NONE;
        }
        return ProtoInnerImp.getInstance().getWsStatus(this.mCurWSURL);
    }

    public String getCurWSURL() {
        return this.mCurWSURL;
    }

    public long getCurWSUid() {
        return this.mUid;
    }

    private <REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> void sendInner(String roomId, REQ proto, @Nullable IProtoCallback<RES> callback, boolean isWsRequest) {
        RpcMethod<REQ, RES> rpcMethod = ProtoUtils.checkResType(proto, callback);
        IProtoRequestPreventDuplicater preventDuplicater = sProtoRequestPreventDuplicater;
        if (preventDuplicater != null && preventDuplicater.isProtoRequestNeedPrevent(roomId, proto, rpcMethod, callback, isWsRequest)) {
            if (sProtoRequestRealSender == null) {
                sProtoRequestRealSender = new IProtoRequestRealSender(){

                    @Override
                    public <REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> void sendProtoRequest(String roomId, REQ proto, RpcMethod<REQ, RES> rpcMethod, @Nullable IProtoCallback<RES> callback, boolean isWsRequest) {
                        ProtoManager.this.realSend(roomId, proto, rpcMethod, callback, isWsRequest);
                    }
                };
            }
            preventDuplicater.sendProtoRequest(roomId, proto, rpcMethod, callback, isWsRequest, sProtoRequestRealSender);
            return;
        }
        this.realSend(roomId, proto, rpcMethod, callback, isWsRequest);
    }

    private <REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> void realSend(String roomId, REQ proto, final RpcMethod<REQ, RES> rpcMethod, final @Nullable IProtoCallback<RES> callback, boolean isWsRequest) {
        if (SystemUtils.isShowEnvSetting() && rpcMethod != null) {
            PerfActionLog.add((String)"Net_WSRequest %s %s", (Object[])new Object[]{rpcMethod.sName, rpcMethod.methodName});
        }
        final long startAddTaskTime = System.currentTimeMillis();
        IProtoInnerCallback innerCallback = new IProtoInnerCallback<RES>(){

            @Override
            public boolean retryWhenTimeout(boolean canRetry) {
                long useTime = System.currentTimeMillis() - startAddTaskTime;
                if (this.mIsWsRequest) {
                    RpcRequestStrategy.sCurWsTaskCount.getAndDecrement();
                }
                boolean value = callback != null && callback.retryWhenTimeout(canRetry);
                ProtoManager.this.handleErrorStat(useTime, this.mIsWsRequest, rpcMethod.sName, rpcMethod.methodName, "retryWhenTimeout canRetry " + canRetry, -1);
                return value;
            }

            @Override
            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                long useTime = System.currentTimeMillis() - startAddTaskTime;
                if (this.mIsWsRequest) {
                    RpcRequestStrategy.sCurWsTaskCount.getAndDecrement();
                } else {
                    RpcRequestStrategy.setRpcHttpTokenStatus(code == 401);
                }
                boolean value = callback != null && callback.retryWhenError(canRetry, reason, code);
                ProtoManager.this.handleErrorStat(useTime, this.mIsWsRequest, rpcMethod.sName, rpcMethod.methodName, "retryWhenError canRetry " + canRetry, code);
                return value;
            }

            @Override
            public void onResponse(@Nullable RES message, MetricData metricData) {
                super.onResponse(message);
                if (callback != null) {
                    callback.onResponse(message);
                }
                YYTaskExecutor.execute(() -> ProtoManager.this.handleResponseCallback(metricData, rpcMethod2.sName, rpcMethod2.methodName, this.mIsWsRequest, callback, 0L));
            }

            @Override
            public void onResponse(@NonNull RES message, long code, String msgTip, MetricData metricData) {
                super.onResponse(message, code, msgTip);
                if (callback != null) {
                    callback.onResponse(message, code, msgTip);
                }
                if (!this.mIsWsRequest) {
                    RpcRequestStrategy.setRpcHttpTokenStatus(code == 401L);
                }
                YYTaskExecutor.execute(() -> ProtoManager.this.handleResponseCallback(metricData, rpcMethod2.sName, rpcMethod2.methodName, this.mIsWsRequest, callback, code));
            }
        };
        this.dispatcher(rpcMethod, roomId, proto, innerCallback, isWsRequest);
        if (callback != null) {
            callback.mIsWsRequest = innerCallback.mIsWsRequest;
        }
    }

    public static void setHeartMonitor(IHeartMonitor monitor) {
        ProtoInnerImp.setHeartMonitor(monitor);
    }

    public static void setNotifyMonitor(INotifyMonitor notifyMonitor) {
        ProtoInnerImp.getInstance().setNotifyMonitor(notifyMonitor);
    }

    private void handleErrorStat(long netRt, boolean isWsRequest, String sName, String methodName, String errMsg, int errorCode) {
        if (StatInitDelegate.isStatSwitchOn((String)sName, (String)methodName)) {
            String url;
            MLog.debug((Object)"ws_proto", (String)(errMsg + " rpcMethod.methodName " + methodName + " mIsWsRequest " + isWsRequest), (Object[])new Object[0]);
            String type = isWsRequest ? "ws" : "http";
            String string = url = isWsRequest ? this.mCurWSURL : ProtoManager.curParse.mRpcUrl;
            int code = !NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext) ? 250 : (!this.isWSConnected() && isWsRequest ? 251 : errorCode);
            HashMap moreInfo = RpcStat.buildMetricMoreInfoMap((long)code, (String)sName, (int)0, (int)-1, (int)-1, (String)type, (int)-1, (String)errMsg, (String)HostUtil.getHostInUrl((String)url), (long)netRt, (long)-1L, (long)-1L, (String)RpcRequestStrategy.getCurABTestValue());
            StatInitDelegate.metric((String)("rpc_" + type + "/" + methodName), (long)netRt, (String)(code + ""), (HashMap)moreInfo, (boolean)false);
        }
    }

    private void handleResponseCallback(MetricData metricData, String sName, String methodName, boolean isWsRequest, IProtoCallback callback, long code) {
        long networkResponseTime = metricData.networkRt - metricData.startTime;
        long dataParseTime = metricData.parseTime - metricData.startTime;
        long bizTime = System.currentTimeMillis() - metricData.startTime;
        MLog.debug((Object)"ws_proto", (String)("onResponse msgTip rpcMethod.methodName " + methodName + " mIsWsRequest " + isWsRequest + " sendSize " + metricData.sendSize + " rec " + metricData.contentLength + " networkRt " + networkResponseTime + " dataParseTime " + dataParseTime + " bizTime " + bizTime + " wsQueueLength " + metricData.wsQueueLength), (Object[])new Object[0]);
        if (StatInitDelegate.isStatSwitchOn((String)sName, (String)methodName)) {
            String type = isWsRequest ? "ws" : "http";
            String url = isWsRequest ? this.mCurWSURL : ProtoManager.curParse.mRpcUrl;
            HashMap moreInfo = RpcStat.buildMetricMoreInfoMap((long)code, (String)sName, (int)metricData.sendSize, (int)metricData.contentLength, (int)metricData.retryTimes, (String)type, (int)metricData.wsQueueLength, (String)"", (String)HostUtil.getHostInUrl((String)url), (long)networkResponseTime, (long)(dataParseTime - networkResponseTime), (long)(bizTime - dataParseTime), (String)RpcRequestStrategy.getCurABTestValue());
            StatInitDelegate.metric((String)("rpc_" + type + "/" + methodName), (long)networkResponseTime, (String)(code + ""), (HashMap)moreInfo, (boolean)false);
        }
        metricData.recycle();
        if (isWsRequest) {
            RpcRequestStrategy.sCurWsTaskCount.getAndDecrement();
        }
        if (RuntimeContext.sIsDebuggable) {
            // empty if block
        }
    }

    private <REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> void dispatcher(RpcMethod<REQ, RES> rpcMethod, String roomId, REQ proto, @NotNull IProtoInnerCallback<RES> innerCallback, boolean isWsRequest) {
        if (RpcRequestStrategy.rpcRequestType(rpcMethod, isWsRequest) == RpcRequestStrategy.RpcRequestStrategyType.WEBSOCKET) {
            MLog.debug((Object)"ws_proto", (String)("websocket cur ws size " + RpcRequestStrategy.sCurWsTaskCount.get() + " rpcMethod.methodName " + rpcMethod.methodName), (Object[])new Object[0]);
            innerCallback.mIsWsRequest = true;
            RpcRequestStrategy.sCurWsTaskCount.getAndIncrement();
            ProtoInnerImp.getInstance().setResponseInterceptor(GlobalBanInterface.INSTANCE);
            ProtoInnerImp.getInstance().sendRpc(this.mCurWSURL, roomId, proto, innerCallback, rpcMethod);
        } else {
            MLog.debug((Object)"ws_proto", (String)("http cur ws size " + RpcRequestStrategy.sCurWsTaskCount.get() + " rpcMethod.methodName " + rpcMethod.methodName), (Object[])new Object[0]);
            innerCallback.mIsWsRequest = false;
            HttpRpcImp.getInstance().setResponseInterceptor(GlobalBanInterface.INSTANCE);
            HttpRpcImp.getInstance().sendHttp(ProtoManager.curParse.mRpcUrl, roomId, proto, innerCallback, rpcMethod);
        }
    }

    private <REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> void sendInnerAsync(String roomId, REQ proto, @Nullable IProtoCallback<RES> callback, boolean isWsRequest) {
        if (!this.checkSate(callback)) {
            return;
        }
        YYTaskExecutor.execute(() -> this.sendInner(roomId, proto, callback, isWsRequest));
    }

    public <RES extends AndroidMessage<RES, ?>> void send(RES proto, final @Nullable IProtoCallback<RES> callback) {
        if (!this.checkSate(callback)) {
            return;
        }
        IProtoInnerCallback innerCallback = new IProtoInnerCallback<RES>(){

            @Override
            public boolean retryWhenTimeout(boolean canRetry) {
                RpcRequestStrategy.sCurWsTaskCount.getAndDecrement();
                return callback != null && callback.retryWhenTimeout(canRetry);
            }

            @Override
            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                RpcRequestStrategy.sCurWsTaskCount.getAndDecrement();
                return callback != null && callback.retryWhenError(canRetry, reason, code);
            }

            @Override
            public void onResponse(@Nullable RES message) {
                super.onResponse(message);
                RpcRequestStrategy.sCurWsTaskCount.getAndDecrement();
                if (callback != null) {
                    callback.onResponse(message);
                }
            }

            @Override
            public void onResponse(@NonNull RES message, long code, String msgTip) {
                super.onResponse(message, code, msgTip);
                RpcRequestStrategy.sCurWsTaskCount.getAndDecrement();
                if (callback != null) {
                    callback.onResponse(message, code, msgTip);
                }
            }
        };
        RpcRequestStrategy.sCurWsTaskCount.getAndIncrement();
        ProtoInnerImp.getInstance().send(this.mCurWSURL, proto, innerCallback);
    }

    public <REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> void sendRpc(REQ proto, @Nullable IProtoCallback<RES> callback) {
        this.sendInnerAsync("", proto, callback, true);
    }

    public <REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> void sendRpc(String roomId, REQ proto, @Nullable IProtoCallback<RES> callback) {
        this.sendInnerAsync(roomId, proto, callback, true);
    }

    public <REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> void sendHttp(REQ proto, @Nullable IProtoCallback<RES> callback) {
        this.sendInnerAsync("", proto, callback, false);
    }

    public <REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> void sendHttp(String roomId, REQ proto, @Nullable IProtoCallback<RES> callback) {
        this.sendInnerAsync(roomId, proto, callback, false);
    }

    public void sendCIMRpc(String sName, String methodName, byte[] requestBytes, @Nullable ICIMProtoCallback<byte[]> callback) {
        if (!this.checkSate(callback)) {
            return;
        }
        ProtoInnerImp.getInstance().sendCIMRpc(this.mCurWSURL, sName, methodName, requestBytes, callback);
    }

    private <T extends AndroidMessage<T, ?>> boolean checkSate(@Nullable IProtoCallback<T> callback) {
        boolean needCheckUrlOrToken;
        boolean bl = needCheckUrlOrToken = callback == null || callback.needToken();
        if (!needCheckUrlOrToken) {
            return true;
        }
        if (TextUtils.isEmpty((CharSequence)this.mCurWSURL)) {
            if (callback != null) {
                MLog.warn((Object)TAG, (String)"sendAsync ws maybe not connect", (Object[])new Object[0]);
                if (RuntimeContext.sIsDebuggable) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"\u957f\u8fde\u63a5\u53ef\u80fd\u8fd8\u672a\u8fde\u63a5\u6210\u529f\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u65f6\u673a", (int)0);
                    MLog.error((Object)TAG, (String)"send web socket before connect", (Throwable)new Throwable(), (Object[])new Object[0]);
                }
                callback.retryWhenError(false, "error url", 101);
            }
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.mCurToken)) {
            if (callback != null) {
                MLog.warn((Object)TAG, (String)"sendAsync ws maybe not connect", (Object[])new Object[0]);
                if (RuntimeContext.sIsDebuggable) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"\u957f\u8fde\u63a5\u53ef\u80fd\u8fd8\u672a\u8fde\u63a5\u6210\u529f\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u65f6\u673a", (int)0);
                    MLog.error((Object)TAG, (String)"send web socket before connect", (Throwable)new Throwable(), (Object[])new Object[0]);
                }
                callback.retryWhenError(false, "no token", 100);
            }
            return false;
        }
        return true;
    }

    private <T> boolean checkSate(@Nullable ICIMProtoCallback<T> callback) {
        if (TextUtils.isEmpty((CharSequence)this.mCurWSURL)) {
            if (callback != null) {
                MLog.warn((Object)TAG, (String)"sendCIMAsync ws maybe not connect", (Object[])new Object[0]);
                if (RuntimeContext.sIsDebuggable) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"\u957f\u8fde\u63a5\u53ef\u80fd\u8fd8\u672a\u8fde\u63a5\u6210\u529f\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u65f6\u673a", (int)0);
                    MLog.error((Object)TAG, (String)"send web socket before connect", (Throwable)new Throwable(), (Object[])new Object[0]);
                }
                callback.retryWhenError(false, "error url", 101);
            }
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.mCurToken)) {
            if (callback != null) {
                MLog.warn((Object)TAG, (String)"sendCIMAsync ws maybe not connect", (Object[])new Object[0]);
                if (RuntimeContext.sIsDebuggable) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"\u957f\u8fde\u63a5\u53ef\u80fd\u8fd8\u672a\u8fde\u63a5\u6210\u529f\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u65f6\u673a", (int)0);
                    MLog.error((Object)TAG, (String)"send web socket before connect", (Throwable)new Throwable(), (Object[])new Object[0]);
                }
                callback.retryWhenError(false, "no token", 100);
            }
            return false;
        }
        return true;
    }

    private <T extends AndroidMessage<T, ?>> boolean checkToken(@Nullable IProtoCallback<T> callback) {
        if (callback != null && callback.needToken() && this.checkTokenSwitch() && (mICheckTokenListener == null || !mICheckTokenListener.isTokenValid())) {
            MLog.warn((Object)TAG, (String)"token \u672a\u6709\u6548\uff0crpc \u4e0d\u80fd\u8bf7\u6c42", (Object[])new Object[0]);
            if (RuntimeContext.sIsMainProcess) {
                callback.retryWhenError(false, "no token", 100);
            } else {
                YYTaskExecutor.postToMainThread(() -> callback.retryWhenError(false, "no token", 100));
            }
            if (RuntimeContext.sIsDebuggable && sNeedCheckToken) {
                IllegalStateException e = new IllegalStateException("token \u672a\u6709\u6548\uff0crpc \u4e0d\u80fd\u8bf7\u6c42");
                MLog.error((Object)TAG, (Throwable)e);
                YYTaskExecutor.execute(() -> {
                    throw e;
                });
            }
        }
        return true;
    }

    private boolean checkTokenSwitch() {
        if (this.mTokenSwitch == 0 && SettingFlags.containKey((String)"close_token_check")) {
            this.mTokenSwitch = SettingFlags.getBoolean((String)"close_token_check", (boolean)false) ? -1 : 1;
        }
        return this.mTokenSwitch != -1;
    }

    public void registerNotify(IProtoNotify notify) {
        ProtoInnerImp.getInstance().registerNotify(notify);
    }

    public void unregisterNotify(IProtoNotify notify) {
        ProtoInnerImp.getInstance().unregisterNotify(notify);
    }

    public <T> void registerThirdNotify(Class<T> type, IThirdNotify<T> notify) {
        ProtoInnerImp.getInstance().registerThirdNotify(type, notify);
    }

    public void addNotifyInterceptor(INotifyInterceptor interceptor) {
        ProtoInnerImp.getInstance().addNotifyInterceptor(interceptor);
    }

    public void removeNotifyInterceptor(INotifyInterceptor interceptor) {
        ProtoInnerImp.getInstance().removeNotifyInterceptor(interceptor);
    }

    public void unregisterThirdNotify(IThirdNotify notify) {
        ProtoInnerImp.getInstance().unregisterThirdNotify(notify);
    }

    public <T> void registerCIMNotify(ICIMProtoNotify<T> notify) {
        ProtoInnerImp.getInstance().registerCIMNotify(notify);
    }

    public <T> void unregisterCIMNotify(ICIMProtoNotify<T> notify) {
        ProtoInnerImp.getInstance().unregisterCIMNotify(notify);
    }

    public void disconnect() {
        if (!TextUtils.isEmpty((CharSequence)this.mCurWSURL)) {
            ProtoInnerImp.getInstance().disconnect(this.mCurWSURL);
            this.mCurWSURL = "";
        }
    }

    public void setGameId(String gameId) {
        ProtoInnerImp.getInstance().setGameId(gameId);
    }

    private synchronized long uniqueSeq() {
        return ProtoUtils.uniqueSeq();
    }

    public static boolean isSuccessCode(long code) {
        return code == 0L;
    }

    public static common.Page obtainPage(Page page) {
        Page.Builder builder = new Page.Builder();
        builder.snap(page.snap);
        builder.limit(page.limit);
        builder.offset(page.offset);
        return builder.build();
    }

    public static Page obtainPage(common.Page pageFromServer) {
        Page page = new Page();
        page.snap = pageFromServer.snap;
        page.limit = pageFromServer.limit;
        page.offset = pageFromServer.offset;
        page.total = pageFromServer.total;
        return page;
    }

    static {
        sNeedCheckToken = true;
    }

    public static class Page {
        public long snap;
        public long offset;
        public long limit;
        public long total;

        public String toString() {
            return "Page{snap='" + this.snap + '\'' + ", offset='" + this.offset + '\'' + ", limit='" + this.limit + '\'' + ", total='" + this.total + '\'' + '}';
        }
    }

    private static class Holder {
        static ProtoManager instance = new ProtoManager();

        private Holder() {
        }
    }

    public static class ProxyParser {
        String mUrl;
        String mRpcUrl;
        ProxyListRes.Proxy[] mFallbacks = new ProxyListRes.Proxy[0];

        ProxyParser(String url, ProxyListRes.Proxy[] fallbacks) {
            this.mUrl = url;
            this.mRpcUrl = url + ProtoManager.RPC_HTTP_API;
            if (fallbacks != null) {
                this.mFallbacks = fallbacks;
            }
        }

        public static class ProxyListRes {
            public int code;
            public String message;
            public List<Proxy> data;

            public static class Proxy {
                public String proxy;
                public int weight;

                Proxy(String p, int w) {
                    this.proxy = p;
                    this.weight = w;
                }
            }
        }
    }

    public static interface ResponseCode {
        public static final int CODE_SUCCESS = 0;
        public static final int CODE_ERROR_PARAMETER = 1;
        public static final int CODE_ERROR_COOKIE = 2;
        public static final int CODE_ERROR_UNAUTHORIZED = 3;
        public static final int CODE_ERROR_UNKNOWURI = 4;
        public static final int CODE_ERROR_VERSION = 5;
        public static final int CODE_ERROR_BANNED = 6;
        public static final int CODE_ERROR_BUSY = 7;
        public static final int CODE_ERROR_SYSTEM = 999;
        public static final int CODE_TOKEN_INVALID = 401;
        public static final int CODE_BANED_TOKEN_INVALID = 9401;
        public static final int CODE_BANED_ACTION = 9403;
    }
}

