/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.proto;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.squareup.wire.ProtoAdapter;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.GraceUtil;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.tmp.PageResponse;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.URLUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.grace.Call;
import com.yy.grace.Callback;
import com.yy.grace.MediaType;
import com.yy.grace.Request;
import com.yy.grace.RequestBody;
import com.yy.grace.ResponseBody;
import com.yy.grace.networkinterceptor.BizScenc;
import com.yy.hiyo.proto.IProtoInnerCallback;
import com.yy.hiyo.proto.IResponseInterceptor;
import com.yy.hiyo.proto.ProtoMonitor;
import com.yy.hiyo.proto.ProtoUtils;
import com.yy.hiyo.proto.RouteTransmission;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.metric.MetricData;
import com.yy.hiyo.proto.rpc.RpcMethod;
import common.Detail;
import common.DetailTypeURI;
import common.Response;
import common.Result;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

class HttpRpcImp {
    private static final String TAG = "HttpRpcImp";
    private final ConcurrentHashMap<String, String> mUrlEncodeCache = new ConcurrentHashMap();
    private final MediaType sProtoMediaType = MediaType.get((String)"application/proto");
    public static volatile AtomicInteger sTaskNum = new AtomicInteger(0);
    private IResponseInterceptor mGlobalBanInterface;

    HttpRpcImp() {
    }

    public void setResponseInterceptor(IResponseInterceptor instance) {
        this.mGlobalBanInterface = instance;
    }

    public static HttpRpcImp getInstance() {
        return InstanceHolder.instance;
    }

    public <REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> void sendHttp(String url, String roomId, REQ proto, @Nullable IProtoInnerCallback<RES> callback, RpcMethod<REQ, RES> rpcMethod) {
        if (YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.execute(() -> this.sendAsync(url, roomId, proto, callback, rpcMethod));
        } else {
            this.sendAsync(url, roomId, proto, callback, rpcMethod);
        }
    }

    private <REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> void sendAsync(final String url, String roomId, final REQ request, final @Nullable IProtoInnerCallback<RES> callback, final RpcMethod<REQ, RES> rpcMethod) {
        String sName = rpcMethod.sName;
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("hago-room-id", roomId == null ? "" : roomId);
        header.put("X-Ymicro-Api-Service-Name", this.urlEncode(sName));
        header.put("X-Ymicro-Api-Method-Name", this.urlEncode(rpcMethod.methodName));
        header = RouteTransmission.routeTransMap(header, sName);
        ProtoMonitor.onHttpRpcRequestStart(roomId == null ? "" : roomId, url, sName, rpcMethod.methodName, request);
        sTaskNum.getAndIncrement();
        MLog.debug((Object)"ws_vanda", (String)("RPC http put size " + sTaskNum.get()), (Object[])new Object[0]);
        byte[] bytes = request.encode();
        final int sendSize = bytes.length;
        final long startTime = System.currentTimeMillis();
        GraceUtil.getGrace().newCall(new Request.Builder<ResponseBody>(){}.url(url).addHeader(header).post(RequestBody.create((MediaType)this.sProtoMediaType, (byte[])bytes)).group((Request.Group)BizScenc.HTTP_RPC).build()).enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(Call<ResponseBody> call, com.yy.grace.Response<ResponseBody> response) {
                boolean isBaned;
                long networkRt = System.currentTimeMillis();
                sTaskNum.getAndDecrement();
                MLog.debug((Object)"ws_vanda", (String)("RPC http size " + sTaskNum.get()), (Object[])new Object[0]);
                boolean bl = isBaned = HttpRpcImp.this.mGlobalBanInterface != null && HttpRpcImp.this.mGlobalBanInterface.interceptHttpResponse(response, request);
                if (!isBaned && response.isSuccessful()) {
                    HttpRpcImp.this.handleResponse(url, (com.yy.grace.Response<ResponseBody>)response, callback, request, rpcMethod, sendSize, startTime, networkRt);
                } else {
                    HttpRpcImp.this.onErrorCallback(url, rpcMethod, callback, new Exception("code is " + response.code() + ", isBanded: " + isBaned));
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable e) {
                sTaskNum.getAndDecrement();
                MLog.debug((Object)"ws_vanda", (String)("RPC http size " + sTaskNum.get()), (Object[])new Object[0]);
                HttpRpcImp.this.onErrorCallback(url, rpcMethod, callback, e);
            }
        });
    }

    private <REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> void onErrorCallback(String url, RpcMethod<REQ, RES> rpcMethod, @Nullable IProtoCallback<RES> callback, Throwable e) {
        MLog.error((Object)TAG, (String)"onError sName: %s, method: %s, url: %s", (Throwable)e, (Object[])new Object[]{rpcMethod.sName, rpcMethod.methodName, url});
        if (callback != null) {
            String reason = e.getMessage();
            callback.retryWhenError(false, reason == null ? "http onError" : reason, NetworkUtils.getErrorCodeByExc((Throwable)e));
        }
    }

    private static <RES extends AndroidMessage<RES, ?>> void responseCallback(@Nullable RES res, @Nullable Result result, IProtoInnerCallback<RES> callback, MetricData metricData, String serverName, String method) {
        if (callback == null) {
            return;
        }
        YYTaskExecutor.postToMainThread(() -> {
            block7: {
                try {
                    if (res == null) {
                        MLog.error((Object)TAG, (String)"responseCallback onResponse null, serverName:%s, method:%s!", (Object[])new Object[]{serverName, method});
                        callback.retryWhenError(false, "parse proto failed", -100000);
                    } else if (result == null) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)TAG, (String)"responseCallback onResponse old, serverName:%s, method:%s!", (Object[])new Object[]{serverName, method});
                        }
                        callback.onResponse(res, metricData);
                    } else {
                        callback.onResponse(res, result.errcode, HttpRpcImp.paresResultMsgTip(result, serverName, method), metricData);
                    }
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, (Throwable)e);
                    if (!RuntimeContext.sIsDebuggable) break block7;
                    throw e;
                }
            }
        });
    }

    private String urlEncode(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        if (this.mUrlEncodeCache.containsKey(str)) {
            return this.mUrlEncodeCache.get(str);
        }
        String encode = URLUtils.urlEncoderEncode((String)str);
        if (encode != null) {
            this.mUrlEncodeCache.put(str, encode);
            return encode;
        }
        return "";
    }

    private static String paresResultMsgTip(@Nullable Result result, String serverName, String method) {
        if (result == null) {
            return "";
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"paraseResultMsgTip serverName:%s, method:%s, errmsg:%s,  ErrCode:%d", (Object[])new Object[]{serverName, method, result.errmsg, result.errcode});
        }
        MLog.debug((Object)TAG, (String)"paraseResultMsgTip result.details:%s", (Object[])new Object[]{result.details});
        for (Detail detail : result.details) {
            MLog.debug((Object)TAG, (String)"paraseResultMsgTip detail.type_uri:%d", (Object[])new Object[]{detail.type_uri});
            if (DetailTypeURI.DETAIL_TYPE_URI_LOCALIZE_MESSAGE.getValue() != detail.type_uri.intValue()) continue;
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"paraseResultMsgTip msgTip:%s", (Object[])new Object[]{detail.localize_message.message});
            }
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)detail.localize_message.message, (int)0);
            return detail.localize_message.message;
        }
        return "";
    }

    private <REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> void handleResponse(String url, com.yy.grace.Response<ResponseBody> response, @Nullable IProtoInnerCallback<RES> callback, REQ request, RpcMethod<REQ, RES> rpcMethod, int sendSize, long startTime, long networkRt) {
        try {
            byte[] responseBody = ((ResponseBody)response.body()).bytes();
            int contentLength = responseBody.length;
            RouteTransmission.proRequestHeader(rpcMethod.sName, response.raw().getResponseHeaderFields());
            MLog.debug((Object)TAG, (String)"sendAsync rpc onResponse sName: %s, methodName: %s responseSize:%d", (Object[])new Object[]{rpcMethod.sName, rpcMethod.methodName, responseBody.length});
            MLog.debug((Object)TAG, (String)"sendAsync response: %s ", (Object[])new Object[]{new String(responseBody)});
            if (callback == null) {
                return;
            }
            Runnable command = () -> {
                ProtoAdapter proto = ProtoUtils.getResProtoAdapter(request);
                AndroidMessage res = null;
                if (proto != null) {
                    res = ProtoUtils.parseBytes(proto, responseBody);
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"res: comeBack, sName:%s, methodName:%s!", (Object[])new Object[]{rpcMethod.sName != null ? rpcMethod.sName : "", rpcMethod.methodName != null ? rpcMethod.methodName : ""});
                }
                if (ProtoUtils.isResultRes(rpcMethod)) {
                    Response resultRes = ProtoUtils.parseBytes(Response.ADAPTER, responseBody);
                    if (!MLog.isLogLevelAboveDebug()) {
                        MLog.debug((Object)TAG, (String)ProtoUtils.resultString(resultRes), (Object[])new Object[0]);
                    }
                    if (ProtoUtils.isResultLegal(resultRes)) {
                        MetricData metricData = MetricData.buildMetricData(startTime, contentLength, sendSize, networkRt, System.currentTimeMillis(), sTaskNum.get(), 0);
                        HttpRpcImp.responseCallback(res, resultRes.result, callback, metricData, rpcMethod.sName != null ? rpcMethod.sName : "", rpcMethod.methodName != null ? rpcMethod.methodName : "");
                    } else {
                        String resDecode = new String(responseBody);
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)TAG, (String)"parse error,  response: %s ", (Object[])new Object[]{resDecode});
                        }
                        String msg = "\u54cd\u5e94result\u975e\u6cd5,\u5d29\u6e83\uff0c\u627e\u540e\u53f0\u68c0\u67e5\u3002sName: " + rpcMethod.sName + ", methodName: " + rpcMethod.methodName + "; " + resDecode;
                        MLog.error((Object)TAG, (String)msg, (Object[])new Object[0]);
                        callback.retryWhenError(false, msg, -1);
                    }
                } else {
                    MetricData metricData = MetricData.buildMetricData(startTime, contentLength, sendSize, networkRt, System.currentTimeMillis(), sTaskNum.get(), 0);
                    HttpRpcImp.responseCallback(res, null, callback, metricData, rpcMethod.sName != null ? rpcMethod.sName : "", rpcMethod.methodName != null ? rpcMethod.methodName : "");
                }
            };
            HttpRpcImp.execute(command);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.onErrorCallback(url, rpcMethod, callback, e);
        }
    }

    private static void execute(Runnable runnable) {
        if (PageResponse.isNewTaskExecuteEnable()) {
            if (PageResponse.isNewTaskPriorityEnable()) {
                YYTaskExecutor.execute((Runnable)runnable, (long)0L, (int)0);
            } else {
                YYTaskExecutor.execute((Runnable)runnable, (long)0L);
            }
        } else if (SettingFlags.getBoolean((String)"keynetopenthreadopt", (boolean)true)) {
            YYTaskExecutor.execute((Runnable)runnable, (long)0L, (int)5);
        } else {
            YYTaskExecutor.execute((Runnable)runnable);
        }
    }

    private static class InstanceHolder {
        static HttpRpcImp instance = new HttpRpcImp();

        private InstanceHolder() {
        }
    }
}

