/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.proto;

import android.os.SystemClock;
import android.text.TextUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.websocket.WsClient;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.TimeUtils;
import com.yy.hiyo.proto.IHeartMonitor;
import com.yy.hiyo.proto.IProtoInnerCallback;
import com.yy.hiyo.proto.ProtoInnerImp;
import com.yy.hiyo.proto.ProtoManager;
import ikxd.cproxy.CProxy;
import ikxd.cproxy.HeartbeatReq;
import ikxd.cproxy.HeartbeatRes;
import ikxd.cproxy.Uri;
import ikxd.online.HeartBeatReq;
import ikxd.online.HeartBeatRes;
import ikxd.online.IKXDOnlineProto;
import java.util.HashMap;

class HeartBeatTask
implements Runnable {
    private static final String TAG = "HeartBeatTask";
    private volatile long mHeartTime = 15L;
    private volatile long mAcceptPongTs = SystemClock.elapsedRealtime();
    private volatile int mCliSeq = 0;
    private final String mUrl;
    private final WsClient mClient;
    private volatile boolean mStopped = false;
    private static long sServiceTime = 0L;
    private static long sClientRealTime = 0L;
    private static String mGameId = "";
    private static boolean isGameIdChange = false;
    private boolean mUseCproxyHeart = false;
    private static IHeartMonitor sMonitor;

    HeartBeatTask(WsClient cli, String url) {
        this.mClient = cli;
        this.mCliSeq = cli.mConnectSeq;
        this.mUrl = url == null ? "" : url;
        this.mUseCproxyHeart = SettingFlags.getBoolean((String)"heartToCproxy", (boolean)false);
    }

    public void stop() {
        this.mStopped = true;
    }

    public String getUrl() {
        return this.mUrl;
    }

    static void setGameId(String gameId) {
        if (gameId == null) {
            gameId = "";
        }
        isGameIdChange = !gameId.equals(mGameId);
        mGameId = gameId;
    }

    static long getServiceTime() {
        return sServiceTime;
    }

    static long getClientRealTime() {
        return sClientRealTime;
    }

    @Override
    public void run() {
        if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"HeartBeat sendHeartBeatTask gid:%s, roomid:%s", (Object[])new Object[]{mGameId, RuntimeContext.getVoiceRoomId()});
        }
        if (!this.shouldSendHeart()) {
            return;
        }
        long currentTimeMillis = SystemClock.elapsedRealtime();
        int timeoutHeartNum = 3;
        if (sMonitor != null && ((timeoutHeartNum = sMonitor.getHeartBeatTimeoutNum()) <= 0 || timeoutHeartNum > 5)) {
            timeoutHeartNum = 3;
        }
        if (currentTimeMillis - this.mAcceptPongTs > (long)timeoutHeartNum * this.mHeartTime * 1000L + 3000L) {
            MLog.error((Object)TAG, (String)"[SOCKET:%d] cur:%d tryReconnect because of no-pong since from %d (%d), pong:%d", (Object[])new Object[]{this.mCliSeq, currentTimeMillis, this.mAcceptPongTs, currentTimeMillis - this.mAcceptPongTs, this.mHeartTime});
            this.mClient.tryReconnect("\u53d1\u8d77\u91cd\u8fde-\u5fc3\u8df3\u8d85\u65f6");
            return;
        }
        if (sMonitor != null) {
            sMonitor.beforeSendHeart(this.mHeartTime * 1000L);
        }
        if (this.mUseCproxyHeart) {
            this.sendCproxyProto();
        } else {
            this.sendOnlineProto(false);
        }
        YYTaskExecutor.execute((Runnable)this, (long)(this.mHeartTime * 1000L), (int)5);
    }

    private boolean shouldSendHeart() {
        if (this.mStopped) {
            MLog.error((Object)TAG, (String)"HeartBeat stope true!", (Object[])new Object[0]);
            return false;
        }
        if (!this.mClient.checkWs()) {
            MLog.error((Object)TAG, (String)"HeartBeat client closed!", (Object[])new Object[0]);
            return false;
        }
        if (this.mCliSeq != this.mClient.mConnectSeq) {
            MLog.error((Object)TAG, (String)"HeartBeat equel clietseq %d!", (Object[])new Object[]{this.mCliSeq});
            return false;
        }
        return true;
    }

    public static void setHeartMonitor(IHeartMonitor monitor) {
        sMonitor = monitor;
    }

    private void sendOnlineProto(final boolean isRetryed) {
        String roomIdWithRoomGame = HeartBeatTask.getChannelInfo(RuntimeContext.getCurMainChannel());
        HeartBeatReq heartbeatReq = null;
        if (StringUtils.isNotEmpty((String)roomIdWithRoomGame)) {
            HashMap<String, String> bizs = new HashMap<String, String>();
            bizs.put("roomid", roomIdWithRoomGame);
            String coexistenceChanneInfo = HeartBeatTask.getChannelInfo(RuntimeContext.getCoexistenceChannel());
            if (StringUtils.isNotEmpty((String)coexistenceChanneInfo)) {
                bizs.put("minbase", coexistenceChanneInfo);
            }
            if (RuntimeContext.sIsDebuggable) {
                if (StringUtils.isNotEmpty((String)roomIdWithRoomGame) && RuntimeContext.getCurMainChannel() != null) {
                    RuntimeContext.getCurMainChannel().logSelf("HeartBeatTask_MainChannel");
                } else if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"HeartBeatTask_MainChannel", (String)"empty!", (Object[])new Object[0]);
                }
                if (StringUtils.isNotEmpty((String)coexistenceChanneInfo) && RuntimeContext.getCoexistenceChannel() != null) {
                    RuntimeContext.getCoexistenceChannel().logSelf("HeartBeatTask_CoexistenceChannel");
                } else if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"HeartBeatTask_CoexistenceChannel", (String)"empty!", (Object[])new Object[0]);
                }
            }
            heartbeatReq = new HeartBeatReq.Builder().gid(mGameId).changed(isGameIdChange).bizs(bizs).back_ground(!RuntimeContext.sIsForeground).build();
        } else {
            heartbeatReq = new HeartBeatReq.Builder().gid(mGameId).changed(isGameIdChange).back_ground(!RuntimeContext.sIsForeground).build();
        }
        if (TextUtils.isEmpty((CharSequence)mGameId)) {
            isGameIdChange = false;
        }
        IKXDOnlineProto onlineProto = new IKXDOnlineProto.Builder().header(ProtoManager.getInstance().getHeader("ikxd_online_d")).uri(ikxd.online.Uri.kUriHeartBeatReq).heartbeat_req(heartbeatReq).build();
        if (this.mStopped) {
            MLog.error((Object)TAG, (String)"HeartBeat stope true!", (Object[])new Object[0]);
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"HeartBeat sendHeartBeatTask real", (Object[])new Object[0]);
        }
        ProtoInnerImp.getInstance().send(this.mUrl, onlineProto, new IProtoInnerCallback<IKXDOnlineProto>(){

            @Override
            public void onResponse(IKXDOnlineProto proto) {
                long timeNow = SystemClock.elapsedRealtime();
                if (proto != null) {
                    HeartBeatRes res = proto.heartbeat_res;
                    if (res != null) {
                        HeartBeatTask.this.mHeartTime = res.next;
                        sServiceTime = res.timestamp;
                        sClientRealTime = timeNow;
                        TimeUtils.setServiceTime((long)sServiceTime);
                        TimeUtils.setClientRealTime((long)sClientRealTime);
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)HeartBeatTask.TAG, (String)"HeartBeat onResponse mHeartTime: %d, mServiceTime: %d, mClientRealTime: %d", (Object[])new Object[]{HeartBeatTask.this.mHeartTime, sServiceTime, sClientRealTime});
                        }
                    }
                    if (HeartBeatTask.this.mHeartTime <= 0L) {
                        HeartBeatTask.this.mHeartTime = 10L;
                    }
                    TimeUtils.setHeartBeatGapTs((long)(HeartBeatTask.this.mHeartTime * 1000L));
                    if (res != null && sMonitor != null) {
                        sMonitor.onHeartBeatResp(HeartBeatTask.this.mHeartTime * 1000L, isRetryed);
                    }
                }
                HeartBeatTask.this.mAcceptPongTs = timeNow;
            }

            @Override
            public boolean retryWhenTimeout(boolean canRetry) {
                if (RuntimeContext.sIsDebuggable) {
                    MLog.error((Object)HeartBeatTask.TAG, (String)"HeartBeat retryWhenTimeout canRetry: %b", (Object[])new Object[]{canRetry});
                }
                HeartBeatTask.this.handleOnlineProtoError(isRetryed, "TimeOut", 99);
                return false;
            }

            @Override
            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                if (RuntimeContext.sIsDebuggable) {
                    MLog.error((Object)HeartBeatTask.TAG, (String)"HeartBeat retryWhenError canRetry: %b, code: %d, reason: %s", (Object[])new Object[]{canRetry, code, reason});
                }
                HeartBeatTask.this.handleOnlineProtoError(isRetryed, reason, code);
                return false;
            }
        });
    }

    private void handleOnlineProtoError(boolean isRetryed, String reason, int code) {
        if (sMonitor == null || !this.shouldSendHeart()) {
            return;
        }
        if (sMonitor.needRetryWhenError(isRetryed, reason, code)) {
            this.sendOnlineProto(true);
        }
    }

    private static String getChannelInfo(final RuntimeContext.ChannelHeartItem channelHeartItem) {
        if (channelHeartItem == null) {
            return "";
        }
        String roomIdWithRoomGame = "";
        String roomId = channelHeartItem.getRoomId();
        if (StringUtils.isNotEmpty((String)roomId)) {
            String pluginId = channelHeartItem.getChannelPluginId();
            roomIdWithRoomGame = StringUtils.isNotEmpty((String)pluginId) ? roomId + "|" + pluginId : roomId + "|";
            if (RuntimeContext.sIsDebuggable) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (StringUtils.isNotEmpty((String)channelHeartItem.getRoomId()) && StringUtils.isEmpty((String)channelHeartItem.getChannelPluginId())) {
                            throw new RuntimeException("no pluginId");
                        }
                    }
                });
            }
            roomIdWithRoomGame = StringUtils.isNotEmpty((String)channelHeartItem.getLastVoiceRoomJoinSession()) ? roomIdWithRoomGame + "|" + channelHeartItem.getLastVoiceRoomJoinSession() : roomIdWithRoomGame + "|";
            roomIdWithRoomGame = channelHeartItem.isVoiceRoomInMic() ? roomIdWithRoomGame + "|1" : roomIdWithRoomGame + "|0";
            roomIdWithRoomGame = roomIdWithRoomGame + "|" + (RuntimeContext.isHagoPartySdk() ? "1" : "4");
            roomIdWithRoomGame = roomIdWithRoomGame + "|" + channelHeartItem.getChannelTagId();
            roomIdWithRoomGame = channelHeartItem.isChannelOpenVideo() ? roomIdWithRoomGame + "|1" : roomIdWithRoomGame + "|2";
            roomIdWithRoomGame = channelHeartItem.isSameCityChannel() ? roomIdWithRoomGame + "|1" : roomIdWithRoomGame + "|";
            roomIdWithRoomGame = roomIdWithRoomGame + "|" + channelHeartItem.getRecommendToken();
            String subType = channelHeartItem.getSubType();
            roomIdWithRoomGame = StringUtils.isNotEmpty((String)subType) ? roomIdWithRoomGame + "|" + subType : roomIdWithRoomGame + "|";
            roomIdWithRoomGame = roomIdWithRoomGame + "|" + channelHeartItem.getPkType();
            roomIdWithRoomGame = roomIdWithRoomGame + "|" + channelHeartItem.getLinkMicType();
            roomIdWithRoomGame = roomIdWithRoomGame + "|" + channelHeartItem.getLinkMicId();
            roomIdWithRoomGame = roomIdWithRoomGame + "|" + channelHeartItem.getLinkMicUidType();
            int channelType = channelHeartItem.getChannelType();
            roomIdWithRoomGame = channelType == 0 ? roomIdWithRoomGame + "|" : roomIdWithRoomGame + "|" + channelType;
            roomIdWithRoomGame = roomIdWithRoomGame + "|" + channelHeartItem.getSeatIndex();
            roomIdWithRoomGame = roomIdWithRoomGame + "|" + channelHeartItem.consumeRecordTime(1);
            roomIdWithRoomGame = roomIdWithRoomGame + "|" + channelHeartItem.consumeRecordTime(2);
            roomIdWithRoomGame = roomIdWithRoomGame + "|" + channelHeartItem.consumeRecordTime(3);
            roomIdWithRoomGame = roomIdWithRoomGame + "|" + (channelHeartItem.isPlayingBackgroundMusic() ? "1" : "0");
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"heart roominfo: %s", (Object[])new Object[]{roomIdWithRoomGame});
            }
        } else if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"heart roominfo empty!", (Object[])new Object[0]);
        }
        return roomIdWithRoomGame;
    }

    private void sendCproxyProto() {
        HeartbeatReq heartbeatReq = new HeartbeatReq.Builder().game_id(mGameId).changed(isGameIdChange).back_ground(!RuntimeContext.sIsForeground).build();
        if (TextUtils.isEmpty((CharSequence)mGameId)) {
            isGameIdChange = false;
        }
        CProxy cproxy = new CProxy.Builder().header(ProtoManager.getInstance().getHeader("ikxd_cproxy_d")).uri(Uri.kUriHeartbeatReq).heartbeat_req(heartbeatReq).build();
        if (this.mStopped) {
            MLog.error((Object)TAG, (String)"HeartBeat stope true!", (Object[])new Object[0]);
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"HeartBeat sendHeartBeatTask real", (Object[])new Object[0]);
        }
        ProtoInnerImp.getInstance().send(this.mUrl, cproxy, new IProtoInnerCallback<CProxy>(){

            @Override
            public void onResponse(CProxy proxy) {
                long timeNow = SystemClock.elapsedRealtime();
                if (proxy != null) {
                    HeartbeatRes res = proxy.heartbeat_res;
                    if (res != null) {
                        HeartBeatTask.this.mHeartTime = res.next;
                        sServiceTime = res.timestamp;
                        sClientRealTime = timeNow;
                        TimeUtils.setServiceTime((long)sServiceTime);
                        TimeUtils.setClientRealTime((long)sClientRealTime);
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)HeartBeatTask.TAG, (String)"HeartBeat onResponse mHeartTime: %d, mServiceTime: %d, mClientRealTime: %d", (Object[])new Object[]{HeartBeatTask.this.mHeartTime, sServiceTime, sClientRealTime});
                        }
                    }
                    if (HeartBeatTask.this.mHeartTime <= 0L) {
                        HeartBeatTask.this.mHeartTime = 10L;
                    }
                    TimeUtils.setHeartBeatGapTs((long)(HeartBeatTask.this.mHeartTime * 1000L));
                    if (res != null && sMonitor != null) {
                        sMonitor.onHeartBeatResp(HeartBeatTask.this.mHeartTime * 1000L, false);
                    }
                }
                HeartBeatTask.this.mAcceptPongTs = timeNow;
            }

            @Override
            public boolean retryWhenTimeout(boolean canRetry) {
                if (RuntimeContext.sIsDebuggable) {
                    MLog.error((Object)HeartBeatTask.TAG, (String)"HeartBeat retryWhenTimeout canRetry: %b", (Object[])new Object[]{canRetry});
                }
                return false;
            }

            @Override
            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                if (RuntimeContext.sIsDebuggable) {
                    MLog.error((Object)HeartBeatTask.TAG, (String)"HeartBeat retryWhenError canRetry: %b, code: %d, reason: %s", (Object[])new Object[]{canRetry, code, reason});
                }
                return false;
            }
        });
    }
}

