/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.proto;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.squareup.wire.Message;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.websocket.WsClient;
import com.yy.base.okhttp.websocket.ws.RpcStat;
import com.yy.base.utils.FP;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.proto.IDispatchCallback;
import com.yy.hiyo.proto.IProtoInnerCallback;
import com.yy.hiyo.proto.ProtoMonitor;
import com.yy.hiyo.proto.ProtoUtils;
import com.yy.hiyo.proto.WsRequest;
import com.yy.hiyo.proto.callback.IProtoCallback;
import common.Header;
import ikxd.cproxy.InnerV2;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

abstract class AbsProtoDispatch {
    private static final String TAG = "AbsProtoDispatch";
    private final ConcurrentHashMap<Class<? extends Message.Builder>, Method> mSetHeaderMethodCache = new ConcurrentHashMap();
    protected final IDispatchCallback mDispatchCallback;

    public abstract int getCurTaskSize();

    protected AbsProtoDispatch(IDispatchCallback callback) {
        this.mDispatchCallback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSomeError(boolean canRetry, String reason, int code) {
        WsRequest request;
        HashMap<Long, WsRequest> requestCopy;
        ArrayList rm = new ArrayList();
        Map<Long, WsRequest> original = this.getRequestMap();
        if (FP.empty(original)) {
            return;
        }
        Iterator iterator = original;
        synchronized (iterator) {
            requestCopy = new HashMap<Long, WsRequest>(original);
        }
        for (Map.Entry entry : requestCopy.entrySet()) {
            request = (WsRequest)entry.getValue();
            boolean remove = this.checkoutRetryWhenError(canRetry, request, reason, code);
            if (!remove) continue;
            rm.add(entry.getKey());
        }
        for (Object e : rm) {
            request = this.removeRequest(original, e, " onerror");
            if (request == null) continue;
            request.recycle();
        }
    }

    boolean checkoutRetryWhenError(boolean canRetry, WsRequest request, String reason, int code) {
        Header header;
        if (request == null) {
            return true;
        }
        IProtoInnerCallback cb = request.callback;
        if (cb == null) {
            return true;
        }
        String sName = "";
        String method = "";
        int uri = 0;
        InnerV2 innerV2 = request.inner;
        if (innerV2 != null && (header = innerV2.header) != null) {
            sName = header.sname;
            method = header.method;
            uri = innerV2.uri != null ? innerV2.uri : 0;
        }
        long useTime = System.currentTimeMillis() - request.time;
        if (TextUtils.isEmpty((CharSequence)sName)) {
            this.onRetryWhenError(cb, sName, uri, request.seqId, false, "sname is empty. " + reason, code, useTime, request.retryCount, method);
            return true;
        }
        if (canRetry) {
            if ((long)request.retryCount > 3L) {
                this.onRetryWhenError(cb, sName, uri, request.seqId, false, reason, code, useTime, request.retryCount, method);
                return true;
            }
            if (this.onRetryWhenError(cb, sName, uri, request.seqId, true, reason, code, useTime, request.retryCount, method)) {
                this.resend(request, true);
                return false;
            }
            return true;
        }
        this.onRetryWhenError(cb, sName, uri, request.seqId, false, reason, code, useTime, request.retryCount, method);
        return true;
    }

    void onResponse(String wsUrl, @NonNull byte[] resData, @NonNull InnerV2 inner, int originSize, long networkRt) {
    }

    @NonNull
    protected abstract Map<Long, WsRequest> getRequestMap();

    protected abstract boolean onResend(WsClient var1, WsRequest var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCheckTimeoutReq() {
        HashMap<Long, WsRequest> requestCopy;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onCheckTimeoutReq", (Object[])new Object[0]);
        }
        long cur = System.currentTimeMillis();
        Map<Long, WsRequest> original = this.getRequestMap();
        if (FP.empty(original)) {
            return;
        }
        Map<Long, WsRequest> map = original;
        synchronized (map) {
            requestCopy = new HashMap<Long, WsRequest>(original);
        }
        for (Map.Entry entry : requestCopy.entrySet()) {
            WsRequest req;
            IProtoInnerCallback cb;
            WsRequest request = (WsRequest)entry.getValue();
            if (RuntimeContext.sIsDebuggable) {
                long timeCheck = cur - request.time;
                request.statKey = request.statKey + " checktime" + timeCheck;
            }
            if ((cb = request.callback) == null || cb.getTimeoutTimeLength() <= 0L ? cur - request.time < 10000L : cur - request.time < cb.getTimeoutTimeLength()) continue;
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"onCheckTimeoutReq timeout request.inner: %s", (Object[])new Object[]{ProtoUtils.innerString(request.inner)});
            }
            if (cb == null) {
                req = this.removeRequest(original, entry.getKey(), " timeout");
                if (req == null) continue;
                req.recycle();
                continue;
            }
            if ((long)request.retryCount > 3L) {
                this.onRetryWhenTimeout(cb, request, false);
                req = this.removeRequest(original, entry.getKey(), " timeout");
                if (req == null) continue;
                req.recycle();
                continue;
            }
            if (!this.onRetryWhenTimeout(cb, request, true)) {
                req = this.removeRequest(original, entry.getKey(), " timeout");
                if (req == null) continue;
                req.recycle();
                continue;
            }
            this.resend(request, true);
        }
    }

    void onWsConnectSucceed(WsClient cli, String wsUrl) {
        Map<Long, WsRequest> original = this.getRequestMap();
        long cur = System.currentTimeMillis();
        if (!FP.empty(original) && original.size() > 0) {
            HashMap<Long, WsRequest> requestCopy = new HashMap<Long, WsRequest>(original);
            Set entries = requestCopy.entrySet();
            for (Map.Entry entry : entries) {
                boolean resendSuccess;
                WsClient wsClient;
                WsRequest request = (WsRequest)entry.getValue();
                if (request == null || request.firstSendTime > 0L || cur - request.time > 20000L && request.time > 0L || (wsClient = this.mDispatchCallback.getWsClient(request.wsUrl)) == null || !(resendSuccess = wsClient.send(request.getData())) || request.firstSendTime > 0L) continue;
                request.firstSendTime = cur;
            }
        }
    }

    protected boolean onRetryWhenTimeout(IProtoCallback cb, WsRequest request, boolean canRetry) {
        Header header;
        InnerV2 innerV2;
        if (request != null && (innerV2 = request.inner) != null && (header = innerV2.header) != null) {
            ProtoMonitor.monitorTimeout(header.sname, innerV2.uri != null ? innerV2.uri : 0, request.seqId);
            RpcStat.statRpcFail((String)header.sname, (String)(header.method + innerV2.uri), (long)(System.currentTimeMillis() - request.time), (String)("timeout in " + cb.getTimeoutTimeLength() + " ms "), (int)request.retryCount, (int)NetworkUtils.getWsRpcRequestTimeoutCode());
        }
        if (cb != null) {
            return cb.retryWhenTimeout(canRetry);
        }
        return false;
    }

    protected boolean onRetryWhenError(IProtoCallback cb, String sName, int uri, long seqId, boolean canRetry, String reason, int code, long useTime, int retryTimes, String method) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onRetryWhenError sName:%s, method:%s, reason:%s, code:%d", (Object[])new Object[]{sName != null ? sName : "", method != null ? method : "", reason != null ? reason : "", code});
        }
        ProtoMonitor.monitorError(sName, uri, seqId, reason, code);
        RpcStat.statRpcFail((String)sName, (String)(method + uri), (long)useTime, (String)("retry when error code " + code + " reason = " + reason + " seqId = " + seqId), (int)retryTimes, (int)code);
        if (cb != null) {
            return cb.retryWhenError(canRetry, reason, code);
        }
        return false;
    }

    protected WsRequest removeRequest(Map<? extends Object, WsRequest> map, Object key, String reasonStatStr) {
        WsRequest request = null;
        request = map.remove(key);
        ProtoMonitor.monitorMsgConsumeTime(reasonStatStr, request);
        return request;
    }

    private void resend(WsRequest request, boolean isRetry) {
        boolean resendSuccess;
        if (request == null || request.isRecycle) {
            return;
        }
        if (isRetry) {
            ++request.retryCount;
        }
        request.time = System.currentTimeMillis();
        WsClient wsClient = this.mDispatchCallback.getWsClient(request.wsUrl);
        if (wsClient == null) {
            return;
        }
        if (RuntimeContext.sIsDebuggable) {
            request.statKey = request.statKey + " resend";
        }
        if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"[SOCKET:%d] ReSend before reset seqId (%s)", (Object[])new Object[]{wsClient.identifySeq(), ProtoUtils.innerString(request.inner)});
        }
        if ((resendSuccess = this.onResend(wsClient, request)) && request.firstSendTime <= 0L) {
            request.firstSendTime = request.time;
        }
        if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"[SOCKET:%d] ReSend (%s)", (Object[])new Object[]{wsClient.identifySeq(), ProtoUtils.innerString(request.inner)});
        }
    }

    protected boolean setHeaderReflect(Message.Builder builder, Header header) {
        Object result = null;
        Class<?> c = builder.getClass();
        Method method = this.mSetHeaderMethodCache.get(c);
        try {
            if (method == null) {
                method = c.getMethod("setHeader", Header.class);
                this.mSetHeaderMethodCache.put(c, method);
            }
            result = method.invoke((Object)builder, new Object[]{header});
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"setHeaderReflect header: %s", (Throwable)e, (Object[])new Object[]{ProtoUtils.headerString(header)});
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"setHeaderReflect result: %b, header: %s", (Object[])new Object[]{result, ProtoUtils.headerString(header)});
        }
        return result != null;
    }
}

