/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.proto;

import androidx.annotation.NonNull;
import com.squareup.wire.Message;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.websocket.WsClient;
import com.yy.base.okhttp.websocket.ws.RpcStat;
import com.yy.base.utils.FP;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.proto.IDispatchCallback;
import com.yy.hiyo.proto.ProtoMonitor;
import com.yy.hiyo.proto.ProtoUtils;
import com.yy.hiyo.proto.WsCIMRequest;
import com.yy.hiyo.proto.callback.ICIMProtoCallback;
import common.Header;
import ikxd.cproxy.InnerV2;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbsCIMProtoDispatch {
    private static final String TAG = "AbsCIMProtoDispatch";
    private final ConcurrentHashMap<Class<? extends Message.Builder>, Method> mSetHeaderMethodCache = new ConcurrentHashMap();
    protected final IDispatchCallback mDispatchCallback;

    protected AbsCIMProtoDispatch(IDispatchCallback callback) {
        this.mDispatchCallback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSomeError(boolean canRetry, String reason, int code) {
        WsCIMRequest request;
        HashMap<Long, WsCIMRequest> requestCopy;
        ArrayList rm = new ArrayList();
        Map<Long, WsCIMRequest> original = this.getRequestMap();
        if (FP.empty(original)) {
            return;
        }
        Iterator iterator = original;
        synchronized (iterator) {
            requestCopy = new HashMap<Long, WsCIMRequest>(original);
        }
        for (Map.Entry entry : requestCopy.entrySet()) {
            Header header;
            ICIMProtoCallback cb;
            request = (WsCIMRequest)entry.getValue();
            if (request == null || (cb = request.callback) == null) {
                rm.add(entry.getKey());
                continue;
            }
            String sName = "";
            String method = "";
            int uri = 0;
            InnerV2 innerV2 = request.inner;
            if (innerV2 != null && (header = innerV2.header) != null) {
                sName = header.sname;
                method = header.method;
                uri = innerV2.uri != null ? innerV2.uri : 0;
            }
            long useTime = System.currentTimeMillis() - request.time;
            if (canRetry) {
                if ((long)request.retryCount > 3L) {
                    this.onRetryWhenError(cb, sName, uri, request.seqId, false, reason, code, useTime, request.retryCount, method);
                    rm.add(entry.getKey());
                    continue;
                }
                if (this.onRetryWhenError(cb, sName, uri, request.seqId, true, reason, code, useTime, request.retryCount, method)) {
                    this.resend(request, true);
                    continue;
                }
                rm.add(entry.getKey());
                continue;
            }
            this.onRetryWhenError(cb, sName, uri, request.seqId, false, reason, code, useTime, request.retryCount, method);
            rm.add(entry.getKey());
        }
        for (Object e : rm) {
            request = this.removeRequest(original, e, " onerror");
            if (request == null) continue;
            request.recycle();
        }
    }

    void onResponse(String wsUrl, @NonNull byte[] resData, @NonNull InnerV2 inner, int originSize) {
        if (inner.header != null) {
            Header header = inner.header;
            ProtoMonitor.monitorResponse(header.sname, inner.uri, header.seqid, inner.payload.size());
        }
    }

    @NonNull
    protected abstract Map<Long, WsCIMRequest> getRequestMap();

    protected abstract boolean onResend(WsClient var1, WsCIMRequest var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCheckTimeoutReq() {
        HashMap<Long, WsCIMRequest> requestCopy;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onCheckTimeoutReq", (Object[])new Object[0]);
        }
        long cur = System.currentTimeMillis();
        Map<Long, WsCIMRequest> original = this.getRequestMap();
        if (FP.empty(original)) {
            return;
        }
        Map<Long, WsCIMRequest> map = original;
        synchronized (map) {
            requestCopy = new HashMap<Long, WsCIMRequest>(original);
        }
        for (Map.Entry entry : requestCopy.entrySet()) {
            WsCIMRequest req;
            WsCIMRequest request = (WsCIMRequest)entry.getValue();
            if (RuntimeContext.sIsDebuggable) {
                long timeCheck = cur - request.time;
                request.statKey = request.statKey + " checktime" + timeCheck;
            }
            String method = request.inner != null ? request.inner.header.method : "";
            int uri = request.inner != null ? request.inner.uri : InnerV2.DEFAULT_URI;
            ICIMProtoCallback cb = request.callback;
            if (cb == null || cb.getTimeoutTimeLength() <= 0L ? cur - request.time < 10000L : cur - request.time < cb.getTimeoutTimeLength()) continue;
            if (cb == null) {
                req = this.removeRequest(original, entry.getKey(), " timeout");
                if (req == null) continue;
                req.recycle();
                continue;
            }
            if ((long)request.retryCount > 3L) {
                this.onRetryWhenTimeout(cb, request, false, uri, method);
                req = this.removeRequest(original, entry.getKey(), " timeout");
                if (req == null) continue;
                req.recycle();
                continue;
            }
            if (!this.onRetryWhenTimeout(cb, request, true, uri, method)) {
                req = this.removeRequest(original, entry.getKey(), " timeout");
                if (req == null) continue;
                req.recycle();
                continue;
            }
            this.resend(request, true);
        }
    }

    protected boolean onRetryWhenTimeout(ICIMProtoCallback cb, WsCIMRequest request, boolean canRetry, int uri, String method) {
        Header header;
        InnerV2 innerV2;
        if (request != null && (innerV2 = request.inner) != null && (header = innerV2.header) != null) {
            ProtoMonitor.monitorTimeout(header.sname, innerV2.uri != null ? innerV2.uri : 0, request.seqId);
            RpcStat.statRpcFail((String)header.sname, (String)(method + uri), (long)(System.currentTimeMillis() - request.time), (String)("timeout in " + cb.getTimeoutTimeLength() + " ms "), (int)request.retryCount, (int)NetworkUtils.getWsRpcRequestTimeoutCode());
        }
        if (cb != null) {
            return cb.retryWhenTimeout(canRetry);
        }
        return false;
    }

    protected boolean onRetryWhenError(ICIMProtoCallback cb, String sName, int uri, long seqId, boolean canRetry, String reason, int code, long useTime, int retryTimes, String method) {
        ProtoMonitor.monitorError(sName, uri, seqId, reason, code);
        RpcStat.statRpcFail((String)sName, (String)(method + uri), (long)useTime, (String)("retry when error code " + code + " reason = " + reason + " seqId = " + seqId), (int)code, (int)retryTimes);
        if (cb != null) {
            return cb.retryWhenError(canRetry, reason, code);
        }
        return false;
    }

    protected WsCIMRequest removeRequest(Map<? extends Object, WsCIMRequest> map, Object key, String reasonStatStr) {
        WsCIMRequest request = null;
        request = map.remove(key);
        ProtoMonitor.monitorMsgConsumeTime(reasonStatStr, request);
        return request;
    }

    private void resend(WsCIMRequest request, boolean isRetry) {
        if (request == null || request.isRecycle) {
            return;
        }
        if (isRetry) {
            ++request.retryCount;
        }
        request.time = System.currentTimeMillis();
        WsClient wsClient = this.mDispatchCallback.getWsClient(request.wsUrl);
        if (wsClient == null) {
            return;
        }
        if (RuntimeContext.sIsDebuggable) {
            request.statKey = request.statKey + " resend";
        }
        if (RuntimeContext.sIsDebuggable) {
            MLog.debug((Object)TAG, (String)"[SOCKET:%d] ReSend before reset seqId (%s)", (Object[])new Object[]{wsClient.identifySeq(), ProtoUtils.innerString(request.inner)});
        }
        this.onResend(wsClient, request);
        if (RuntimeContext.sIsDebuggable) {
            MLog.debug((Object)TAG, (String)"[SOCKET:%d] ReSend (%s)", (Object[])new Object[]{wsClient.identifySeq(), ProtoUtils.innerString(request.inner)});
        }
    }

    protected boolean setHeaderReflect(Message.Builder builder, Header header) {
        Object result = null;
        Class<?> c = builder.getClass();
        Method method = this.mSetHeaderMethodCache.get(c);
        try {
            if (method == null) {
                method = c.getMethod("header", Header.class);
                this.mSetHeaderMethodCache.put(c, method);
            }
            result = method.invoke((Object)builder, new Object[]{header});
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"setHeaderReflect header: %s", (Throwable)e, (Object[])new Object[]{ProtoUtils.headerString(header)});
        }
        if (RuntimeContext.sIsDebuggable) {
            MLog.debug((Object)TAG, (String)"setHeaderReflect result: %b, header: %s", (Object[])new Object[]{result, ProtoUtils.headerString(header)});
        }
        return result != null;
    }
}

