/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.pk.video.data.model;

import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.MetricMonitor;
import com.yy.base.logger.MLog;
import com.yy.hiyo.pk.video.data.PkDataManager;
import com.yy.hiyo.pk.video.data.entity.PkInviteNotifyData;
import com.yy.hiyo.pk.video.data.entity.PkStatus;
import com.yy.hiyo.pk.video.data.model.OnPkRequestCallback;
import com.yy.hiyo.pk.video.data.model.PkRelatedModel;
import com.yy.hiyo.pk.video.data.model.PkRelatedModelImpl;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.show.api.pk.AcceptPkReq;
import net.ihago.show.api.pk.AcceptPkRes;
import net.ihago.show.api.pk.RejectPkReq;
import net.ihago.show.api.pk.RejectPkRes;
import net.ihago.show.api.pk.RetCode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u001aH\u0016J\u0016\u0010\u001b\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u0012H\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u0018\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010 \u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u001aH\u0016J\u0016\u0010!\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u001aH\u0016J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u000bH\u0016R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\t\u001a\u0004\b\f\u0010\u0007R!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\t\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006$"}, d2={"Lcom/yy/hiyo/pk/video/data/model/PkRelatedModelImpl;", "Lcom/yy/hiyo/pk/video/data/model/PkRelatedModel;", "()V", "mAcceptData", "Landroidx/lifecycle/MutableLiveData;", "Lcom/yy/hiyo/pk/video/data/entity/PkStatus;", "getMAcceptData", "()Landroidx/lifecycle/MutableLiveData;", "mAcceptData$delegate", "Lkotlin/Lazy;", "mInviteNotifyData", "Lcom/yy/hiyo/pk/video/data/entity/PkInviteNotifyData;", "getMInviteNotifyData", "mInviteNotifyData$delegate", "mRejectData", "getMRejectData", "mRejectData$delegate", "acceptPkRequest", "", "cid", "", "pkId", "callback", "Lcom/yy/hiyo/pk/video/data/model/OnPkRequestCallback;", "addAcceptDataObserver", "observer", "Landroidx/lifecycle/Observer;", "addRejectDataObserver", "clearAllObservers", "getAcceptData", "getRejectData", "rejectPkRequest", "removeAcceptDataObserver", "removeRejectDataObserver", "setInviteNotifyData", "entity", "pk_debug"})
public final class PkRelatedModelImpl
implements PkRelatedModel {
    private final Lazy mAcceptData$delegate = LazyKt.lazy((Function0)mAcceptData.2.INSTANCE);
    private final Lazy mRejectData$delegate = LazyKt.lazy((Function0)mRejectData.2.INSTANCE);
    private final Lazy mInviteNotifyData$delegate = LazyKt.lazy((Function0)mInviteNotifyData.2.INSTANCE);

    private final MutableLiveData<PkStatus> getMAcceptData() {
        Lazy lazy = this.mAcceptData$delegate;
        PkRelatedModelImpl pkRelatedModelImpl = this;
        Object var3_3 = null;
        boolean bl = false;
        return (MutableLiveData)lazy.getValue();
    }

    private final MutableLiveData<PkStatus> getMRejectData() {
        Lazy lazy = this.mRejectData$delegate;
        PkRelatedModelImpl pkRelatedModelImpl = this;
        Object var3_3 = null;
        boolean bl = false;
        return (MutableLiveData)lazy.getValue();
    }

    private final MutableLiveData<PkInviteNotifyData> getMInviteNotifyData() {
        Lazy lazy = this.mInviteNotifyData$delegate;
        PkRelatedModelImpl pkRelatedModelImpl = this;
        Object var3_3 = null;
        boolean bl = false;
        return (MutableLiveData)lazy.getValue();
    }

    @Override
    public void setInviteNotifyData(@NotNull PkInviteNotifyData entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        this.getMInviteNotifyData().postValue((Object)entity);
    }

    @Override
    public void addAcceptDataObserver(@NotNull Observer<PkStatus> observer2) {
        Intrinsics.checkParameterIsNotNull(observer2, (String)"observer");
        this.getMAcceptData().observe(PkDataManager.Companion.getPkLifecycleOwner(), observer2);
    }

    @Override
    public void removeAcceptDataObserver(@NotNull Observer<PkStatus> observer2) {
        Intrinsics.checkParameterIsNotNull(observer2, (String)"observer");
        this.getMAcceptData().removeObserver(observer2);
    }

    @Override
    @NotNull
    public MutableLiveData<PkStatus> getAcceptData() {
        return this.getMAcceptData();
    }

    @Override
    public void addRejectDataObserver(@NotNull Observer<PkStatus> observer2) {
        Intrinsics.checkParameterIsNotNull(observer2, (String)"observer");
        this.getMRejectData().observe(PkDataManager.Companion.getPkLifecycleOwner(), observer2);
    }

    @Override
    public void removeRejectDataObserver(@NotNull Observer<PkStatus> observer2) {
        Intrinsics.checkParameterIsNotNull(observer2, (String)"observer");
        this.getMRejectData().removeObserver(observer2);
    }

    @Override
    @NotNull
    public MutableLiveData<PkStatus> getRejectData() {
        return this.getMRejectData();
    }

    @Override
    public void acceptPkRequest(@NotNull String cid, @NotNull String pkId, @NotNull OnPkRequestCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)cid, (String)"cid");
        Intrinsics.checkParameterIsNotNull((Object)pkId, (String)"pkId");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        AcceptPkReq req = new AcceptPkReq.Builder().pk_id(pkId).build();
        MLog.debug((Object)"FTPK_PkData", (String)("acceptPkRequest " + req), (Object[])new Object[0]);
        long curTime = System.currentTimeMillis();
        ProtoManager.getInstance().sendRpc(cid, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<AcceptPkRes>(this, callback, curTime){
            final /* synthetic */ PkRelatedModelImpl this$0;
            final /* synthetic */ OnPkRequestCallback $callback;
            final /* synthetic */ long $curTime;

            public void onResponse(@NotNull AcceptPkRes message, long code, @Nullable String msg) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                super.onResponse((AndroidMessage)message, code, msg);
                PkRelatedModelImpl.access$getMAcceptData$p(this.this$0).postValue((Object)new PkStatus(code, msg));
                this.$callback.onResponse(code, msg);
                if ((int)code != RetCode.ERR_Ok.getValue()) {
                    MLog.info((Object)"FTPK_PkData", (String)("accept Pk error code=" + code + ", reason=" + msg), (Object[])new Object[0]);
                }
                MetricMonitor.INSTANCE.statMetric("showpk/acceptPk", System.currentTimeMillis() - this.$curTime, this.isSuccess(code), code);
            }

            public void onError(@Nullable String reason, int code) {
                super.onError(reason, code);
                this.$callback.onResponse(code, reason);
                MLog.info((Object)"FTPK_PkData", (String)("accept Pk error code=" + code + ", reason=" + reason), (Object[])new Object[0]);
                MetricMonitor.INSTANCE.statMetric("showpk/acceptPk", System.currentTimeMillis() - this.$curTime, false, (long)code);
            }
            {
                this.this$0 = $outer;
                this.$callback = $captured_local_variable$1;
                this.$curTime = $captured_local_variable$2;
            }
        });
    }

    @Override
    public void rejectPkRequest(@NotNull String pkId, @NotNull OnPkRequestCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)pkId, (String)"pkId");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        RejectPkReq req = new RejectPkReq.Builder().pk_id(pkId).build();
        MLog.debug((Object)"FTPK_PkData", (String)("rejectPkRequest " + req), (Object[])new Object[0]);
        long cur = System.currentTimeMillis();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<RejectPkRes>(this, callback, pkId, cur){
            final /* synthetic */ PkRelatedModelImpl this$0;
            final /* synthetic */ OnPkRequestCallback $callback;
            final /* synthetic */ String $pkId;
            final /* synthetic */ long $cur;

            public void onResponse(@NotNull RejectPkRes message, long code, @Nullable String msg) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                super.onResponse((AndroidMessage)message, code, msg);
                PkRelatedModelImpl.access$getMRejectData$p(this.this$0).postValue((Object)new PkStatus(code, msg));
                this.$callback.onResponse(code, msg);
                if ((int)code != RetCode.ERR_Ok.getValue()) {
                    MLog.info((Object)"FTPK_PkData", (String)("reject Pk id: " + this.$pkId + " error code=" + code + ", reason=" + msg), (Object[])new Object[0]);
                }
                MetricMonitor.INSTANCE.statMetric("showpk/rejectPk", System.currentTimeMillis() - this.$cur, this.isSuccess(code), code);
            }

            public void onError(@Nullable String reason, int code) {
                super.onError(reason, code);
                this.$callback.onResponse(code, reason);
                MLog.info((Object)"FTPK_PkData", (String)("reject Pk error code=" + code + ", reason=" + reason), (Object[])new Object[0]);
                MetricMonitor.INSTANCE.statMetric("showpk/rejectPk", System.currentTimeMillis() - this.$cur, false, (long)code);
            }
            {
                this.this$0 = $outer;
                this.$callback = $captured_local_variable$1;
                this.$pkId = $captured_local_variable$2;
                this.$cur = $captured_local_variable$3;
            }
        });
    }

    @Override
    public void clearAllObservers() {
        this.getMAcceptData().removeObservers(PkDataManager.Companion.getPkLifecycleOwner());
        this.getMRejectData().removeObservers(PkDataManager.Companion.getPkLifecycleOwner());
        this.getMInviteNotifyData().removeObservers(PkDataManager.Companion.getPkLifecycleOwner());
    }

    public static final /* synthetic */ MutableLiveData access$getMAcceptData$p(PkRelatedModelImpl $this) {
        return $this.getMAcceptData();
    }

    public static final /* synthetic */ MutableLiveData access$getMRejectData$p(PkRelatedModelImpl $this) {
        return $this.getMRejectData();
    }
}

