/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.pickme.ui.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import com.opensource.svgaplayer.SVGACallback;
import com.opensource.svgaplayer.SVGADrawable;
import com.opensource.svgaplayer.SVGADynamicEntity;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.hiyo.channel.plugins.pickme.bean.MatchSuccessInfo;
import com.yy.hiyo.channel.plugins.pickme.ui.callback.IPlayMatchEffectEnd;
import com.yy.hiyo.dyres.api.DyResLoader;
import org.jetbrains.annotations.Nullable;

public class PickMeMatchSVGAView
extends SVGAImageView {
    private static final String TAG = "PickMeMatchSVGAView";
    private TextPaint mNickNamePaint;
    private TextPaint mLeftIndexPaint;
    private TextPaint mRightIndexPaint;
    private TextPaint mCharmValuePaint;
    private IPlayMatchEffectEnd playMatchEffectEnd;
    private SVGACallback mSvgaCallback = new SVGACallback(){

        public void onPause() {
        }

        public void onFinished() {
            YYTaskExecutor.postToMainThread(() -> PickMeMatchSVGAView.this.doCallback(true));
        }

        public void onRepeat() {
        }

        public void onStep(int i, double v) {
        }
    };

    public void setPlayMatchEffectEnd(@NonNull IPlayMatchEffectEnd playMatchEffectEnd) {
        this.playMatchEffectEnd = playMatchEffectEnd;
    }

    public PickMeMatchSVGAView(@Nullable Context context) {
        super(context);
        this.initView(context);
    }

    public PickMeMatchSVGAView(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public PickMeMatchSVGAView(@Nullable Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    private void initView(Context context) {
        this.setLoops(1);
        this.setCallback(this.mSvgaCallback);
    }

    public void startMatchEffect(MatchSuccessInfo matchUserInfo) {
        if (matchUserInfo == null) {
            this.doCallback(false);
            return;
        }
        this.loadSvga(matchUserInfo);
    }

    private void loadSvga(final @NonNull MatchSuccessInfo matchSuccessInfo) {
        DyResLoader.INSTANCE.loadSvga((SVGAImageView)this, matchSuccessInfo.getSvgaKey(), new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                PickMeMatchSVGAView.this.fillSvgaImage(svgaVideoEntity, matchSuccessInfo);
            }

            public void onFailed(Exception e) {
                MLog.info((Object)PickMeMatchSVGAView.TAG, (String)"SvgaLoader.load onFailed: %s", (Object[])new Object[]{e});
                PickMeMatchSVGAView.this.doCallback(false);
            }
        });
    }

    private void fillSvgaImage(@NonNull SVGAVideoEntity svgaVideoEntity, @NonNull MatchSuccessInfo matchUserInfo) {
        String leftUrl = matchUserInfo.getFemaleAvatarUrl();
        String leftName = this.cutNickName(matchUserInfo.getFemaleName());
        String leftIndex = matchUserInfo.getFemaleIndex();
        String rightUrl = matchUserInfo.getMaleAvatarUrl();
        String rightName = this.cutNickName(matchUserInfo.getMaleName());
        String rightIndex = matchUserInfo.getMaleIndex();
        String leftHatUrl = matchUserInfo.getFemaleHatUrl();
        String rightHatUrl = matchUserInfo.getMaleHatUrl();
        String totalCharmValue = StringUtils.getFormatedNumber((long)matchUserInfo.getCharmValue(), (int)1);
        SVGADynamicEntity dynamicEntity = new SVGADynamicEntity();
        dynamicEntity.setDynamicText(leftIndex, this.getLeftIndexPaint(), "number01");
        dynamicEntity.setDynamicText(rightIndex, this.getRightIndexPaint(), "number02");
        dynamicEntity.setDynamicText(leftName, this.getNickNamePaint(), "username01");
        dynamicEntity.setDynamicText(rightName, this.getNickNamePaint(), "username02");
        if (matchUserInfo.getCharmValue() > 0L) {
            dynamicEntity.setDynamicText(totalCharmValue, this.getCharmValuePaint(), "meili");
        }
        this.showUserAvatar(true, leftUrl, dynamicEntity);
        this.showUserAvatar(false, rightUrl, dynamicEntity);
        this.showUserHat(true, leftHatUrl, dynamicEntity);
        this.showUserHat(false, rightHatUrl, dynamicEntity);
        SVGADrawable drawable2 = new SVGADrawable(svgaVideoEntity, dynamicEntity);
        this.setImageDrawable((Drawable)drawable2);
        this.startAnimation();
    }

    private void showUserAvatar(final boolean left, String url, final SVGADynamicEntity dynamicEntity) {
        ImageLoader.loadBitmap((Context)this.getContext(), (String)url, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

            public void onLoadFailed(Exception e) {
            }

            public void onResourceReady(Bitmap bitmap) {
                String key = left ? "touxiang01" : "touxiang02";
                dynamicEntity.setDynamicImage(bitmap, key);
            }
        });
    }

    private void showUserHat(final boolean left, String url, final SVGADynamicEntity dynamicEntity) {
        ImageLoader.loadBitmap((Context)this.getContext(), (String)url, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

            public void onLoadFailed(Exception e) {
            }

            public void onResourceReady(Bitmap bitmap) {
                MLog.info((Object)PickMeMatchSVGAView.TAG, (String)"showUserHat onResourceReady", (Object[])new Object[0]);
                String key = left ? "hat01" : "hat02";
                dynamicEntity.setDynamicImage(bitmap, key);
            }
        });
    }

    private TextPaint getNickNamePaint() {
        if (this.mNickNamePaint == null) {
            this.mNickNamePaint = new TextPaint();
        }
        this.mNickNamePaint.setTextSize(25.0f);
        this.mNickNamePaint.setColor(-1);
        return this.mNickNamePaint;
    }

    private TextPaint getLeftIndexPaint() {
        if (this.mLeftIndexPaint == null) {
            this.mLeftIndexPaint = new TextPaint();
        }
        this.mLeftIndexPaint.setColor(Color.parseColor((String)"#ea3c74"));
        this.mLeftIndexPaint.setTextSize(20.0f);
        return this.mLeftIndexPaint;
    }

    private TextPaint getRightIndexPaint() {
        if (this.mRightIndexPaint == null) {
            this.mRightIndexPaint = new TextPaint();
        }
        this.mRightIndexPaint.setTextSize(20.0f);
        this.mRightIndexPaint.setColor(Color.parseColor((String)"#15cade"));
        return this.mRightIndexPaint;
    }

    private TextPaint getCharmValuePaint() {
        if (this.mCharmValuePaint == null) {
            this.mCharmValuePaint = new TextPaint();
        }
        this.mCharmValuePaint.setColor(-1);
        this.mCharmValuePaint.setTextSize(20.0f);
        return this.mCharmValuePaint;
    }

    private String cutNickName(String nickName) {
        if (FP.empty((CharSequence)nickName)) {
            return "";
        }
        if (nickName.length() > 7) {
            nickName = nickName.substring(0, 7) + "...";
        }
        return nickName;
    }

    private void doCallback(boolean successs) {
        if (this.playMatchEffectEnd != null) {
            this.playMatchEffectEnd.playEnd(successs);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.clearAnimation();
    }
}

