/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.pickme.business.manager;

import android.os.Bundle;
import androidx.annotation.NonNull;
import com.yy.hiyo.channel.plugins.pickme.base.IEventHandler;
import com.yy.hiyo.channel.plugins.pickme.base.IEventProducer;
import com.yy.hiyo.channel.plugins.pickme.base.IService;
import com.yy.hiyo.channel.plugins.pickme.base.PickMeContext;
import com.yy.hiyo.channel.plugins.pickme.model.base.IProtoService;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BaseManager
implements IService,
IEventProducer {
    protected PickMeContext mContext;
    protected IProtoService mProtoService;
    private List<IEventHandler> mEventHandlers = new LinkedList<IEventHandler>();
    private boolean mIsDestroyed = false;

    public BaseManager(@NotNull PickMeContext context, @NonNull IProtoService protoService) {
        this.mContext = context;
        this.mProtoService = protoService;
    }

    @Override
    public void onServiceInit() {
        this.mIsDestroyed = false;
    }

    @Override
    public void onServiceDestroy() {
        this.mIsDestroyed = true;
        this.mEventHandlers.clear();
    }

    public boolean isDestroyed() {
        return this.mIsDestroyed;
    }

    @Override
    public void addEventHandler(IEventHandler handler) {
        if (handler == null) {
            return;
        }
        this.mEventHandlers.add(handler);
    }

    @Override
    public void removeEventHandler(IEventHandler handler) {
        if (handler == null) {
            return;
        }
        this.mEventHandlers.remove(handler);
    }

    @Override
    public void sendEvent(int eventId) {
        this.sendEvent(eventId, null);
    }

    @Override
    public void sendEvent(int eventId, Bundle data) {
        for (IEventHandler handler : this.mEventHandlers) {
            handler.handleEvent(eventId, data);
        }
    }
}

