/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.pickme.ui;

import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.plugins.pickme.seat.PickmeSeatPresenter;
import com.yy.hiyo.channel.plugins.pickme.ui.FunctionMenuManager;
import com.yy.hiyo.channel.plugins.pickme.ui.GuideManager;
import com.yy.hiyo.channel.plugins.pickme.ui.PlayAnimManager;
import com.yy.hiyo.channel.plugins.pickme.ui.StageViewManager;
import com.yy.hiyo.channel.plugins.pickme.ui.base.IFunctionMenuManager;
import com.yy.hiyo.channel.plugins.pickme.ui.base.IGuideManager;
import com.yy.hiyo.channel.plugins.pickme.ui.base.IPlayAnimManager;
import com.yy.hiyo.channel.plugins.pickme.ui.base.ISeatViewManager;
import com.yy.hiyo.channel.plugins.pickme.ui.base.IStageViewManager;
import com.yy.hiyo.channel.plugins.pickme.ui.base.IViewManagerProvider;

public class ViewManagerProvider
implements IViewManagerProvider {
    private IChannelPageContext mRoomPageContext;
    private RelativeLayout mViewContainer;
    private IGuideManager mGuideManager;
    private IFunctionMenuManager mFunctionMenuManager;
    private IPlayAnimManager mPlayAnimManager;
    private ISeatViewManager mSeatViewManager;
    private IStageViewManager mStageViewManager;

    public ViewManagerProvider(IChannelPageContext mRoomPageContext, @NonNull RelativeLayout viewContainer) {
        this.mViewContainer = viewContainer;
        this.mRoomPageContext = mRoomPageContext;
    }

    @Override
    public IGuideManager getGuideManager() {
        if (this.mGuideManager == null) {
            this.mGuideManager = new GuideManager(this.mRoomPageContext);
        }
        return this.mGuideManager;
    }

    @Override
    public IPlayAnimManager getPlayAnimManager() {
        if (this.mPlayAnimManager == null) {
            this.mPlayAnimManager = new PlayAnimManager(this.mViewContainer);
        }
        return this.mPlayAnimManager;
    }

    @Override
    public IFunctionMenuManager getFunctionMenuManager() {
        if (this.mFunctionMenuManager == null) {
            this.mFunctionMenuManager = new FunctionMenuManager(this.mViewContainer);
        }
        return this.mFunctionMenuManager;
    }

    @Override
    public ISeatViewManager getSeatViewManager() {
        if (this.mSeatViewManager == null) {
            this.mSeatViewManager = (ISeatViewManager)this.mRoomPageContext.getPresenter(PickmeSeatPresenter.class);
        }
        return this.mSeatViewManager;
    }

    @Override
    public IStageViewManager getStageViewManager() {
        if (this.mStageViewManager == null) {
            this.mStageViewManager = new StageViewManager(this.mViewContainer);
        }
        return this.mStageViewManager;
    }
}

