/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.pickme.business;

import com.yy.hiyo.channel.plugins.pickme.base.PickMeContext;
import com.yy.hiyo.channel.plugins.pickme.business.base.IServiceProvider;
import com.yy.hiyo.channel.plugins.pickme.business.manager.ILifecycleManager;
import com.yy.hiyo.channel.plugins.pickme.business.manager.IPlayerManager;
import com.yy.hiyo.channel.plugins.pickme.business.manager.IRoleManager;
import com.yy.hiyo.channel.plugins.pickme.business.manager.LifecycleManager;
import com.yy.hiyo.channel.plugins.pickme.business.manager.PlayerManager;
import com.yy.hiyo.channel.plugins.pickme.business.manager.RoleManager;
import com.yy.hiyo.channel.plugins.pickme.model.ProtoServiceFactory;
import com.yy.hiyo.channel.plugins.pickme.model.base.IProtoService;
import org.jetbrains.annotations.NotNull;

public class ServiceProvider
implements IServiceProvider {
    private ILifecycleManager mLifecycleManager;
    private IRoleManager mRoleManager;
    private IPlayerManager mPlayerManager;
    private IProtoService mProtoService;

    public ServiceProvider(@NotNull PickMeContext context) {
        String roomId = context.getRoomData().getRoomId();
        this.mProtoService = ProtoServiceFactory.createProtoService(roomId);
        this.mLifecycleManager = new LifecycleManager(context, this.mProtoService);
        this.mRoleManager = new RoleManager(context, this.mProtoService);
        this.mPlayerManager = new PlayerManager(context, this.mProtoService);
    }

    @Override
    public ILifecycleManager getLifecycleManager() {
        return this.mLifecycleManager;
    }

    @Override
    public IPlayerManager getPlayerManager() {
        return this.mPlayerManager;
    }

    @Override
    public IRoleManager getRoleManager() {
        return this.mRoleManager;
    }

    @Override
    public IProtoService getProtoService() {
        return this.mProtoService;
    }

    @Override
    public void onServiceInit() {
        if (this.mLifecycleManager != null) {
            this.mLifecycleManager.onServiceInit();
        }
        if (this.mPlayerManager != null) {
            this.mPlayerManager.onServiceInit();
        }
        if (this.mRoleManager != null) {
            this.mRoleManager.onServiceInit();
        }
        if (this.mProtoService != null) {
            this.mProtoService.startNotifyListen();
        }
    }

    @Override
    public void onServiceDestroy() {
        if (this.mLifecycleManager != null) {
            this.mLifecycleManager.onServiceDestroy();
        }
        if (this.mPlayerManager != null) {
            this.mPlayerManager.onServiceDestroy();
        }
        if (this.mRoleManager != null) {
            this.mRoleManager.onServiceDestroy();
        }
        if (this.mProtoService != null) {
            this.mProtoService.stopNotifyListen();
        }
    }
}

