/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.pickme.ui;

import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.hiyo.channel.plugins.pickme.R;
import com.yy.hiyo.channel.plugins.pickme.bean.FuncBtnStatus;
import com.yy.hiyo.channel.plugins.pickme.ui.base.IFunctionMenuManager;
import com.yy.hiyo.channel.plugins.pickme.ui.callback.IFunctionMenuCallback;
import com.yy.hiyo.channel.plugins.pickme.ui.callback.IFunctionMenuClickListener;
import com.yy.hiyo.channel.plugins.pickme.ui.view.FunctionMenuView;

public class FunctionMenuManager
implements IFunctionMenuManager {
    private static final String TAG = "FTPickMe#FunctionMenuManager";
    private RelativeLayout mViewContainer;
    private FunctionMenuView mFuncMenuView;
    private IFunctionMenuCallback mMenuCallback;
    private FuncBtnStatus mFuncBtnStatus;

    public FunctionMenuManager(@NonNull RelativeLayout viewContainer) {
        this.mViewContainer = viewContainer;
    }

    @Override
    public void showFunctionMenu(FuncBtnStatus status) {
        if (status == null) {
            return;
        }
        if (this.mFuncBtnStatus != null && this.mFuncBtnStatus.equals(status)) {
            return;
        }
        MLog.info((Object)TAG, (String)("showFunctionMenu, " + status), (Object[])new Object[0]);
        if (this.mFuncMenuView == null) {
            this.mFuncMenuView = this.createFuncMenuView();
            RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-2, -2);
            lp.topMargin = ResolutionUtils.dip2Px((float)340.0f);
            lp.addRule(11);
            if (Build.VERSION.SDK_INT >= 17) {
                lp.addRule(21);
            }
            this.mViewContainer.addView((View)this.mFuncMenuView, 0, (ViewGroup.LayoutParams)lp);
        }
        this.updateStatus(status);
    }

    private void updateStatus(FuncBtnStatus status) {
        this.mFuncBtnStatus = status;
        if (status.getType() == -1) {
            this.mFuncMenuView.mTvFuncBtn.setText(R.string.title_pick_me);
            this.mFuncMenuView.mTvFuncBtn.setActivated(status.isCanClick());
        } else if (status.getType() == 0) {
            this.mFuncMenuView.mTvFuncBtn.setText(R.string.btn_pick_me_publish);
            this.mFuncMenuView.mTvFuncBtn.setActivated(status.isCanClick());
        } else if (status.getType() == 1) {
            this.mFuncMenuView.mTvFuncBtn.setText(R.string.btn_pick_me_new_round);
            this.mFuncMenuView.mTvFuncBtn.setActivated(status.isCanClick());
        }
        this.mFuncMenuView.mTvEndBtn.setActivated(true);
    }

    @Override
    public void closeFunctionMenu() {
        if (this.mFuncMenuView != null) {
            this.mViewContainer.removeView((View)this.mFuncMenuView);
            this.mFuncMenuView = null;
        }
        this.mFuncBtnStatus = null;
    }

    @Override
    public void setCallback(IFunctionMenuCallback callback) {
        this.mMenuCallback = callback;
    }

    private FunctionMenuView createFuncMenuView() {
        FunctionMenuView functionMenuView = new FunctionMenuView(this.mViewContainer.getContext());
        functionMenuView.setListener(new IFunctionMenuClickListener(){

            @Override
            public void onIconClick() {
                if (FunctionMenuManager.this.mMenuCallback != null) {
                    FunctionMenuManager.this.mMenuCallback.onIconClick();
                }
            }

            @Override
            public void onFunctionClick() {
                if (FunctionMenuManager.this.mMenuCallback == null) {
                    return;
                }
                if (FunctionMenuManager.this.mFuncBtnStatus == null) {
                    return;
                }
                if (FunctionMenuManager.this.mFuncBtnStatus.getType() == -1) {
                    if (FunctionMenuManager.this.mFuncBtnStatus.isCanClick()) {
                        FunctionMenuManager.this.mMenuCallback.onChooseClick();
                    }
                } else if (FunctionMenuManager.this.mFuncBtnStatus.getType() == 0) {
                    if (FunctionMenuManager.this.mFuncBtnStatus.isCanClick()) {
                        FunctionMenuManager.this.mMenuCallback.onPublishClick();
                    } else {
                        ToastUtils.showToast((Context)FunctionMenuManager.this.mFuncMenuView.getContext(), (int)R.string.short_tips_pick_me_no_people_choose, (int)0);
                    }
                } else if (FunctionMenuManager.this.mFuncBtnStatus.getType() == 1 && FunctionMenuManager.this.mFuncBtnStatus.isCanClick()) {
                    FunctionMenuManager.this.mMenuCallback.onNewRoundClick();
                }
            }

            @Override
            public void onEndClick() {
                if (FunctionMenuManager.this.mMenuCallback != null) {
                    FunctionMenuManager.this.mMenuCallback.onEndClick();
                }
            }
        });
        return functionMenuView;
    }
}

