/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.pickme.ui;

import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.core.util.Pair;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiyo.channel.cbase.ChannelSettingFlag;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.tools.IRevenueToolsModulePresenter;
import com.yy.hiyo.channel.plugins.pickme.R;
import com.yy.hiyo.channel.plugins.pickme.base.PickMeContext;
import com.yy.hiyo.channel.plugins.pickme.bean.FuncBtnStatus;
import com.yy.hiyo.channel.plugins.pickme.bean.MatchSuccessInfo;
import com.yy.hiyo.channel.plugins.pickme.bean.MatchSuccessNotify;
import com.yy.hiyo.channel.plugins.pickme.bean.PlayerUpdateData;
import com.yy.hiyo.channel.plugins.pickme.business.dataprovider.IDataProvider;
import com.yy.hiyo.channel.plugins.pickme.common.MatchEffectLevel;
import com.yy.hiyo.channel.plugins.pickme.common.PickMeEvent;
import com.yy.hiyo.channel.plugins.pickme.common.PickMeStatis;
import com.yy.hiyo.channel.plugins.pickme.model.base.IResDataCallback;
import com.yy.hiyo.channel.plugins.pickme.seat.PickMeSeatItem;
import com.yy.hiyo.channel.plugins.pickme.ui.ViewManagerProvider;
import com.yy.hiyo.channel.plugins.pickme.ui.base.AbsPickMeViewController;
import com.yy.hiyo.channel.plugins.pickme.ui.base.IViewManagerProvider;
import com.yy.hiyo.channel.plugins.pickme.ui.callback.IFunctionMenuCallback;
import com.yy.hiyo.channel.plugins.pickme.ui.callback.IPickMeHolderCallback;
import com.yy.hiyo.channel.plugins.pickme.ui.callback.IPublishGuideCallback;
import com.yy.hiyo.channel.plugins.pickme.ui.callback.IStartGuideCallback;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PickMeViewController
extends AbsPickMeViewController {
    private static final String TAG = "FTPickMe#PickMeViewController";
    private PickMeContext mPickMeContext;
    private IChannelPageContext mRoomPageContext;
    private DefaultWindow mWindow;
    private RelativeLayout mExtLayerContainer;
    private IViewManagerProvider mViewManagerProvider;
    private IDataProvider mDataProvider;

    public PickMeViewController(@NonNull IChannelPageContext context, @NonNull DefaultWindow window, @NonNull PickMeContext pickMeContext) {
        this.mRoomPageContext = context;
        this.mWindow = window;
        this.mPickMeContext = pickMeContext;
        this.initExtLayerContainer();
        this.mViewManagerProvider = new ViewManagerProvider(this.mRoomPageContext, this.mExtLayerContainer);
        this.initListener();
    }

    private void initExtLayerContainer() {
        this.mExtLayerContainer = new YYRelativeLayout(this.mWindow.getContext());
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, -1);
        this.mWindow.getExtLayer().addView((View)this.mExtLayerContainer, 0, (ViewGroup.LayoutParams)lp);
    }

    private void initListener() {
        this.mViewManagerProvider.getFunctionMenuManager().setCallback(new IFunctionMenuCallback(){

            @Override
            public void onIconClick() {
                if (PickMeViewController.this.mPickMeContext != null && PickMeViewController.this.mPickMeContext.getRoomData() != null) {
                    PickMeStatis.reportMenuEnterClick(PickMeViewController.this.mPickMeContext.getRoomData().getRoomId());
                }
            }

            @Override
            public void onChooseClick() {
                PickMeViewController.this.sendEvent(PickMeEvent.ON_START_CHOOSE_CLICK);
            }

            @Override
            public void onNewRoundClick() {
                PickMeViewController.this.sendEvent(PickMeEvent.ON_NEW_ROUND_CLICK);
                if (PickMeViewController.this.mPickMeContext != null && PickMeViewController.this.mPickMeContext.getRoomData() != null) {
                    PickMeStatis.reportMenuNewRoundClick(PickMeViewController.this.mPickMeContext.getRoomData().getRoomId());
                }
            }

            @Override
            public void onPublishClick() {
                PickMeViewController.this.handleStartPublishClick();
                if (PickMeViewController.this.mPickMeContext != null && PickMeViewController.this.mPickMeContext.getRoomData() != null) {
                    PickMeStatis.reportMenuAnnounceClick(PickMeViewController.this.mPickMeContext.getRoomData().getRoomId());
                }
            }

            @Override
            public void onEndClick() {
                PickMeViewController.this.handleEndClick();
                if (PickMeViewController.this.mPickMeContext != null && PickMeViewController.this.mPickMeContext.getRoomData() != null) {
                    int stageId = 2;
                    if (PickMeViewController.this.mDataProvider != null && PickMeViewController.this.mDataProvider.getStatus().getValue() != null) {
                        boolean isSelectStatus = (Integer)PickMeViewController.this.mDataProvider.getStatus().getValue() == 1;
                        stageId = isSelectStatus ? 1 : 2;
                    }
                    PickMeStatis.reportMenuStopClick(PickMeViewController.this.mPickMeContext.getRoomData().getRoomId(), stageId);
                }
            }
        });
    }

    private void handleEndClick() {
        if (this.mRoomPageContext == null || this.mRoomPageContext.getDialogLinkManager() == null) {
            return;
        }
        OkCancelDialog dialog = new OkCancelDialog.Builder().message((CharSequence)ResourceUtils.getString((int)R.string.tips_close_pick_me_ensure, (Object[])new Object[]{this.mPickMeContext.getPickMeName()})).setCancelLabel((CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_no)).okLabel((CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_yes)).listener(new OkCancelDialogListener(){

            public void onCancel() {
            }

            public void onOk() {
                PickMeViewController.this.sendEvent(PickMeEvent.ON_END_CLICK);
            }
        }).cancelable(true).outSideCancelable(true).build();
        this.mRoomPageContext.getDialogLinkManager().showDialog((BaseDialog)dialog);
    }

    private void handleStartPublishClick() {
        if (this.checkNeedShowPublishGuide()) {
            this.mViewManagerProvider.getGuideManager().showPublishGuide(new IPublishGuideCallback(){

                @Override
                public void onPublish() {
                    PickMeViewController.this.sendEvent(PickMeEvent.ON_START_PUBLISH_CLICK);
                    if (PickMeViewController.this.mPickMeContext != null && PickMeViewController.this.mPickMeContext.getRoomData() != null) {
                        PickMeStatis.reportFirstPubGetClick(PickMeViewController.this.mPickMeContext.getRoomData().getRoomId());
                    }
                }

                @Override
                public void onLater() {
                    if (PickMeViewController.this.mPickMeContext != null && PickMeViewController.this.mPickMeContext.getRoomData() != null) {
                        PickMeStatis.reportFirstPubLaterClick(PickMeViewController.this.mPickMeContext.getRoomData().getRoomId());
                    }
                }
            });
            if (this.mPickMeContext != null && this.mPickMeContext.getRoomData() != null) {
                PickMeStatis.reportFirstPubPopShow(this.mPickMeContext.getRoomData().getRoomId());
            }
        } else {
            this.sendEvent(PickMeEvent.ON_START_PUBLISH_CLICK);
        }
    }

    @Override
    public void initDataObserver(@NotNull IDataProvider provider) {
        this.mDataProvider = provider;
        this.mViewManagerProvider.getSeatViewManager().setCallBack(new IPickMeHolderCallback(){

            @Override
            public void onPickMeOperationClick(int pickMode, long chooseUid) {
                Bundle bundle = new Bundle();
                bundle.putLong("seatUid", chooseUid);
                if (PickMeSeatItem.isSameMainMode(pickMode, 8)) {
                    PickMeViewController.this.sendEvent(PickMeEvent.ON_PICK_SOMEONE_CLICK, bundle);
                    if (PickMeViewController.this.mPickMeContext != null && PickMeViewController.this.mPickMeContext.getRoomData() != null) {
                        PickMeStatis.reportSelectLoveClick(PickMeViewController.this.mPickMeContext.getRoomData().getRoomId(), chooseUid);
                    }
                } else if (PickMeSeatItem.isSameMainMode(pickMode, 16)) {
                    PickMeViewController.this.sendEvent(PickMeEvent.ON_CANCEL_PICK_SOMEONE_CLICK, bundle);
                    if (PickMeViewController.this.mPickMeContext != null && PickMeViewController.this.mPickMeContext.getRoomData() != null) {
                        PickMeStatis.reportCancelLoveClick(PickMeViewController.this.mPickMeContext.getRoomData().getRoomId(), chooseUid);
                    }
                } else if (PickMeSeatItem.isSameMainMode(pickMode, 64)) {
                    PickMeViewController.this.sendEvent(PickMeEvent.ON_PUBLISH_SOMEONE_CLICK, bundle);
                    if (PickMeViewController.this.mPickMeContext != null && PickMeViewController.this.mPickMeContext.getRoomData() != null) {
                        PickMeStatis.reportPublishPlayerClick(PickMeViewController.this.mPickMeContext.getRoomData().getRoomId(), chooseUid);
                    }
                }
            }

            @Override
            public int getUidIndex(long uid) {
                return PickMeViewController.this.mRoomPageContext.getChannel().getSeatService().getSeatIndex(uid);
            }

            @Override
            public boolean hasShowResult(long uid) {
                return PickMeViewController.this.mViewManagerProvider.getSeatViewManager().hasShowResult(uid);
            }

            @Override
            public void setHasShowResult(long uid) {
                PickMeViewController.this.mViewManagerProvider.getSeatViewManager().setHasShowResult(uid);
            }
        });
        this.mViewManagerProvider.getSeatViewManager().initPickMeContext(this.mPickMeContext);
        this.mViewManagerProvider.getSeatViewManager().initDataProvider(this.mDataProvider, this.getLifecycleOwner());
        provider.getStatus().observe(this.getLifecycleOwner(), status -> {
            if (status == null) {
                return;
            }
            this.onPlayStatusUpdate((int)status);
        });
        provider.getRoleType().observe(this.getLifecycleOwner(), type -> {
            if (type == null) {
                return;
            }
            this.onRoleTypeUpdate((int)type);
        });
        provider.getPlayerUpdateData().observe(this.getLifecycleOwner(), playerUpdateData -> {
            if (playerUpdateData == null) {
                return;
            }
            this.onPlayerUpdate((PlayerUpdateData)playerUpdateData);
        });
        provider.getCanStartPublish().observe(this.getLifecycleOwner(), canStartPublish -> {
            if (canStartPublish == null) {
                return;
            }
            this.onCanPublishChanged((boolean)canStartPublish);
        });
        provider.getMatchSuccessNotify().observe(this.getLifecycleOwner(), matchSuccessNotify -> {
            if (matchSuccessNotify == null) {
                return;
            }
            if (!this.checkMatchSuccNotifyValid((MatchSuccessNotify)matchSuccessNotify)) {
                return;
            }
            this.onMatchSuccessNotify(matchSuccessNotify.getMatchSuccessInfo());
        });
    }

    @Override
    public void resume() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"resume", (Object[])new Object[0]);
        }
        super.resume();
        if (this.mViewManagerProvider != null && this.mViewManagerProvider.getSeatViewManager() != null) {
            this.mViewManagerProvider.getSeatViewManager().onResume();
        }
    }

    @Override
    public void pause() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"pause", (Object[])new Object[0]);
        }
        super.pause();
        if (this.mViewManagerProvider != null && this.mViewManagerProvider.getPlayAnimManager() != null) {
            this.mViewManagerProvider.getPlayAnimManager().onPause();
        }
    }

    @Override
    public void clear() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"clear", (Object[])new Object[0]);
        }
        super.clear();
        if (this.mViewManagerProvider != null && this.mViewManagerProvider.getSeatViewManager() != null) {
            this.mViewManagerProvider.getSeatViewManager().destroy();
        }
        if (this.mWindow != null && this.mExtLayerContainer != null) {
            try {
                this.mWindow.getExtLayer().removeView((View)this.mExtLayerContainer);
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)("mWindow.getExtLayer() removeView error, " + e.getMessage()), (Object[])new Object[0]);
            }
            this.mExtLayerContainer = null;
        }
        this.mWindow = null;
        this.mDataProvider = null;
    }

    private void onRoleTypeUpdate(int roleType) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("onRoleTypeUpdate, roleType=" + roleType), (Object[])new Object[0]);
        }
        if (roleType == 2) {
            boolean upgradedToNewPickMe = this.mPickMeContext.isNewPickMe();
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"is new pick me: %s", (Object[])new Object[]{upgradedToNewPickMe});
            }
            if (upgradedToNewPickMe) {
                if (this.checkNeedShowNewStartGuide()) {
                    this.showStartGuide(true);
                }
            } else if (this.checkNeedShowStartGuide()) {
                this.showStartGuide(false);
            }
        }
        this.updateFunctionMenu();
        this.updateStageView();
    }

    private void showStartGuide(boolean newPickMe) {
        this.mViewManagerProvider.getGuideManager().showStartGuide(new IStartGuideCallback(){

            @Override
            public void onGet() {
                if (PickMeViewController.this.mPickMeContext != null && PickMeViewController.this.mPickMeContext.getRoomData() != null) {
                    PickMeStatis.reportFirstSelectOkClick(PickMeViewController.this.mPickMeContext.getRoomData().getRoomId());
                }
            }
        }, newPickMe);
        if (this.mPickMeContext != null && this.mPickMeContext.getRoomData() != null) {
            PickMeStatis.reportFirstSelectPopShow(this.mPickMeContext.getRoomData().getRoomId());
        }
    }

    private void onPlayStatusUpdate(int status) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("onPlayStatusUpdate, status=" + status), (Object[])new Object[0]);
        }
        if (this.mDataProvider.getRoleType().getValue() != null && (Integer)this.mDataProvider.getRoleType().getValue() == 2) {
            this.updateFunctionMenu();
        }
        if (this.mDataProvider.getRoleType().getValue() != null && (Integer)this.mDataProvider.getRoleType().getValue() != 2) {
            this.updateStageView();
        }
        if (this.checkNeedShowStatusAnim()) {
            if (status == 4) {
                YYTaskExecutor.postToMainThread(() -> this.mViewManagerProvider.getPlayAnimManager().showStartIntroduceAnim(), (long)500L);
            } else if (status == 1) {
                YYTaskExecutor.postToMainThread(() -> this.mViewManagerProvider.getPlayAnimManager().showStartChooseAnim(), (long)500L);
            } else if (status == 2) {
                YYTaskExecutor.postToMainThread(() -> this.mViewManagerProvider.getPlayAnimManager().showPublishAnim(), (long)500L);
            }
        }
    }

    private void onPlayerUpdate(PlayerUpdateData updateData) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("onPlayerUpdate, " + updateData), (Object[])new Object[0]);
        }
    }

    private void onCanPublishChanged(boolean canStartPublish) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onCanPublishChanged, canStartPublish=%b", (Object[])new Object[]{canStartPublish});
        }
        if (this.mDataProvider.getRoleType().getValue() != null && (Integer)this.mDataProvider.getRoleType().getValue() == 2 && this.mDataProvider.getStatus().getValue() != null && (Integer)this.mDataProvider.getStatus().getValue() == 1) {
            this.updateFunctionMenu();
        }
    }

    private void onMatchSuccessNotify(MatchSuccessInfo matchSuccessInfo) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("onMatchSuccessNotify, " + matchSuccessInfo), (Object[])new Object[0]);
        }
        String leftHatUrl = ((IRevenueToolsModulePresenter)this.mRoomPageContext.getPresenter(IRevenueToolsModulePresenter.class)).getUserHatUrl(matchSuccessInfo.getLeftUid());
        String rightHatUrl = ((IRevenueToolsModulePresenter)this.mRoomPageContext.getPresenter(IRevenueToolsModulePresenter.class)).getUserHatUrl(matchSuccessInfo.getRightUid());
        if (StringUtils.isNotEmpty((String)leftHatUrl)) {
            matchSuccessInfo.setLeftHatUrl(leftHatUrl);
        }
        if (StringUtils.isNotEmpty((String)rightHatUrl)) {
            matchSuccessInfo.setRightUrl(rightHatUrl);
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onMatchSuccessNotify, leftHatUrl %s rightHatUrl : %s", (Object[])new Object[]{leftHatUrl, rightHatUrl});
        }
        this.fetchUserInfo(matchSuccessInfo, new IResDataCallback<MatchSuccessInfo>(){

            @Override
            public void onSuccess(final MatchSuccessInfo data) {
                if (PickMeViewController.this.mDataProvider == null) {
                    MLog.error((Object)PickMeViewController.TAG, (String)"mDataProvider == null", (Object[])new Object[0]);
                    data.setCharmValue(0L);
                    data.setMatchEffectLevel(MatchEffectLevel.LOWER);
                    if (PickMeViewController.this.mViewManagerProvider != null) {
                        PickMeViewController.this.mViewManagerProvider.getPlayAnimManager().showMatchAnim(data);
                    }
                    return;
                }
                PickMeViewController.this.mDataProvider.getCharmInfo(data.getMaleUid(), data.getFemaleUid(), new IResDataCallback<Pair<Long, MatchEffectLevel>>(){

                    @Override
                    public void onSuccess(Pair<Long, MatchEffectLevel> info) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)PickMeViewController.TAG, (String)"getCharmValue: %s", (Object[])new Object[]{info});
                        }
                        long totalCharmValue = 0L;
                        MatchEffectLevel level = MatchEffectLevel.LOWER;
                        if (info != null) {
                            totalCharmValue = info.first != null ? (Long)info.first : 0L;
                            level = info.second != null ? (MatchEffectLevel)((Object)info.second) : MatchEffectLevel.LOWER;
                        }
                        data.setCharmValue(totalCharmValue);
                        data.setMatchEffectLevel(level);
                        if (PickMeViewController.this.mViewManagerProvider != null) {
                            PickMeViewController.this.mViewManagerProvider.getPlayAnimManager().showMatchAnim(data);
                        }
                    }

                    @Override
                    public void onFailure(long code, String msg) {
                        MLog.error((Object)PickMeViewController.TAG, (String)"getCharmValue error: %s ,msg: %s", (Object[])new Object[]{code, msg});
                        data.setCharmValue(0L);
                        data.setMatchEffectLevel(MatchEffectLevel.LOWER);
                        if (PickMeViewController.this.mViewManagerProvider != null) {
                            PickMeViewController.this.mViewManagerProvider.getPlayAnimManager().showMatchAnim(data);
                        }
                    }
                });
            }

            @Override
            public void onFailure(long code, String msg) {
            }
        });
    }

    private void fetchUserInfo(final @NonNull MatchSuccessInfo matchSuccessInfo, final @NonNull IResDataCallback<MatchSuccessInfo> callback) {
        ArrayList<Long> uidList = new ArrayList<Long>(2);
        uidList.add(matchSuccessInfo.getLeftUid());
        uidList.add(matchSuccessInfo.getRightUid());
        ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfos(uidList, new OnProfileCallback(){

            public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                if (FP.size(userInfoKSList) == 0) {
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)PickMeViewController.TAG, (String)"queryUserInfo onSelected userInfoKSList error: left: %s  right: %s", (Object[])new Object[]{matchSuccessInfo.getLeftUid(), matchSuccessInfo.getRightUid()});
                    }
                    return;
                }
                int size = userInfoKSList.size();
                for (int i = 0; i < size; ++i) {
                    UserInfoKS userInfo = userInfoKSList.get(i);
                    if (userInfo == null) continue;
                    if (matchSuccessInfo.getLeftUid() == userInfo.uid) {
                        matchSuccessInfo.setLeftUser(userInfo);
                    }
                    if (matchSuccessInfo.getRightUid() != userInfo.uid) continue;
                    matchSuccessInfo.setRightUser(userInfo);
                }
                callback.onSuccess(matchSuccessInfo);
            }

            public void onFail(int id2, String msg, String response) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)PickMeViewController.TAG, (String)"queryUserInfo error: left: %s  right: %s  msg: %s", (Object[])new Object[]{matchSuccessInfo.getLeftUid(), matchSuccessInfo.getRightUid(), msg});
                }
                callback.onFailure(-1L, msg);
            }
        });
    }

    private void updateFunctionMenu() {
        if (this.mDataProvider.getRoleType().getValue() != null && (Integer)this.mDataProvider.getRoleType().getValue() == 2) {
            int status = 0;
            if (this.mDataProvider.getStatus().getValue() != null) {
                status = (Integer)this.mDataProvider.getStatus().getValue();
            }
            if (status == 0) {
                this.mViewManagerProvider.getFunctionMenuManager().closeFunctionMenu();
            } else {
                FuncBtnStatus funcBtnStatus = null;
                if (status == 4) {
                    funcBtnStatus = new FuncBtnStatus(-1, true);
                } else if (status == 1) {
                    boolean canStartPublish = false;
                    if (this.mDataProvider.getCanStartPublish().getValue() != null) {
                        canStartPublish = (Boolean)this.mDataProvider.getCanStartPublish().getValue();
                    }
                    funcBtnStatus = new FuncBtnStatus(0, canStartPublish);
                } else if (status == 2) {
                    funcBtnStatus = new FuncBtnStatus(1, false);
                } else if (status == 3) {
                    funcBtnStatus = new FuncBtnStatus(1, true);
                }
                if (funcBtnStatus != null) {
                    this.mViewManagerProvider.getFunctionMenuManager().showFunctionMenu(funcBtnStatus);
                }
            }
        } else {
            this.mViewManagerProvider.getFunctionMenuManager().closeFunctionMenu();
        }
    }

    private void updateStageView() {
        if (this.mDataProvider.getRoleType().getValue() != null && (Integer)this.mDataProvider.getRoleType().getValue() != 2) {
            int status = 0;
            if (this.mDataProvider.getStatus().getValue() != null) {
                status = (Integer)this.mDataProvider.getStatus().getValue();
            }
            if (status == 0) {
                this.mViewManagerProvider.getStageViewManager().hideStageView();
            } else {
                this.mViewManagerProvider.getStageViewManager().showStageView(status, this.mPickMeContext.isNewPickMe());
            }
        } else {
            this.mViewManagerProvider.getStageViewManager().hideStageView();
        }
    }

    private boolean checkNeedShowPublishGuide() {
        boolean hasShown = SettingFlags.getBoolean((String)"key_pick_me_publish_guide_shown", (boolean)false);
        if (hasShown) {
            return false;
        }
        SettingFlags.setBoolean((String)"key_pick_me_publish_guide_shown", (boolean)true);
        return true;
    }

    private boolean checkNeedShowStartGuide() {
        boolean hasShown = SettingFlags.getBoolean((String)"key_pick_me_start_guide_shown", (boolean)false);
        if (hasShown) {
            return false;
        }
        SettingFlags.setBoolean((String)"key_pick_me_start_guide_shown", (boolean)true);
        return true;
    }

    private boolean checkNeedShowNewStartGuide() {
        boolean hasShown = ChannelSettingFlag.INSTANCE.getBoolean("key_pick_me_start_new_guide_show", false);
        if (hasShown) {
            return false;
        }
        ChannelSettingFlag.INSTANCE.putBoolean("key_pick_me_start_new_guide_show", true);
        return true;
    }

    private boolean checkMatchSuccNotifyValid(MatchSuccessNotify notify) {
        if (notify == null) {
            return false;
        }
        return System.currentTimeMillis() - notify.getNotifyTime() <= 800L;
    }

    private boolean checkNeedShowStatusAnim() {
        return System.currentTimeMillis() - this.mDataProvider.getStatusUpdateTime() <= 500L;
    }
}

