/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mvp.base.callback;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Observer;
import com.squareup.wire.AndroidMessage;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.mvp.base.ExtensionsKt;
import com.yy.hiyo.mvp.base.callback.IDestroyable;
import com.yy.hiyo.proto.callback.IProtoCallback;
import java.lang.ref.WeakReference;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;

public final class WeakProtoCallback<T extends AndroidMessage<T, ?>>
extends IProtoCallback<T>
implements Observer<Boolean> {
    private static final String TAG = "WeakProtoCallback";
    @Nullable
    private IProtoCallback<T> mCallback;
    @Nullable
    private WeakReference<IDestroyable> mWeakReference;

    public static <T extends AndroidMessage<T, ?>> WeakProtoCallback<T> of(IDestroyable destroyable, IProtoCallback<T> callback2) {
        MLog.debug((Object)TAG, (String)"init destroyable %s, callback %s", (Object[])new Object[]{destroyable, callback2});
        WeakProtoCallback weakProtoCallback = new WeakProtoCallback();
        weakProtoCallback.mWeakReference = new WeakReference<IDestroyable>(destroyable);
        weakProtoCallback.mCallback = callback2;
        ExtensionsKt.onUi((Function0<Unit>)((Function0)() -> {
            destroyable.isDestroyData().observeForever((Observer)weakProtoCallback);
            return null;
        }));
        return weakProtoCallback;
    }

    public boolean retryWhenTimeout(boolean canRetry) {
        if (this.isDestroy()) {
            this.onDestroy();
            return false;
        }
        if (this.mCallback != null) {
            boolean result = this.mCallback.retryWhenTimeout(canRetry);
            if (!result) {
                this.onDestroy();
            }
            return result;
        }
        return false;
    }

    public boolean retryWhenError(boolean canRetry, String reason, int code) {
        if (this.isDestroy()) {
            this.onDestroy();
            return false;
        }
        if (this.mCallback != null) {
            boolean result = this.mCallback.retryWhenError(canRetry, reason, code);
            if (!result) {
                this.onDestroy();
            }
            return result;
        }
        return false;
    }

    public void onResponse(@Nullable T message) {
        super.onResponse(message);
        MLog.debug((Object)TAG, (String)"onResponse", (Object[])new Object[0]);
        if (!this.isDestroy() && this.mCallback != null) {
            this.mCallback.onResponse(message);
        }
        this.onDestroy();
    }

    public void onResponse(@NonNull T message, long code, String msg) {
        super.onResponse(message, code, msg);
        MLog.debug((Object)TAG, (String)"onResponse", (Object[])new Object[0]);
        if (!this.isDestroy() && this.mCallback != null) {
            this.mCallback.onResponse(message, code, msg);
        }
        this.onDestroy();
    }

    public long getTimeoutTimeLength() {
        if (this.mCallback != null) {
            return this.mCallback.getTimeoutTimeLength();
        }
        return super.getTimeoutTimeLength();
    }

    private boolean isDestroy() {
        IDestroyable destroyable = this.mWeakReference != null ? (IDestroyable)this.mWeakReference.get() : null;
        return this.mCallback == null || destroyable == null || Boolean.TRUE.equals(destroyable.isDestroyData().getValue());
    }

    private void onDestroy() {
        if (this.mWeakReference != null) {
            IDestroyable destroyable = (IDestroyable)this.mWeakReference.get();
            MLog.debug((Object)TAG, (String)"onDestroy mCallback %s, IDestroyable %s", (Object[])new Object[]{this.mCallback, destroyable});
            if (destroyable != null) {
                YYTaskExecutor.postToMainThread(() -> destroyable.isDestroyData().removeObserver((Observer)this));
            }
            this.mWeakReference.clear();
            this.mWeakReference = null;
        }
        this.mCallback = null;
    }

    public void onChanged(@Nullable Boolean isDestroy) {
        if (Boolean.TRUE.equals(isDestroy)) {
            MLog.debug((Object)TAG, (String)"onChanged isDestroy", (Object[])new Object[0]);
            this.onDestroy();
        }
    }
}

