/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mvp.base.callback;

import androidx.annotation.Nullable;
import androidx.lifecycle.Observer;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.service.callback.OnProfileListCallback;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.mvp.base.ExtensionsKt;
import com.yy.hiyo.mvp.base.callback.IDestroyable;
import java.lang.ref.WeakReference;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import okhttp3.Call;

public final class WeakProfileListCallback
implements OnProfileListCallback,
Observer<Boolean> {
    private static final String TAG = "WeakProfileCallback";
    @Nullable
    private OnProfileListCallback mCallback;
    @Nullable
    private WeakReference<IDestroyable> mWeakReference;

    public static WeakProfileListCallback of(IDestroyable destroyable, OnProfileListCallback callback2) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"init destroyable %s, callback %s", (Object[])new Object[]{destroyable, callback2});
        }
        WeakProfileListCallback weakProfileCallback = new WeakProfileListCallback();
        weakProfileCallback.mCallback = callback2;
        weakProfileCallback.mWeakReference = new WeakReference<IDestroyable>(destroyable);
        ExtensionsKt.onUi((Function0<Unit>)((Function0)() -> {
            destroyable.isDestroyData().observeForever((Observer)weakProfileCallback);
            return null;
        }));
        return weakProfileCallback;
    }

    public void onUISuccess(List<UserInfoBean> userInfo) {
        YYTaskExecutor.postToMainThread(() -> {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"onSuccess", (Object[])new Object[0]);
            }
            if (!this.isDestroy() && this.mCallback != null) {
                this.mCallback.onUISuccess(userInfo);
            }
            this.onDestroy();
        });
    }

    public void onError(@Nullable Call call, @Nullable Exception e, int id) {
        YYTaskExecutor.postToMainThread(() -> {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"onFail", (Object[])new Object[0]);
            }
            if (!this.isDestroy() && this.mCallback != null) {
                this.mCallback.onError(call, e, id);
            }
            this.onDestroy();
        });
    }

    public void onChanged(@Nullable Boolean isDestroy) {
        if (Boolean.TRUE.equals(isDestroy)) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"onChanged isDestroy", (Object[])new Object[0]);
            }
            this.onDestroy();
        }
    }

    private boolean isDestroy() {
        IDestroyable destroyable = this.mWeakReference != null ? (IDestroyable)this.mWeakReference.get() : null;
        return this.mCallback == null || destroyable == null || Boolean.TRUE.equals(destroyable.isDestroyData().getValue());
    }

    private void onDestroy() {
        Runnable runnable = () -> {
            if (this.mWeakReference != null) {
                IDestroyable destroyable = (IDestroyable)this.mWeakReference.get();
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)TAG, (String)"onDestroy destroyable %s, callback %s", (Object[])new Object[]{destroyable, this.mCallback});
                }
                if (destroyable != null) {
                    destroyable.isDestroyData().removeObserver((Observer)this);
                }
                this.mWeakReference.clear();
                this.mWeakReference = null;
            }
            this.mCallback = null;
        };
        if (YYTaskExecutor.isMainThread()) {
            runnable.run();
        } else {
            YYTaskExecutor.postToMainThread((Runnable)runnable);
        }
    }

    public void onResponseError(int id, @Nullable String message, @Nullable String response) {
        YYTaskExecutor.postToMainThread(() -> {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"onFail", (Object[])new Object[0]);
            }
            if (!this.isDestroy() && this.mCallback != null) {
                this.mCallback.onResponseError(id, message, response);
            }
            this.onDestroy();
        });
    }
}

