/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.result;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IServiceManager;
import com.yy.architecture.ViewModelWindow;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.utils.ResolutionUtils;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.plugins.micup.MicUpStatisHelper;
import com.yy.hiyo.channel.plugins.micup.R;
import com.yy.hiyo.channel.plugins.micup.bean.ResultInfo;
import com.yy.hiyo.channel.plugins.micup.result.BaseMicUpResultPage;
import com.yy.hiyo.channel.plugins.micup.result.MicUpResultAudiencePage;
import com.yy.hiyo.channel.plugins.micup.result.MicUpResultPage;
import com.yy.hiyo.channel.plugins.micup.result.MicUpResultUiCallback;
import com.yy.hiyo.channel.plugins.micup.result.MicUpViewMode;
import com.yy.hiyo.channel.plugins.micup.result.ResultPageViewCallback;
import com.yy.hiyo.channel.plugins.micup.share.MicUpShareHelper;
import com.yy.hiyo.channel.plugins.micup.share.PlayerShareCardViewProvider;
import com.yy.hiyo.channel.plugins.micup.share.ViewerShareCardViewProvider;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.mvp.base.PageMvpContext;
import com.yy.hiyo.share.base.IShareViewProvider;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@SuppressLint(value={"ViewConstructor"})
public class MicUpResultWindow
extends ViewModelWindow {
    private BaseMicUpResultPage mMicUpResultPage;
    private final MicUpViewMode mMicUpViewMode;
    private MicUpShareHelper mMicUpShareHelper;
    private MicUpResultUiCallback mMicUpResultUiCallback;
    private String mRoomId;
    private int mRoleType;

    public MicUpResultWindow(Context context, MicUpResultUiCallback callBacks, String name, boolean isAudience) {
        super((IMvpContext)PageMvpContext.Companion.of((Context)((FragmentActivity)context)), (UICallBacks)callBacks, AbstractWindow.WindowLayerType.USE_ALL_LAYER, name);
        this.mMicUpResultUiCallback = callBacks;
        this.mMicUpViewMode = (MicUpViewMode)this.viewModelProvider().get(MicUpViewMode.class);
        this.createView(context, isAudience, this.mMicUpViewMode.isCloseBtnInBottom());
        this.subscribeUI();
    }

    private void createView(Context context, boolean isAudience, boolean isCloseInBottom) {
        this.mMicUpResultPage = isAudience ? new MicUpResultAudiencePage(context, isCloseInBottom) : new MicUpResultPage(context, isCloseInBottom);
        this.initPageViewCallback(this.mMicUpResultPage);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2, 17);
        layoutParams.bottomMargin = isCloseInBottom ? ResolutionUtils.dip2Px((float)40.0f) : 0;
        YYFrameLayout rootContainer = new YYFrameLayout(context);
        rootContainer.setBackgroundResource(R.drawable.bg_mic_up_blur);
        rootContainer.addView((View)this.mMicUpResultPage, (ViewGroup.LayoutParams)layoutParams);
        this.getBaseLayer().addView((View)rootContainer, new ViewGroup.LayoutParams(-1, -1));
        this.mMicUpViewMode.isAudience(isAudience);
    }

    private void initPageViewCallback(@NotNull BaseMicUpResultPage page) {
        page.setViewCallback(new ResultPageViewCallback(){

            @Override
            public void onCloseClick() {
                if (MicUpResultWindow.this.mMicUpResultUiCallback != null) {
                    MicUpResultWindow.this.mMicUpResultUiCallback.closeMicUpResultWindow(false);
                }
            }

            @Override
            public void onPlayAgainClick() {
                if (MicUpResultWindow.this.mMicUpResultUiCallback != null) {
                    MicUpResultWindow.this.mMicUpResultUiCallback.closeMicUpResultWindow(true);
                }
                MicUpStatisHelper.reportPlayAgainClick(MicUpResultWindow.this.mRoomId);
            }

            @Override
            public void onShareBtnClick() {
                if (MicUpResultWindow.this.mMicUpShareHelper == null) {
                    return;
                }
                MicUpResultWindow.this.mMicUpShareHelper.showShareBottomDialog();
                MicUpStatisHelper.reportShareBtnClick(MicUpResultWindow.this.mRoomId);
            }

            @Override
            public void onShareChannelClick(int channelId) {
                if (MicUpResultWindow.this.mMicUpShareHelper == null) {
                    return;
                }
                MicUpResultWindow.this.mMicUpShareHelper.share(channelId);
            }

            @Override
            public void onPlayAgainTimerFinish() {
                if (MicUpResultWindow.this.mMicUpResultUiCallback != null) {
                    MicUpResultWindow.this.mMicUpResultUiCallback.closeMicUpResultWindow(true);
                }
            }
        });
    }

    public void initData(String roomId, int term, int roleType) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTMicUpResult", (String)"init data roomId: %s,term: %s", (Object[])new Object[]{roomId, term});
        }
        this.mRoomId = roomId;
        this.mRoleType = roleType;
        this.mMicUpViewMode.fetchData(roomId, term);
    }

    public String getRoomId() {
        return this.mRoomId;
    }

    private void subscribeUI() {
        Boolean isAudience = (Boolean)this.mMicUpViewMode.isAudience().getValue();
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTMicUpResult", (String)"subscribeUI isAudience: %s", (Object[])new Object[]{isAudience});
        }
        if (isAudience == null) {
            return;
        }
        if (isAudience.booleanValue()) {
            this.mMicUpViewMode.getAudienceHeaderLiveData().observe((LifecycleOwner)this, resultInfoList -> {
                if (this.mMicUpResultPage != null) {
                    this.mMicUpResultPage.renderHeader((List)resultInfoList);
                }
            });
            this.mMicUpViewMode.getAudienceRankLiveData().observe((LifecycleOwner)this, resultInfoList -> {
                if (this.mMicUpResultPage != null) {
                    this.mMicUpResultPage.renderRankList((List<ResultInfo>)resultInfoList);
                }
            });
            this.mMicUpViewMode.getShareChannelLiveData().observe((LifecycleOwner)this, shareChannelList -> {
                if (this.mMicUpResultPage != null) {
                    this.mMicUpResultPage.renderShareChannelList((List)shareChannelList);
                }
            });
        } else {
            this.mMicUpViewMode.getMyResultInfo().observe((LifecycleOwner)this, resultInfo -> {
                if (this.mMicUpResultPage != null) {
                    this.mMicUpResultPage.renderMyResult((ResultInfo)resultInfo);
                }
                this.initShareViewProvider();
            });
            this.mMicUpViewMode.getResultInfoLiveData().observe((LifecycleOwner)this, resultInfoList -> {
                if (this.mMicUpResultPage != null) {
                    this.mMicUpResultPage.renderRankList((List<ResultInfo>)resultInfoList);
                }
            });
        }
    }

    public void initShareHelper(IServiceManager serviceManager, DialogLinkManager dialogLinkManager) {
        this.mMicUpShareHelper = new MicUpShareHelper(serviceManager);
        this.mMicUpShareHelper.setDialogLinkManager(dialogLinkManager);
        UserInfoKS playerUserInfo = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(AccountUtil.getUid(), null);
        this.mMicUpShareHelper.setShareUserInfo(playerUserInfo);
        this.mMicUpShareHelper.setRoomId(this.mRoomId);
        this.mMicUpShareHelper.setRoleType(this.mRoleType);
        this.initShareViewProvider();
    }

    private void initShareViewProvider() {
        if (!((Boolean)this.mMicUpViewMode.isAudience().getValue()).booleanValue()) {
            ResultInfo myResultInfo = (ResultInfo)this.mMicUpViewMode.getMyResultInfo().getValue();
            if (myResultInfo != null) {
                PlayerShareCardViewProvider playerShareCardViewProvider = new PlayerShareCardViewProvider(this.getContext());
                UserInfoKS playerUserInfo = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(AccountUtil.getUid(), null);
                playerShareCardViewProvider.setPlayerUserInfo(playerUserInfo);
                playerShareCardViewProvider.setResultInfo(myResultInfo);
                this.mMicUpShareHelper.setShareViewProvider((IShareViewProvider)playerShareCardViewProvider);
                this.mMicUpShareHelper.setCanShare(true);
            } else {
                this.mMicUpShareHelper.setCanShare(false);
            }
        } else {
            ViewerShareCardViewProvider viewerShareCardViewProvider = new ViewerShareCardViewProvider(this.getContext());
            this.mMicUpShareHelper.setShareViewProvider((IShareViewProvider)viewerShareCardViewProvider);
            this.mMicUpShareHelper.setCanShare(true);
        }
    }

    public void onAttach() {
        super.onAttach();
        MicUpStatisHelper.reportResultPageShow(this.mRoomId, this.mRoleType);
    }

    public void onDetached() {
        super.onDetached();
        MicUpStatisHelper.reportResultPageClose(this.mRoomId, this.mRoleType);
    }
}

