/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.panel.leadsing;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.UiThread;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.hiyo.channel.plugins.micup.R;
import com.yy.hiyo.channel.plugins.micup.bean.SongInfo;
import com.yy.hiyo.channel.plugins.micup.interfaces.IMicUpView;
import com.yy.hiyo.channel.plugins.micup.panel.MicUpUICallback;
import com.yy.hiyo.channel.plugins.micup.panel.leadsing.BaseMicUpLeadSingView;
import java.util.List;

public class MicUpAudienceLeadSingView
extends BaseMicUpLeadSingView
implements View.OnClickListener,
IMicUpView {
    private MicUpUICallback mUICallback;
    private CircleImageView mAvatarView;
    private YYTextView mSongNameView;
    private RecycleImageView mCopyRightView;
    private YYTextView mSingerNameView;
    private YYTextView mFirstLyricView;
    private YYTextView mSecondLyricView;

    public MicUpAudienceLeadSingView(Context context) {
        this(context, null);
    }

    public MicUpAudienceLeadSingView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MicUpAudienceLeadSingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setBackgroundResource(R.drawable.bg_mic_up_complete_panel);
    }

    public void setUICallback(MicUpUICallback uiCallback) {
        this.mUICallback = uiCallback;
    }

    @Override
    protected void createView(Context context) {
        View rootView = LayoutInflater.from((Context)context).inflate(R.layout.layout_mic_up_audience_lead_sing_channel, (ViewGroup)this);
        this.mAvatarView = (CircleImageView)rootView.findViewById(R.id.iv_avatar);
        this.mSongNameView = (YYTextView)rootView.findViewById(R.id.tv_song_name);
        this.mCopyRightView = (RecycleImageView)rootView.findViewById(R.id.iv_copyright);
        this.mSingerNameView = (YYTextView)rootView.findViewById(R.id.tv_singer_name);
        this.mFirstLyricView = (YYTextView)rootView.findViewById(R.id.tv_first_lyric);
        this.mSecondLyricView = (YYTextView)rootView.findViewById(R.id.tv_second_lyric);
        RecycleImageView rulesView = (RecycleImageView)rootView.findViewById(R.id.iv_rules);
        rulesView.setOnClickListener((View.OnClickListener)this);
        this.mCopyRightView.setOnClickListener((View.OnClickListener)this);
    }

    @UiThread
    public void updateSongInfo(@NonNull SongInfo songInfo) {
        if (songInfo == null) {
            FeatureLog.e((String)"FTMicUpPanel", (String)"audience updateSongInfo songInfo == null.", (Object[])new Object[0]);
            return;
        }
        ImageLoader.loadImage((RecycleImageView)this.mAvatarView, (String)songInfo.avatar, (int)R.drawable.icon_avatar_default_male, (int)R.drawable.icon_avatar_default_male);
        this.mSongNameView.setText((CharSequence)songInfo.musicName);
        this.mSingerNameView.setText((CharSequence)songInfo.singer);
        this.mFirstLyricView.setText((CharSequence)"");
        this.mSecondLyricView.setText((CharSequence)"");
        List<String> preLyrics = songInfo.preLyric;
        if (FP.empty(preLyrics)) {
            return;
        }
        int size = preLyrics.size();
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                String firstLyric = preLyrics.get(0);
                this.mFirstLyricView.setText((CharSequence)firstLyric);
                continue;
            }
            if (i != 1) break;
            String secondLyric = preLyrics.get(1);
            this.mSecondLyricView.setText((CharSequence)secondLyric);
        }
    }

    @UiThread
    public void setMaxRound(int maxRound) {
        this.setMaxProgress(maxRound);
    }

    @UiThread
    public void setCurrentRound(int progress) {
        this.setProgress(progress);
    }

    public void onClick(View view) {
        if (view == null) {
            return;
        }
        int viewId = view.getId();
        if (viewId == R.id.iv_copyright) {
            this.showVerticalPopWindow((View)this.mCopyRightView, R.string.tips_mic_up_copy_right);
        } else if (viewId == R.id.iv_rules && this.mUICallback != null) {
            this.mUICallback.onGameRuleClick();
        }
    }

    @Override
    public void onDestroy() {
    }

    @Override
    protected void onDetachedFromWindow() {
        this.hidePopWindow();
        super.onDetachedFromWindow();
    }
}

