/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.impl;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.common.Callback;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.cbase.model.bean.RoomData;
import com.yy.hiyo.channel.plugins.micup.bean.AudioInfo;
import com.yy.hiyo.channel.plugins.micup.bean.MicupDataContext;
import com.yy.hiyo.channel.plugins.micup.bean.SongInfo;
import com.yy.hiyo.channel.plugins.micup.impl.AudioManager;
import com.yy.hiyo.channel.plugins.micup.interfaces.IAudioManager;
import com.yy.hiyo.channel.plugins.micup.interfaces.IDataCallback;
import com.yy.hiyo.channel.plugins.micup.interfaces.IMicupDataService;
import com.yy.hiyo.channel.plugins.micup.interfaces.IMicupLifeCycle;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.IProtoNotify;
import com.yy.hiyo.voice.base.bean.VoiceNotificationDef;
import common.Header;
import common.Result;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.ihago.room.srv.micup.DataType;
import net.ihago.room.srv.micup.DeterminationNotify;
import net.ihago.room.srv.micup.DeterminationReq;
import net.ihago.room.srv.micup.DeterminationRes;
import net.ihago.room.srv.micup.ECode;
import net.ihago.room.srv.micup.ExtendInfo;
import net.ihago.room.srv.micup.ExtendKey;
import net.ihago.room.srv.micup.GetRoundInfoReq;
import net.ihago.room.srv.micup.GetRoundInfoRes;
import net.ihago.room.srv.micup.GetTheChanceNotify;
import net.ihago.room.srv.micup.GetTheChanceReq;
import net.ihago.room.srv.micup.GetTheChanceRes;
import net.ihago.room.srv.micup.MicUPNotify;
import net.ihago.room.srv.micup.NextRoundNotify;
import net.ihago.room.srv.micup.PlayerInfo;
import net.ihago.room.srv.micup.RoundStatus;
import net.ihago.room.srv.micup.Uri;
import net.ihago.room.srv.micup.WaitDetermineNotify;
import okio.ByteString;

public class MicupDataService
implements IMicupDataService {
    private static final String TAG = "FTMicUpDataFetcher";
    private String mRoomId = "";
    private boolean isNotifyLost = false;
    private long lastSeqId = 0L;
    private IDataCallback dataCallback;
    private boolean hasFetchPlayerInfos = false;
    private IMicupLifeCycle micupStartedCallback;
    private MicupDataContext dataContext;
    private IChannel mVoiceRoom;
    private RoomData roomData;
    private IAudioManager audioManager;
    private boolean needRefetchStartGameInfo = false;
    private Runnable mNotifyEndRunnable;
    private IProtoNotify<MicUPNotify> protoNotify = new IProtoNotify<MicUPNotify>(){

        public String serviceName() {
            return "net.ihago.room.srv.micup";
        }

        public void onNotify(@NonNull MicUPNotify notify) {
            if (this.filterNotify(notify)) {
                MLog.error((Object)MicupDataService.TAG, (String)"onNotify", (Object[])new Object[0]);
                return;
            }
            if (notify.uri == Uri.kUriNextRound) {
                MicupDataService.this.onNextRound(notify.next_round);
            } else if (notify.uri == Uri.kUriGetTheChance) {
                MicupDataService.this.onUserGetTheChance(notify.get_the_chance);
            } else if (notify.uri == Uri.kUriDetermination) {
                MicupDataService.this.onSongIdentifyResult(notify.determination);
            } else if (notify.uri == Uri.kUriWaitDetermine) {
                MicupDataService.this.onWaitDetermine(notify.wait_determine);
            }
        }

        private boolean filterNotify(@NonNull MicUPNotify notify) {
            String currentRoomId;
            if (notify == null) {
                MLog.error((Object)MicupDataService.TAG, (String)"notify null!!!", (Object[])new Object[0]);
                return true;
            }
            Header header = notify.header;
            String roomId = header != null ? header.roomid : "";
            String string2 = currentRoomId = MicupDataService.this.getRoomDataContainer() != null ? MicupDataService.this.getRoomDataContainer().getRoomId() : "";
            if (StringUtils.isNotEmpty((String)roomId) && StringUtils.isNotEmpty((String)currentRoomId) && roomId.equals(currentRoomId)) {
                return false;
            }
            MLog.error((Object)MicupDataService.TAG, (String)"notify room id not equal!!!,cur:%s, notify:%s", (Object[])new Object[]{currentRoomId, roomId});
            return true;
        }
    };
    private INotify iNotify = notification -> {
        if (notification != null && notification.id == VoiceNotificationDef.EXCEPTION_EXIT_PLUGIN) {
            if (this.dataCallback != null) {
                this.dataCallback.onRoomExceptionFinish();
            }
            if (this.audioManager != null && this.audioManager.getNotify() != null) {
                this.audioManager.getNotify().onGameExitedNotify();
            }
            this.submitAudioWhenExit();
        } else if (notification != null && notification.id == NotificationDef.WSCLIENT_CONNECT_SUCCESS) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"ws connected!,needRefetchStartGameInfo %b, state:%d", (Object[])new Object[]{this.needRefetchStartGameInfo, this.getDataContext().getState()});
            }
            if (this.needRefetchStartGameInfo && this.getDataContext().getState() != 1) {
                this.fetchRoundInfos(false);
            } else {
                this.fetchRoundInfoWhenAfterNetWorkAvalible();
            }
        }
    };

    private void submitAudioWhenExit() {
        if (!this.getDataContext().isSinger()) {
            return;
        }
        int roundState = this.getDataContext().getCurrentRoundInfo().getRoundState();
        int songIdentifyState = this.getDataContext().getCurrentRoundInfo().getSongIdentifyState();
        if (roundState == 3 && songIdentifyState == 0) {
            SongInfo songInfo = this.getDataContext().getCurrentRoundInfo().getSongInfo();
            if (this.audioManager == null) {
                return;
            }
            this.audioManager.stopSelfSinging(songInfo);
            AudioInfo selfAudioInfo = this.audioManager.getSelfAudioInfo(songInfo);
            if (selfAudioInfo == null || selfAudioInfo.cacheAccAudio == null) {
                return;
            }
            this.identifyAudio(selfAudioInfo.cacheAccAudio, selfAudioInfo.cacheAccAudio.length, "audio", selfAudioInfo.followAudioInfo.songId, this.getDataContext().getTerm());
        }
    }

    private RoomData getRoomDataContainer() {
        return this.roomData;
    }

    public MicupDataService(IChannel voiceRoom, RoomData roomData) {
        this.mVoiceRoom = voiceRoom;
        this.roomData = roomData;
    }

    private void onSongIdentifyResult(DeterminationNotify determination) {
        boolean isOver;
        if (determination == null) {
            MLog.error((Object)TAG, (String)"onSongIdentifyResult null!!!", (Object[])new Object[0]);
            return;
        }
        PlayerInfo playerInfo = determination.player;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onSongIdentifyResult success:%b,out:%b, over:%b,round:%d, player:%d", (Object[])new Object[]{determination.is_success, determination.is_out, determination.is_over, determination.round, playerInfo != null ? playerInfo.uid : 0L});
        }
        if (determination.code == ECode.kRetErrAPIError) {
            this.getDataContext().updateRoundSongState(4, determination.round, determination.uid);
        } else {
            this.getDataContext().updateRoundSongState(determination.is_success != false ? 2 : 3, determination.round, determination.uid);
        }
        this.getDataContext().getCurrentRoundInfo().setRoundState(5);
        if (playerInfo != null && determination.uid != -1L) {
            this.getDataContext().updatePlayerInfo(playerInfo.uid, playerInfo.life, playerInfo.score, playerInfo.success, playerInfo.seat, playerInfo.total);
        }
        if (this.dataCallback != null) {
            this.dataCallback.onSongIdentifyResult(this.getDataContext().getCurrentRoundInfo());
        }
        if (this.audioManager != null && this.audioManager.getNotify() != null) {
            this.audioManager.getNotify().onSongIdentifyResultNotify(this.getDataContext().getCurrentRoundInfo());
        }
        if (isOver = determination.is_over.booleanValue()) {
            this.notifyGameEnded();
        }
    }

    private void onUserGetTheChance(GetTheChanceNotify getTheChance) {
        if (getTheChance == null) {
            MLog.error((Object)TAG, (String)"onUserGetTheChance null!!!", (Object[])new Object[0]);
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onUserGetTheChance, uid:%d, round:%d, isOver:%b, nick:%s, avatar:%s", (Object[])new Object[]{getTheChance.uid, getTheChance.round, getTheChance.is_over, getTheChance.nick, getTheChance.avatar});
        }
        this.getDataContext().setCurrentRoundUid(getTheChance.uid, getTheChance.round);
        this.getDataContext().getCurrentRoundInfo().setRoundState(3);
        if (this.dataCallback != null) {
            this.dataCallback.onUserGetTheChance(getTheChance.uid, getTheChance.round, getTheChance.avatar, getTheChance.nick);
        }
        if (this.audioManager != null && this.audioManager.getNotify() != null) {
            this.audioManager.getNotify().onUserGetTheChanceNotify(getTheChance.uid, getTheChance.round, getTheChance.avatar, getTheChance.nick);
        }
        if (getTheChance.is_over.booleanValue()) {
            this.notifyGameEnded();
        }
    }

    private void onNextRound(NextRoundNotify nextRound) {
        if (nextRound == null) {
            MLog.error((Object)TAG, (String)"next round null!!!", (Object[])new Object[0]);
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onNextRound:%d,term:%d", (Object[])new Object[]{nextRound.round, nextRound.term});
        }
        this.getDataContext().updateNewRound(nextRound.round);
        this.getDataContext().getCurrentRoundInfo().setRoundState(1);
        this.getDataContext().getCurrentRoundInfo().setTotalRound(nextRound.max_round);
        this.fetchRoundInfos();
        if (this.dataCallback != null) {
            this.dataCallback.onNextRound(nextRound.round);
        }
        if (this.audioManager != null && this.audioManager.getNotify() != null) {
            this.audioManager.getNotify().onNextRoundNotify(nextRound.round);
        }
    }

    private void onWaitDetermine(WaitDetermineNotify waitDetermine) {
        if (waitDetermine == null) {
            MLog.error((Object)TAG, (String)"waitDetermine null!!!", (Object[])new Object[0]);
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onWaitDetermine ,round:%d, term:%d", (Object[])new Object[]{waitDetermine.round, waitDetermine.term});
        }
        this.getDataContext().getCurrentRoundInfo().setSongIdentifyState(1);
        this.getDataContext().getCurrentRoundInfo().setRoundState(4);
        if (this.dataCallback != null) {
            this.dataCallback.onWaitForDetermine(waitDetermine.round, waitDetermine.term);
        }
        if (this.audioManager != null && this.audioManager.getNotify() != null) {
            this.audioManager.getNotify().onWaitForDetermineNotify(waitDetermine.round, waitDetermine.term);
        }
    }

    @Override
    public void setDataCallback(IDataCallback dataCallback) {
        this.dataCallback = dataCallback;
    }

    @Override
    public void onPrepare(IMicupLifeCycle callback, boolean isGameStarted) {
        this.micupStartedCallback = callback;
        this.mRoomId = this.getRoomDataContainer() != null ? this.getRoomDataContainer().getRoomId() : "";
        ProtoManager.getInstance().registerNotify(this.protoNotify);
        MicupDataContext dataContext = this.getDataContext();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onPrepare, started:%b, state:%d roomId:%s", (Object[])new Object[]{isGameStarted, dataContext != null ? dataContext.getState() : 0, this.mRoomId});
        }
        if (dataContext != null && dataContext.getState() == 3) {
            dataContext.setState(0);
        }
        if (isGameStarted) {
            if (dataContext != null && dataContext.getState() == 2 && this.hasFetchPlayerInfos) {
                this.notifyGameStarted();
            } else {
                this.fetchRoundInfos();
            }
        }
    }

    @Override
    public void tryGetTheChance(final int round, final int term, final @Nullable Callback<Boolean> callback) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"tryGetTheChance round:%d, term:%d", (Object[])new Object[]{round, term});
        }
        ProtoManager.getInstance().sendRpc(this.mRoomId, (AndroidMessage)new GetTheChanceReq.Builder().round(Integer.valueOf(round)).term(Integer.valueOf(term)).build(), (IProtoCallback)new IProtoCallback<GetTheChanceRes>(){

            public void onResponse(@NonNull GetTheChanceRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (message == null) {
                    MLog.error((Object)MicupDataService.TAG, (String)"tryGetTheChance response null!!!,round:%d, term:%d", (Object[])new Object[]{round, term});
                    return;
                }
                boolean isSuccess = message.is_success;
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)MicupDataService.TAG, (String)"tryGetTheChance isSuccess:%b", (Object[])new Object[]{isSuccess});
                }
                Result result = message.res;
                if (callback != null) {
                    callback.onResponse((Object)isSuccess);
                }
                MicupDataService.checkResponseResult(StringUtils.formatWitUSLocal((String)"tryGetTheChance round:%d, term:%d", (Object[])new Object[]{round, term}), result);
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.error((Object)MicupDataService.TAG, (String)"tryGetTheChance retryWhenTimeout,round:%d, term:%d", (Object[])new Object[]{round, term});
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.error((Object)MicupDataService.TAG, (String)"tryGetTheChance retryWhenError,round:%d, term:%d", (Object[])new Object[]{round, term});
                return false;
            }
        });
    }

    public static void checkResponseResult(String previousMsg, Result result) {
        String msgEnd = "";
        if (result != null) {
            long errCode = result.errcode;
            if (errCode == (long)ECode.kRetErrAlreadyOut.getValue()) {
                msgEnd = "kRetErrAlreadyOut.getValue()";
            } else if (errCode == (long)ECode.kRetErrWrongDataType.getValue()) {
                msgEnd = "kRetErrWrongDataType.getValue()";
            } else if (errCode == (long)ECode.kRetErrChanceMissed.getValue()) {
                msgEnd = "kRetErrChanceMissed.getValue()";
            } else if (errCode == (long)ECode.kRetErrGameOver.getValue()) {
                msgEnd = "kRetErrGameOver.getValue()";
            } else if (errCode == (long)ECode.kRetErrNotExist.getValue()) {
                msgEnd = "kRetErrNotExist.getValue()";
            } else if (errCode == (long)ECode.kRetErrS2SError.getValue()) {
                msgEnd = "kRetErrS2SError.getValue()";
            } else if (errCode == (long)ECode.kRetErrAPIError.getValue()) {
                msgEnd = "kRetErrAPIError.getValue()";
            } else if (!ProtoManager.isSuccessCode((long)errCode)) {
                msgEnd = "UNKNOWN ERROR CODE:" + errCode;
            }
        }
        if (StringUtils.isNotEmpty((String)msgEnd)) {
            MLog.error((Object)TAG, (String)"%s is not normal. error:%s !!!", (Object[])new Object[]{previousMsg, msgEnd});
        }
    }

    @Override
    public void identifyAudio(byte[] audioOrFingerPrint, int size, String dataType, String songId, int term) {
        final String msg = StringUtils.formatWitUSLocal((String)"identifyAudio size:%d, dataType:%s, songId:%s, term:%d", (Object[])new Object[]{size, dataType, songId, term});
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)msg, (Object[])new Object[0]);
        }
        this.getDataContext().getCurrentRoundInfo().setRoundState(4);
        ProtoManager.getInstance().sendRpc(this.mRoomId, (AndroidMessage)new DeterminationReq.Builder().sample(ByteString.of((byte[])audioOrFingerPrint)).data_type(DataType.fromValue((int)(dataType.equals("audio") ? DataType.Audio.getValue() : DataType.FingerPrint.getValue()))).song_id(songId).term(Integer.valueOf(term)).build(), (IProtoCallback)new IProtoCallback<DeterminationRes>(){

            public void onResponse(@NonNull DeterminationRes message, long code, String msg2) {
                super.onResponse((AndroidMessage)message, code, msg2);
                if (message == null) {
                    MLog.error((Object)MicupDataService.TAG, (String)"identifyAudio response null!!!", (Object[])new Object[0]);
                    return;
                }
                MicupDataService.checkResponseResult(msg2, message.res);
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.error((Object)MicupDataService.TAG, (String)"retryWhenTimeout %s,can retry:%s", (Object[])new Object[]{msg, canRetry});
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.error((Object)MicupDataService.TAG, (String)"retryWhenError %s,can retry:%s, reason:%s, code:%d", (Object[])new Object[]{msg, canRetry, reason, code});
                return false;
            }
        });
    }

    @Override
    public void onCreate(IMvpContext context) {
    }

    @Override
    public void onDestroy(int reasonCode) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onDestroy:%d", (Object[])new Object[]{reasonCode});
        }
        if (reasonCode == 0) {
            ProtoManager.getInstance().unregisterNotify(this.protoNotify);
            NotificationCenter.getGlobalInstance().unregister(VoiceNotificationDef.EXCEPTION_EXIT_PLUGIN, this.iNotify);
            NotificationCenter.getGlobalInstance().unregister(NotificationDef.WSCLIENT_CONNECT_SUCCESS, this.iNotify);
            this.hasFetchPlayerInfos = false;
            if (this.audioManager != null) {
                this.audioManager.onDestroy(0);
                this.audioManager = null;
            }
            YYTaskExecutor.removeTask((Runnable)this.mNotifyEndRunnable);
        }
        this.micupStartedCallback = null;
    }

    private void fetchRoundInfos() {
        this.fetchRoundInfos(true);
    }

    private void fetchRoundInfos(final boolean needRetry) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"fetchRoundInfos roomId:%s, fetch:%b", (Object[])new Object[]{this.mRoomId, this.hasFetchPlayerInfos});
        }
        if (this.hasFetchPlayerInfos) {
            return;
        }
        List<ExtendKey> extendKeys = Arrays.asList(ExtendKey.Avatar, ExtendKey.Nick, ExtendKey.Duration);
        ProtoManager.getInstance().sendRpc(this.mRoomId, (AndroidMessage)new GetRoundInfoReq.Builder().keys(extendKeys).build(), (IProtoCallback)new IProtoCallback<GetRoundInfoRes>(){

            public void onResponse(@NonNull GetRoundInfoRes message, long code, String msg) {
                int lastRound;
                super.onResponse((AndroidMessage)message, code, msg);
                if (message == null) {
                    String errMsg = "fetchRoundInfos response null!!!";
                    MLog.error((Object)MicupDataService.TAG, (String)errMsg, (Object[])new Object[0]);
                    return;
                }
                MicupDataService.this.needRefetchStartGameInfo = false;
                MicupDataService.this.hasFetchPlayerInfos = true;
                MicupDataService.checkResponseResult("fetchRoundInfos", message.res);
                List playerInfos = message.players;
                int term = message.term;
                int round = message.round;
                RoundStatus roundStatus = message.status;
                ArrayList<com.yy.hiyo.channel.plugins.micup.bean.PlayerInfo> playerTemp = new ArrayList<com.yy.hiyo.channel.plugins.micup.bean.PlayerInfo>();
                if (playerInfos != null && !playerInfos.isEmpty()) {
                    for (PlayerInfo info : playerInfos) {
                        com.yy.hiyo.channel.plugins.micup.bean.PlayerInfo playerInfo = new com.yy.hiyo.channel.plugins.micup.bean.PlayerInfo();
                        playerInfo.setTotal(info.total);
                        playerInfo.setSuccess(info.success);
                        playerInfo.setLife(info.life);
                        playerInfo.setUid(info.uid);
                        playerInfo.setIndex(info.seat);
                        playerInfo.setScore(info.score);
                        ExtendInfo extra = info.extra;
                        if (extra != null) {
                            playerInfo.setNick(extra.Nick);
                            playerInfo.setAvatar(extra.Avatar);
                        }
                        playerTemp.add(playerInfo);
                    }
                }
                List songList = message.songs;
                ArrayList<SongInfo> songInfos = new ArrayList<SongInfo>();
                if (songList != null && songList.size() > 0) {
                    for (net.ihago.room.srv.micup.SongInfo info : songList) {
                        SongInfo songInfo = new SongInfo();
                        songInfo.songId = info.song_id;
                        songInfo.musicName = info.title;
                        songInfo.audioUrl = info.audio_url;
                        ExtendInfo extendInfo = info.extra;
                        if (extendInfo != null) {
                            songInfo.avatar = extendInfo.Avatar;
                            songInfo.duration = extendInfo.Duration;
                        }
                        songInfo.postLyric = info.post_lyric;
                        songInfo.preLyric = info.pre_lyric;
                        songInfo.singer = info.singer;
                        songInfos.add(songInfo);
                    }
                    MicupDataService.this.getDataContext().setSongInfoList(songInfos);
                }
                if (round > (lastRound = MicupDataService.this.getDataContext().getCurrentRoundInfo().getRound())) {
                    MicupDataService.this.getDataContext().updateNewRound(round);
                }
                MicupDataService.this.getDataContext().getCurrentRoundInfo().setRoundState(roundStatus != null ? message.getStatusValue() : 0);
                MicupDataService.this.getDataContext().getCurrentRoundInfo().setTotalRound(message.max_round);
                MicupDataService.this.getDataContext().setCurrentRoundUid(message.uid, message.round);
                MicupDataService.this.getDataContext().setPlayerList(playerTemp);
                MicupDataService.this.getDataContext().setTerm(term);
                if (roundStatus != null && message.getStatusValue() == 5) {
                    MicupDataService.this.getDataContext().updateRoundSongState(message.is_success != false ? 2 : 3, message.round, message.uid);
                }
                if (round > 0 && roundStatus != null && roundStatus != RoundStatus.GameOver) {
                    MicupDataService.this.notifyGameStarted();
                }
                if (MicupDataService.this.dataCallback != null) {
                    MicupDataService.this.dataCallback.onUpdateRoundInfo(playerTemp, 0, "");
                }
                if (MicupDataService.this.audioManager != null && MicupDataService.this.audioManager.getNotify() != null) {
                    MicupDataService.this.audioManager.getNotify().onUpdateRoundInfoNotify(playerTemp, 0, "");
                }
                if (roundStatus != null && roundStatus == RoundStatus.GameOver) {
                    MicupDataService.this.notifyGameEnded();
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)MicupDataService.TAG, (String)"fetchRoundInfos success,pre:%d, round:%d, status:%s, players:%d, term:%d, songlist:%s", (Object[])new Object[]{lastRound, round, roundStatus, playerTemp.size(), term, songInfos});
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                String errMsg = StringUtils.formatWitUSLocal((String)"fetchRoundInfos retryWhenTimeout !!!need retry:%b", (Object[])new Object[]{needRetry});
                MLog.error((Object)MicupDataService.TAG, (String)errMsg, (Object[])new Object[0]);
                if (needRetry) {
                    if (ProtoManager.getInstance().isWSConnected()) {
                        MLog.error((Object)MicupDataService.TAG, (String)"ws connect and retry!!!", (Object[])new Object[0]);
                        MicupDataService.this.fetchRoundInfos(false);
                    } else {
                        MicupDataService.this.needRefetchStartGameInfo = true;
                    }
                }
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                String errMsg = StringUtils.formatWitUSLocal((String)"fetchRoundInfos retryWhenError!!! canRetry:%b, reason:%s, code:%d ,need retry%b", (Object[])new Object[]{canRetry, reason, code, needRetry});
                MLog.error((Object)MicupDataService.TAG, (String)errMsg, (Object[])new Object[0]);
                if (needRetry) {
                    if (ProtoManager.getInstance().isWSConnected()) {
                        MLog.error((Object)MicupDataService.TAG, (String)"ws connect and retry!!!", (Object[])new Object[0]);
                        MicupDataService.this.fetchRoundInfos(false);
                    } else {
                        MicupDataService.this.needRefetchStartGameInfo = true;
                    }
                }
                return false;
            }
        });
    }

    private void fetchRoundInfoWhenAfterNetWorkAvalible() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"fetchRoundInfoWhenAfterNetWorkAvalible roomId:%s", (Object[])new Object[]{this.mRoomId});
        }
        List<ExtendKey> extendKeys = Arrays.asList(ExtendKey.Avatar, ExtendKey.Nick, ExtendKey.Duration);
        ProtoManager.getInstance().sendRpc(this.mRoomId, (AndroidMessage)new GetRoundInfoReq.Builder().keys(extendKeys).build(), (IProtoCallback)new IProtoCallback<GetRoundInfoRes>(){

            public void onResponse(@NonNull GetRoundInfoRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (message == null) {
                    String errMsg = "fetchRoundInfoWhenAfterNetWorkAvalible response null!!!";
                    MLog.error((Object)MicupDataService.TAG, (String)errMsg, (Object[])new Object[0]);
                    return;
                }
                MicupDataService.checkResponseResult("fetchRoundInfoWhenAfterNetWorkAvalible", message.res);
                int term = message.term;
                int round = message.round;
                RoundStatus roundStatus = message.status;
                int lastRound = MicupDataService.this.getDataContext().getCurrentRoundInfo().getRound();
                if (round < lastRound) {
                    MLog.error((Object)MicupDataService.TAG, (String)"fetch late!!!", (Object[])new Object[0]);
                    return;
                }
                List playerInfos = message.players;
                ArrayList<com.yy.hiyo.channel.plugins.micup.bean.PlayerInfo> playerTemp = new ArrayList<com.yy.hiyo.channel.plugins.micup.bean.PlayerInfo>();
                if (playerInfos != null && !playerInfos.isEmpty()) {
                    for (PlayerInfo info : playerInfos) {
                        com.yy.hiyo.channel.plugins.micup.bean.PlayerInfo playerInfo = new com.yy.hiyo.channel.plugins.micup.bean.PlayerInfo();
                        playerInfo.setTotal(info.total);
                        playerInfo.setSuccess(info.success);
                        playerInfo.setLife(info.life);
                        playerInfo.setUid(info.uid);
                        playerInfo.setIndex(info.seat);
                        playerInfo.setScore(info.score);
                        ExtendInfo extra = info.extra;
                        if (extra != null) {
                            playerInfo.setNick(extra.Nick);
                            playerInfo.setAvatar(extra.Avatar);
                        }
                        playerTemp.add(playerInfo);
                    }
                }
                MicupDataService.this.getDataContext().setPlayerList(playerTemp);
                if (round > lastRound) {
                    MicupDataService.this.getDataContext().updateNewRound(round);
                    if (MicupDataService.this.dataCallback != null) {
                        MicupDataService.this.dataCallback.onNextRound(round);
                    }
                    if (MicupDataService.this.audioManager != null && MicupDataService.this.audioManager.getNotify() != null) {
                        MicupDataService.this.audioManager.getNotify().onNextRoundNotify(round);
                    }
                }
                int lastRoundStatus = MicupDataService.this.getDataContext().getCurrentRoundInfo().getRoundState();
                int currentStatus = roundStatus != null ? message.getStatusValue() : 0;
                MicupDataService.this.getDataContext().getCurrentRoundInfo().setRoundState(currentStatus);
                if (lastRoundStatus != currentStatus) {
                    if (currentStatus == 3) {
                        MicupDataService.this.getDataContext().setCurrentRoundUid(message.uid, round);
                        if (MicupDataService.this.dataCallback != null) {
                            MicupDataService.this.dataCallback.onUserGetTheChance(message.uid, round, MicupDataService.this.getDataContext().getPlayer(message.uid).getAvatar(), MicupDataService.this.getDataContext().getPlayer(message.uid).getNick());
                        }
                        if (MicupDataService.this.audioManager != null && MicupDataService.this.audioManager.getNotify() != null) {
                            MicupDataService.this.audioManager.getNotify().onUserGetTheChanceNotify(message.uid, round, MicupDataService.this.getDataContext().getPlayer(message.uid).getAvatar(), MicupDataService.this.getDataContext().getPlayer(message.uid).getNick());
                        }
                    } else if (currentStatus == 4) {
                        MicupDataService.this.getDataContext().setCurrentRoundUid(message.uid, round);
                        MicupDataService.this.getDataContext().getCurrentRoundInfo().setSongIdentifyState(1);
                        if (MicupDataService.this.dataCallback != null) {
                            MicupDataService.this.dataCallback.onWaitForDetermine(round, term);
                        }
                        if (MicupDataService.this.audioManager != null && MicupDataService.this.audioManager.getNotify() != null) {
                            MicupDataService.this.audioManager.getNotify().onWaitForDetermineNotify(round, term);
                        }
                    } else if (currentStatus == 5) {
                        MicupDataService.this.getDataContext().setCurrentRoundUid(message.uid, round);
                        MicupDataService.this.getDataContext().getCurrentRoundInfo().setSongIdentifyState(message.is_success != false ? 2 : 3);
                        if (MicupDataService.this.dataCallback != null) {
                            MicupDataService.this.dataCallback.onSongIdentifyResult(MicupDataService.this.getDataContext().getCurrentRoundInfo());
                        }
                        if (MicupDataService.this.audioManager != null && MicupDataService.this.audioManager.getNotify() != null) {
                            MicupDataService.this.audioManager.getNotify().onSongIdentifyResultNotify(MicupDataService.this.getDataContext().getCurrentRoundInfo());
                        }
                    }
                }
                if (roundStatus != null && roundStatus == RoundStatus.GameOver) {
                    MicupDataService.this.notifyGameEnded();
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread(() -> {
                    String errMsg = "fetchRoundInfos retryWhenTimeout !!!";
                    MLog.error((Object)MicupDataService.TAG, (String)errMsg, (Object[])new Object[0]);
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                YYTaskExecutor.postToMainThread(() -> {
                    String errMsg = StringUtils.formatWitUSLocal((String)"fetchRoundInfos retryWhenError!!! canRetry:%b, reason:%s, code:%d ", (Object[])new Object[]{canRetry, reason, code});
                    MLog.error((Object)MicupDataService.TAG, (String)errMsg, (Object[])new Object[0]);
                });
                return false;
            }
        });
    }

    private void notifyGameStarted() {
        MicupDataContext dataContext = this.getDataContext();
        if (dataContext != null && (dataContext.getState() == 0 || dataContext.getState() == 2)) {
            dataContext.setState(1);
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"notifyGameStarted", (Object[])new Object[0]);
            }
            if (this.audioManager == null) {
                this.audioManager = new AudioManager(this.getDataContext());
            }
            this.audioManager.onCreate(this.dataCallback.getMvpContext());
            if (this.dataCallback != null) {
                this.dataCallback.onGameStarted();
            }
            if (this.micupStartedCallback != null) {
                this.micupStartedCallback.onMicUpStarted();
            }
            NotificationCenter.getGlobalInstance().register(VoiceNotificationDef.EXCEPTION_EXIT_PLUGIN, this.iNotify);
            NotificationCenter.getGlobalInstance().register(NotificationDef.WSCLIENT_CONNECT_SUCCESS, this.iNotify);
        } else {
            MLog.error((Object)TAG, (String)"notifyGameStarted error!!!datacontext:%s", (Object[])new Object[]{dataContext});
        }
    }

    private void notifyGameEnded() {
        MicupDataContext dataContext = this.getDataContext();
        if (dataContext != null && dataContext.getState() != 3) {
            IMicupLifeCycle lifeCycle = this.micupStartedCallback;
            YYTaskExecutor.removeTask((Runnable)this.mNotifyEndRunnable);
            this.mNotifyEndRunnable = () -> {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"notifyGameEnded", (Object[])new Object[0]);
                }
                if (dataContext.getState() == 3) {
                    MLog.error((Object)TAG, (String)"notifyGameEnded context is destroy", (Object[])new Object[0]);
                    return;
                }
                dataContext.setState(3);
                if (this.dataCallback != null) {
                    this.dataCallback.onGameEnded();
                }
                if (this.audioManager != null) {
                    this.audioManager.onDestroy(0);
                    this.audioManager = null;
                }
                this.dataCallback = null;
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTMicUpPanel", (String)"data service dataCallback = null.", (Object[])new Object[0]);
                }
                if (lifeCycle != null) {
                    lifeCycle.onMicUpEnded();
                }
            };
            YYTaskExecutor.postToMainThread((Runnable)this.mNotifyEndRunnable, (long)3000L);
        } else {
            MLog.error((Object)TAG, (String)"notifyGameEnded error!!!,datacontext:%s", (Object[])new Object[]{dataContext});
        }
    }

    @Override
    public MicupDataContext getDataContext() {
        if (this.dataContext == null) {
            this.dataContext = new MicupDataContext();
            this.dataContext.setVoiceRoom(this.mVoiceRoom);
        }
        return this.dataContext;
    }

    @Override
    public boolean isRunning() {
        return this.getDataContext().getState() == 1;
    }

    @Override
    public IAudioManager getAudioManager() {
        return this.audioManager;
    }
}

