/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup;

import android.graphics.Typeface;
import android.view.View;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.opensource.svgaplayer.hago.SVGAImageView;
import com.opensource.svgaplayer.hago.SVGAVideoEntity;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.hiyo.channel.plugins.micup.DR;
import com.yy.hiyo.channel.plugins.micup.R;
import com.yy.hiyo.channel.plugins.micup.bean.PlayerInfo;
import com.yy.hiyo.channel.plugins.micup.bean.SeatUser;
import com.yy.hiyo.dyres.api.DyResLoader;

public class VH
extends RecyclerView.ViewHolder {
    private static final String TAG = "VH";
    private SeatUser seatUser;
    private RecycleImageView ivAvatar;
    private YYTextView tvOut;
    private YYLinearLayout llSum;
    private YYTextView tvIndex;
    private YYTextView tvSum;
    private SVGAImageView svBg;
    private final KvoBinder mBinder = new KvoBinder((Object)this);

    public VH(View itemView) {
        super(itemView);
        this.ivAvatar = (RecycleImageView)itemView.findViewById(R.id.iv_avatar);
        this.tvOut = (YYTextView)itemView.findViewById(R.id.tv_out);
        this.llSum = (YYLinearLayout)itemView.findViewById(R.id.ll_sum);
        this.tvIndex = (YYTextView)itemView.findViewById(R.id.tv_index);
        this.tvSum = (YYTextView)itemView.findViewById(R.id.tv_sum);
        this.svBg = (SVGAImageView)itemView.findViewById(R.id.sv_bg);
        this.svBg.setFillMode(SVGAImageView.FillMode.Forward);
        FontUtils.setFontType((TextView)this.tvIndex, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
    }

    void bindData(SeatUser seatUser) {
        if (seatUser == null || seatUser.playerInfo == null) {
            MLog.error((Object)TAG, (String)"seatUser input error:%s", (Object[])new Object[]{seatUser});
            return;
        }
        this.unbindPrevious();
        this.seatUser = seatUser;
        this.mBinder.singleBindSourceTo((KvoSource)seatUser.userInfoKS);
        this.mBinder.singleBindSourceTo((KvoSource)seatUser);
        this.mBinder.singleBindSourceTo((KvoSource)seatUser.playerInfo);
    }

    public void unbindPrevious() {
        if (this.seatUser != null) {
            this.mBinder.clearAllKvoConnections();
        }
    }

    @KvoMethodAnnotation(name="avatar", thread=1, sourceClass=UserInfoKS.class)
    public void onUserAvatar(KvoEventIntent event) {
        ImageLoader.loadImage((RecycleImageView)this.ivAvatar, (String)((String)event.caseNewValue((Object)"")));
    }

    @KvoMethodAnnotation(sourceClass=SeatUser.class, name="isFirst", thread=1)
    public void isFirstOne(KvoEventIntent event) {
        boolean isFirst = (Boolean)event.caseNewValue((Object)false);
        this.llSum.setBackgroundDrawable(ResourceUtils.getDrawable((int)(isFirst ? R.drawable.bg_micup_first_sum : R.drawable.bg_micup_sum)));
        this.tvIndex.setTextColor(ResourceUtils.getColor((int)(isFirst ? R.color.color_ff7400 : R.color.color_ob0505)));
    }

    @KvoMethodAnnotation(sourceClass=SeatUser.class, name="state", thread=1)
    public void onStateUpdate(KvoEventIntent event) {
        int state = (Integer)event.caseNewValue((Object)0);
        this.tvOut.setVisibility(8);
        this.svBg.setVisibility(4);
        if (state == 4) {
            this.tvOut.setVisibility(0);
        } else if (state == 2) {
            this.svBg.setClearsAfterStop(true);
            this.svBg.setVisibility(0);
            DyResLoader.INSTANCE.loadSvga(this.svBg, DR.micup_plus_one, new ISvgaLoadCallback(){

                public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                    if (VH.this.svBg != null && VH.this.seatUser != null && VH.this.seatUser.getState() == 2) {
                        VH.this.svBg.startAnimation();
                    }
                }

                public void onFailed(Exception e) {
                }
            });
        } else if (state == 1) {
            this.svBg.setClearsAfterStop(false);
            this.svBg.setVisibility(0);
            DyResLoader.INSTANCE.loadSvga(this.svBg, DR.micup_singing, new ISvgaLoadCallback(){

                public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                    if (VH.this.svBg != null && VH.this.seatUser != null && VH.this.seatUser.getState() == 1) {
                        VH.this.svBg.startAnimation();
                    }
                }

                public void onFailed(Exception e) {
                }
            });
        } else if (state == 0 || state == 3) {
            // empty if block
        }
    }

    @KvoMethodAnnotation(sourceClass=SeatUser.class, name="index", thread=1)
    public void onIndexUpdate(KvoEventIntent event) {
        this.tvIndex.setText((CharSequence)((Integer)event.caseNewValue((Object)0) + 1 + ""));
    }

    @KvoMethodAnnotation(sourceClass=PlayerInfo.class, name="score", thread=1)
    public void onScoreUpdate(KvoEventIntent event) {
        this.tvSum.setText((CharSequence)(event.caseNewValue((Object)0) + ""));
    }

    public SeatUser getSeatUser() {
        return this.seatUser;
    }

    public RecycleImageView getIvAvatar() {
        return this.ivAvatar;
    }
}

