/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.panel;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.opensource.svgaplayer.hago.SVGADynamicEntity;
import com.opensource.svgaplayer.hago.SVGAImageView;
import com.opensource.svgaplayer.hago.SVGAVideoEntity;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.hiyo.channel.plugins.micup.DR;
import com.yy.hiyo.channel.plugins.micup.R;
import com.yy.hiyo.channel.plugins.micup.interfaces.IMicUpView;
import com.yy.hiyo.channel.plugins.micup.panel.MicUpUICallback;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.dyres.inner.DResource;
import com.yy.hiyo.wallet.base.giftbox.GiftSweepImageView;

public abstract class BaseMicUpAnimView
extends YYFrameLayout
implements View.OnClickListener,
IMicUpView {
    protected MicUpUICallback mUICallback;
    private SVGAImageView mSVGAImageView;
    private YYTextView mTitleView;
    private YYFrameLayout mTopContainerView;
    private YYLinearLayout mBottomContainerView;
    protected View mGiftContainerView;
    private GiftSweepImageView mSweepImageView;
    private static final String KEY_SVGA_AVATAR = "toux00";
    private static final int COLOR_WHITE = ColorUtils.parseColor((String)"#FFFFFFFF");
    private static final int COLOR_YELLOW = ColorUtils.parseColor((String)"#FFFFBE03");
    private static final int COLOR_BLUE = ColorUtils.parseColor((String)"#FF25D572");
    protected long mSingerUid = -1L;

    public BaseMicUpAnimView(Context context) {
        this(context, null);
    }

    public BaseMicUpAnimView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BaseMicUpAnimView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(context);
        this.createView(context);
        this.addBottomView(context);
    }

    private void initView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.view_mic_up_anim_layout_channel, (ViewGroup)this);
        this.mSVGAImageView = (SVGAImageView)this.findViewById(R.id.view_svga);
        this.mTitleView = (YYTextView)this.findViewById(R.id.tv_tip);
        this.mTopContainerView = (YYFrameLayout)this.findViewById(R.id.fl_top_container);
        this.mBottomContainerView = (YYLinearLayout)this.findViewById(R.id.ll_bottom_container);
        RecycleImageView rulesView = (RecycleImageView)this.findViewById(R.id.iv_rules);
        rulesView.setOnClickListener((View.OnClickListener)this);
    }

    private void addBottomView(Context context) {
        LinearLayout.LayoutParams layoutParams;
        View followView = this.createBottomView();
        if (followView != null) {
            layoutParams = new LinearLayout.LayoutParams(-2, -1);
            layoutParams.rightMargin = ResolutionUtils.dip2Px((float)10.0f);
            layoutParams.gravity = 17;
            this.mBottomContainerView.addView(followView, (ViewGroup.LayoutParams)layoutParams);
        }
        this.mGiftContainerView = View.inflate((Context)context, (int)R.layout.view_mic_up_bottom_send_gift_channel, null);
        this.mSweepImageView = (GiftSweepImageView)this.mGiftContainerView.findViewById(R.id.view_sweep);
        layoutParams = new LinearLayout.LayoutParams(-2, -2);
        layoutParams.gravity = 17;
        this.mBottomContainerView.addView(this.mGiftContainerView, (ViewGroup.LayoutParams)layoutParams);
        this.mGiftContainerView.setOnClickListener((View.OnClickListener)this);
    }

    public void setUICallback(MicUpUICallback uiCallback) {
        this.mUICallback = uiCallback;
    }

    protected abstract void createView(Context var1);

    protected void setUid(long singerUid) {
        this.mSingerUid = singerUid;
    }

    protected void startPlaySvga(int status, String singerAvatar) {
        FeatureLog.i((String)"FTMicUpPanel", (String)"updateAudienceSingPanel sing status: %s,mOriginSinger avatar: %s", (Object[])new Object[]{status, singerAvatar});
        if (StringUtils.isEmpty((String)singerAvatar)) {
            singerAvatar = "";
        }
        this.mTitleView.setText((CharSequence)"");
        if (status == 0) {
            this.playSvga(singerAvatar, DR.mic_up_audience_singing, true);
        } else if (status == 1) {
            this.mTitleView.setTextColor(COLOR_YELLOW);
            this.mTitleView.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_mic_up_recognize));
            this.playSvga(singerAvatar, DR.mic_up_audience_recognizing, true);
        } else if (status == 2) {
            this.mTitleView.setTextColor(COLOR_BLUE);
            this.mTitleView.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_mic_up_sing_success));
            this.playSvga(singerAvatar, DR.mic_up_sing_success, false);
        } else if (status == 3) {
            this.mTitleView.setTextColor(COLOR_WHITE);
            this.mTitleView.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_mic_up_sing_fail));
            this.playSvga(singerAvatar, DR.mic_up_sing_fail, false);
        } else if (status == 4) {
            this.mTitleView.setTextColor(COLOR_WHITE);
            this.mTitleView.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_mic_up_out));
            this.playSvga(singerAvatar, DR.mic_up_out, false);
        }
        if (this.mSweepImageView != null) {
            this.mSweepImageView.initAndStartRepeatTranslation(-1, ResolutionUtils.dip2Px((float)76.0f));
        }
    }

    private void playSvga(final @NonNull String avatar, DResource svgaResource, final boolean loopPlayAnimation) {
        DyResLoader.INSTANCE.loadSvga(this.mSVGAImageView, svgaResource, new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                if (BaseMicUpAnimView.this.mSVGAImageView != null) {
                    if (loopPlayAnimation) {
                        BaseMicUpAnimView.this.mSVGAImageView.setLoopCount(-1);
                    } else {
                        BaseMicUpAnimView.this.mSVGAImageView.setLoopCount(1);
                    }
                    BaseMicUpAnimView.this.loadAvatar(avatar, BaseMicUpAnimView.this.mSVGAImageView, svgaVideoEntity);
                } else {
                    FeatureLog.e((String)"FTMicUpPanel", (String)"determine panel play svga mSVGAImageView == null.", (Object[])new Object[0]);
                }
            }

            public void onFailed(Exception e) {
                FeatureLog.e((String)"FTMicUpPanel", (String)"determine play svga failed: %s", (Object[])new Object[]{e});
            }
        });
    }

    private void loadAvatar(@NonNull String avatar, final @NonNull SVGAImageView svgaImageView, final @NonNull SVGAVideoEntity svgaVideoEntity) {
        ImageLoader.loadBitmap((Context)this.getContext(), (String)avatar, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

            public void onLoadFailed(Exception e) {
                FeatureLog.e((String)"FTMicUpPanel", (String)"load avatar failed: %s", (Object[])new Object[]{e});
            }

            public void onResourceReady(Bitmap bitmap) {
                FeatureLog.i((String)"FTMicUpPanel", (String)"load avatar success.", (Object[])new Object[0]);
                SVGADynamicEntity dynamicEntity = new SVGADynamicEntity();
                dynamicEntity.setDynamicImage(bitmap, BaseMicUpAnimView.KEY_SVGA_AVATAR);
                svgaImageView.setVideoItem(svgaVideoEntity, dynamicEntity);
                svgaImageView.startAnimation();
            }
        });
    }

    protected void addTopView(@Nullable View view) {
        if (this.mTopContainerView == null) {
            return;
        }
        if (view != null) {
            FrameLayout.LayoutParams secondLayoutParams = new FrameLayout.LayoutParams(-2, -2, 0x800005);
            secondLayoutParams.rightMargin = ResolutionUtils.dip2Px((float)45.0f);
            this.mTopContainerView.addView(view, (ViewGroup.LayoutParams)secondLayoutParams);
        }
    }

    protected View createBottomView() {
        return null;
    }

    public void onClick(View view) {
        if (view == null) {
            return;
        }
        int viewId = view.getId();
        if (viewId == R.id.iv_rules) {
            if (this.mUICallback != null) {
                this.mUICallback.onGameRuleClick();
            }
        } else if (viewId == R.id.fl_gift && this.mUICallback != null) {
            this.mUICallback.onSendGiftClick(this.mSingerUid);
        }
    }

    @Override
    public void onDestroy() {
        if (this.mSweepImageView != null) {
            this.mSweepImageView.cancelTransAnim();
        }
        if (this.mSVGAImageView != null) {
            this.mSVGAImageView.stopAnimation(true);
        }
    }
}

