/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.panel;

import android.content.Context;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.plugins.micup.R;
import com.yy.hiyo.channel.plugins.micup.panel.BaseMicUpAnimView;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.data.Relation;
import com.yy.hiyo.relation.base.data.RelationInfo;

public class BaseAudienceDetermineView
extends BaseMicUpAnimView {
    private View mFollowContainer;
    private RecycleImageView mFollowIconView;
    private YYTextView mFollowView;
    private float mGiftTextWidth;
    private float mFollowTextWidth;
    private float mFollowingTextWidth;
    private static final int TEXT_SIZE = ResolutionUtils.spToPx((float)10.0f);
    private static final int EXTRA_WIDTH = ResolutionUtils.dip2Px((float)24.0f);
    private RelationInfo mRelation;

    public BaseAudienceDetermineView(Context context) {
        super(context);
    }

    public BaseAudienceDetermineView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public BaseAudienceDetermineView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void createView(Context context) {
        TextPaint paint = new TextPaint();
        paint.setTextSize((float)TEXT_SIZE);
        this.mGiftTextWidth = paint.measureText(ResourceUtils.getString((int)R.string.btn_mic_up_gift));
        this.mFollowTextWidth = paint.measureText(ResourceUtils.getString((int)R.string.btn_profile_card_follow));
        this.mFollowingTextWidth = paint.measureText(ResourceUtils.getString((int)R.string.btn_profile_card_following));
    }

    @Override
    protected View createBottomView() {
        this.mFollowContainer = View.inflate((Context)this.getContext(), (int)R.layout.view_mic_up_bottom_follow_channel, null);
        this.mFollowContainer.setOnClickListener((View.OnClickListener)this);
        this.mFollowIconView = (RecycleImageView)this.mFollowContainer.findViewById(R.id.iv_follow);
        this.mFollowView = (YYTextView)this.mFollowContainer.findViewById(R.id.tv_follow);
        return this.mFollowContainer;
    }

    @Override
    protected void setUid(long singerUid) {
        super.setUid(singerUid);
        if (this.mRelation != null) {
            Kvo.autoUnbindingFrom((KvoSource)this.mRelation, (Object)this);
        }
        this.mRelation = ((IRelationService)ServiceManagerProxy.getServiceManager().getService(IRelationService.class)).getRelationLocal(this.mSingerUid);
        Kvo.autoBindingTo((KvoSource)this.mRelation, (Object)this);
    }

    @KvoMethodAnnotation(name="relation", sourceClass=RelationInfo.class, thread=1)
    public void updateFollowStatus(KvoEventIntent event) {
        RelationInfo followStatus = (RelationInfo)event.source();
        FeatureLog.i((String)"FTMicUpPanel", (String)"user follow status: %d", (Object[])new Object[]{followStatus.getRelation().getValue()});
        float maxTextWidth = 0.0f;
        if (!followStatus.isFollow()) {
            maxTextWidth = this.getMaxTextWidth(this.mFollowTextWidth);
            if (this.mFollowContainer != null && this.mFollowView != null && this.mFollowIconView != null) {
                this.mFollowContainer.setBackgroundResource(R.drawable.shape_mic_up_btn_follow);
                this.mFollowIconView.setBackgroundResource(R.drawable.icon_mic_up_follow);
                this.mFollowView.setTextColor(ColorUtils.parseColor((String)"#FFFF2137"));
                this.mFollowView.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_profile_card_follow));
            }
        } else {
            maxTextWidth = this.getMaxTextWidth(this.mFollowingTextWidth);
            if (this.mFollowContainer != null && this.mFollowView != null && this.mFollowIconView != null) {
                this.mFollowContainer.setBackgroundResource(R.drawable.shape_mic_up_btn_following);
                this.mFollowIconView.setBackgroundResource(R.drawable.icon_mic_up_following);
                this.mFollowView.setTextColor(ColorUtils.parseColor((String)"#FFFFFFFF"));
                this.mFollowView.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_profile_card_following));
            }
        }
        if (followStatus.getRelation() != Relation.NONE) {
            this.resetFollowAndGiftLayoutParams((int)(maxTextWidth + (float)EXTRA_WIDTH));
        }
    }

    private float getMaxTextWidth(float followWidth) {
        return followWidth >= this.mGiftTextWidth ? followWidth : this.mGiftTextWidth;
    }

    private void resetFollowAndGiftLayoutParams(int maxTextWidth) {
        if (this.mFollowContainer == null || this.mGiftContainerView == null) {
            return;
        }
        ViewGroup.LayoutParams followViewLayoutParams = this.mFollowContainer.getLayoutParams();
        ViewGroup.LayoutParams giftViewLayoutParams = this.mGiftContainerView.getLayoutParams();
        followViewLayoutParams.width = maxTextWidth;
        giftViewLayoutParams.width = maxTextWidth;
    }

    @Override
    public void onClick(View view) {
        super.onClick(view);
        if (view == this.mFollowContainer && this.mUICallback != null) {
            this.mUICallback.onFollowClick(this.mSingerUid);
        }
    }

    @Override
    public void onDestroy() {
        if (this.mRelation != null) {
            Kvo.autoUnbindingFrom((KvoSource)this.mRelation, (Object)this);
        }
        super.onDestroy();
    }
}

