/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.panel.leadsing;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import androidx.annotation.UiThread;
import com.yy.appbase.ui.widget.bubble.BubbleFrameLayout;
import com.yy.appbase.ui.widget.bubble.BubblePopupWindow;
import com.yy.appbase.ui.widget.bubble.BubbleStyle;
import com.yy.appbase.ui.widget.bubble.RelativePos;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.plugins.micup.R;
import com.yy.hiyo.channel.plugins.micup.widget.StepProgressView;

public abstract class BaseMicUpLeadSingView
extends YYConstraintLayout {
    private StepProgressView mProgressView;
    private BubblePopupWindow mPopWindow;
    private YYTextView mBubbleTextView;
    private BubbleFrameLayout mBubbleFrameLayout;
    private Animator mAnimator;
    protected boolean mCurrViewDetached = false;

    public BaseMicUpLeadSingView(Context context) {
        this(context, null);
    }

    public BaseMicUpLeadSingView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BaseMicUpLeadSingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initPopWindow();
        this.createView(context);
        this.initProgressView();
        this.setClipChildren(false);
    }

    private void initProgressView() {
        View contentView = View.inflate((Context)this.getContext(), (int)R.layout.view_mic_up_progress_channel, (ViewGroup)this);
        this.mProgressView = (StepProgressView)contentView.findViewById(R.id.progress_bar);
    }

    private void initPopWindow() {
        View contentView = View.inflate((Context)this.getContext(), (int)R.layout.view_mic_up_pop_channel, null);
        this.mBubbleTextView = (YYTextView)contentView.findViewById(R.id.tv_tip);
        this.mBubbleFrameLayout = (BubbleFrameLayout)contentView.findViewById(R.id.pop_container);
        this.mBubbleFrameLayout.setFillColor(Color.parseColor((String)"#FF25D572"));
        this.mBubbleFrameLayout.setCornerRadius((float)ResolutionUtils.dip2Px((float)5.0f));
        this.mPopWindow = new BubblePopupWindow(contentView, (BubbleStyle)this.mBubbleFrameLayout);
        this.mPopWindow.setCancelOnTouch(false);
        this.mPopWindow.setCancelOnTouchOutside(false);
    }

    protected abstract void createView(Context var1);

    protected void showVerticalPopWindow(@NonNull View targetView, @StringRes int stringRes) {
        if (this.mCurrViewDetached) {
            return;
        }
        this.mBubbleTextView.setText((CharSequence)StringUtils.getHtmlText((int)stringRes, (Object[])new Object[0]));
        this.mBubbleTextView.setAutoLinkMask(2);
        RelativePos relativePos = new RelativePos(0, 2);
        this.mPopWindow.setPadding(ResolutionUtils.dip2Px((float)55.0f));
        this.mPopWindow.showArrowTo(targetView, relativePos, 0, ResolutionUtils.dip2Px((float)5.0f));
    }

    protected void showHorizontalPopWindow(@NonNull View targetView, @StringRes int stringRes) {
        if (this.mCurrViewDetached) {
            return;
        }
        this.mBubbleTextView.setText((CharSequence)ResourceUtils.getString((int)stringRes));
        this.mPopWindow.showArrowTo(targetView, BubbleStyle.ArrowDirection.Right);
        if (this.mAnimator != null) {
            this.mAnimator.cancel();
            this.mAnimator = null;
        }
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)this.mBubbleFrameLayout, (String)"translationX", (float[])new float[]{-ResolutionUtils.dip2Px((float)20.0f), 0.0f});
        animator.setRepeatCount(-1);
        animator.setRepeatMode(2);
        animator.setDuration(500L);
        animator.start();
        this.mAnimator = animator;
    }

    protected void hidePopWindow() {
        if (this.mPopWindow != null && this.mPopWindow.isShowing()) {
            this.mPopWindow.dismiss();
        }
        if (this.mAnimator != null) {
            this.mAnimator.cancel();
            this.mAnimator = null;
        }
    }

    @UiThread
    protected void setMaxProgress(int maxProgress) {
        if (this.mProgressView != null) {
            this.mProgressView.setMaxValue(maxProgress);
        }
    }

    @UiThread
    protected void setProgress(int value) {
        if (this.mProgressView != null) {
            this.mProgressView.setValue(value);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mCurrViewDetached = false;
    }

    protected void onDetachedFromWindow() {
        this.mCurrViewDetached = true;
        super.onDetachedFromWindow();
    }
}

