/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.result;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.plugins.micup.R;
import com.yy.hiyo.channel.plugins.micup.bean.ResultInfo;
import com.yy.hiyo.channel.plugins.micup.result.MicUpResultRankListDiffCallback;
import java.util.Collections;
import java.util.List;

public final class MicUpResultAdapter
extends RecyclerView.Adapter<MicUpResultItemViewHolder> {
    private List<ResultInfo> mResultInfoList = Collections.emptyList();

    @NonNull
    public MicUpResultItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View rootView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_mic_up_result_rank_channel, parent, false);
        return new MicUpResultItemViewHolder(rootView);
    }

    public void setData(@NonNull List<ResultInfo> resultInfoList) {
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)new MicUpResultRankListDiffCallback(this.mResultInfoList, resultInfoList), (boolean)true);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)this);
        this.mResultInfoList = resultInfoList;
    }

    public void onBindViewHolder(@NonNull MicUpResultItemViewHolder holder, int position) {
        if (FP.empty(this.mResultInfoList)) {
            return;
        }
        ResultInfo resultInfo = this.mResultInfoList.get(position);
        if (resultInfo == null) {
            return;
        }
        boolean lastItem = this.mResultInfoList.size() - 1 == position;
        holder.bindData(resultInfo, lastItem);
    }

    public int getItemCount() {
        return FP.empty(this.mResultInfoList) ? 0 : this.mResultInfoList.size();
    }

    static class MicUpResultItemViewHolder
    extends RecyclerView.ViewHolder {
        YYTextView mRankView;
        RecycleImageView mCrownView;
        CircleImageView mAvatarView;
        YYTextView mNickView;
        YYTextView mMicNumView;
        YYTextView mMicNumTipView;
        YYTextView mScoreView;
        YYTextView mScoreTipView;
        View mDividerView;

        MicUpResultItemViewHolder(View itemView) {
            super(itemView);
            this.mRankView = (YYTextView)itemView.findViewById(R.id.tv_rank);
            this.mCrownView = (RecycleImageView)itemView.findViewById(R.id.iv_crown);
            this.mAvatarView = (CircleImageView)itemView.findViewById(R.id.iv_avatar);
            this.mNickView = (YYTextView)itemView.findViewById(R.id.tv_user_name);
            this.mNickView.setTextColor(ResourceUtils.getColor((int)R.color.common_title_color));
            this.mMicNumView = (YYTextView)itemView.findViewById(R.id.tv_mic_num);
            this.mMicNumView.setTextColor(ResourceUtils.getColor((int)R.color.common_title_color));
            this.mMicNumTipView = (YYTextView)itemView.findViewById(R.id.tv_mic_num_tip);
            this.mMicNumTipView.setTextColor(ResourceUtils.getColor((int)R.color.color_979797));
            this.mScoreView = (YYTextView)itemView.findViewById(R.id.tv_score);
            this.mScoreView.setTextColor(ResourceUtils.getColor((int)R.color.common_title_color));
            this.mScoreTipView = (YYTextView)itemView.findViewById(R.id.tv_score_tip);
            this.mScoreTipView.setTextColor(ResourceUtils.getColor((int)R.color.color_979797));
            View line = itemView.findViewById(R.id.line);
            line.setBackgroundColor(ResourceUtils.getColor((int)R.color.color_979797));
            this.mDividerView = itemView.findViewById(R.id.view_divider);
            this.mDividerView.setBackgroundColor(ResourceUtils.getColor((int)R.color.color_ebebeb));
        }

        void bindData(@NonNull ResultInfo resultInfo, boolean lastItem) {
            if (lastItem) {
                this.mDividerView.setVisibility(8);
            } else {
                this.mDividerView.setVisibility(0);
            }
            int rank = resultInfo.rank;
            this.mRankView.setText((CharSequence)String.valueOf(rank));
            if (rank == 1) {
                this.mRankView.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.icon_mic_up_result_rank_first));
                this.mCrownView.setVisibility(0);
                this.mCrownView.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.icon_mic_up_result_rank_first_crown));
            } else if (rank == 2) {
                this.mRankView.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.icon_mic_up_result_rank_second));
                this.mCrownView.setVisibility(0);
                this.mCrownView.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.icon_mic_up_result_rank_second_crown));
            } else if (rank == 3) {
                this.mRankView.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.icon_mic_up_result_rank_third));
                this.mCrownView.setVisibility(0);
                this.mCrownView.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.icon_mic_up_result_rank_third_crown));
            } else {
                this.mCrownView.setVisibility(8);
                this.mRankView.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.icon_mic_up_result_rank_normal));
            }
            ImageLoader.loadImage((ImageView)this.mAvatarView, (String)resultInfo.avatar, (int)R.drawable.icon_avatar_default_male, (int)R.drawable.icon_avatar_default_male);
            this.mNickView.setText((CharSequence)resultInfo.nick);
            this.mMicNumView.setText((CharSequence)String.valueOf(resultInfo.micNum));
            this.mScoreView.setText((CharSequence)String.valueOf(resultInfo.score));
        }
    }
}

