/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.guide;

import android.content.Context;
import android.view.ViewGroup;
import androidx.annotation.DrawableRes;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.yy.appbase.ui.widget.MoveSpotLayout;
import com.yy.appbase.ui.widget.viewpager.YYViewPager;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.cbase.model.bean.RuleCardInfoBean;
import com.yy.hiyo.channel.cbase.widget.IGuidePageCallback;
import com.yy.hiyo.channel.plugins.micup.R;
import com.yy.hiyo.channel.plugins.micup.guide.RuleCardPagerAdapter;
import java.util.ArrayList;

public class MicUpGuidePage
extends YYFrameLayout {
    private YYViewPager mVpRuleCard;
    private YYTextView mTvNextBtn;
    private MoveSpotLayout mSpotRuleCard;
    private RuleCardPagerAdapter mRuleCardPagerAdapter;
    private YYImageView mIvClose;
    private IGuidePageCallback mCallback;

    public MicUpGuidePage(Context context) {
        super(context);
        this.createView();
        this.initRuleCardPager();
        this.initListener();
    }

    private void createView() {
        MicUpGuidePage.inflate((Context)this.getContext(), (int)R.layout.layout_mic_up_guide_page_channel, (ViewGroup)this);
        this.mVpRuleCard = (YYViewPager)this.findViewById(R.id.vp_rule);
        this.mSpotRuleCard = (MoveSpotLayout)this.findViewById(R.id.spot_rule);
        this.mTvNextBtn = (YYTextView)this.findViewById(R.id.tv_next);
        this.mIvClose = (YYImageView)this.findViewById(R.id.iv_close);
    }

    public void setBgColor(int color2) {
        this.setBackgroundColor(color2);
    }

    public void setBgImg(@DrawableRes int res) {
        this.setBackgroundResource(res);
    }

    private void initRuleCardPager() {
        this.mRuleCardPagerAdapter = new RuleCardPagerAdapter();
        this.mVpRuleCard.setAdapter((PagerAdapter)this.mRuleCardPagerAdapter);
        ArrayList<RuleCardInfoBean> pagerData = new ArrayList<RuleCardInfoBean>();
        pagerData.add(new RuleCardInfoBean(R.drawable.img_mic_up_rule_get, ResourceUtils.getString((int)R.string.tips_mic_up_rule_get)));
        pagerData.add(new RuleCardInfoBean(R.drawable.img_mic_up_rule_win, ResourceUtils.getString((int)R.string.tips_mic_up_rule_win)));
        pagerData.add(new RuleCardInfoBean(R.drawable.img_mic_up_rule_fail, ResourceUtils.getString((int)R.string.tips_mic_up_rule_fail)));
        this.mRuleCardPagerAdapter.setData(pagerData);
        this.mSpotRuleCard.setSpots(pagerData.size(), this.mVpRuleCard.getCurrentItem());
    }

    private void initListener() {
        this.mTvNextBtn.setOnClickListener(v -> {
            int itemCount;
            int currentPosition = this.mVpRuleCard.getCurrentItem();
            int nextPosition = currentPosition + 1;
            if (nextPosition < (itemCount = this.mRuleCardPagerAdapter.getCount())) {
                this.mVpRuleCard.setCurrentItem(nextPosition, true);
            } else if (this.mCallback != null) {
                this.mCallback.onClose();
            }
        });
        this.mIvClose.setOnClickListener(v -> {
            if (this.mCallback != null) {
                this.mCallback.onClose();
            }
        });
        this.mVpRuleCard.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                if (MicUpGuidePage.this.mSpotRuleCard != null) {
                    MicUpGuidePage.this.mSpotRuleCard.setMoveSpotPosition(position, positionOffset);
                }
            }

            public void onPageSelected(int position) {
                if (position == MicUpGuidePage.this.mRuleCardPagerAdapter.getCount() - 1) {
                    MicUpGuidePage.this.mTvNextBtn.setText(R.string.btn_mic_up_rule_get);
                } else {
                    MicUpGuidePage.this.mTvNextBtn.setText(R.string.btn_mic_up_rule_next);
                }
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    public void setCallback(IGuidePageCallback callback) {
        this.mCallback = callback;
    }
}

