/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.bean;

import android.content.Context;
import android.util.SparseArray;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.plugins.micup.bean.AudioInfo;
import com.yy.hiyo.channel.plugins.micup.bean.PlayerInfo;
import com.yy.hiyo.channel.plugins.micup.bean.RoundInfo;
import com.yy.hiyo.channel.plugins.micup.bean.SongInfo;
import com.yy.hiyo.channel.plugins.micup.bean.SongStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MicupDataContext {
    private static final String TAG = "FTMicUpMicupDataContext";
    private int state = 0;
    private int term;
    private RoundInfo currentRoundInfo = new RoundInfo();
    private final List<SongInfo> songInfoList = new ArrayList<SongInfo>();
    private final SparseArray<RoundInfo> cacheRoundInfo = new SparseArray();
    private final Map<Long, PlayerInfo> cachePlayerInfo = new LinkedHashMap<Long, PlayerInfo>();
    private Map<String, SongStatus> preSongStatus = new HashMap<String, SongStatus>(10);
    private Map<String, AudioInfo> selfAudioInfo = new HashMap<String, AudioInfo>();
    private IChannel mVoiceRoom;

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getTerm() {
        return this.term;
    }

    public void setTerm(int term) {
        this.term = term;
    }

    public synchronized RoundInfo getCurrentRoundInfo() {
        return this.currentRoundInfo;
    }

    public synchronized void updateNewRound(int round) {
        MLog.info((Object)TAG, (String)"update new round, round:%d", (Object[])new Object[]{round});
        this.currentRoundInfo = this.getRoundInfoAndUpdate(round);
        this.currentRoundInfo.setSongIdentifyState(0);
    }

    private void addSongInfo(RoundInfo roundInfo, int round) {
        if (roundInfo.getSongInfo() != null) {
            return;
        }
        if (this.songInfoList.isEmpty() || round < 0 || round > 0 && this.songInfoList.size() < round) {
            MLog.error((Object)TAG, (String)"song list empty or round is error,song list size:%d, round:%d", (Object[])new Object[]{this.songInfoList.size(), round});
            return;
        }
        roundInfo.setSongInfo(this.songInfoList.get(round - 1));
    }

    public synchronized void setCurrentRoundUid(long uid, int round) {
        RoundInfo roundInfo = this.getRoundInfoAndUpdate(round);
        roundInfo.setPlayerInfo(this.getPlayer(uid));
        roundInfo.setUid(uid);
        MLog.info((Object)TAG, (String)"setCurrentRoundUid uid:%d, round:%d, info:%s", (Object[])new Object[]{uid, round, roundInfo});
    }

    private RoundInfo getRoundInfoAndUpdate(int round) {
        RoundInfo roundInfo;
        if (this.currentRoundInfo.getRound() == round) {
            roundInfo = this.currentRoundInfo;
        } else {
            roundInfo = (RoundInfo)this.cacheRoundInfo.get(round);
            if (roundInfo == null) {
                roundInfo = new RoundInfo();
                this.cacheRoundInfo.append(round, (Object)roundInfo);
            }
            this.currentRoundInfo = roundInfo;
        }
        roundInfo.setRound(round);
        this.addSongInfo(roundInfo, round);
        return roundInfo;
    }

    public synchronized void setSongInfoList(List<SongInfo> songInfoList) {
        MLog.info((Object)TAG, (String)"set song list,info:%s", (Object[])new Object[]{songInfoList});
        this.songInfoList.clear();
        if (songInfoList != null) {
            this.songInfoList.addAll(songInfoList);
        }
        if (this.currentRoundInfo.getSongInfo() == null && this.currentRoundInfo.getRound() > 0 && this.currentRoundInfo.getRound() <= this.songInfoList.size()) {
            MLog.info((Object)TAG, (String)"update current song info when list back!!!,songlist:%d, current round:%d", (Object[])new Object[]{this.songInfoList.size(), this.currentRoundInfo.getRound()});
            this.currentRoundInfo.setSongInfo(this.songInfoList.get(this.currentRoundInfo.getRound() - 1));
        }
    }

    public synchronized void updateRoundSongState(int songState, int round, long uid) {
        RoundInfo roundInfo = this.getRoundInfoAndUpdate(round);
        if (roundInfo.getUid() > 0L && roundInfo.getUid() != uid) {
            if (RuntimeContext.sIsDebuggable) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)StringUtils.formatWitUSLocal((String)"\u8fd9\u4e00\u5c40\u8bc6\u522b\u7ed3\u679c\u7684uid\u548c\u62a2\u5230\u8fd9\u5c40\u7684\u7528\u6237uid\u4e0d\u4e00\u81f4\uff01\uff01\uff01round:%d,pUid:%d, cUid:%d, state:%d", (Object[])new Object[]{round, roundInfo.getUid(), uid, songState}), (int)1);
            } else {
                MLog.error((Object)TAG, (String)"\u8fd9\u4e00\u5c40\u8bc6\u522b\u7ed3\u679c\u7684uid\u548c\u62a2\u5230\u8fd9\u5c40\u7684\u7528\u6237uid\u4e0d\u4e00\u81f4\uff01\uff01\uff01round:%d,pUid:%d, cUid:%d, state:%d", (Object[])new Object[]{round, roundInfo.getUid(), uid, songState});
            }
        }
        roundInfo.setUid(uid);
        roundInfo.setPlayerInfo(this.getPlayer(uid));
        roundInfo.setSongIdentifyState(songState);
    }

    public String toString() {
        return "MicupDataContext{state=" + this.state + ", term=" + this.term + ", currentRoundInfo=" + this.currentRoundInfo + ", songInfoList=" + this.songInfoList + ", cacheRoundInfo=" + this.cacheRoundInfo + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlayerList(List<PlayerInfo> playerList) {
        if (playerList != null && !playerList.isEmpty()) {
            Map<Long, PlayerInfo> map = this.cachePlayerInfo;
            synchronized (map) {
                HashMap<Long, PlayerInfo> playerInfoMap = new HashMap<Long, PlayerInfo>(this.cachePlayerInfo);
                this.cachePlayerInfo.clear();
                for (PlayerInfo playerInfo : playerList) {
                    PlayerInfo playerInfo1 = (PlayerInfo)((Object)playerInfoMap.get(playerInfo.getUid()));
                    if (playerInfo1 == null) {
                        playerInfo1 = this.getPlayer(playerInfo.getUid());
                    } else {
                        this.cachePlayerInfo.put(playerInfo.getUid(), playerInfo1);
                    }
                    playerInfo1.setLife(playerInfo.getLife());
                    playerInfo1.setIndex(playerInfo.getIndex());
                    playerInfo1.setSuccess(playerInfo.getSuccess());
                    playerInfo1.setTotal(playerInfo.getTotal());
                    playerInfo1.setScore(playerInfo.getScore());
                    playerInfo1.setNick(playerInfo.getNick());
                    playerInfo1.setAvatar(playerInfo.getAvatar());
                }
            }
        }
    }

    public List<PlayerInfo> getPlayerList() {
        return new ArrayList<PlayerInfo>(this.cachePlayerInfo.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayerInfo getPlayer(long uid) {
        Map<Long, PlayerInfo> map = this.cachePlayerInfo;
        synchronized (map) {
            PlayerInfo playerInfo = this.cachePlayerInfo.get(uid);
            if (playerInfo == null) {
                playerInfo = new PlayerInfo();
                playerInfo.setUid(uid);
                this.cachePlayerInfo.put(uid, playerInfo);
            }
            return playerInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePlayerInfo(long uid, int life, int score, int success, int seat, int total) {
        Map<Long, PlayerInfo> map = this.cachePlayerInfo;
        synchronized (map) {
            PlayerInfo playerInfo = this.getPlayer(uid);
            playerInfo.setUid(uid);
            playerInfo.setLife(life);
            playerInfo.setScore(score);
            playerInfo.setSuccess(success);
            playerInfo.setIndex(seat);
            playerInfo.setTotal(total);
        }
    }

    public boolean isAudience(long uid) {
        return !this.cachePlayerInfo.containsKey(uid);
    }

    public boolean isSinger() {
        return AccountUtil.getUid() == this.currentRoundInfo.getUid();
    }

    public long getSingerUid() {
        return this.currentRoundInfo.getUid();
    }

    public Map<String, SongStatus> getPreSongStatus() {
        return this.preSongStatus;
    }

    public Map<String, AudioInfo> getSelfAudioInfo() {
        return this.selfAudioInfo;
    }

    public List<SongInfo> getSongInfoList() {
        return this.songInfoList;
    }

    public void setVoiceRoom(IChannel voiceRoom) {
        this.mVoiceRoom = voiceRoom;
    }

    public IChannel getVoiceRoom() {
        return this.mVoiceRoom;
    }
}

