/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.webbussiness.ui;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.main.R;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.IJsEventCallback;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsMethod;
import com.yy.webservice.event.parqam.BaseJsParam;
import com.yy.webservice.event.parqam.IJsParam;
import org.json.JSONException;
import org.json.JSONObject;

public class ToastJsEvent
implements JsEvent {
    @NonNull
    public JsMethod method() {
        return JsEventDefine.UI.showToast;
    }

    public void jsCall(@NonNull IWebBusinessHandler webHandler, final @NonNull String paramJson, final @Nullable IJsEventCallback callback) {
        if (TextUtils.isEmpty((CharSequence)paramJson)) {
            if (callback != null) {
                BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"paramJson is null");
                callback.callJs((IJsParam)err);
            }
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                block13: {
                    try {
                        JSONObject jo = JsonParser.obtainJSONObject((String)paramJson);
                        String msg = jo.optString("msg", "");
                        int type2 = jo.optInt("type", 0);
                        String color2 = jo.optString("color", "");
                        Integer colorInt = null;
                        if (type2 == 1) {
                            colorInt = ResourceUtils.getColor((int)R.color.error_toast_bg);
                        } else if (type2 == 2) {
                            colorInt = ResourceUtils.getColor((int)R.color.warn_toast_bg);
                        } else if (type2 == 3) {
                            colorInt = ResourceUtils.getColor((int)R.color.normal_toast_bg);
                        } else if (!TextUtils.isEmpty((CharSequence)color2)) {
                            try {
                                colorInt = Color.parseColor((String)color2);
                            }
                            catch (Exception e) {
                                MLog.error((Object)"ToastJsEvent", (Throwable)e);
                            }
                        }
                        if (colorInt == null) {
                            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)msg, (int)0);
                        } else {
                            TopToastUtils.showToast((CharSequence)msg, (int)colorInt, (int)0, (int)10);
                        }
                    }
                    catch (JSONException e) {
                        if (callback == null) break block13;
                        BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"paramJson is illegal");
                        callback.callJs((IJsParam)err);
                    }
                }
            }
        });
    }
}

