/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.webbussiness.ui;

import android.content.Context;
import android.text.TextUtils;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.ablum_select.mulitablumselect.internal.entity.BasicMediaInfo;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.IOOSService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnCameraCallbak;
import com.yy.appbase.service.oos.IUploadObjectCallBack;
import com.yy.appbase.service.oos.UploadObjectRequest;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.image.compress.Luban;
import com.yy.base.image.compress.OnCompressListener;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.MD5Utils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.camera.base.ICameraService;
import com.yy.hiyo.camera.base.ablum_select.AlbumConfig;
import com.yy.hiyo.main.R;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

public class SelectPhotoPresenter {
    private DialogLinkManager mDialogLinkManager;
    private SelectPhotoCallback mSelectPhotoCallback;
    private int finQuality;
    private OnCameraCallbak mOnCameraCallbak = new OnCameraCallbak(){

        public void onBackPress() {
            if (SelectPhotoPresenter.this.mSelectPhotoCallback != null) {
                SelectPhotoPresenter.this.mSelectPhotoCallback.onFail(-6, "back press");
            }
        }

        public void onFinish(final String path) {
            if (TextUtils.isEmpty((CharSequence)path)) {
                if (SelectPhotoPresenter.this.mSelectPhotoCallback != null) {
                    SelectPhotoPresenter.this.mSelectPhotoCallback.onFail(-3, "path of image is empty, please makesure photo you select is valid");
                }
            } else {
                String lowerCasePath = path.toLowerCase();
                if (lowerCasePath.endsWith(".3gp") || lowerCasePath.endsWith(".mp4") || lowerCasePath.endsWith(".mkv")) {
                    ProgressDialog progressDialog = new ProgressDialog();
                    if (SelectPhotoPresenter.this.mDialogLinkManager != null) {
                        SelectPhotoPresenter.this.mDialogLinkManager.showDialog((BaseDialog)progressDialog);
                    }
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_video_report_upload, (int)0);
                    YYTaskExecutor.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            String fileName = SelectPhotoPresenter.this.getFileName("feedback/video/", path, ".mp4");
                            if (!FP.empty((CharSequence)fileName)) {
                                ((IOOSService)ServiceManagerProxy.getInstance().getService(IOOSService.class)).uploadFile(fileName, path, new IUploadObjectCallBack(){

                                    public void onSuccess(UploadObjectRequest request) {
                                        if (SelectPhotoPresenter.this.mDialogLinkManager != null) {
                                            SelectPhotoPresenter.this.mDialogLinkManager.dismissDialog();
                                        }
                                        MLog.info((Object)"SelectPhotoPresenter", (String)"\u4e0a\u4f20\u89c6\u9891:%s", (Object[])new Object[]{request.mUrl});
                                        if (SelectPhotoPresenter.this.mSelectPhotoCallback != null) {
                                            SelectPhotoPresenter.this.mSelectPhotoCallback.onSuccess(request.mUrl, path);
                                        }
                                    }

                                    public void onFailure(UploadObjectRequest request, int errorCode, Exception exception) {
                                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_video_report_fail, (int)0);
                                        if (SelectPhotoPresenter.this.mDialogLinkManager != null) {
                                            SelectPhotoPresenter.this.mDialogLinkManager.dismissDialog();
                                        }
                                        if (SelectPhotoPresenter.this.mSelectPhotoCallback != null) {
                                            SelectPhotoPresenter.this.mSelectPhotoCallback.onFail(-5, "Failed to upload, please try again");
                                        }
                                        MLog.info((Object)"SelectPhotoPresenter", (String)"\u4e0a\u4f20\u89c6\u9891\u5931\u8d25\uff0c\u9519\u8bef\u7801:%s, \u9519\u8bef:%s", (Object[])new Object[]{errorCode, exception});
                                    }
                                });
                            } else {
                                if (SelectPhotoPresenter.this.mDialogLinkManager != null) {
                                    SelectPhotoPresenter.this.mDialogLinkManager.dismissDialog();
                                }
                                if (SelectPhotoPresenter.this.mSelectPhotoCallback != null) {
                                    SelectPhotoPresenter.this.mSelectPhotoCallback.onFail(-4, "path of video is empty, please makesure photo you select is valid");
                                }
                            }
                        }
                    });
                } else {
                    SelectPhotoPresenter.this.processImagePathSafe(path, SelectPhotoPresenter.this.finQuality, SelectPhotoPresenter.this.mSelectPhotoCallback);
                }
            }
        }
    };

    public SelectPhotoPresenter(DialogLinkManager dialogLinkManager) {
        this.mDialogLinkManager = dialogLinkManager;
    }

    private String getFileName(String domain, String path, String defaultSuffix) {
        String md5 = "";
        try {
            File file = new File(path);
            if (file != null && file.length() > 0x3C00000L) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_video_report_too_large, (int)0);
                MLog.info((Object)"SelectPhotoPresenter", (String)"getFileName too large, size:%s", (Object[])new Object[]{file.length()});
                return md5;
            }
            md5 = YYFileUtils.getFileMD5String((File)file, (long)1000L);
            if (TextUtils.isEmpty((CharSequence)md5)) {
                md5 = AccountUtil.getUid() + "_" + MD5Utils.getMD5String((String)path) + "_" + System.currentTimeMillis();
            }
            int index = path.lastIndexOf(".");
            String suffix = defaultSuffix;
            if (index >= 0) {
                suffix = path.substring(index);
            }
            return domain + md5 + suffix;
        }
        catch (Exception e) {
            MLog.info((Object)"SelectPhotoPresenter", (String)"getFileName error:%s", (Object[])new Object[]{e.toString()});
            return md5;
        }
    }

    public void selectPhoto(final @NonNull String paramJson, final @Nullable SelectPhotoCallback callback) {
        if (!YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    SelectPhotoPresenter.this.selectPhotoAsync(paramJson, callback);
                }
            });
        } else {
            this.selectPhotoAsync(paramJson, callback);
        }
    }

    private void selectPhotoAsync(@NonNull String paramJson, @Nullable SelectPhotoCallback callback) {
        FeatureLog.i((String)"FTCustomerServiceBase", (String)"Js openCameraOrAlbum and param: %s", (Object[])new Object[]{paramJson});
        int type2 = 0;
        int quality = 100;
        try {
            JSONObject jo = JsonParser.obtainJSONObject((String)paramJson);
            type2 = jo.optInt("type");
            quality = jo.optInt("quality");
        }
        catch (Exception e) {
            MLog.error((Object)"FTCustomerServiceBase", (Throwable)e);
            if (callback != null) {
                callback.onFail(-1, "illegal param");
            }
            return;
        }
        this.finQuality = quality <= 0 ? 100 : quality;
        this.mSelectPhotoCallback = callback;
        if (type2 == 2) {
            FeatureLog.i((String)"FTCustomerServiceBase", (String)"Js openCameraOrAlbum and type: %d", (Object[])new Object[]{2});
            ((ICameraService)ServiceManagerProxy.getServiceManager().getService(ICameraService.class)).takePhoto("FTCustomerServiceBase", this.mOnCameraCallbak);
        } else if (type2 == 3) {
            FeatureLog.i((String)"FTCustomerServiceBase", (String)"Js openCameraOrAlbum and type: %d", (Object[])new Object[]{3});
            ((ICameraService)ServiceManagerProxy.getServiceManager().getService(ICameraService.class)).chooseFromGallery("FTCustomerServiceBase", 3, 0, this.mOnCameraCallbak);
        } else if (type2 == 4) {
            FeatureLog.i((String)"FTCustomerServiceBase", (String)"Js openCameraOrAlbum and type: %d", (Object[])new Object[]{4});
            this.openVideoAlbum(1);
        } else if (type2 == 5) {
            FeatureLog.i((String)"FTCustomerServiceBase", (String)"Js openCameraOrAlbum and type: %d", (Object[])new Object[]{5});
            this.openVideoAlbum(3);
        } else if (callback != null) {
            callback.onFail(-1, "illegal param");
        }
    }

    private void openVideoAlbum(int type2) {
        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_video_select_too_large, (int)0);
        AlbumConfig config = new AlbumConfig();
        config.maxCount = 1;
        config.type = type2;
        config.styleType = 4;
        config.mMediaMode = 4;
        ((ICameraService)ServiceManagerProxy.getServiceManager().getService(ICameraService.class)).chooseFromGallery("FTCustomerServiceBase", 6, config, this.mOnCameraCallbak);
    }

    private void processImagePathSafe(String path, int quality, @Nullable SelectPhotoCallback callback) {
        block2: {
            try {
                this.processImagePath(path, quality, callback);
            }
            catch (Exception e) {
                MLog.error((Object)"FTCustomerServiceBase", (Throwable)e);
                if (callback == null) break block2;
                callback.onFail(-2, "compress image fail,error msg: " + e.getMessage());
            }
        }
    }

    private void processImagePath(String path, int quality, final @Nullable SelectPhotoCallback callback) {
        File temp = YYFileUtils.getTempFile((Context)RuntimeContext.sApplicationContext, (String)"");
        String tempPath = temp.getPath();
        Luban.with((Context)RuntimeContext.sApplicationContext).load(path).ignoreBy(quality).setTargetDir(tempPath).filter(path1 -> !TextUtils.isEmpty((CharSequence)path1) && !path1.toLowerCase().endsWith(".gif")).setCompressListener(new OnCompressListener(){

            public void onStart() {
            }

            public void onSuccess(File file) {
                String filePath = file.getAbsolutePath();
                String base64 = SelectPhotoPresenter.imageToBase64(filePath);
                if (callback != null) {
                    callback.onSuccess(base64, filePath);
                }
            }

            public void onError(Throwable e) {
                MLog.error((Object)"FTCustomerServiceBase", (Throwable)e);
                if (callback != null) {
                    callback.onFail(-2, "compress image fail,error msg: " + e.getMessage());
                }
            }

            public void onPatchCompressFinish(CopyOnWriteArrayList<BasicMediaInfo> photos) {
            }
        }).launch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String imageToBase64(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        FileInputStream is = null;
        byte[] data = null;
        String result = null;
        try {
            is = new FileInputStream(path);
            data = new byte[((InputStream)is).available()];
            ((InputStream)is).read(data);
            result = Base64.encodeToString((byte[])data, (int)0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != is) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static interface SelectPhotoCallback {
        public void onSuccess(String var1, String var2);

        public void onFail(int var1, String var2);
    }
}

