/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.webbussiness.ui;

import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.logger.MLog;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.MsgDispatcher;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.IJsEventCallback;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsMethod;
import com.yy.webservice.event.parqam.BaseJsParam;
import com.yy.webservice.event.parqam.IJsParam;
import org.json.JSONObject;

public class OpenRechargeDialogJsEvent
implements JsEvent {
    private static final String TAG = "OpenRechargeDialogJsEvent";

    @NonNull
    public JsMethod method() {
        return JsEventDefine.UI.openRechargeDialog;
    }

    public void jsCall(@NonNull IWebBusinessHandler webHandler, @NonNull String param, @Nullable IJsEventCallback callback) {
        if (TextUtils.isEmpty((CharSequence)param)) {
            MLog.error((Object)TAG, (String)"param is empty", (Object[])new Object[0]);
            this.callbackErr(callback, 0, "paramJson is null");
            return;
        }
        String roomId = "";
        String actId = "";
        String pageId = "";
        int activityType = 0;
        boolean onlyNativeRecharge = false;
        try {
            JSONObject jsonObject = JsonParser.obtainJSONObject((String)param);
            roomId = jsonObject.optString("roomId");
            activityType = jsonObject.optInt("activityType");
            onlyNativeRecharge = jsonObject.optBoolean("onlyNativeRecharge");
            actId = jsonObject.optString("actId");
            pageId = jsonObject.optString("pageId");
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"json\u89e3\u6790\u5f02\u5e38", (Object[])new Object[0]);
        }
        this.openRechargeDialog(roomId, activityType, onlyNativeRecharge, actId, pageId, callback);
    }

    public void openRechargeDialog(String roomId, int activityType, boolean onlyNativeRecharge, String actId, String pageId, @Nullable IJsEventCallback callback) {
        Message msg = Message.obtain();
        Bundle bundle = new Bundle();
        bundle.putString("roomId", roomId);
        bundle.putInt("fromType", 1000);
        bundle.putInt("recharge_dialog_act_type", activityType);
        bundle.putBoolean("onlyNativeRecharge", onlyNativeRecharge);
        bundle.putString("actId", actId);
        bundle.putString("pageId", pageId);
        msg.setData(bundle);
        msg.what = AppbaseMsgDef.SHOW_RECHARGE_DIALOG;
        MsgDispatcher.getInstance().sendMessage(msg);
        if (callback != null) {
            callback.callJs((IJsParam)BaseJsParam.successParam((String)"open recharge dialog successfully"));
        }
    }

    private void callbackErr(@Nullable IJsEventCallback callback, int code, String msg) {
        if (callback != null) {
            BaseJsParam err = BaseJsParam.errorParam((int)code, (String)msg);
            callback.callJs((IJsParam)err);
        }
    }
}

