/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.webbussiness.base;

import android.content.SharedPreferences;
import android.text.TextUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SharedPreferencesUtils;

public class WebStorage {
    private static SharedPreferences mStorageSP;

    public static void setStorage(String key, String value) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)value)) {
            WebStorage.getStorageSP().edit().remove(key).apply();
            return;
        }
        WebStorage.getStorageSP().edit().putString(key, value).apply();
        if (SettingFlags.containKey((String)key)) {
            SettingFlags.removeKey((String)key);
        }
    }

    public static String getStorage(String key) {
        return WebStorage.getStorage(key, "");
    }

    public static String getStorage(String key, String defaultValue) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return defaultValue;
        }
        if (SettingFlags.containKey((String)key)) {
            String value = SettingFlags.getStringValue((String)key);
            WebStorage.setStorage(key, value);
            return value;
        }
        return WebStorage.getStorageSP().getString(key, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SharedPreferences getStorageSP() {
        if (mStorageSP != null) return mStorageSP;
        Class<WebStorage> clazz = WebStorage.class;
        synchronized (WebStorage.class) {
            if (mStorageSP != null) return mStorageSP;
            mStorageSP = SharedPreferencesUtils.INSTANCE.getSharedPreferences(RuntimeContext.sApplicationContext, "webstoragesp", 0);
            // ** MonitorExit[var0] (shouldn't be in output)
            return mStorageSP;
        }
    }
}

