/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.webbussiness.base;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.web.JsEventControllerCallback;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.json.JsonParser;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.IJsEventCallback;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsMethod;
import com.yy.webservice.event.parqam.BaseJsParam;
import com.yy.webservice.event.parqam.IJsParam;

public class OpenScanJsEvent
implements JsEvent {
    private final JsEventControllerCallback mControllerCallback;
    private IJsEventCallback mJsCallback;

    public OpenScanJsEvent(@NonNull JsEventControllerCallback callback) {
        this.mControllerCallback = callback;
    }

    @NonNull
    public JsMethod method() {
        return JsEventDefine.BASE.openScan;
    }

    public void jsCall(@NonNull IWebBusinessHandler webHandler, final @NonNull String param, final @Nullable IJsEventCallback callback) {
        if (TextUtils.isEmpty((CharSequence)param)) {
            FeatureLog.e((String)"FTScan", (String)"param is empty", (Object[])new Object[0]);
            if (callback != null) {
                BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"paramJson is null");
                callback.callJs((IJsParam)err);
            }
            return;
        }
        this.mJsCallback = callback;
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                OpenScanJsEvent.this.openScanView(param, callback);
            }
        });
    }

    private void openScanView(String paramJson, IJsEventCallback callback) {
        OpenScanParam param = (OpenScanParam)JsonParser.parseJsonObject((String)paramJson, OpenScanParam.class);
        if (param == null) {
            BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"paramJson is not right");
            if (callback != null) {
                callback.callJs((IJsParam)err);
            }
            FeatureLog.i((String)"FTScan", (String)"openScanView error, code:%s, msg:%s", (Object[])new Object[]{err.code, err.msg});
            return;
        }
        BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"ScanView not found");
        if (callback != null) {
            callback.callJs((IJsParam)err);
        }
    }

    @DontProguardClass
    static class OpenScanParam {
        String tips;

        OpenScanParam() {
        }
    }
}

