/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.webbussiness.base;

import android.os.Message;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.web.JsEventControllerCallback;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.user.base.UserMsgDef;
import com.yy.hiyo.user.base.profilesource.ProfileReportBean;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.IJsEventCallback;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsMethod;
import com.yy.webservice.event.parqam.BaseJsParam;
import com.yy.webservice.event.parqam.IJsParam;
import org.json.JSONException;
import org.json.JSONObject;

class OpenProfileJsEvent
implements JsEvent {
    private static final String TAG = "OpenProfileJsEvent";
    private final JsEventControllerCallback mControllerCallback;

    OpenProfileJsEvent(@NonNull JsEventControllerCallback callback) {
        this.mControllerCallback = callback;
    }

    @NonNull
    public JsMethod method() {
        return JsEventDefine.BASE.openProfile;
    }

    public void jsCall(@NonNull IWebBusinessHandler webHandler, final @NonNull String param, final @Nullable IJsEventCallback callback) {
        if (TextUtils.isEmpty((CharSequence)param)) {
            MLog.error((Object)TAG, (String)"param is empty", (Object[])new Object[0]);
            if (callback != null) {
                BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"paramJson is null");
                callback.callJs((IJsParam)err);
            }
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                OpenProfileJsEvent.this.openProfile(param, callback);
            }
        });
    }

    private void openProfile(@NonNull String paramJson, @Nullable IJsEventCallback callback) {
        block6: {
            try {
                JSONObject jo = JsonParser.obtainJSONObject((String)paramJson);
                final long uid = jo.optLong("uid");
                final int from = jo.optInt("fromType");
                if (uid <= 0L) {
                    if (callback != null) {
                        BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"paramJson is illegal");
                        callback.callJs((IJsParam)err);
                    }
                } else {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MLog.info((Object)OpenProfileJsEvent.TAG, (String)"open profile window:%s", (Object[])new Object[]{String.valueOf(uid)});
                            Message msg = Message.obtain();
                            ProfileReportBean bean = new ProfileReportBean();
                            bean.setUid(Long.valueOf(uid));
                            bean.setShowSource(Integer.valueOf(ProfileReportBean.ShowSource.getActivity()));
                            bean.setActId(from + "");
                            msg.what = UserMsgDef.OPEN_WINDOW_NEW_PROFILE;
                            msg.obj = bean;
                            msg.arg1 = from == 8 ? 12 : 0;
                            OpenProfileJsEvent.this.mControllerCallback.sendMsg(msg);
                        }
                    });
                    if (callback != null) {
                        BaseJsParam re = BaseJsParam.codeParam((int)1, (String)"go to profile success");
                        callback.callJs((IJsParam)re);
                    }
                }
            }
            catch (JSONException e) {
                if (callback == null) break block6;
                BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"paramJson is illegal");
                callback.callJs((IJsParam)err);
            }
        }
    }
}

