/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.webbussiness.base;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.yy.appbase.web.JsEventControllerCallback;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.IJsEventCallback;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsMethod;
import com.yy.webservice.event.parqam.BaseJsParam;
import com.yy.webservice.event.parqam.IJsParam;

class GameIsInstallJsEvent
implements JsEvent {
    private static final String TAG = "GameIsInstallJsEvent";
    private static final int START_GAME_VALID = 1;
    private static final int START_GAME_UNDOWNLOAD = 2;
    private static final int START_GAME_UNFOUND = 3;
    private final JsEventControllerCallback mControllerCallback;

    GameIsInstallJsEvent(@NonNull JsEventControllerCallback callback) {
        this.mControllerCallback = callback;
    }

    @NonNull
    public JsMethod method() {
        return JsEventDefine.BASE.isGameInstalled;
    }

    public void jsCall(@NonNull IWebBusinessHandler webHandler, final @NonNull String param, final @Nullable IJsEventCallback callback) {
        if (TextUtils.isEmpty((CharSequence)param)) {
            MLog.error((Object)TAG, (String)"param is empty", (Object[])new Object[0]);
            if (callback != null) {
                BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"paramJson is null");
                callback.callJs((IJsParam)err);
            }
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                GameIsInstallJsEvent.this.isGameValid(param, callback);
            }
        });
    }

    private void isGameValid(@NonNull String paramJson, @Nullable IJsEventCallback callback) {
        GameParam param = (GameParam)JsonParser.parseJsonObject((String)paramJson, GameParam.class);
        if (param != null) {
            GameInfo info = ((IGameInfoService)this.mControllerCallback.getService().getService(IGameInfoService.class)).getGameInfoByGid(param.gameId);
            if (info == null) {
                this.resultCallback(callback, param.gameId, param.activityId, 3);
                return;
            }
            boolean isInstalled = ((IGameService)this.mControllerCallback.getService().getService(IGameService.class)).isGameValid(info);
            if (isInstalled) {
                this.resultCallback(callback, param.gameId, param.activityId, 1);
            } else {
                this.resultCallback(callback, param.gameId, param.activityId, 2);
            }
        } else if (callback != null) {
            BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"paramJson is illegal");
            callback.callJs((IJsParam)err);
        }
    }

    private void resultCallback(@Nullable IJsEventCallback callback, String gameId, String activityId, int result) {
        if (callback != null) {
            BaseJsParam.DataBuilder builder = BaseJsParam.builder().put("gameId", (Object)gameId).put("result", (Object)result).put("gameInstalled", (Object)(1 == result ? 1 : 0));
            if (!TextUtils.isEmpty((CharSequence)activityId)) {
                builder.put("activityId", (Object)activityId);
            }
            BaseJsParam param = builder.build();
            callback.callJs((IJsParam)param);
        }
    }

    static class GameParam {
        @SerializedName(value="gameId")
        String gameId = "";
        @SerializedName(value="gameModel")
        int gameModel;
        @SerializedName(value="activityId")
        String activityId = "";

        GameParam() {
        }
    }
}

