/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.unifyconfig;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.envsetting.EnvSettingType;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.http.SimpleNetStringRespCallback;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.IConfigListener;
import com.yy.appbase.unifyconfig.IUnifyHandler;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.AIDenoiseConfig;
import com.yy.appbase.unifyconfig.config.ARBeautyFilterConfig;
import com.yy.appbase.unifyconfig.config.AVSyncConfig;
import com.yy.appbase.unifyconfig.config.AccountAsyncConfig;
import com.yy.appbase.unifyconfig.config.AdConfig;
import com.yy.appbase.unifyconfig.config.AgeRestrainConfig;
import com.yy.appbase.unifyconfig.config.AmongUsConfig;
import com.yy.appbase.unifyconfig.config.AnchorLevelConfig;
import com.yy.appbase.unifyconfig.config.AssistGameAutoDownloadConfig;
import com.yy.appbase.unifyconfig.config.AssistGameBtnConfig;
import com.yy.appbase.unifyconfig.config.AssistGameFollowConfig;
import com.yy.appbase.unifyconfig.config.AssistGameJoinInviteConfig;
import com.yy.appbase.unifyconfig.config.AtFansCountConfig;
import com.yy.appbase.unifyconfig.config.AudioRecordConfig;
import com.yy.appbase.unifyconfig.config.AutoInviteMicUpConfig;
import com.yy.appbase.unifyconfig.config.BackupHostConfig;
import com.yy.appbase.unifyconfig.config.BaseRoomStatusConfig;
import com.yy.appbase.unifyconfig.config.BasicGroupEnterConfig;
import com.yy.appbase.unifyconfig.config.BbsAggTagPageConfig;
import com.yy.appbase.unifyconfig.config.BbsPostConfig;
import com.yy.appbase.unifyconfig.config.BbsShareConfig;
import com.yy.appbase.unifyconfig.config.BeautyFilterConfig;
import com.yy.appbase.unifyconfig.config.BeautyIntensityConfig;
import com.yy.appbase.unifyconfig.config.BirthdayRegConfig;
import com.yy.appbase.unifyconfig.config.BossBBSConfig;
import com.yy.appbase.unifyconfig.config.BossDelayParseConfig;
import com.yy.appbase.unifyconfig.config.ChannelAlphaVideoConfig;
import com.yy.appbase.unifyconfig.config.ChannelDeleteShowConfig;
import com.yy.appbase.unifyconfig.config.ChannelFollowGuideConfig;
import com.yy.appbase.unifyconfig.config.ChannelJumpBackConfig;
import com.yy.appbase.unifyconfig.config.ChannelListTopTabConfig;
import com.yy.appbase.unifyconfig.config.ChannelNearbyPeopleMsgConfig;
import com.yy.appbase.unifyconfig.config.ChannelNoCustomCameraCpuConfig;
import com.yy.appbase.unifyconfig.config.ChannelOfCrashDevicesConfig;
import com.yy.appbase.unifyconfig.config.ChannelPushConfig;
import com.yy.appbase.unifyconfig.config.ChannelRadioCatonCodeRateConfig;
import com.yy.appbase.unifyconfig.config.ChannelRtcTransConfig;
import com.yy.appbase.unifyconfig.config.ChannelTabConfig;
import com.yy.appbase.unifyconfig.config.ChannelTeamUpDDLConfig;
import com.yy.appbase.unifyconfig.config.ChannelTeamUpGameAuthorityConfig;
import com.yy.appbase.unifyconfig.config.ChannelTeamUpGameFloatWinConfig;
import com.yy.appbase.unifyconfig.config.ChannelTitleBgConfig;
import com.yy.appbase.unifyconfig.config.ChannelToolsConfig;
import com.yy.appbase.unifyconfig.config.ChannelZombieAccountConfig;
import com.yy.appbase.unifyconfig.config.CharmValueJumpConfig;
import com.yy.appbase.unifyconfig.config.ChatSwipeConfig;
import com.yy.appbase.unifyconfig.config.CommonConfig;
import com.yy.appbase.unifyconfig.config.ContributionCharismaJumpConfig;
import com.yy.appbase.unifyconfig.config.CrashProtectConfig;
import com.yy.appbase.unifyconfig.config.CrawlerGroupThemeConfig;
import com.yy.appbase.unifyconfig.config.CreateChannelPartyConfig;
import com.yy.appbase.unifyconfig.config.CrossRegionConfig;
import com.yy.appbase.unifyconfig.config.CustomerServiceDomainConfig;
import com.yy.appbase.unifyconfig.config.DPJumpOptConfig;
import com.yy.appbase.unifyconfig.config.DeeplinkConfig;
import com.yy.appbase.unifyconfig.config.DefaultIPConfig;
import com.yy.appbase.unifyconfig.config.DirectRenderToSurfaceBlackConfig;
import com.yy.appbase.unifyconfig.config.EmoticonConfig;
import com.yy.appbase.unifyconfig.config.EndPageConfig;
import com.yy.appbase.unifyconfig.config.EnterRoomSourceConfig;
import com.yy.appbase.unifyconfig.config.ExitFollowGuideConfig;
import com.yy.appbase.unifyconfig.config.FamilyChatBgConfig;
import com.yy.appbase.unifyconfig.config.FindFriendBroadcastConfig;
import com.yy.appbase.unifyconfig.config.FlagSwitchConfig;
import com.yy.appbase.unifyconfig.config.FollowMostActiveLiveNotifyConfig;
import com.yy.appbase.unifyconfig.config.FollowerSourceConfig;
import com.yy.appbase.unifyconfig.config.GameGroupThemeMapConfig;
import com.yy.appbase.unifyconfig.config.GameLoadingTipsConfig;
import com.yy.appbase.unifyconfig.config.GameTopVideoConfig;
import com.yy.appbase.unifyconfig.config.GlobalNationConfig;
import com.yy.appbase.unifyconfig.config.GroupChatClassificationConfig;
import com.yy.appbase.unifyconfig.config.GroupInviteListContactEntranceConfig;
import com.yy.appbase.unifyconfig.config.GroupOptCompatConfig;
import com.yy.appbase.unifyconfig.config.GroupToolsPlugInConfig;
import com.yy.appbase.unifyconfig.config.GroupVideoMsgConfig;
import com.yy.appbase.unifyconfig.config.GrowthBusinessConfig;
import com.yy.appbase.unifyconfig.config.GrowthConfig;
import com.yy.appbase.unifyconfig.config.GuestLoginDeeplinkConfig;
import com.yy.appbase.unifyconfig.config.HagoCdnConfig;
import com.yy.appbase.unifyconfig.config.HiidoActFilterConfig;
import com.yy.appbase.unifyconfig.config.HiidoEventFilterConfig;
import com.yy.appbase.unifyconfig.config.HomeConfigBoss;
import com.yy.appbase.unifyconfig.config.HomePlanConfig;
import com.yy.appbase.unifyconfig.config.HomePushViewConfig;
import com.yy.appbase.unifyconfig.config.HomeScrollTopConfig;
import com.yy.appbase.unifyconfig.config.HomeTownConfig;
import com.yy.appbase.unifyconfig.config.HostPreConnectConfig;
import com.yy.appbase.unifyconfig.config.HyperLinkConfig;
import com.yy.appbase.unifyconfig.config.IMContentConfig;
import com.yy.appbase.unifyconfig.config.IMDragGuideConfig;
import com.yy.appbase.unifyconfig.config.IMRevokeConfig;
import com.yy.appbase.unifyconfig.config.IMSocialRoomRecommendConfig;
import com.yy.appbase.unifyconfig.config.ImChatSessionRecommendConfig;
import com.yy.appbase.unifyconfig.config.ImCommonPushConfig;
import com.yy.appbase.unifyconfig.config.ImGameMsgContentConfig;
import com.yy.appbase.unifyconfig.config.ImMoreOptionConfig;
import com.yy.appbase.unifyconfig.config.ImRecomChannelConfig;
import com.yy.appbase.unifyconfig.config.IntentFilterConfig;
import com.yy.appbase.unifyconfig.config.KtvAudioEffectConfig;
import com.yy.appbase.unifyconfig.config.KtvGiftConfig;
import com.yy.appbase.unifyconfig.config.KtvVideoCodeRateConfig;
import com.yy.appbase.unifyconfig.config.KtvWorksEntranceConfig;
import com.yy.appbase.unifyconfig.config.LogOptimizationConfig;
import com.yy.appbase.unifyconfig.config.LoginTypeConfigData;
import com.yy.appbase.unifyconfig.config.LoopMicFollowConfig;
import com.yy.appbase.unifyconfig.config.LoopMicLabelConfig;
import com.yy.appbase.unifyconfig.config.MetricReportSampleConfig;
import com.yy.appbase.unifyconfig.config.MinePageFamilyEntryConfig;
import com.yy.appbase.unifyconfig.config.MultiVideoEnableBufferDevicesConfig;
import com.yy.appbase.unifyconfig.config.MultiVideoGuideConfig;
import com.yy.appbase.unifyconfig.config.MultiVideoLightConfig;
import com.yy.appbase.unifyconfig.config.MultiVideoTipConfig;
import com.yy.appbase.unifyconfig.config.NTProductConfig;
import com.yy.appbase.unifyconfig.config.NetPreventDuplicateConfig;
import com.yy.appbase.unifyconfig.config.NetworkConfig;
import com.yy.appbase.unifyconfig.config.NoPostBtnConfig;
import com.yy.appbase.unifyconfig.config.NoSocialGuideConfig;
import com.yy.appbase.unifyconfig.config.NotifyFrequencyConfig;
import com.yy.appbase.unifyconfig.config.OnLineFriendsNumConfig;
import com.yy.appbase.unifyconfig.config.OssConfig;
import com.yy.appbase.unifyconfig.config.PackageChannelDeepLinkConfig;
import com.yy.appbase.unifyconfig.config.PageChangeReportConfig;
import com.yy.appbase.unifyconfig.config.PartyFeedbackEntryConfig;
import com.yy.appbase.unifyconfig.config.PartyPageListConfig;
import com.yy.appbase.unifyconfig.config.PeopleEnterRoomTipConfig;
import com.yy.appbase.unifyconfig.config.PerformanceConfigData;
import com.yy.appbase.unifyconfig.config.PkPointLuckBagConfig;
import com.yy.appbase.unifyconfig.config.PkPunishTextConfig;
import com.yy.appbase.unifyconfig.config.PostVideoDetailConfig;
import com.yy.appbase.unifyconfig.config.PostWaringConfig;
import com.yy.appbase.unifyconfig.config.PreResolveHostConfig;
import com.yy.appbase.unifyconfig.config.ProfileCardGiftEntryConfig;
import com.yy.appbase.unifyconfig.config.ProfileInfoPageConfig;
import com.yy.appbase.unifyconfig.config.ProfileLabelConfig;
import com.yy.appbase.unifyconfig.config.ProfilePersonSignLines;
import com.yy.appbase.unifyconfig.config.PublicScreenScrollTestConfig;
import com.yy.appbase.unifyconfig.config.PushControlBossConfig;
import com.yy.appbase.unifyconfig.config.RadioEnableConfig;
import com.yy.appbase.unifyconfig.config.RadioListGuideBlackDevicesConfig;
import com.yy.appbase.unifyconfig.config.RadioLiveConfig;
import com.yy.appbase.unifyconfig.config.RadioShowEndPageConfig;
import com.yy.appbase.unifyconfig.config.RamadanConfig;
import com.yy.appbase.unifyconfig.config.RandomAvatarConfig;
import com.yy.appbase.unifyconfig.config.RechargeRiskTipsConfig;
import com.yy.appbase.unifyconfig.config.RechargeTipsConfig;
import com.yy.appbase.unifyconfig.config.RecommendGameConfig;
import com.yy.appbase.unifyconfig.config.ReminderPartyGuideConfig;
import com.yy.appbase.unifyconfig.config.RevenueDomainConfig;
import com.yy.appbase.unifyconfig.config.RiskTipsConfig;
import com.yy.appbase.unifyconfig.config.RoomGameMatchFloatButtonConfig;
import com.yy.appbase.unifyconfig.config.RoomListQucikJoinConfig;
import com.yy.appbase.unifyconfig.config.RoomRolePermissionConfig;
import com.yy.appbase.unifyconfig.config.RoomThemeConfig;
import com.yy.appbase.unifyconfig.config.RpcReportSampleConfig;
import com.yy.appbase.unifyconfig.config.ScenePerformanceOptConfig;
import com.yy.appbase.unifyconfig.config.ShareChannelConfig;
import com.yy.appbase.unifyconfig.config.ShareConfig;
import com.yy.appbase.unifyconfig.config.ShareGuideTimeConfig;
import com.yy.appbase.unifyconfig.config.ShareTeamUpConfig;
import com.yy.appbase.unifyconfig.config.SocialMatchConfig;
import com.yy.appbase.unifyconfig.config.SwordConfig;
import com.yy.appbase.unifyconfig.config.TeamGameConfigData;
import com.yy.appbase.unifyconfig.config.TeamGameMatchMsgsConfig;
import com.yy.appbase.unifyconfig.config.TeamMatchGameGroupThemeConfig;
import com.yy.appbase.unifyconfig.config.TeamMultiGameConfigData;
import com.yy.appbase.unifyconfig.config.TeamUpGameFollowTimeShowConfig;
import com.yy.appbase.unifyconfig.config.TeamUpGameRoomElementConfig;
import com.yy.appbase.unifyconfig.config.TeamUpMatchConfig;
import com.yy.appbase.unifyconfig.config.TeamUpMatchWinConfig;
import com.yy.appbase.unifyconfig.config.TextureConfig;
import com.yy.appbase.unifyconfig.config.TodayListDataConfig;
import com.yy.appbase.unifyconfig.config.TranslateGuideConfig;
import com.yy.appbase.unifyconfig.config.TryCatchSwitchConfig;
import com.yy.appbase.unifyconfig.config.UidBelongServiceConfig;
import com.yy.appbase.unifyconfig.config.UserNationFlagConfig;
import com.yy.appbase.unifyconfig.config.VideoPkConfig;
import com.yy.appbase.unifyconfig.config.VietnamInviteFriendConfig;
import com.yy.appbase.unifyconfig.config.VoiceFilterConfig;
import com.yy.appbase.unifyconfig.config.VoiceRoomBillboardTipConfig;
import com.yy.appbase.unifyconfig.config.VoiceRoomCalculatorConfig;
import com.yy.appbase.unifyconfig.config.VoiceRoomFollowConfig;
import com.yy.appbase.unifyconfig.config.VoiceRoomPublicScreenConfig;
import com.yy.appbase.unifyconfig.config.VoiceRoomShareConfig;
import com.yy.appbase.unifyconfig.config.VoiceRoomShareStrategyTipConfig;
import com.yy.appbase.unifyconfig.config.VoiceRoomTagConfig;
import com.yy.appbase.unifyconfig.config.WebViewLayerConfig;
import com.yy.appbase.unifyconfig.config.WsHttpDispatcherConfig;
import com.yy.appbase.unifyconfig.config.YouTubeShareConfig;
import com.yy.appbase.unifyconfig.config.data.AfAndFirebaseStatConfig;
import com.yy.appbase.unifyconfig.config.data.PartyGameConfig;
import com.yy.appbase.unifyconfig.config.data.ThreadOptConfig;
import com.yy.appbase.unifyconfig.config.taskopt.TaskOptConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.CountryCodeUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.app.perf.PushHostNameConfig;
import com.yy.hiyo.channel.base.bean.ChannelConfigParse;
import com.yy.hiyo.channel.base.bean.InnerPkConfig;
import com.yy.hiyo.channel.base.bean.VoiceRoomPkConfig;
import com.yy.hiyo.channel.base.config.VideoCoverSupportBlackConfig;
import com.yy.hiyo.game.base.config.CommemorativeCoinConfig;
import com.yy.hiyo.game.base.config.FavorGameConfig;
import com.yy.hiyo.game.base.config.GameCommonConfig;
import com.yy.hiyo.game.base.config.GameCrashBlackConfig;
import com.yy.hiyo.game.base.config.GameEmojiConfig;
import com.yy.hiyo.game.base.config.GamePublicConfig;
import com.yy.hiyo.game.base.config.GameShareConfig;
import com.yy.hiyo.game.base.config.GameShortCutConfig;
import com.yy.hiyo.game.base.config.GameWebSockectConfig;
import com.yy.hiyo.game.base.config.GangupInviteConfig;
import com.yy.hiyo.game.base.config.NotchBlackConfig;
import com.yy.hiyo.game.base.config.TranslucentBarBlackConfig;
import com.yy.hiyo.game.base.config.WebPreloadConfig;
import com.yy.hiyo.home.base.randomgame.RandomGameConfig;
import com.yy.hiyo.module.unifyconfig.UnifyDefaultConfigProcess;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.Call;
import org.json.JSONObject;

public class UnifyConfigController
extends DefaultController
implements IUnifyHandler {
    private static final String TAG = "UnifyConfigController";
    private static final Object FILE_LOCK = new Object();
    private static final String KEY_BSS_REQUEST_REGION = "bss_code_request_region";
    private static final int RETRY_MAX = 3;
    private static final long RETRY_DELAY = 500L;
    private static final Map<BssCode, Class<? extends AConfigData>> gBasDataSet = new LinkedHashMap<BssCode, Class<? extends AConfigData>>();
    private final ConcurrentHashMap<String, AConfigData> mConfigs = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, List<IConfigListener<? extends AConfigData>>> mConfigListeners = new ConcurrentHashMap();
    private final AtomicBoolean mHasRequest = new AtomicBoolean(false);
    private final AtomicBoolean mRequesting = new AtomicBoolean(false);
    private final AtomicBoolean mRequestResult = new AtomicBoolean(true);
    private int mRetryTimes = 0;
    private String mLastRequestRegion = null;
    private final Map<String, Integer> mBssParam = new ConcurrentHashMap<String, Integer>();
    private final IQueueTaskExecutor mQueueTaskExecutor = YYTaskExecutor.createAQueueExcuter();
    private final CountDownLatch mWaitLocal = new CountDownLatch(1);

    public UnifyConfigController(Environment env) {
        super(env);
        this.init();
    }

    private void init() {
        UnifyConfig.INSTANCE.initController((IUnifyHandler)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_LOGIN_OUT, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_NETWORK_STATE_CHANGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED_AFTER_3_SECONDS, (INotify)this);
        this.checkReadLocalConfig();
        if (AccountUtil.getUid() <= 0L || RuntimeContext.sIsCrashedInLastRun) {
            this.requestAllConfig();
        }
    }

    public void notify(Notification notification) {
        if (notification.id == NotificationDef.N_LOGIN_LOGIN_OUT) {
            MLog.info((Object)TAG, (String)"logout success", (Object[])new Object[0]);
        } else if (notification.id == NotificationDef.N_NETWORK_STATE_CHANGE) {
            if (NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                MLog.info((Object)TAG, (String)"network available change", (Object[])new Object[0]);
                if (!this.mRequestResult.get()) {
                    this.mRetryTimes = 0;
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            UnifyConfigController.this.requestAllConfig();
                        }
                    }, (long)500L);
                }
            }
        } else if (notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_3_SECONDS) {
            MLog.info((Object)TAG, (String)"start up finish after 3 seconds", (Object[])new Object[0]);
            this.checkRequest();
        }
    }

    private void checkRequest() {
        if (!this.mHasRequest.get()) {
            this.requestAllConfig();
        }
    }

    private void requestAllConfig() {
        this.checkCanRequestConfig(UnifyConfig.INSTANCE.getRequestBssCode(), true);
    }

    public void requestConfigData(@NonNull BssCode key) {
        MLog.info((Object)TAG, (String)("request config: " + key.code()), (Object[])new Object[0]);
        this.checkCanRequestConfig(Collections.singletonList(key), false);
    }

    public void requestConfigData(@NonNull List<BssCode> keyList) {
        MLog.info((Object)TAG, (String)("request config: " + keyList), (Object[])new Object[0]);
        this.checkCanRequestConfig(keyList, false);
    }

    private void checkCanRequestConfig(final @Nullable List<BssCode> keyList, final boolean toRequestAll) {
        if (!NetworkUtils.isNetworkAvailable((Context)this.mContext)) {
            MLog.debug((Object)TAG, (String)"checkCanRequestConfig fail, network is not available", (Object[])new Object[0]);
            if (toRequestAll) {
                this.mRequestResult.set(false);
            }
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                UnifyConfigController.this.requestConfigDataInner(keyList, toRequestAll);
            }
        });
    }

    private void requestConfigDataInner(final @Nullable List<BssCode> keyList, final boolean toRequestAll) {
        if (this.mRequesting.get()) {
            MLog.debug((Object)TAG, (String)"requestConfigDataInner ignore, is requesting", (Object[])new Object[0]);
            return;
        }
        String url = this.getBssRequestUrl();
        if (StringUtils.isEmpty((String)url)) {
            MLog.warn((Object)TAG, (String)"requestConfigData fail, url is null", (Object[])new Object[0]);
            return;
        }
        if (toRequestAll) {
            this.mHasRequest.set(true);
            this.mRequesting.set(true);
        }
        final ArrayList<String> cmdList = new ArrayList<String>(1);
        HashMap<String, String> param = new HashMap<String, String>(1);
        this.getBssRequestParam(keyList, param, cmdList);
        MLog.info((Object)TAG, (String)"requestConfigData url: %s, param: %s", (Object[])new Object[]{url, param});
        final long reqTime = SystemClock.uptimeMillis();
        HttpUtil.post().url(url).param(param).header(this.getHeaders()).execute((INetRespCallback)new SimpleNetStringRespCallback("requestConfig"){

            public void onError(Call call, Exception e, int id2) {
                super.onError(call, e, id2);
                if (toRequestAll) {
                    UnifyConfigController.this.mRequestResult.set(false);
                    UnifyConfigController.this.mRequesting.set(false);
                    UnifyConfigController.this.mRetryTimes++;
                    if (UnifyConfigController.this.mRetryTimes <= 3) {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                UnifyConfigController.this.requestAllConfig();
                            }
                        }, (long)500L);
                    }
                }
                for (String cmd : cmdList) {
                    HiidoStatis.reportAppMonitorReturnCode((String)("bossconfig/" + cmd), (long)(SystemClock.uptimeMillis() - reqTime), (String)("" + NetworkUtils.getErrorCodeByExc((Throwable)e)));
                }
            }

            public void onResponse(String response, BaseResponseBean<String> res, int id2) {
                super.onResponse(response, res, id2);
                if (toRequestAll) {
                    UnifyConfigController.this.mRequestResult.set(true);
                    UnifyConfigController.this.mRequesting.set(false);
                    UnifyConfigController.this.mRetryTimes = 0;
                }
                UnifyConfigController.this.parseConfigResponse((String)res.data, keyList);
                for (String cmd : cmdList) {
                    HiidoStatis.reportAppMonitorReturnCode((String)("bossconfig/" + cmd), (long)(SystemClock.uptimeMillis() - reqTime), (String)"0");
                }
            }

            public boolean needToken() {
                return false;
            }
        });
    }

    private Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>(1);
        headers.put("app", "hago");
        headers.put("X-Country", SystemUtils.getHagoCountry());
        return headers;
    }

    private String handleParse(@Nullable String lastConfigString, @Nullable String responseString, @NonNull Collection<BssCode> bssCodes, @Nullable Map<String, Boolean> handledMap) throws Exception {
        JSONObject lastConfigJson;
        JSONObject lastDataJson;
        MLog.debug((Object)TAG, (String)"handleParse begin", (Object[])new Object[0]);
        if (StringUtils.isEmpty((String)responseString)) {
            throw new Exception("response string is null");
        }
        JSONObject responseJson = JsonParser.obtainJSONObject((String)responseString).optJSONObject("data");
        if (responseJson == null) {
            throw new Exception("response json data is null");
        }
        if (StringUtils.isEmpty((String)lastConfigString)) {
            lastConfigString = "{}";
        }
        if ((lastDataJson = (lastConfigJson = JsonParser.obtainJSONObject((String)lastConfigString)).optJSONObject("data")) == null) {
            lastDataJson = JsonParser.obtainJSONObject();
            lastConfigJson.put("data", (Object)lastDataJson);
        }
        BssCode priorityBss = BssCode.BOOS_DELAY_PARSE;
        String priorityCode = priorityBss.code();
        JSONObject delayParseJson = responseJson.optJSONObject(priorityCode);
        String configString = null;
        if (delayParseJson != null) {
            configString = delayParseJson.optString("value", "");
            this.createConfig(priorityBss, configString);
        }
        for (BssCode bsscode : bssCodes) {
            String code = bsscode.code();
            JSONObject newBssJson = responseJson.optJSONObject(code);
            if (newBssJson == null) continue;
            configString = newBssJson.optString("value", "");
            int version = newBssJson.optInt("version", -1);
            MLog.debug((Object)TAG, (String)"handleParse response code: %s, version: %d", (Object[])new Object[]{code, version});
            this.mBssParam.put(code, version);
            lastDataJson.put(code, (Object)newBssJson);
            if (!StringUtils.equal((String)code, (String)priorityCode)) {
                this.createConfig(bsscode, configString, true);
            }
            if (handledMap == null) continue;
            handledMap.put(code, true);
        }
        MLog.debug((Object)TAG, (String)("handleParse end, configs size: " + this.mConfigs.size()), (Object[])new Object[0]);
        return lastConfigJson.toString();
    }

    private void parseConfigResponse(final @Nullable String response, final @Nullable List<BssCode> keys) {
        if (RuntimeContext.sIsDebuggable) {
            MLog.info((Object)TAG, (String)"parseConfigResponse keys: %s, response: %s", (Object[])new Object[]{keys, response});
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    String finalConfigString;
                    String lastConfigString;
                    Collection<Object> bssCodes = keys;
                    if (bssCodes == null || bssCodes.size() == 0) {
                        bssCodes = gBasDataSet.keySet();
                    }
                    if (!StringUtils.equal((String)(lastConfigString = UnifyConfigController.this.readLocalConfigString()), (String)(finalConfigString = UnifyConfigController.this.handleParse(lastConfigString, response, bssCodes, null)))) {
                        MLog.debug((Object)UnifyConfigController.TAG, (String)("saveLocalConfigString: " + finalConfigString), (Object[])new Object[0]);
                        UnifyConfigController.this.saveLocalConfigString(finalConfigString);
                    } else {
                        MLog.debug((Object)UnifyConfigController.TAG, (String)"saveLocalConfigString ignore, no changed", (Object[])new Object[0]);
                    }
                }
                catch (Exception e) {
                    MLog.error((Object)UnifyConfigController.TAG, (String)"parseConfig", (Throwable)e, (Object[])new Object[0]);
                }
            }
        });
    }

    private void checkHandleDefault(Map<String, Boolean> handledMap) {
        if (handledMap == null) {
            return;
        }
        MLog.debug((Object)TAG, (String)("check handle default handled: " + handledMap.size()), (Object[])new Object[0]);
        BssCode priorityBss = BssCode.BOOS_DELAY_PARSE;
        String priorityBssCode = priorityBss.code();
        Boolean handled = handledMap.get(priorityBssCode);
        String config = null;
        if (handled == null || !handled.booleanValue()) {
            config = UnifyDefaultConfigProcess.getDefaultConfig(priorityBssCode);
            MLog.debug((Object)TAG, (String)"handleDefault %s config: %s", (Object[])new Object[]{priorityBssCode, config});
            if (priorityBss.hadDefault() || StringUtils.isNotEmpty((String)config)) {
                this.createConfig(priorityBss, config);
            } else {
                this.updateCallback(null, priorityBss);
            }
        }
        for (BssCode bsscode : gBasDataSet.keySet()) {
            if (bsscode == priorityBss || (handled = handledMap.get(bsscode.code())) != null && handled.booleanValue()) continue;
            config = UnifyDefaultConfigProcess.getDefaultConfig(bsscode.code());
            MLog.debug((Object)TAG, (String)"handleDefault %s config: %s", (Object[])new Object[]{bsscode.code(), config});
            if (bsscode.hadDefault() || StringUtils.isNotEmpty((String)config)) {
                this.createConfig(bsscode, config, true);
                continue;
            }
            this.updateCallback(null, bsscode);
        }
    }

    private void createConfig(@NonNull BssCode bsscode, @Nullable String config) {
        this.createConfig(bsscode, config, false);
    }

    private void createConfig(final @NonNull BssCode bsscode, @Nullable String config, boolean canDelay) {
        block11: {
            Class<? extends AConfigData> clazz = gBasDataSet.get(bsscode);
            try {
                if (clazz != null) {
                    final String finalConfig = config;
                    final AConfigData data = clazz.newInstance();
                    if (StringUtils.isEmpty((String)finalConfig)) {
                        if (data.parseDefault()) {
                            this.updateCallback(data, bsscode);
                        }
                    } else {
                        Runnable parseConfigRunnable = new Runnable(){

                            @Override
                            public void run() {
                                data.parseConfig(finalConfig);
                                if (data.recycleAfterParse()) {
                                    MLog.debug((Object)UnifyConfigController.TAG, (String)("recycle after parse bss: " + data.getBssCode()), (Object[])new Object[0]);
                                    data.recycle();
                                }
                                UnifyConfigController.this.updateCallback(data, bsscode);
                            }
                        };
                        if (canDelay) {
                            long delay = BossDelayParseConfig.Companion.getDelay(bsscode);
                            if (delay > 0L) {
                                this.mQueueTaskExecutor.execute(parseConfigRunnable, delay);
                            } else {
                                parseConfigRunnable.run();
                            }
                        } else {
                            parseConfigRunnable.run();
                        }
                    }
                } else {
                    this.updateCallback(null, bsscode);
                }
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)"parseConfig %s", (Object[])new Object[]{config, e});
                this.updateCallback(null, bsscode);
                if (!SystemUtils.isShowEnvSetting()) break block11;
                throw new RuntimeException(e);
            }
        }
    }

    public AConfigData getConfigData(BssCode bssCode) {
        AConfigData data = this.mConfigs.get(bssCode.code());
        if (data == null) {
            this.createConfig(bssCode, null);
            data = this.mConfigs.get(bssCode.code());
        }
        return data;
    }

    public String getLocalDefaultConfigJson(BssCode bssCode) {
        return UnifyDefaultConfigProcess.getDefaultConfig(bssCode.code());
    }

    public void onLoginSuccess() {
        String currentRegion = SystemUtils.getLangAndCountry();
        if (StringUtils.isNotEmpty((String)this.mLastRequestRegion) && !StringUtils.equalsIgnoreCase((String)currentRegion, (String)this.mLastRequestRegion)) {
            List codes;
            MLog.info((Object)TAG, (String)"requestRegion not equal, current: %s, last: %s", (Object[])new Object[]{currentRegion, this.mLastRequestRegion});
            if (this.mConfigs != null && this.mConfigs.size() > 0 && (codes = UnifyConfig.INSTANCE.bssCodesNewCountryStrictMatch()) != null && codes.size() > 0) {
                for (BssCode item : codes) {
                    this.mConfigs.remove(item.code());
                }
            }
        }
        MLog.info((Object)TAG, (String)"login success, request configData", (Object[])new Object[0]);
        if (this.mRequesting != null && this.mRequesting.get()) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    UnifyConfigController.this.requestAllConfig();
                }
            }, (long)1500L);
        } else {
            this.requestAllConfig();
        }
    }

    public <D extends AConfigData> boolean registerListener(BssCode bssCode, final IConfigListener<D> listener) {
        AConfigData data;
        if (bssCode == null || listener == null) {
            MLog.warn((Object)TAG, (String)"registerListener bssCode(%s) == null or listener(%s) == null", (Object[])new Object[]{bssCode, listener});
            return false;
        }
        List<IConfigListener<? extends AConfigData>> listeners = this.mConfigListeners.get(bssCode.code());
        if (listeners == null) {
            listeners = new CopyOnWriteArrayList<IConfigListener<? extends AConfigData>>();
            this.mConfigListeners.put(bssCode.code(), listeners);
        }
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
        if ((data = this.getConfigData(bssCode)) != null) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    listener.onUpdateConfig(data);
                }
            });
        }
        return true;
    }

    public <D extends AConfigData> void unregisterListener(BssCode bssCode, IConfigListener<D> listener) {
        if (bssCode == null || listener == null) {
            MLog.warn((Object)TAG, (String)"unregisterListener bssCode(%s) == null or listener(%s) == null", (Object[])new Object[]{bssCode, listener});
            return;
        }
        List<IConfigListener<? extends AConfigData>> listeners = this.mConfigListeners.get(bssCode.code());
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    private void updateCallback(final @Nullable AConfigData config, @NonNull BssCode bssCode) {
        if (config == null) {
            this.mConfigs.remove(bssCode.code());
        } else {
            this.mConfigs.put(bssCode.code(), config);
        }
        final List<IConfigListener<? extends AConfigData>> listeners = this.mConfigListeners.get(bssCode.code());
        if (listeners != null) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                @SuppressLint(value={"LoopUsage"})
                public void run() {
                    for (IConfigListener listener : listeners) {
                        if (!RuntimeContext.sIsDebuggable) {
                            try {
                                listener.onUpdateConfig(config);
                            }
                            catch (Exception e) {
                                MLog.error((Object)UnifyConfigController.TAG, (Throwable)e);
                            }
                            continue;
                        }
                        listener.onUpdateConfig(config);
                    }
                }
            });
        }
    }

    private void saveLocalConfigString(final String finalConfigString) {
        if (finalConfigString == null) {
            return;
        }
        MLog.info((Object)TAG, (String)"saveLocalConfigString", (Object[])new Object[0]);
        YYTaskExecutor.getDefaultIdleExecutor().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String path = UnifyConfigController.this.configPath();
                    Object object = FILE_LOCK;
                    synchronized (object) {
                        YYFileUtils.writeBytesToFile((File)YYFileUtils.createNewFile((String)path, (boolean)false), (byte[])finalConfigString.getBytes(), (boolean)false);
                    }
                }
                catch (Exception e) {
                    MLog.error((Object)UnifyConfigController.TAG, (Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readLocalConfigString() {
        MLog.info((Object)TAG, (String)"readLocalConfigString", (Object[])new Object[0]);
        Object object = FILE_LOCK;
        synchronized (object) {
            try {
                String path = this.configPath();
                if (YYFileUtils.isPathExist((String)path)) {
                    byte[] bs = YYFileUtils.readBytes((String)path);
                    return StringUtils.byteToStringUtf8((byte[])bs);
                }
                MLog.error((Object)TAG, (String)"readLocalConfigString but path is not exist : %s", (Object[])new Object[]{path});
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)"readLocalConfigString", (Throwable)e, (Object[])new Object[0]);
            }
        }
        return null;
    }

    private void checkReadLocalConfig() {
        if (this.mWaitLocal.getCount() <= 0L) {
            MLog.warn((Object)TAG, (String)"has read local config", (Object[])new Object[0]);
            return;
        }
        YYTaskExecutor.execute(() -> {
            Set<BssCode> bssCodes = gBasDataSet.keySet();
            HashMap<String, Boolean> handledMap = new HashMap<String, Boolean>(bssCodes.size());
            try {
                String lastSaveConfigString = this.readLocalConfigString();
                MLog.debug((Object)TAG, (String)("checkReadLocalConfig: " + lastSaveConfigString), (Object[])new Object[0]);
                this.handleParse(null, lastSaveConfigString, bssCodes, handledMap);
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)"checkReadLocalConfig", (Throwable)e, (Object[])new Object[0]);
            }
            finally {
                this.checkHandleDefault(handledMap);
                MLog.debug((Object)TAG, (String)"notify wait local finish", (Object[])new Object[0]);
                this.mWaitLocal.countDown();
                if (RuntimeContext.isHagoPartySdk()) {
                    YYTaskExecutor.execute(() -> this.checkRequest(), (long)2000L);
                }
            }
        });
    }

    private String configPath() {
        return FileStorageUtils.getInstance().getExternalCacheRootDir() + "/config/unifyconfig";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getBssRequestParam(List<BssCode> keyList, Map<String, String> paramMap, List<String> cmdList) {
        HashMap<String, Integer> tempMap;
        MLog.debug((Object)TAG, (String)"getBssRequestParam begin", (Object[])new Object[0]);
        this.initAttribution();
        try {
            this.mWaitLocal.await();
        }
        catch (Exception ex) {
            MLog.error((Object)TAG, (Throwable)ex);
        }
        String currentRegion = SystemUtils.getLangAndCountry();
        if (!StringUtils.equalsIgnoreCase((String)currentRegion, (String)this.mLastRequestRegion)) {
            MLog.debug((Object)TAG, (String)"requestRegion not equal, current: %s, last: %s", (Object[])new Object[]{currentRegion, this.mLastRequestRegion});
            UnifyConfigController unifyConfigController = this;
            synchronized (unifyConfigController) {
                this.mLastRequestRegion = currentRegion;
                SettingFlags.setStringValue((String)KEY_BSS_REQUEST_REGION, (String)currentRegion);
            }
            this.mBssParam.clear();
        }
        Collection<BssCode> bssCodeList = keyList;
        if (keyList == null || keyList.size() == 0) {
            bssCodeList = gBasDataSet.keySet();
            tempMap = new HashMap(bssCodeList.size());
            cmdList.add("all");
        } else {
            tempMap = new HashMap<String, Integer>(keyList.size());
            for (BssCode bssCode : keyList) {
                cmdList.add(bssCode.code());
            }
        }
        for (BssCode bssCode : bssCodeList) {
            Integer version = this.mBssParam.get(bssCode.code());
            if (version == null) {
                tempMap.put(bssCode.code(), -1);
                continue;
            }
            tempMap.put(bssCode.code(), version);
        }
        paramMap.put("keys", JsonParser.toJson(tempMap));
        MLog.debug((Object)TAG, (String)"getBssRequestParam end", (Object[])new Object[0]);
    }

    private String getBssRequestUrl() {
        String url = UriProvider.getBossConfigUrl();
        if (!url.startsWith("http")) {
            return null;
        }
        if (AccountUtil.getUid() <= 0L && !CountryCodeUtils.isCountryIndonesia() && !RuntimeContext.sIsDebuggable && EnvSettings.instance().getUriSettingValue() == EnvSettingType.Product) {
            if (CountryCodeUtils.isCountryIndia()) {
                url = "https://i-875.ihago.net/boss_config/get";
            } else if (CountryCodeUtils.isCountryVietnam()) {
                url = "https://i-881.ihago.net/boss_config/get";
            }
        }
        return url;
    }

    private synchronized void initAttribution() {
        if (this.mLastRequestRegion == null) {
            this.mLastRequestRegion = SettingFlags.getStringValue((String)KEY_BSS_REQUEST_REGION, (String)"");
        }
    }

    static {
        long startAt = System.currentTimeMillis();
        MLog.info((Object)TAG, (String)"bss set init", (Object[])new Object[0]);
        gBasDataSet.put(BssCode.GROWTH, GrowthConfig.class);
        gBasDataSet.put(BssCode.GROWTH_BUSINESS, GrowthBusinessConfig.class);
        gBasDataSet.put(BssCode.PERFORMANCE_CONFIG, PerformanceConfigData.class);
        gBasDataSet.put(BssCode.COMMON_CONFIG, CommonConfig.class);
        gBasDataSet.put(BssCode.NETWORK, NetworkConfig.class);
        gBasDataSet.put(BssCode.CAMPAIGN_DP, DeeplinkConfig.class);
        gBasDataSet.put(BssCode.PACKAGE_CHANNEL_DEEP_LINK, PackageChannelDeepLinkConfig.class);
        gBasDataSet.put(BssCode.DP_JUMP_OPT_CONFIG, DPJumpOptConfig.class);
        gBasDataSet.put(BssCode.DEFAULT_IP_CONFIG, DefaultIPConfig.class);
        gBasDataSet.put(BssCode.LOGIN_TYPE_CONFIG, LoginTypeConfigData.class);
        gBasDataSet.put(BssCode.HIIDO_EVENT_FILTER, HiidoEventFilterConfig.class);
        gBasDataSet.put(BssCode.HIIDO_ACT_FILTER, HiidoActFilterConfig.class);
        gBasDataSet.put(BssCode.WEB_PRELOAD_CONFIG, WebPreloadConfig.class);
        gBasDataSet.put(BssCode.OSS_MATCH, OssConfig.class);
        gBasDataSet.put(BssCode.NET_PREVENTDUPLICATE, NetPreventDuplicateConfig.class);
        gBasDataSet.put(BssCode.AF_FIREBASE_STAT_CONFIG, AfAndFirebaseStatConfig.class);
        gBasDataSet.put(BssCode.PUSH_CLEAR_CONFIG, PushControlBossConfig.class);
        gBasDataSet.put(BssCode.AUDIO_RECORD_CONFIG, AudioRecordConfig.class);
        gBasDataSet.put(BssCode.GAME_SHARE_CONFIG, GameShareConfig.class);
        gBasDataSet.put(BssCode.TEAM_GAME_CONFIG, TeamGameConfigData.class);
        gBasDataSet.put(BssCode.FAVOR_GAME, FavorGameConfig.class);
        gBasDataSet.put(BssCode.SHARE_CHANNEL_CONFIG, ShareChannelConfig.class);
        gBasDataSet.put(BssCode.GAME_EMOJIS, GameEmojiConfig.class);
        gBasDataSet.put(BssCode.ONLINE_FRIENDS_NUM, OnLineFriendsNumConfig.class);
        gBasDataSet.put(BssCode.SHARE_CONFIG, ShareConfig.class);
        gBasDataSet.put(BssCode.TEAM_GAME_MULTI_CONFIG, TeamMultiGameConfigData.class);
        gBasDataSet.put(BssCode.GAME_WEBSOCKET_CONFIG, GameWebSockectConfig.class);
        gBasDataSet.put(BssCode.TEAM_GAME_MATCH_MSGS, TeamGameMatchMsgsConfig.class);
        gBasDataSet.put(BssCode.HOME_PUSH_VIEW_CONFIG, HomePushViewConfig.class);
        gBasDataSet.put(BssCode.RECOMMEND_GAMES, RecommendGameConfig.class);
        gBasDataSet.put(BssCode.REVENUE_DOMAIN_ROUTE, RevenueDomainConfig.class);
        gBasDataSet.put(BssCode.VOICE_ROOM_TAGS, VoiceRoomTagConfig.class);
        gBasDataSet.put(BssCode.VOICE_ROOM_PUBLIC_SCREEN_TIPS, VoiceRoomPublicScreenConfig.class);
        gBasDataSet.put(BssCode.VOICE_ROOM_CALCULATOR_INSTRUCTION, VoiceRoomCalculatorConfig.class);
        gBasDataSet.put(BssCode.UID_BELONG_SERVICE, UidBelongServiceConfig.class);
        gBasDataSet.put(BssCode.VOICE_ROOM_SHARE, VoiceRoomShareConfig.class);
        gBasDataSet.put(BssCode.ROOM_LIST_QUICK_JOIN, RoomListQucikJoinConfig.class);
        gBasDataSet.put(BssCode.CHARM_VALUE_JUMP, CharmValueJumpConfig.class);
        gBasDataSet.put(BssCode.RAMADAN, RamadanConfig.class);
        gBasDataSet.put(BssCode.CONTRIBUTION_CHARSMA_JUMP, ContributionCharismaJumpConfig.class);
        gBasDataSet.put(CrashProtectConfig.getRealBssCode(), CrashProtectConfig.class);
        gBasDataSet.put(BssCode.VOICE_ROOM_FOLLOW, VoiceRoomFollowConfig.class);
        gBasDataSet.put(BssCode.CUSTOMER_SERVICE_DOMAIN, CustomerServiceDomainConfig.class);
        gBasDataSet.put(BssCode.ROOM_ROLE_PERMISSION, RoomRolePermissionConfig.class);
        gBasDataSet.put(BssCode.GANGUP_INVITE_INFO, GangupInviteConfig.class);
        gBasDataSet.put(BssCode.ACCOUNT_ASYNC_TIME, AccountAsyncConfig.class);
        gBasDataSet.put(BssCode.AI_DENOISE, AIDenoiseConfig.class);
        gBasDataSet.put(BssCode.PK_PUNISH_TEXT, PkPunishTextConfig.class);
        gBasDataSet.put(BssCode.CATCH_SWITCH, TryCatchSwitchConfig.class);
        gBasDataSet.put(BssCode.EMOTICON_CONFIG, EmoticonConfig.class);
        gBasDataSet.put(BssCode.RISK_TIPS_CONFIG, RiskTipsConfig.class);
        gBasDataSet.put(BssCode.GAME_PUBLIC, GamePublicConfig.class);
        gBasDataSet.put(BssCode.HOME_PLAN, HomePlanConfig.class);
        gBasDataSet.put(BssCode.BIRTHDAY_REG, BirthdayRegConfig.class);
        gBasDataSet.put(BssCode.GAME_SHORT_CUT, GameShortCutConfig.class);
        gBasDataSet.put(BssCode.GAME_COMMON_CONFIG, GameCommonConfig.class);
        gBasDataSet.put(BssCode.AD_CONFIG, AdConfig.class);
        gBasDataSet.put(BssCode.VOICE_FILTER_CONFIG, VoiceFilterConfig.class);
        gBasDataSet.put(BssCode.VIETNAM_INVITE_FRIEND, VietnamInviteFriendConfig.class);
        gBasDataSet.put(BssCode.GAME_CRASH_BLACK, GameCrashBlackConfig.class);
        gBasDataSet.put(BssCode.IM_COMMON_PUSH, ImCommonPushConfig.class);
        gBasDataSet.put(BssCode.IM_GAME_CONTENT_LIST, ImGameMsgContentConfig.class);
        gBasDataSet.put(BssCode.BEAUTY_FILTER, BeautyFilterConfig.class);
        gBasDataSet.put(BssCode.USER_NATION_FLAG, UserNationFlagConfig.class);
        gBasDataSet.put(BssCode.ANCHOR_LEVEL, AnchorLevelConfig.class);
        gBasDataSet.put(BssCode.RANDOM_GAME_CONFIG, RandomGameConfig.class);
        gBasDataSet.put(BssCode.RECHARGE_RISK_TIPS, RechargeRiskTipsConfig.class);
        gBasDataSet.put(BssCode.WEB_INTENT_FILTER, IntentFilterConfig.class);
        gBasDataSet.put(BssCode.PRE_RESOLVE_HOSTS, PreResolveHostConfig.class);
        gBasDataSet.put(BssCode.IM_RECOM_CHANNEL_CONFIG, ImRecomChannelConfig.class);
        gBasDataSet.put(BssCode.HOME_SCROLL_TOP, HomeScrollTopConfig.class);
        gBasDataSet.put(BssCode.RANDOM_AVATAR_LIST, RandomAvatarConfig.class);
        gBasDataSet.put(BssCode.IM_INVITE_CONFIG, IMContentConfig.class);
        gBasDataSet.put(BssCode.CHANNEL_FOLLOW_GUIDE_CONFIG, ChannelFollowGuideConfig.class);
        gBasDataSet.put(BssCode.ASSIST_GAME_JOIN_INVITE_CONFIG, AssistGameJoinInviteConfig.class);
        gBasDataSet.put(BssCode.ASSIST_GAME_FOLLOW_MSG_CONFIG, AssistGameFollowConfig.class);
        gBasDataSet.put(BssCode.ASSIST_GAME_BTN_CONFIG, AssistGameBtnConfig.class);
        gBasDataSet.put(BssCode.ASSIST_GAME_AUTO_DOWNLOAD_CONFIG, AssistGameAutoDownloadConfig.class);
        gBasDataSet.put(BssCode.END_PAGE_CONFIG, EndPageConfig.class);
        gBasDataSet.put(BssCode.CROSS_REGION_CONFIG, CrossRegionConfig.class);
        gBasDataSet.put(BssCode.GLOBAL_NATION_CONFIG, GlobalNationConfig.class);
        gBasDataSet.put(BssCode.BBS_CONFIG, BossBBSConfig.class);
        gBasDataSet.put(BssCode.NO_POST_BTN_CONFIG, NoPostBtnConfig.class);
        gBasDataSet.put(BssCode.AT_FANS_COUNT, AtFansCountConfig.class);
        gBasDataSet.put(BssCode.RADIO_LIVE_CONFIG, RadioLiveConfig.class);
        gBasDataSet.put(BssCode.TEXTURE_CONFIG, TextureConfig.class);
        gBasDataSet.put(BssCode.IM_CHAT_SESSION_RECOMMEND_CONFIG, ImChatSessionRecommendConfig.class);
        gBasDataSet.put(BssCode.PAGE_CHANGE_REPORT, PageChangeReportConfig.class);
        gBasDataSet.put(BssCode.BEAUTY_INTENSITY_CONFIG, BeautyIntensityConfig.class);
        gBasDataSet.put(BssCode.AR_BEAUTY_FILTER, ARBeautyFilterConfig.class);
        gBasDataSet.put(BssCode.CHANNEL_LIST_TOP_TAB_CONFIG, ChannelListTopTabConfig.class);
        gBasDataSet.put(BssCode.IM_MORE_OPTION, ImMoreOptionConfig.class);
        gBasDataSet.put(BssCode.HYPER_LINK_INTERCEPT_CONFIG, HyperLinkConfig.class);
        gBasDataSet.put(BssCode.NOSOCIAL_GUIDE_CONFIG, NoSocialGuideConfig.class);
        gBasDataSet.put(BssCode.CHANNEL_DELETE_SHOW, ChannelDeleteShowConfig.class);
        gBasDataSet.put(BssCode.GROUP_OPT_COMPAT_GUIDE, GroupOptCompatConfig.class);
        gBasDataSet.put(BssCode.GROUP_CHAT_CLASSIFICATION, GroupChatClassificationConfig.class);
        gBasDataSet.put(BssCode.GAME_GROUP_THEME_MAP, GameGroupThemeMapConfig.class);
        gBasDataSet.put(BssCode.MULTI_VIDEO_DIALOG_CONTROL, MultiVideoTipConfig.class);
        gBasDataSet.put(BssCode.BBS_POST_CONFIG, BbsPostConfig.class);
        gBasDataSet.put(BssCode.PROFILE_LABEL, ProfileLabelConfig.class);
        gBasDataSet.put(BssCode.RADIO_ENABLE_CONFIG, RadioEnableConfig.class);
        gBasDataSet.put(BssCode.CRAWLER_GROUP_THEME_DEFAULT, CrawlerGroupThemeConfig.class);
        gBasDataSet.put(BssCode.IM_REVOKE_CONFIG, IMRevokeConfig.class);
        gBasDataSet.put(BssCode.TRANSLUCENT_BAR_BLACK, TranslucentBarBlackConfig.class);
        gBasDataSet.put(BssCode.COMMEMORATIVE_COIN_CONFIG, CommemorativeCoinConfig.class);
        gBasDataSet.put(BssCode.VIDEO_COVER_SUPPORT_BLACK, VideoCoverSupportBlackConfig.class);
        gBasDataSet.put(BssCode.NOTCH_BLACK, NotchBlackConfig.class);
        gBasDataSet.put(BssCode.MULTIVIDEO_CHANNEL_LIGHT, MultiVideoLightConfig.class);
        gBasDataSet.put(BssCode.MULTIVIDEO_ENABLE_BUFFER_DEVICES_CONFIG, MultiVideoEnableBufferDevicesConfig.class);
        gBasDataSet.put(BssCode.CHANNEL_OF_CRASH_DEVICES_CONFIG, ChannelOfCrashDevicesConfig.class);
        gBasDataSet.put(BssCode.CHANNEL_RADIO_CATON_CODE_RATE_CONFIG, ChannelRadioCatonCodeRateConfig.class);
        gBasDataSet.put(BssCode.CHANNEL_NO_CUSTOM_CAMERA_CPU_CONFIG, ChannelNoCustomCameraCpuConfig.class);
        gBasDataSet.put(BackupHostConfig.getRealBssCode(), BackupHostConfig.class);
        gBasDataSet.put(BssCode.THREAD_OPT_CONFIG, ThreadOptConfig.class);
        gBasDataSet.put(BssCode.ROOM_GAME_MATCH_FLOAT_BUTTON_ENABLE_LINE, RoomGameMatchFloatButtonConfig.class);
        gBasDataSet.put(BssCode.PROFILE_CARD_GIFT_ENTRY_SWITCH, ProfileCardGiftEntryConfig.class);
        gBasDataSet.put(BssCode.KTV_WORKS_SAVE_ENTRANCE, KtvWorksEntranceConfig.class);
        gBasDataSet.put(BssCode.FAMILY_CHAT_BG_CONFIG, FamilyChatBgConfig.class);
        gBasDataSet.put(BssCode.YOUTUBE_SHARE, YouTubeShareConfig.class);
        gBasDataSet.put(BssCode.BBS_SHARE_CONFIG, BbsShareConfig.class);
        gBasDataSet.put(BssCode.PROFILE_PERSON_SIGN_LINES, ProfilePersonSignLines.class);
        gBasDataSet.put(BssCode.GROUP_VIDEO_MSG, GroupVideoMsgConfig.class);
        gBasDataSet.put(BssCode.GROUP_TOOLS_PLUG_IN, GroupToolsPlugInConfig.class);
        gBasDataSet.put(BssCode.RECHARGE_TIPS_SWITCH, RechargeTipsConfig.class);
        gBasDataSet.put(BssCode.CHANNEL_COMMON, ChannelConfigParse.class);
        gBasDataSet.put(BssCode.CHANNEL_TITLE_BG, ChannelTitleBgConfig.class);
        gBasDataSet.put(BssCode.VOICE_ROOM_BILLBOARD_TIP, VoiceRoomBillboardTipConfig.class);
        gBasDataSet.put(BssCode.VOICE_ROOM_SHARE_STRATEGY_TIP, VoiceRoomShareStrategyTipConfig.class);
        gBasDataSet.put(BssCode.CHANNEL_ZOMBIE_ACCOUNT, ChannelZombieAccountConfig.class);
        gBasDataSet.put(BssCode.PEOPLE_ENTER_ROOM_TIP, PeopleEnterRoomTipConfig.class);
        gBasDataSet.put(BssCode.CHANNEL_NEARBY_PEOPLE_MSG, ChannelNearbyPeopleMsgConfig.class);
        gBasDataSet.put(BssCode.WS_HTTP_PICK_CONFIG, WsHttpDispatcherConfig.class);
        gBasDataSet.put(BssCode.MULTI_VIDEO_GUIDE, MultiVideoGuideConfig.class);
        gBasDataSet.put(BssCode.REMINDER_GUIDE, ReminderPartyGuideConfig.class);
        gBasDataSet.put(BssCode.VIDEO_PK_CONFIG, VideoPkConfig.class);
        gBasDataSet.put(BssCode.GAME_LOADING_TIPS, GameLoadingTipsConfig.class);
        gBasDataSet.put(BssCode.CHANNEL_ALPHA_VIDEO_CONFIG, ChannelAlphaVideoConfig.class);
        gBasDataSet.put(BssCode.FLAG_SWITCH_CONFIG, FlagSwitchConfig.class);
        gBasDataSet.put(BssCode.RPC_REPORT_SAMPLE, RpcReportSampleConfig.class);
        gBasDataSet.put(BssCode.SOCIAL_MATCH, SocialMatchConfig.class);
        gBasDataSet.put(BssCode.LOGIN_TYPE_CONFIG, LoginTypeConfigData.class);
        gBasDataSet.put(BssCode.PARTY_FEEDBACK_ENTRY_SWITCH, PartyFeedbackEntryConfig.class);
        gBasDataSet.put(BssCode.EXIT_FOLLOW_GUIDE, ExitFollowGuideConfig.class);
        gBasDataSet.put(BssCode.GROWTH_BUSINESS, GrowthBusinessConfig.class);
        gBasDataSet.put(BssCode.OLA_PUSH_HOSTNAME_CONFIG, PushHostNameConfig.class);
        gBasDataSet.put(BssCode.METRIC_REPORT_SAMPLE, MetricReportSampleConfig.class);
        gBasDataSet.put(BssCode.AGE_RESTRAIN_CONFIG, AgeRestrainConfig.class);
        gBasDataSet.put(BssCode.AUTO_INVITE_TRIGGER_TIME, AutoInviteMicUpConfig.class);
        gBasDataSet.put(BssCode.FIND_FRIEND_BROADCAST, FindFriendBroadcastConfig.class);
        gBasDataSet.put(BssCode.MINE_PAGE_FAMILY_ENTRY, MinePageFamilyEntryConfig.class);
        gBasDataSet.put(BssCode.SHARE_GUIDE_TIME, ShareGuideTimeConfig.class);
        gBasDataSet.put(BssCode.VOICE_ROOM_PK_CONFIG, VoiceRoomPkConfig.class);
        gBasDataSet.put(BssCode.LOG_OPTIMIZATION_CONFIG, LogOptimizationConfig.class);
        gBasDataSet.put(BssCode.USER_REMAIN_ACTIVE_NOTIFY, FollowMostActiveLiveNotifyConfig.class);
        gBasDataSet.put(BssCode.PUBLICSCREEN_TRANSLATE_GUIDE_CONFIG, TranslateGuideConfig.class);
        gBasDataSet.put(BssCode.RADIO_GUIDE_BLACK_DEVICES_CONFIG, RadioListGuideBlackDevicesConfig.class);
        gBasDataSet.put(BssCode.POST_TAG_WARING, PostWaringConfig.class);
        gBasDataSet.put(BssCode.GUEST_LOGIN_CONFIG, GuestLoginDeeplinkConfig.class);
        gBasDataSet.put(BssCode.RADIO_SHOW_END_PAGE_CONFIG, RadioShowEndPageConfig.class);
        gBasDataSet.put(BssCode.POST_VIDEO_DETAIL_CONFIG, PostVideoDetailConfig.class);
        gBasDataSet.put(BssCode.AMONG_US_CONFIG, AmongUsConfig.class);
        gBasDataSet.put(BssCode.KTV_GIFT_CONFIG, KtvGiftConfig.class);
        gBasDataSet.put(BssCode.KTV_AUDIO_EFFECT_CONFIG, KtvAudioEffectConfig.class);
        gBasDataSet.put(BssCode.KTV_VIDEO_CODERATE_CONFIG, KtvVideoCodeRateConfig.class);
        gBasDataSet.put(BssCode.NOTIFY_FREQUENCY_CONFIG, NotifyFrequencyConfig.class);
        gBasDataSet.put(BssCode.SCENE_PERFORMANCE_OPT_CONFIG, ScenePerformanceOptConfig.class);
        gBasDataSet.put(BssCode.ROOM_THEME_CONFIG, RoomThemeConfig.class);
        gBasDataSet.put(BssCode.PK_POINT_LUCK_BAG, PkPointLuckBagConfig.class);
        gBasDataSet.put(BssCode.PARTY_GAME_CONFIG, PartyGameConfig.class);
        gBasDataSet.put(BssCode.CHANNEL_JUMP_BACK_CONFIG, ChannelJumpBackConfig.class);
        gBasDataSet.put(BssCode.ENTER_ROOM_SOURCE_CONFIG, EnterRoomSourceConfig.class);
        gBasDataSet.put(BssCode.FOLLOW_SOURCE_CONFIG, FollowerSourceConfig.class);
        gBasDataSet.put(BssCode.DIRECT_RENDER_TO_SURFACE_BLACK, DirectRenderToSurfaceBlackConfig.class);
        gBasDataSet.put(BssCode.WEBVIEW_LAYER_CONFIG, WebViewLayerConfig.class);
        gBasDataSet.put(BssCode.BBS_ADD_TAG_PAGE_CONFIG, BbsAggTagPageConfig.class);
        gBasDataSet.put(BssCode.BOOS_DELAY_PARSE, BossDelayParseConfig.class);
        gBasDataSet.put(BssCode.TASK_OPT_CONFIG, TaskOptConfig.class);
        gBasDataSet.put(BssCode.LOOP_MIC_LABEL, LoopMicLabelConfig.class);
        gBasDataSet.put(BssCode.LOOP_MIC_FOLLOW_ROOM, LoopMicFollowConfig.class);
        gBasDataSet.put(BssCode.HOME_TOWN_CONFIG, HomeTownConfig.class);
        gBasDataSet.put(BssCode.HAGO_CDN_LIST, HagoCdnConfig.class);
        gBasDataSet.put(BssCode.BASE_ROOM_STATUS_CONFIG, BaseRoomStatusConfig.class);
        gBasDataSet.put(BssCode.HOME_CONFIG, HomeConfigBoss.class);
        gBasDataSet.put(BssCode.SWITCH_CREATE_CHANNEL_AND_PARTY, CreateChannelPartyConfig.class);
        gBasDataSet.put(BssCode.PARTY_PAGE_LIST_CONFIG, PartyPageListConfig.class);
        gBasDataSet.put(BssCode.PRE_CONNECT, HostPreConnectConfig.class);
        gBasDataSet.put(BssCode.CHANNEL_TEAM_UP_GAME_AUTHORITY_METHOD, ChannelTeamUpGameAuthorityConfig.class);
        gBasDataSet.put(BssCode.CHANNEL_TEAM_UP_GAME_FLOAT_WIN_SWITCH, ChannelTeamUpGameFloatWinConfig.class);
        gBasDataSet.put(BssCode.TEAM_UP_DDL_CONFIG, ChannelTeamUpDDLConfig.class);
        gBasDataSet.put(BssCode.TEAM_UP_SHARE_CONFIG, ShareTeamUpConfig.class);
        gBasDataSet.put(BssCode.TEAM_UP_MATCH_CONFIG, TeamUpMatchConfig.class);
        gBasDataSet.put(BssCode.TEAM_UP_LIST_MATCH_WIN_CONFIG, TeamUpMatchWinConfig.class);
        gBasDataSet.put(BssCode.TEAM_UP_GAME_ROOM_ELEMENT_CONFIG, TeamUpGameRoomElementConfig.class);
        gBasDataSet.put(BssCode.TEAM_UP_GAME_SHOW_FOLLOW_TIME_CONFIG, TeamUpGameFollowTimeShowConfig.class);
        gBasDataSet.put(BssCode.CHANNEL_RTC_TRANS_CONFIG, ChannelRtcTransConfig.class);
        gBasDataSet.put(BssCode.INNER_PK_CONFIG, InnerPkConfig.class);
        gBasDataSet.put(BssCode.GROUP_INVITE_ENTRANCE_CONFIG, GroupInviteListContactEntranceConfig.class);
        gBasDataSet.put(BssCode.GAME_TOP_VIDEO_CONFIG, GameTopVideoConfig.class);
        gBasDataSet.put(BssCode.TODAY_LIST_DATA_CONFIG, TodayListDataConfig.class);
        gBasDataSet.put(BssCode.BASIC_GROUP_ENTER_CONFIG, BasicGroupEnterConfig.class);
        gBasDataSet.put(BssCode.CHANNEL_TOOLS_CONFIG, ChannelToolsConfig.class);
        gBasDataSet.put(BssCode.TEAM_MATCH_ROOM_GAME_GROUP_THEME, TeamMatchGameGroupThemeConfig.class);
        gBasDataSet.put(BssCode.SWORD_CONFIG, SwordConfig.class);
        gBasDataSet.put(BssCode.PROFILE_INFO_PAGE_CONFIG, ProfileInfoPageConfig.class);
        gBasDataSet.put(BssCode.CHANNEL_TAB_CONFIG, ChannelTabConfig.class);
        gBasDataSet.put(BssCode.AV_SYNC_CONFIG, AVSyncConfig.class);
        gBasDataSet.put(BssCode.IM_SOCIAL_ROOM_RECOMMEND_GANG_UP_ICON, IMSocialRoomRecommendConfig.class);
        gBasDataSet.put(BssCode.PUBLIC_SCREEN_SCROLL_TEST, PublicScreenScrollTestConfig.class);
        gBasDataSet.put(BssCode.IM_DRAG_GUIDE_CONFIG, IMDragGuideConfig.class);
        gBasDataSet.put(BssCode.CHANNEL_PUSH_CONFIG, ChannelPushConfig.class);
        gBasDataSet.put(BssCode.CHAT_SWIPE_CONFIG, ChatSwipeConfig.class);
        gBasDataSet.put(BssCode.NT_PRODUCT_CONFIG, NTProductConfig.class);
        gBasDataSet.put(BssCode.NT_TECH_CONFIG, NTProductConfig.class);
        MLog.info((Object)TAG, (String)"bss set init cost %d ms, size: %d", (Object[])new Object[]{System.currentTimeMillis() - startAt, gBasDataSet.size()});
    }
}

