/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.splash;

import android.text.TextUtils;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.push.tips.PushPermissionTipManager;
import com.yy.appbase.resource.file.ResPersistUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IFrequencyLimitExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.TimeUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.app.ServiceManager;
import com.yy.hiyo.game.base.bean.GameDownloadInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.module.splash.ConfigureSplashData;
import com.yy.hiyo.module.splash.SplashDataRes;
import com.yy.hiyo.module.splash.SplashShowData;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import okhttp3.Call;

public enum SplashManager {
    INSTANCE;

    private static final String TAG = "SplashManager";
    private static final String CONFIG_PATH = "/splash/sconfig.txt";
    private static final String SHOW_CONFIG_PATH = "/splash/showConfig.txt";
    private static final String GAME_IDS_PATH = "/splash/splash_cache_game_ids.txt";
    private boolean splashViewShowIng = false;
    private final Object fileLock = new Object();
    private SplashDataRes mLocalSplashDataRes;
    private volatile List<ConfigureSplashData> mSplashs = null;
    public ConfigureSplashData mLastConfigureSplashData;
    private boolean mNeedSplash = false;
    private SplashShowData mSplashShowData;
    private List<String> cacheGameIds = new ArrayList<String>();
    private boolean hasReadGidConfig = false;
    private IFrequencyLimitExecutor mLimitExecutor;

    public void loadSplash() {
        if (AccountUtil.getUid() <= 0L) {
            return;
        }
        String url = UriProvider.getIkxdSvrHost() + "/boss/app_get_splash";
        String campaign = this.getSaveCampaign();
        if (StringUtils.isNotEmpty((String)campaign)) {
            url = url + "?campaign=" + campaign;
        }
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("url: " + url), (Object[])new Object[0]);
        }
        if (!url.startsWith("http")) {
            return;
        }
        HttpUtil.httpReq((String)url, null, (int)1, (INetRespCallback)new INetRespCallback<SplashDataRes>(){

            public void onError(Call call, Exception e, int id2) {
                MLog.error((Object)SplashManager.TAG, (Throwable)e);
            }

            public void onResponse(String response, BaseResponseBean<SplashDataRes> res, int id2) {
                if (RuntimeContext.sIsDebuggable) {
                    MLog.info((Object)SplashManager.TAG, (String)"loadSplash response: %s ", (Object[])new Object[]{response});
                }
                if (res == null || res.data == null) {
                    MLog.error((Object)SplashManager.TAG, (String)"response is null", (Object[])new Object[0]);
                    return;
                }
                SplashManager.this.writeConfig((SplashDataRes)res.data);
                SplashManager.this.handleSplash((SplashDataRes)res.data);
                SplashManager.this.preloadResource(((SplashDataRes)res.data).preloadList);
                YYTaskExecutor.execute(() -> SplashManager.this.preloadGame((SplashDataRes)res.data));
            }
        });
    }

    private void handleSplash(SplashDataRes res) {
        MLog.info((Object)TAG, (String)"handleSplash ", (Object[])new Object[0]);
        if (res == null || FP.empty(res.list)) {
            MLog.info((Object)TAG, (String)"handleSplash splash is empty", (Object[])new Object[0]);
            return;
        }
        for (ConfigureSplashData data : res.list) {
            if (this.isPreload(res.preloadList, data.mResourceUrl) || !data.checkSplashValid()) continue;
            data.downloadResFile();
        }
    }

    private void preloadResource(List<SplashDataRes.Preload> preloadList) {
        MLog.info((Object)TAG, (String)"preloadResource size: %d", (Object[])new Object[]{FP.size(preloadList)});
        if (FP.empty(preloadList)) {
            return;
        }
        HashSet<String> res = new HashSet<String>(preloadList.size());
        for (SplashDataRes.Preload preload : preloadList) {
            if (TextUtils.isEmpty((CharSequence)preload.resourceUrl)) continue;
            res.add(preload.resourceUrl);
        }
        ResPersistUtils.preLoad((ResPersistUtils.Dir)ResPersistUtils.Dir.SPLASH, res);
    }

    private void preloadGame(SplashDataRes data) {
        if (data == null) {
            return;
        }
        HashSet<String> games = new HashSet<String>();
        if (!FP.empty(data.list)) {
            for (ConfigureSplashData splash : data.list) {
                games.add(splash.gameId);
            }
        }
        if (!FP.empty(data.preloadList)) {
            for (SplashDataRes.Preload preload : data.preloadList) {
                games.add(preload.gameId);
            }
        }
        for (String gid : games) {
            MLog.info((Object)TAG, (String)"preloadGame gameId: %s", (Object[])new Object[]{gid});
            GameInfo info = ServiceManager.getInstance().getService(IGameInfoService.class).getGameInfoByGid(gid);
            if (info != null) {
                ServiceManager.getInstance().getService(IGameService.class).downloadGame(info, GameDownloadInfo.DownloadType.silent, 50);
                continue;
            }
            MLog.info((Object)TAG, (String)"preloadGame gid: %s, game info is null", (Object[])new Object[]{gid});
        }
    }

    private boolean isPreload(List<SplashDataRes.Preload> preloadList, String url) {
        if (!FP.empty(preloadList)) {
            for (SplashDataRes.Preload preload : preloadList) {
                if (!StringUtils.equal((String)url, (String)preload.resourceUrl)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean needShowSplash() {
        return this.checkSplashDataValid();
    }

    private boolean checkSplashDataValid() {
        ConfigureSplashData splashData = this.getWillLoadSplashData();
        MLog.debug((Object)"SplashController", (String)("checkSplashDataValid: " + splashData), (Object[])new Object[0]);
        return splashData != null && splashData.checkSplashValid() && splashData.isResourceHadDownloaded();
    }

    public ConfigureSplashData getWillLoadSplashData() {
        return SplashManager.INSTANCE.mLastConfigureSplashData != null ? SplashManager.INSTANCE.mLastConfigureSplashData : INSTANCE.getFirstValidSplash();
    }

    public ConfigureSplashData getFirstValidSplash() {
        List<ConfigureSplashData> splashConfigData = this.getSavedSplashData();
        ConfigureSplashData configureSplashData = this.getLoadStategy().loadSplash(splashConfigData, false);
        if (configureSplashData != null) {
            this.mNeedSplash = true;
        }
        return configureSplashData;
    }

    public boolean isSplashViewShowIng() {
        return this.splashViewShowIng;
    }

    public void setSplashViewShowIng(boolean splashViewShowIng) {
        this.splashViewShowIng = splashViewShowIng;
        PushPermissionTipManager.setIsSplashViewShowIng((boolean)splashViewShowIng);
    }

    public void loadSplashConfigAsyn() {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                List<ConfigureSplashData> splashDataList = SplashManager.this.getSavedSplashData();
                ConfigureSplashData configureSplashData = SplashManager.this.getLoadStategy().loadSplash(splashDataList, true);
                if (configureSplashData != null) {
                    SplashManager.this.mLastConfigureSplashData = configureSplashData;
                }
                INSTANCE.loadSplash();
            }
        });
    }

    public void preloadSplashIcon() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SplashManager.this.loadShowData();
                ConfigureSplashData splashData = SplashManager.this.getFirstValidSplash();
                if (splashData == null) {
                    return;
                }
                SplashManager.this.mLastConfigureSplashData = splashData;
                SplashManager.this.mLastConfigureSplashData.setLocalFilePath(splashData.getResourceFilePath());
            }
        };
        YYTaskExecutor.execute((Runnable)runnable);
    }

    public synchronized List<ConfigureSplashData> getSavedSplashData() {
        if (this.mSplashs != null) {
            return this.mSplashs;
        }
        MLog.info((Object)TAG, (String)"getSavedSplashData", (Object[])new Object[0]);
        this.cacheGameIds = this.getCacheGameIds();
        SplashDataRes res = this.readConfig();
        if (res != null && !FP.empty(res.list)) {
            this.mSplashs = res.list;
            if (YYTaskExecutor.isMainThread()) {
                YYTaskExecutor.execute(this::preloadPath);
            } else {
                this.preloadPath();
            }
        }
        return this.mSplashs;
    }

    private synchronized void preloadPath() {
        if (FP.empty(this.mSplashs)) {
            return;
        }
        for (ConfigureSplashData data : this.mSplashs) {
            if (data == null || TextUtils.isEmpty((CharSequence)data.mResourceUrl)) continue;
            ResPersistUtils.fetchFilePath((ResPersistUtils.Dir)ResPersistUtils.Dir.SPLASH, (String)data.mResourceUrl);
        }
    }

    public synchronized void releaseData() {
        if (this.mSplashs != null) {
            this.mSplashs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SplashDataRes readConfig() {
        if (this.mLocalSplashDataRes != null) {
            return this.mLocalSplashDataRes;
        }
        try {
            Object object = this.fileLock;
            synchronized (object) {
                String path = this.getSaveConfigPath();
                if (YYFileUtils.isPathExist((String)path)) {
                    this.mLocalSplashDataRes = (SplashDataRes)JsonParser.parseJsonFile((String)path, SplashDataRes.class);
                    return this.mLocalSplashDataRes;
                }
                MLog.error((Object)TAG, (String)"readConfig path is not exist: %s", (Object[])new Object[]{path});
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        return null;
    }

    void writeConfig(final SplashDataRes data) {
        if (data == null) {
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object = SplashManager.this.fileLock;
                    synchronized (object) {
                        JsonParser.writeJsonFile((String)SplashManager.this.getSaveConfigPath(), (Object)data, SplashDataRes.class);
                    }
                }
                catch (Exception e) {
                    MLog.error((Object)SplashManager.TAG, (Throwable)e);
                }
            }
        });
    }

    private String getSaveConfigPath() {
        return YYFileUtils.getConfigDir().getAbsolutePath() + CONFIG_PATH;
    }

    private String getGameIdsPath() {
        return YYFileUtils.getConfigDir().getAbsolutePath() + GAME_IDS_PATH;
    }

    public void setGameIds(List<GameInfo> gameInfos) {
        this.cacheGameIds.clear();
        final StringBuilder gameStr = new StringBuilder();
        if (gameInfos != null && !gameInfos.isEmpty()) {
            for (GameInfo gameInfo : gameInfos) {
                gameStr.append(gameInfo.gid).append(",");
                this.cacheGameIds.add(gameInfo.gid);
            }
        }
        MLog.debug((Object)TAG, (String)"setGameIds :%s", (Object[])new Object[]{gameStr.toString()});
        if (this.mLimitExecutor == null) {
            this.mLimitExecutor = YYTaskExecutor.createAFrequencyLimitExecut((long)8000L, (boolean)false);
        }
        this.mLimitExecutor.execute(new Runnable(){

            @Override
            public void run() {
                YYTaskExecutor.getDefaultIdleExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        File file = new File(SplashManager.this.getGameIdsPath());
                        try {
                            YYFileUtils.writeBytesToFile((File)file, (byte[])gameStr.toString().getBytes(), (boolean)false);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
    }

    private List<String> getCacheGameIds() {
        if (this.hasReadGidConfig) {
            return this.cacheGameIds;
        }
        ArrayList<String> gameIds = new ArrayList<String>();
        byte[] bytes = YYFileUtils.readBytes((String)this.getGameIdsPath());
        String gids = null;
        if (bytes != null && bytes.length > 0 && !StringUtils.isEmpty((String)(gids = new String(bytes)))) {
            String[] ids = gids.split(",");
            gameIds.addAll(Arrays.asList(ids));
        }
        this.hasReadGidConfig = true;
        if (RuntimeContext.isInGray()) {
            MLog.info((Object)TAG, (String)"getCacheGameIds :%s", (Object[])new Object[]{gids});
        }
        return gameIds;
    }

    private ILoadFirstSplashStrategy getLoadStategy() {
        return new ATestLoadStrategy();
    }

    public void clickSplash(String splashId) {
        SplashShowData.SplashShow targetShowData = this.getTargetShowData(splashId);
        if (targetShowData != null) {
            targetShowData.hasClick = true;
            if (this.mSplashShowData != null) {
                this.mSplashShowData.lastUpdateTime = System.currentTimeMillis();
                YYTaskExecutor.execute(() -> JsonParser.writeJsonFile((String)this.getShowDataSaveConfigPath(), (Object)this.mSplashShowData, SplashShowData.class));
            }
        }
    }

    public void splashShow(String splashId) {
        SplashShowData.SplashShow targetShowData = this.getTargetShowData(splashId);
        if (targetShowData != null) {
            ++targetShowData.showTimes;
        }
        if (this.mSplashShowData != null) {
            this.mSplashShowData.lastUpdateTime = System.currentTimeMillis();
            YYTaskExecutor.execute(() -> JsonParser.writeJsonFile((String)this.getShowDataSaveConfigPath(), (Object)this.mSplashShowData, SplashShowData.class));
        }
    }

    private SplashShowData.SplashShow getTargetShowData(String splashId) {
        SplashShowData.SplashShow target = null;
        if (StringUtils.isNotEmpty((String)splashId) && this.mSplashShowData != null) {
            boolean hasHandle = false;
            List<SplashShowData.SplashShow> splashShows = this.mSplashShowData.mSplashShows;
            if (splashShows == null) {
                this.mSplashShowData.mSplashShows = splashShows = new CopyOnWriteArrayList<SplashShowData.SplashShow>();
            }
            if (!splashShows.isEmpty()) {
                for (SplashShowData.SplashShow show : splashShows) {
                    if (!splashId.equals(show.splashId)) continue;
                    hasHandle = true;
                    target = show;
                    break;
                }
            }
            if (!hasHandle) {
                target = new SplashShowData.SplashShow();
                target.splashId = splashId;
                splashShows.add(target);
            }
        }
        return target;
    }

    private void loadShowData() {
        if (this.mSplashShowData == null) {
            String path = this.getShowDataSaveConfigPath();
            if (YYFileUtils.isPathExist((String)path)) {
                this.mSplashShowData = (SplashShowData)JsonParser.parseJsonFile((String)path, SplashShowData.class);
            }
            if (this.mSplashShowData == null || !TimeUtils.isSameDay((long)this.mSplashShowData.lastUpdateTime, (long)System.currentTimeMillis())) {
                this.mSplashShowData = new SplashShowData();
            }
        }
    }

    private String getShowDataSaveConfigPath() {
        return YYFileUtils.getConfigDir().getAbsolutePath() + SHOW_CONFIG_PATH;
    }

    private String getSaveCampaign() {
        String settingFlags = SettingFlags.getStringValue((String)"key_dl_campaign_for_splash", null);
        String campaign = null;
        if (StringUtils.isNotEmpty((String)settingFlags)) {
            try {
                long saveTime;
                String[] settingArr = settingFlags.split("`");
                if (settingArr.length == 2 && (saveTime = Long.parseLong(settingArr[1])) > 0L && saveTime < System.currentTimeMillis() && saveTime + 172800000L > System.currentTimeMillis()) {
                    campaign = settingArr[0];
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return campaign;
    }

    private class ATestLoadStrategy
    implements ILoadFirstSplashStrategy {
        private ATestLoadStrategy() {
        }

        @Override
        public ConfigureSplashData loadSplash(List<ConfigureSplashData> splashDataList, boolean downloadOthers) {
            if (FP.empty(splashDataList)) {
                MLog.error((Object)SplashManager.TAG, (String)"loadSplash configureSplashData empty!!!", (Object[])new Object[0]);
                return null;
            }
            ConfigureSplashData mLastConfigureSplashData = null;
            for (int i = splashDataList.size() - 1; i >= 0; --i) {
                ConfigureSplashData splashConfigData = splashDataList.get(i);
                if (splashConfigData == null || !splashConfigData.checkSplashValid()) {
                    MLog.error((Object)SplashManager.TAG, (String)"loadSplash configureSplashData check Splash id not Valid:%s !!!", (Object[])new Object[]{splashConfigData != null ? splashConfigData.splashId : ""});
                    continue;
                }
                if (splashConfigData.isResourceHadDownloaded()) {
                    if (mLastConfigureSplashData != null) continue;
                    String splashId = splashConfigData.splashId;
                    if (StringUtils.isEmpty((String)splashId)) {
                        MLog.error((Object)SplashManager.TAG, (String)"splashId empty!!!, res:%s", (Object[])new Object[]{splashConfigData.mResourceUrl});
                        continue;
                    }
                    boolean isTodayShowValid = this.isTodayShowValidData(splashId);
                    if (!isTodayShowValid) continue;
                    String gameId = splashConfigData.gameId;
                    if (StringUtils.isNotEmpty((String)gameId)) {
                        IGameInfoService gameInfoService = null;
                        if (RuntimeContext.sIsAppStartFinished) {
                            gameInfoService = ServiceManager.getInstance().getService(IGameInfoService.class);
                        }
                        if (gameInfoService != null) {
                            GameInfo gInfo = gameInfoService.getGameInfoByGid(gameId);
                            if (gInfo == null) {
                                MLog.error((Object)SplashManager.TAG, (String)"gInfo null!!! splashId:%s, gameId:%s ", (Object[])new Object[]{splashId, gameId});
                                continue;
                            }
                        } else {
                            MLog.info((Object)SplashManager.TAG, (String)"gameInfoService null, skip check game info!!!!", (Object[])new Object[0]);
                            if (!SplashManager.this.cacheGameIds.contains(gameId)) {
                                MLog.info((Object)SplashManager.TAG, (String)"cache gid not contain gid:%s !!!!", (Object[])new Object[]{gameId});
                                continue;
                            }
                            MLog.info((Object)SplashManager.TAG, (String)"cache gid contain gid:%s", (Object[])new Object[]{gameId});
                        }
                    }
                    mLastConfigureSplashData = splashConfigData;
                    if (downloadOthers) continue;
                    break;
                }
                if (!downloadOthers) continue;
                splashConfigData.downloadResFile();
            }
            if (mLastConfigureSplashData == null) {
                MLog.info((Object)SplashManager.TAG, (String)"mLastConfigureSplashData null!!!", (Object[])new Object[0]);
            }
            return mLastConfigureSplashData;
        }

        private boolean isTodayShowValidData(String splashId) {
            boolean testSwitch = SettingFlags.getBoolean((String)"ENV_AD_DIALOG", (boolean)false);
            if (SystemUtils.isShowEnvSetting() && testSwitch) {
                return true;
            }
            if (SplashManager.this.mSplashShowData != null && ((SplashManager)SplashManager.this).mSplashShowData.mSplashShows != null) {
                for (SplashShowData.SplashShow splashShow : ((SplashManager)SplashManager.this).mSplashShowData.mSplashShows) {
                    if (!splashId.equals(splashShow.splashId) || splashShow.isValid()) continue;
                    MLog.info((Object)SplashManager.TAG, (String)"is not valid!!! splashShow:%s", (Object[])new Object[]{splashShow});
                    return false;
                }
            }
            return true;
        }
    }

    private static interface ILoadFirstSplashStrategy {
        public ConfigureSplashData loadSplash(List<ConfigureSplashData> var1, boolean var2);
    }
}

