/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.splash;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.net.Uri;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import com.yy.appbase.DiskCacheChecker;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.appbase.deeplink.DeepLinkService;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.IYYUriService;
import com.yy.appbase.useractionstat.UserEnterActionStat;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.StatusBarManager;
import com.yy.hiyo.app.MainController;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameInfoSource;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.callback.OnGameInfoChangedListener;
import com.yy.hiyo.home.base.perforstat.StartupStatHelper;
import com.yy.hiyo.main.msg.MsgDef;
import com.yy.hiyo.module.splash.ConfigureSplashData;
import com.yy.hiyo.module.splash.SplashManager;
import com.yy.hiyo.module.splash.SplashWindow;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.List;

public class SplashController
extends DefaultWindowController
implements SplashWindow.ISplashWindowListener {
    private static final String TAG = "SplashController";
    private DefaultWindow mWindow;
    private SplashWindow mSplashView;
    private long mShowTime = 0L;
    private ConfigureSplashData splashData;
    private boolean mAppHadInitSuccess = false;
    private boolean mSplashCountdownComplete = false;
    private boolean mSplashPostpone = false;
    private String actionUrl;
    private final OnGameInfoChangedListener mGameInfoChangedListener = new OnGameInfoChangedListener(){

        public void onGameInfoChanged(GameInfoSource type2, List<GameInfo> list) {
            SplashController.this.saveGameInfos();
        }
    };

    public SplashController(Environment baseEnv) {
        super(baseEnv);
    }

    private void saveGameInfos() {
        List gameInfos = ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getAllGameInfoList();
        SplashManager.INSTANCE.setGameIds(gameInfos);
    }

    private void updateWindow(DefaultWindow parent) {
        this.mWindow = parent;
    }

    private void hideSplash() {
        MLog.debug((Object)TAG, (String)"hideSplash", (Object[])new Object[0]);
        this.mAppHadInitSuccess = true;
        this.sendMessageSync(MsgDef.ROOT_SPLASH_FINISH);
        if (this.mWindow != null && this.mSplashView != null) {
            this.tryHideSplash(false);
        } else {
            this.notifySplashHidden();
        }
    }

    private void tryHideSplash(boolean removeViewImmediately) {
        MLog.info((Object)TAG, (String)"tryHideSplash, initSuccess: %b, countDownComplete: %b, postpone: %b", (Object[])new Object[]{this.mAppHadInitSuccess, this.mSplashCountdownComplete, this.mSplashPostpone});
        if (!this.mAppHadInitSuccess || !this.mSplashCountdownComplete || this.mSplashPostpone) {
            return;
        }
        if (removeViewImmediately) {
            if (this.mWindow != null && this.mSplashView != null) {
                this.mWindowMgr.removeExtLayerContent((View)this.mSplashView);
                this.mSplashView = null;
                this.mShowTime = -1L;
            }
            this.notifySplashHidden();
        } else {
            long consume = System.currentTimeMillis() - this.mShowTime;
            MLog.debug((Object)TAG, (String)("try remove splash anim, delay: " + consume), (Object[])new Object[0]);
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (SplashController.this.mSplashView != null) {
                        ObjectAnimator outAni = ObjectAnimator.ofFloat((Object)SplashController.this.mSplashView, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
                        outAni.setDuration(150L);
                        outAni.addListener(new Animator.AnimatorListener(){

                            public void onAnimationStart(Animator animation) {
                                if (SplashController.this.mWindow != null && SplashController.this.mSplashView != null) {
                                    MLog.debug((Object)SplashController.TAG, (String)"splash view anim start", (Object[])new Object[0]);
                                    SplashController.this.mSplashView.setLayerType(2, null);
                                }
                            }

                            public void onAnimationEnd(Animator animation) {
                                if (SplashController.this.mWindow != null && SplashController.this.mSplashView != null) {
                                    MLog.debug((Object)SplashController.TAG, (String)"splash view anim end", (Object[])new Object[0]);
                                    SplashController.this.mSplashView.setLayerType(0, null);
                                    SplashController.this.mSplashView.exit();
                                    SplashController.this.mWindowMgr.removeExtLayerContent((View)SplashController.this.mSplashView);
                                    SplashController.this.mSplashView = null;
                                    SplashController.this.mShowTime = -1L;
                                }
                            }

                            public void onAnimationCancel(Animator animation) {
                            }

                            public void onAnimationRepeat(Animator animation) {
                            }
                        });
                        outAni.start();
                    }
                    SplashController.this.notifySplashHidden();
                }
            }, (long)(consume > 1000L ? 100L : 1000L - consume));
        }
    }

    public void handleMessage(Message msg) {
        if (msg.what == MsgDef.SPLASH_POSTPONE_START) {
            MLog.info((Object)TAG, (String)"SPLASH_POSTPONE_START", (Object[])new Object[0]);
            this.mSplashPostpone = true;
            Message mockMsg = Message.obtain();
            mockMsg.what = MsgDef.SPLASH_SHOW;
            this.handleMessageSync(mockMsg);
        } else if (msg.what == MsgDef.SPLASH_POSTPONE_FINISH) {
            MLog.info((Object)TAG, (String)"SPLASH_POSTPONE_FINISH", (Object[])new Object[0]);
            if (this.mSplashPostpone) {
                this.mSplashPostpone = false;
                this.tryHideSplash(false);
            }
        }
    }

    public Object handleMessageSync(Message msg) {
        if (msg.what == MsgDef.SPLASH_SHOW) {
            MLog.debug((Object)TAG, (String)("SPLASH_SHOW, splashView is null: " + (this.mSplashView == null)), (Object[])new Object[0]);
            if (this.mSplashView == null) {
                this.splashData = SplashManager.INSTANCE.getWillLoadSplashData();
                MLog.debug((Object)TAG, (String)("show splash data: " + this.splashData), (Object[])new Object[0]);
                if (AccountUtil.getUid() <= 0L || DeepLinkService.INSTANCE.hasTargetAction() != null) {
                    MLog.debug((Object)TAG, (String)"not login or has deeplink jump, no show splash data", (Object[])new Object[0]);
                    this.splashData = null;
                }
                this.mSplashView = new SplashWindow(this.mContext, this.splashData, this);
                if (this.mWindow != null) {
                    RuntimeContext.isSplashShowing = true;
                    this.mWindowMgr.addExtLayerContent((View)this.mSplashView);
                    this.mShowTime = System.currentTimeMillis();
                    StartupStatHelper.onSplashShown();
                    if (this.splashData == null) {
                        StartupStatHelper.updateSplashType((int)10000);
                    } else {
                        StartupStatHelper.updateSplashType((int)this.splashData.mType);
                        SplashManager.INSTANCE.setSplashViewShowIng(true);
                        SplashManager.INSTANCE.splashShow(this.splashData.splashId);
                    }
                    if (this.splashData != null) {
                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20026441").put("startup_id", this.splashData.mId).put("function_id", "show_startup").put("startup_sub_id", this.splashData.splashId).put("gid", this.splashData.gameId));
                        UserEnterActionStat.onSplashShow();
                    }
                    StatusBarManager.INSTANCE.offsetView(this.mContext, this.mSplashView.getOffsetView(), (AbstractWindow)this.mWindow);
                    return true;
                }
            }
        } else {
            if (msg.what == MsgDef.SPLASH_SHOULD_SHOW) {
                MLog.debug((Object)TAG, (String)"SPLASH_SHOULD_SHOW", (Object[])new Object[0]);
                return this.shouldShow((Boolean)msg.obj);
            }
            if (msg.what == MsgDef.SPLASH_UPDATE_WINDOW) {
                if (msg.obj instanceof DefaultWindow) {
                    this.updateWindow((DefaultWindow)msg.obj);
                }
            } else if (msg.what == MsgDef.SPLASH_HIDE) {
                this.hideSplash();
            }
        }
        return false;
    }

    public void notify(Notification notification) {
        if (notification == null) {
            return;
        }
        if (notification.id == NotificationDef.N_APP_DESTROY) {
            this.mWindow = null;
            this.mSplashView = null;
            this.splashData = null;
        } else if (notification.id == NotificationDef.N_LOGIN_SUCCESS) {
            if (!StringUtils.isEmpty((String)this.actionUrl)) {
                this.handleAction();
            }
        } else if (notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_1_SECONDS) {
            ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).addGameInfoListener(this.mGameInfoChangedListener, false);
            this.saveGameInfos();
        }
    }

    private void notifySplashHidden() {
        MLog.debug((Object)TAG, (String)("notifySplashHidden, actionUrl: " + this.actionUrl), (Object[])new Object[0]);
        if (!StringUtils.isEmpty((String)this.actionUrl)) {
            this.handleAction();
        }
        RuntimeContext.isSplashShowing = false;
        StartupStatHelper.onSplashHidden();
        this.sendMessage(MsgDef.ROOT_SPLASH_HIHHEN);
        SplashManager.INSTANCE.setSplashViewShowIng(false);
        SplashManager.INSTANCE.releaseData();
    }

    private boolean shouldShow(boolean isRestart) {
        if (AccountUtil.isNewRegister()) {
            return false;
        }
        if (SplashManager.INSTANCE.needShowSplash()) {
            return true;
        }
        if (RuntimeContext.getPhoneType() == 1 || !isRestart && RuntimeContext.getPhoneType() == 2) {
            return true;
        }
        if (AccountUtil.getUid() <= 0L) {
            return true;
        }
        return DiskCacheChecker.isAvailableInternalStorgeNotEnough();
    }

    @Override
    public void skipSplash() {
        this.mSplashCountdownComplete = true;
        this.tryHideSplash(false);
        UserEnterActionStat.onSplashCloseClick((String)(this.splashData != null ? this.splashData.splashId : ""));
    }

    @Override
    public void countdownComplete() {
        this.mSplashCountdownComplete = true;
        this.tryHideSplash(false);
    }

    @Override
    public void splashClick(ConfigureSplashData data) {
        String actionUrl;
        if (data == null || TextUtils.isEmpty((CharSequence)(actionUrl = data.mActionUrl))) {
            return;
        }
        SplashManager.INSTANCE.clickSplash(data.splashId);
        this.actionUrl = actionUrl;
        this.mSplashCountdownComplete = true;
        this.tryHideSplash(false);
        UserEnterActionStat.onSplashJump((String)actionUrl);
    }

    private void handleAction() {
        String url = this.actionUrl;
        if (TextUtils.isEmpty((CharSequence)url) || AccountUtil.getUid() <= 0L) {
            return;
        }
        if (this.splashData != null) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20026441").put("startup_id", this.splashData.mId).put("function_id", "click_startup").put("startup_sub_id", this.splashData.splashId).put("gid", this.splashData.gameId));
        }
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"DEBUG", (String)("actionUrl: " + url), (Object[])new Object[0]);
        }
        if (url.startsWith("http://") || url.startsWith("https://")) {
            ((IWebService)this.getServiceManager().getService(IWebService.class)).loadUrl(url, null);
        } else {
            Uri uri = Uri.parse((String)url);
            KvoModuleManager.initEnv();
            MainController.registerNonCoreControllers();
            ((IYYUriService)this.getServiceManager().getService(IYYUriService.class)).handleUri(uri);
        }
        this.actionUrl = null;
    }
}

