/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.setting.privacy;

import android.app.Activity;
import android.content.Context;
import android.os.Message;
import androidx.annotation.NonNull;
import biz.UserInfo;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.permission.Permission;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.permission.helper.PermissionHelperUtil;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.callback.OnKSProfileSingleCallback;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.hiyo.login.account.AccountModel;
import com.yy.hiyo.main.R;
import com.yy.hiyo.main.msg.MsgDef;
import com.yy.hiyo.module.setting.privacy.IPrivacyCallback;
import com.yy.hiyo.module.setting.privacy.PrivacyWindow;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.location.LocationHelper;
import com.yy.location.inner.LocationHandler;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import common.Header;
import ikxd.nearby.ULbs;
import ikxd.nearby.ULbsReportLocationReq;
import ikxd.nearby.ULbsUri;
import org.jetbrains.annotations.NotNull;

public class PrivacyController
extends DefaultController
implements IPrivacyCallback {
    private PrivacyWindow mWindow;
    private UserInfoKS mUserInfo;
    private static final String TAG = "PrivacyController";
    private long mLocationStatus = -1L;

    public PrivacyController(Environment env) {
        super(env);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == MsgDef.OPEN_WINDOW_PRIVACY) {
            this.initWindow();
            this.initData();
        }
    }

    @Override
    public void onFinish() {
        if (this.mWindow != null) {
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mWindow);
            this.mWindow = null;
        }
        this.setRedPointValue();
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (abstractWindow == this.mWindow) {
            this.mWindow = null;
        }
        this.setRedPointValue();
        if (this.mUserInfo != null) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20026523").put("out_stranger_state", String.valueOf(this.mUserInfo.hn)));
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                MLog.info((Object)PrivacyController.TAG, (String)("onWindowDetach mLocationStatus: " + PrivacyController.this.mLocationStatus), (Object[])new Object[0]);
                if (PrivacyController.this.mLocationStatus != -1L) {
                    if (PrivacyController.this.mLocationStatus == 0L) {
                        String[] permissions = Permission.Group.LOCATION;
                        if (PermissionHelperUtil.hasPermission((Activity)PrivacyController.this.getActivity(), (String[])permissions)) {
                            MLog.info((Object)PrivacyController.TAG, (String)"onWindowDetach has locatoin Permission", (Object[])new Object[0]);
                            LocationHandler locationHandler = LocationHelper.getLocationHandler();
                            if (locationHandler != null) {
                                locationHandler.initAndStart();
                            }
                        } else {
                            MLog.info((Object)PrivacyController.TAG, (String)"onWindowDetach has no locatoin Permission", (Object[])new Object[0]);
                        }
                    } else if (PrivacyController.this.mLocationStatus == 1L) {
                        ULbsReportLocationReq req2 = new ULbsReportLocationReq.Builder().longitude(Float.valueOf(0.0f)).latitude(Float.valueOf(0.0f)).build();
                        Header header = new Header.Builder().sname("ikxd_nearby_d").code(Long.valueOf(0L)).lang(SystemUtils.getLangAndCountry()).back_ground(Boolean.valueOf(!RuntimeContext.sIsForeground)).build();
                        ULbs uLbs = new ULbs.Builder().header(header).uri(ULbsUri.kUriULbsReportLocationReq).report_location_req(req2).build();
                        ProtoManager.getInstance().send((AndroidMessage)uLbs, null);
                    }
                }
            }
        });
    }

    private void setRedPointValue() {
        if (!RuntimeContext.isNewInstalled()) {
            SettingFlags.setBoolean((String)"privacy_recommend_discover", (boolean)false);
            MLog.info((Object)TAG, (String)"\u79bb\u5f00\u9690\u79c1\u9875\u9762\u8bbe\u7f6e\u7ea2\u70b9\u53ef\u89c1\u4e3afalse", (Object[])new Object[0]);
        }
    }

    @Override
    public void onFriendRecommendCheckChanged(final long status) {
        if (this.mUserInfo != null) {
            if (this.mWindow != null) {
                this.mWindow.updateRecommendSwitch(status);
            }
            ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).updateRemote(new UserInfo.Builder().hide_recomm(Long.valueOf(1L)).build(), new UserInfo.Builder().hide_recomm(Long.valueOf(status)).build(), new OnKSProfileSingleCallback(){

                public void onUISuccess(@NonNull @NotNull UserInfoKS userInfo) {
                }

                public void onError(String reason, long code) {
                    PrivacyController.this.handleError(reason);
                    PrivacyController.this.resumeRecommendSwitch(status);
                }
            });
        }
    }

    @Override
    public void onLocationCheckChanged(final long status) {
        this.mLocationStatus = status;
        if (this.mUserInfo != null) {
            if (this.mWindow != null) {
                this.mWindow.updateLocationSwitch(status);
            }
            ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).updateRemote(new UserInfo.Builder().hide_location(Long.valueOf(1L)).build(), new UserInfo.Builder().hide_location(Long.valueOf(status)).build(), new OnKSProfileSingleCallback(){

                public void onUISuccess(@NonNull @NotNull UserInfoKS userInfo) {
                }

                public void onError(String reason, long code) {
                    PrivacyController.this.handleError(reason);
                    PrivacyController.this.resumeLocationSwitch(status);
                }
            });
        }
    }

    @Override
    public void onPermissionClick() {
        PermissionHelper.actionToPermissionSetttingPager((Activity)this.getActivity());
    }

    @Override
    public void onStrangersRecommendCheckChanged(final long status) {
        if (this.mUserInfo != null) {
            if (this.mWindow != null) {
                this.mWindow.updateRecommendDiscoverySwitch(status);
            }
            ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).updateRemote(new UserInfo.Builder().hn(Long.valueOf(1L)).build(), new UserInfo.Builder().hn(Long.valueOf(status)).build(), new OnKSProfileSingleCallback(){

                public void onUISuccess(@NonNull @NotNull UserInfoKS userInfo) {
                    MLog.info((Object)PrivacyController.TAG, (String)"\u66f4\u65b0\u964c\u751f\u4eba\u5f00\u5173\u6210\u529f:%s", (Object[])new Object[]{userInfo.hn + ""});
                }

                public void onError(String reason, long code) {
                    MLog.info((Object)PrivacyController.TAG, (String)("\u66f4\u65b0\u964c\u751f\u4eba\u5f00\u5173\u5931\u8d25\uff0c\u5f02\u5e38: " + reason + ", code: " + code), (Object[])new Object[0]);
                    PrivacyController.this.handleError(reason);
                    PrivacyController.this.resumeRecommendDiscoverySwitch(status);
                }
            });
        }
    }

    @Override
    public void onNotifyFollow(final long status) {
        if (this.mUserInfo == null) {
            this.mUserInfo = ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid());
        }
        if (this.mUserInfo != null && this.mUserInfo.ver > 0L) {
            if (this.mWindow != null) {
                this.mWindow.updatetNotifyFollow(status);
            }
        } else {
            MLog.info((Object)TAG, (String)"\u66f4\u65b0\u4e0d\u901a\u77e5\u6211\u5173\u6ce8\u7684\u4eba\u5931\u8d25 \u7531\u4e8e mUserInfo \u4e3a\u7a7a", (Object[])new Object[0]);
            return;
        }
        ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).updateRemote(new UserInfo.Builder().on_micro(Long.valueOf(1L)).build(), new UserInfo.Builder().on_micro(Long.valueOf(status)).build(), new OnKSProfileSingleCallback(){

            public void onUISuccess(@NonNull @NotNull UserInfoKS userInfo) {
                MLog.info((Object)PrivacyController.TAG, (String)"\u66f4\u65b0\u4e0d\u901a\u77e5\u6211\u5173\u6ce8\u7684\u4eba\u5f00\u5173\u6210\u529f:%s", (Object[])new Object[]{userInfo.om + ""});
            }

            public void onError(String reason, long code) {
                MLog.info((Object)PrivacyController.TAG, (String)("\u66f4\u65b0\u4e0d\u901a\u77e5\u6211\u5173\u6ce8\u7684\u4eba\u5f00\u5173\u5931\u8d25\uff0c\u5f02\u5e38: " + reason + ", code: " + code), (Object[])new Object[0]);
                PrivacyController.this.handleError(reason);
                PrivacyController.this.resumeNotifyFoillowed(status);
            }
        });
    }

    private void initWindow() {
        if (this.mWindow != null) {
            this.mWindowMgr.popWindow(false, (AbstractWindow)this.mWindow);
        }
        this.mWindow = new PrivacyWindow(this.mContext, this);
        this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
        if (this.isShowRedPoint()) {
            if (this.isAccountIn()) {
                this.mWindow.setRedPointVisible(0);
            }
        } else {
            this.mWindow.setRedPointVisible(8);
        }
    }

    private boolean isAccountIn() {
        if (AccountModel.getInstance().getAccountInfo() != null && "in".equals(AccountModel.getInstance().getAccountInfo().registerCountry)) {
            if (RuntimeContext.sIsDebuggable) {
                MLog.info((Object)TAG, (String)"\u7528\u6237\u7684\u6ce8\u518c\u56fd\u5bb6\u662f\u5370\u5ea6", (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    private boolean isShowRedPoint() {
        if (RuntimeContext.isNewInstalled()) {
            return false;
        }
        return SettingFlags.getBoolean((String)"privacy_recommend_discover", (boolean)true);
    }

    private void initData() {
        this.mUserInfo = ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid());
        if (this.mWindow != null) {
            this.mWindow.updateSwitchStatus(this.mUserInfo);
        }
    }

    private void showNetworkError() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
            }
        });
    }

    private void handleError(final String msg) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)msg, (int)0);
            }
        });
    }

    private void resumeLocationSwitch(final long status) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (PrivacyController.this.mWindow != null) {
                    PrivacyController.this.mWindow.updateLocationSwitch(status == 1L ? 0L : 1L);
                }
            }
        });
    }

    private void resumeRecommendSwitch(final long status) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (PrivacyController.this.mWindow != null) {
                    PrivacyController.this.mWindow.updateRecommendSwitch(status == 1L ? 0L : 1L);
                }
            }
        });
    }

    private void resumeRecommendDiscoverySwitch(final long status) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (PrivacyController.this.mWindow != null) {
                    PrivacyController.this.mWindow.updateRecommendDiscoverySwitch(status == 1L ? 0L : 1L);
                }
            }
        });
    }

    private void resumeNotifyFoillowed(final long status) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (PrivacyController.this.mWindow != null) {
                    PrivacyController.this.mWindow.updatetNotifyFollow(status == 1L ? 0L : 1L);
                }
            }
        });
    }
}

