/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.setting.envsetting.hookview;

import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.core.view.ScrollingView;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.base.utils.ScreenUtils;
import com.yy.hiyo.module.setting.envsetting.hookview.NotHook;
import com.yy.hiyo.module.setting.envsetting.hookview.ViewBorderDrawable;
import com.yy.hiyo.module.setting.envsetting.hookview.ViewInspectUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;

public class HookViewClickHelper {
    private static final String TAG = "HookViewClickHelper";

    public static void hookViewClick(View view) {
        try {
            Class<?> viewClass = Class.forName("android.view.View");
            Method getListenerInfo = viewClass.getDeclaredMethod("getListenerInfo", new Class[0]);
            getListenerInfo.setAccessible(true);
            Object listenerInfoObj = getListenerInfo.invoke((Object)view, new Object[0]);
            Class<?> infoClass = Class.forName("android.view.View$ListenerInfo");
            Field field = infoClass.getDeclaredField("mOnTouchListener");
            field.setAccessible(true);
            View.OnTouchListener onTouchListener = (View.OnTouchListener)field.get(listenerInfoObj);
            if (onTouchListener == null) {
                view.setOnTouchListener((View.OnTouchListener)new OnTouchListenerProxy(null));
                Log.d((String)TAG, (String)"hookViewClick onClickListener = null");
                return;
            }
            if (onTouchListener instanceof OnTouchListenerProxy) {
                Log.d((String)TAG, (String)("hookViewClick view = " + view + "already hooked"));
                return;
            }
            OnTouchListenerProxy proxy = new OnTouchListenerProxy(onTouchListener);
            field.set(listenerInfoObj, proxy);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("hookViewClick view = " + view + " error:"), (Throwable)e);
        }
    }

    public static void hookCurrentActivity() {
        View decorView = ViewInspectUtil.getRunningActivity().getWindow().getDecorView();
        HookViewClickHelper.hookViews(decorView);
        ViewInspectUtil.clearViewBorder(decorView);
    }

    public static void hookViews(View view) {
        if (view instanceof NotHook) {
            return;
        }
        if (view instanceof ViewGroup) {
            ViewGroup vp = (ViewGroup)view;
            HookViewClickHelper.hookViewClick((View)vp);
            for (int i = 0; i < vp.getChildCount(); ++i) {
                View child = vp.getChildAt(i);
                HookViewClickHelper.hookViews(child);
            }
        } else {
            HookViewClickHelper.hookViewClick(view);
        }
    }

    public static class OnTouchListenerProxy
    implements View.OnTouchListener {
        public static boolean intercept = false;
        private View.OnTouchListener touchListener;
        private static Interceptor interceptor;
        private static LinkedList<View> list;
        private static View targetView;

        public static void setInterceptor(Interceptor interceptor) {
            OnTouchListenerProxy.interceptor = interceptor;
        }

        public OnTouchListenerProxy(View.OnTouchListener clickListener) {
            this.touchListener = clickListener;
        }

        public boolean onTouch(View v, MotionEvent event) {
            if (interceptor != null) {
                if (event.getActionMasked() == 0) {
                    if (this.notHookView(v)) {
                        Log.d((String)HookViewClickHelper.TAG, (String)("down = " + ViewInspectUtil.getViewInfo(v) + ", ignore"));
                    } else {
                        Log.i((String)HookViewClickHelper.TAG, (String)("down = " + ViewInspectUtil.getViewInfo(v)));
                        if (targetView == null) {
                            targetView = v;
                        }
                    }
                } else if (event.getActionMasked() == 1) {
                    if (targetView != null) {
                        LinkedList<View> views = ViewInspectUtil.buildTarget2RootChain(targetView);
                        ViewInspectUtil.clearViewBorder(views.peekLast());
                        interceptor.onTouch(views);
                    }
                    if (intercept) {
                        targetView = null;
                        return true;
                    }
                    targetView = null;
                }
            }
            if (this.touchListener != null) {
                return this.touchListener.onTouch(v, event);
            }
            return false;
        }

        private boolean notHookView(View v) {
            if (v.getWidth() == ScreenUtils.getInstance().getWidthPixels() && v.getHeight() >= ScreenUtils.getInstance().getHeightPixels() || v instanceof YYPlaceHolderView) {
                return true;
            }
            if (v instanceof ScrollingView) {
                return true;
            }
            if (v instanceof ViewGroup && ((ViewGroup)v).getChildCount() == 0) {
                int layers;
                Drawable drawable2 = v.getBackground();
                if (drawable2 == null) {
                    return true;
                }
                if (drawable2 instanceof LayerDrawable && (layers = ((LayerDrawable)drawable2).getNumberOfLayers()) == 1 && (((LayerDrawable)drawable2).getDrawable(0) instanceof ViewBorderDrawable || ((LayerDrawable)drawable2).getDrawable(0) instanceof LayerDrawable)) {
                    return true;
                }
            }
            return false;
        }

        static {
            list = new LinkedList();
            targetView = null;
        }

        public static interface Interceptor {
            public void onTouch(LinkedList<View> var1);
        }
    }
}

