/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.setting.envsetting.debugrouting;

import android.content.Context;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.appcompat.widget.SwitchCompat;
import com.yy.appbase.core.DefaultController;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.Environment;
import com.yy.hiyo.main.R;
import com.yy.hiyo.module.setting.envsetting.debugrouting.RoutingKeyData;

public class DebugRoutingController
extends DefaultController {
    private static final String TAG = "DebugRoutingController";
    private static final String PARCELABLE_ROUTINGKEY_NAME = "parcelable_routing_key";
    private volatile RoutingKeyData mRoutingKeyData;
    String typeCountry = "\u8f93\u5165\u56fd\u5bb6\u7801";
    String typeCid = "\u8f93\u5165CID";
    String typeRegion = "\u8f93\u5165\u5927\u533a";
    RadioGroup radioGroup;
    RadioButton radioButtonRoutingTypeLocal;
    RadioButton radioButtonRoutingTypeCountry;
    RadioButton radioButtonRoutingTypeUID;
    RadioButton radioButtonRoutingTypeCID;
    RadioButton radioButtonRoutingTypeRegion;
    LinearLayout linearLayoutLocalRouting;
    LinearLayout linearLayoutCidCountryRegionRouting;
    LinearLayout linearLayoutUIDRouting;
    AppCompatEditText appCompatEditTextUserName;
    AppCompatEditText appCompatEditTextIpPort;
    AppCompatEditText appCompatEditTextUid;
    AppCompatEditText appCompatEditTextOtherType;
    AppCompatEditText appCompatEditTextSnameFilter;
    SwitchCompat switchCompatUserName;
    SwitchCompat switchCompatUserIpPort;
    SwitchCompat switchCompatWsHttpSelect;
    int selectId = R.id.rb_local_routing;

    public DebugRoutingController(Environment env) {
        super(env);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        this.showDialog();
    }

    private void showDialog() {
        YYTaskExecutor.execute(() -> {
            Object object = FileStorageUtils.getInstance().getObject(PARCELABLE_ROUTINGKEY_NAME);
            this.mRoutingKeyData = object instanceof RoutingKeyData ? (RoutingKeyData)object : new RoutingKeyData();
        }, this::initDialog);
    }

    private void initDialog() {
        View view = LayoutInflater.from((Context)this.getEnvironment().getContext()).inflate(R.layout.routingkey_layout, null);
        this.radioGroup = (RadioGroup)view.findViewById(R.id.radio_group);
        this.radioButtonRoutingTypeLocal = (RadioButton)view.findViewById(R.id.rb_local_routing);
        this.radioButtonRoutingTypeCountry = (RadioButton)view.findViewById(R.id.rb_country_routing);
        this.radioButtonRoutingTypeUID = (RadioButton)view.findViewById(R.id.rb_uid_routing);
        this.radioButtonRoutingTypeCID = (RadioButton)view.findViewById(R.id.rb_cid_routing);
        this.radioButtonRoutingTypeRegion = (RadioButton)view.findViewById(R.id.rb_region_routing);
        this.linearLayoutLocalRouting = (LinearLayout)view.findViewById(R.id.local_routing);
        this.linearLayoutCidCountryRegionRouting = (LinearLayout)view.findViewById(R.id.cid_country_region_routing);
        this.linearLayoutUIDRouting = (LinearLayout)view.findViewById(R.id.uid_routing);
        this.appCompatEditTextUserName = (AppCompatEditText)view.findViewById(R.id.user_name);
        this.appCompatEditTextIpPort = (AppCompatEditText)view.findViewById(R.id.ip_port);
        this.appCompatEditTextUid = (AppCompatEditText)view.findViewById(R.id.user_uid);
        this.appCompatEditTextOtherType = (AppCompatEditText)view.findViewById(R.id.ed_other_type);
        this.appCompatEditTextSnameFilter = (AppCompatEditText)view.findViewById(R.id.sname_filter_txt);
        this.switchCompatUserName = (SwitchCompat)view.findViewById(R.id.sc_user_name);
        this.switchCompatUserIpPort = (SwitchCompat)view.findViewById(R.id.sc_ip_port);
        this.switchCompatWsHttpSelect = (SwitchCompat)view.findViewById(R.id.ws_http_select);
        String snameFilter = SettingFlags.getStringValue((String)"key_sname_filter", (String)"all");
        this.appCompatEditTextSnameFilter.setText((CharSequence)snameFilter);
        boolean isWs = SettingFlags.getBoolean((String)"ws_http_merge", (boolean)true);
        this.switchCompatWsHttpSelect.setChecked(!isWs);
        switch (this.mRoutingKeyData.routingType) {
            case 0: {
                this.selectId = R.id.rb_local_routing;
                this.radioButtonRoutingTypeLocal.setChecked(true);
                this.mRoutingKeyData.pi = 0L;
                if (StringUtils.isNotEmpty((String)this.mRoutingKeyData.ip)) {
                    this.switchCompatUserIpPort.setChecked(true);
                    this.appCompatEditTextIpPort.setText((CharSequence)this.mRoutingKeyData.ip);
                    this.mRoutingKeyData.serviceGroup = "";
                    break;
                }
                if (StringUtils.isNotEmpty((String)this.mRoutingKeyData.serviceGroup)) {
                    this.switchCompatUserName.setChecked(true);
                    this.appCompatEditTextUserName.setText((CharSequence)this.mRoutingKeyData.serviceGroup);
                    this.mRoutingKeyData.ip = "";
                    break;
                }
                this.switchCompatUserName.setChecked(true);
                break;
            }
            case 1: {
                this.selectId = R.id.rb_country_routing;
                this.radioButtonRoutingTypeCountry.setChecked(true);
                if (!StringUtils.isNotEmpty((String)this.mRoutingKeyData.ps)) break;
                this.appCompatEditTextOtherType.setText((CharSequence)this.mRoutingKeyData.ps);
                break;
            }
            case 2: {
                this.selectId = R.id.rb_uid_routing;
                this.radioButtonRoutingTypeUID.setChecked(true);
                if (this.mRoutingKeyData.pi == -1L) break;
                this.appCompatEditTextUid.setText((CharSequence)(this.mRoutingKeyData.pi + ""));
                break;
            }
            case 3: {
                this.selectId = R.id.rb_cid_routing;
                this.radioButtonRoutingTypeCID.setChecked(true);
                if (!StringUtils.isNotEmpty((String)this.mRoutingKeyData.ps)) break;
                this.appCompatEditTextOtherType.setText((CharSequence)this.mRoutingKeyData.ps);
                break;
            }
            case 4: {
                this.selectId = R.id.rb_region_routing;
                this.radioButtonRoutingTypeRegion.setChecked(true);
                if (!StringUtils.isNotEmpty((String)this.mRoutingKeyData.ps)) break;
                this.appCompatEditTextOtherType.setText((CharSequence)this.mRoutingKeyData.ps);
                break;
            }
        }
        boolean localRouting = true;
        boolean uidRouting = false;
        this.linearLayoutLocalRouting.setVisibility(localRouting ? 0 : 8);
        this.linearLayoutCidCountryRegionRouting.setVisibility(localRouting ? 8 : 0);
        this.linearLayoutUIDRouting.setVisibility(uidRouting ? 0 : 8);
        this.radioGroup.setOnCheckedChangeListener((group, checkedId) -> {
            this.selectId = checkedId;
            MLog.error((Object)"DebugRouting", (String)("checkedId " + checkedId), (Object[])new Object[0]);
            boolean isLocalRouting = checkedId == R.id.rb_local_routing;
            boolean isUidRouting = checkedId == R.id.rb_uid_routing;
            this.linearLayoutLocalRouting.setVisibility(isLocalRouting ? 0 : 8);
            this.linearLayoutCidCountryRegionRouting.setVisibility(isLocalRouting || isUidRouting ? 8 : 0);
            this.linearLayoutUIDRouting.setVisibility(isUidRouting ? 0 : 8);
            if (checkedId == R.id.rb_cid_routing) {
                this.appCompatEditTextOtherType.setHint((CharSequence)this.typeCid);
            } else if (checkedId == R.id.rb_country_routing) {
                this.appCompatEditTextOtherType.setHint((CharSequence)this.typeCountry);
            } else if (checkedId == R.id.rb_region_routing) {
                this.appCompatEditTextOtherType.setHint((CharSequence)this.typeRegion);
            }
        });
        this.switchCompatUserName.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if (isChecked) {
                this.switchCompatUserIpPort.setChecked(false);
                this.appCompatEditTextIpPort.setFocusable(false);
                this.appCompatEditTextIpPort.setFocusableInTouchMode(false);
                this.appCompatEditTextUserName.setFocusableInTouchMode(true);
                this.appCompatEditTextUserName.setFocusable(true);
                this.appCompatEditTextUserName.requestFocus();
            }
        });
        this.switchCompatUserIpPort.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if (isChecked) {
                this.switchCompatUserName.setChecked(false);
                this.appCompatEditTextUserName.setFocusable(false);
                this.appCompatEditTextUserName.setFocusableInTouchMode(false);
                this.appCompatEditTextIpPort.setFocusableInTouchMode(true);
                this.appCompatEditTextIpPort.setFocusable(true);
                this.appCompatEditTextIpPort.requestFocus();
            }
        });
        this.switchCompatWsHttpSelect.setOnCheckedChangeListener((buttonView, isChecked) -> SettingFlags.setBoolean((String)"ws_http_merge", (!isChecked ? 1 : 0) != 0));
        new AlertDialog.Builder(this.getEnvironment().getContext()).setView(view).setTitle((CharSequence)"RoutingKey Setting").setCancelable(false).setPositiveButton((CharSequence)"Ok", (dialog, which) -> {
            this.buildRoutingKeyData();
            YYTaskExecutor.execute(this::saveObject);
        }).setNegativeButton((CharSequence)"Cancel", (dialog, which) -> {}).show();
    }

    private void buildRoutingKeyData() {
        if (this.selectId == R.id.rb_local_routing) {
            this.mRoutingKeyData.routingType = 0;
            if (this.switchCompatUserName.isChecked()) {
                this.mRoutingKeyData.serviceGroup = this.appCompatEditTextUserName.getText().toString().trim();
                this.mRoutingKeyData.ip = "";
            } else if (this.switchCompatUserIpPort.isChecked()) {
                this.mRoutingKeyData.ip = this.appCompatEditTextIpPort.getText().toString().trim();
                this.mRoutingKeyData.serviceGroup = "";
            }
        } else if (this.selectId == R.id.rb_country_routing) {
            this.mRoutingKeyData.routingType = 1;
            this.mRoutingKeyData.ps = this.appCompatEditTextOtherType.getText().toString().trim();
        } else if (this.selectId == R.id.rb_uid_routing) {
            this.mRoutingKeyData.routingType = 2;
            String value = this.appCompatEditTextUid.getText().toString().trim();
            if (StringUtils.isNotEmpty((String)value)) {
                this.mRoutingKeyData.pi = Long.parseLong(value);
            }
        } else if (this.selectId == R.id.rb_cid_routing) {
            this.mRoutingKeyData.routingType = 3;
            this.mRoutingKeyData.ps = this.appCompatEditTextOtherType.getText().toString().trim();
        } else if (this.selectId == R.id.rb_region_routing) {
            this.mRoutingKeyData.routingType = 4;
            this.mRoutingKeyData.ps = this.appCompatEditTextOtherType.getText().toString().trim();
        }
    }

    private void saveObject() {
        String json = JsonParser.toJson((Object)this.mRoutingKeyData);
        MLog.debug((Object)TAG, (String)("Debug RoutingKey json " + json), (Object[])new Object[0]);
        String snameFilter = this.appCompatEditTextSnameFilter.getText().toString().trim();
        SettingFlags.setStringValue((String)"key_sname_filter", (String)(StringUtils.isEmpty((String)snameFilter) ? "all" : snameFilter));
        SettingFlags.setStringValue((String)"key_debug_switch_version", (String)json);
        FileStorageUtils.getInstance().saveObject((Object)this.mRoutingKeyData, PARCELABLE_ROUTINGKEY_NAME);
    }
}

