/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.push.tip;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import com.yy.appbase.core.DefaultController;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.NotificationsUtils;
import com.yy.base.utils.PackageUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiyo.module.push.tip.IPushTipCallBacks;
import com.yy.hiyo.module.push.tip.PushTipDialog;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.util.Properties;

public class PushTipManager
extends DefaultController {
    private static final String TAG = "PushTipManager";
    private IPushTipCallBacks mPushTipCallBacks = new IPushTipCallBacks(){

        @Override
        public void performOk() {
            PushTipManager.toNotificationSetting((Activity)PushTipManager.this.mContext);
            PushTipManager.this.mDialogLinkManager.dismissDialog();
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("50501").label("0002"));
        }

        @Override
        public void performCancel() {
            PushTipManager.this.mDialogLinkManager.dismissDialog();
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("50501").label("0003"));
        }
    };

    public PushTipManager(Environment baseEnv) {
        super(baseEnv);
    }

    public void showDialog() {
        PushTipDialog pushTipDialog = new PushTipDialog(this.mPushTipCallBacks);
        if (!NotificationsUtils.isNotificationEnabled((Context)this.mContext)) {
            this.mDialogLinkManager.showDialog((BaseDialog)pushTipDialog);
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("50501").label("0001"));
    }

    public static void toNotificationSetting(Activity activity) {
        if ("OPPO".equalsIgnoreCase(Build.MANUFACTURER)) {
            PushTipManager.startColorOSNotificationManager(activity);
        } else if ("vivo".equalsIgnoreCase(Build.MANUFACTURER)) {
            PushTipManager.startFuntouchOSNotificationManager(activity);
        } else {
            PushTipManager.startSettingPage(activity);
        }
    }

    public static void toNotificationAppSetting(Activity activity) {
        PushTipManager.startAppSettingPage(activity);
    }

    private static void startColorOSNotificationManager(Activity activity) {
        String colorOSVersion = PushTipManager.getColorOSVersion();
        if (TextUtils.isEmpty((CharSequence)colorOSVersion)) {
            PushTipManager.startSettingPage(activity);
            return;
        }
        String packageName = null;
        String activityName = null;
        if ("v2.1".equals(colorOSVersion)) {
            packageName = "com.oppo.notification.center";
            activityName = "com.oppo.notification.center.AppDetailActivity";
        } else if ("v3.0".equals(colorOSVersion) || "v3.0.0".equals(colorOSVersion)) {
            packageName = "com.coloros.notificationmanager";
            activityName = "com.coloros.notificationmanager.AppDetailPreferenceActivity";
        } else {
            PushTipManager.startSettingPage(activity);
            return;
        }
        Intent intent = new Intent();
        intent.setComponent(new ComponentName(packageName, activityName));
        intent.putExtra("pkg_name", RuntimeContext.sPackageName);
        intent.putExtra("app_name", PackageUtils.getAppName((Context)activity));
        intent.setFlags(0x10000000);
        try {
            activity.startActivity(intent);
        }
        catch (Exception e) {
            PushTipManager.startSettingPage(activity);
        }
    }

    private static void startFuntouchOSNotificationManager(Activity activity) {
        String funtouchOSVersion = PushTipManager.getFuntouchOSVersion();
        if (TextUtils.isEmpty((CharSequence)funtouchOSVersion)) {
            PushTipManager.startSettingPage(activity);
            return;
        }
        String packageName = null;
        String activityName = null;
        if ("2.5".equals(funtouchOSVersion)) {
            packageName = "com.android.systemui";
            activityName = "com.android.systemui.vivo.common.notification.StatusbarSettingActivity";
        } else if ("3.1".equals(funtouchOSVersion)) {
            packageName = "com.android.systemui";
            activityName = "com.vivo.systemui.statusbar.notification.settings.StatusbarSettingActivity";
        } else {
            PushTipManager.startSettingPage(activity);
            return;
        }
        Intent intent = new Intent();
        intent.setComponent(new ComponentName(packageName, activityName));
        intent.setFlags(0x10000000);
        try {
            activity.startActivity(intent);
        }
        catch (Exception e) {
            PushTipManager.startSettingPage(activity);
        }
    }

    private static String getColorOSVersion() {
        return PushTipManager.getBuildPropFileProperty("ro.build.version.opporom");
    }

    private static String getFuntouchOSVersion() {
        return PushTipManager.getBuildPropFileProperty("ro.vivo.os.version");
    }

    private static String getBuildPropFileProperty(String property) {
        FileInputStream fileInputStream = null;
        String value = null;
        try {
            fileInputStream = new FileInputStream(new File(android.os.Environment.getRootDirectory(), "build.prop"));
            Properties properties = new Properties();
            properties.load(fileInputStream);
            Class<?> clzSystemProperties = Class.forName("android.os.SystemProperties");
            Method getMethod = clzSystemProperties.getDeclaredMethod("get", String.class);
            value = PushTipManager.getLowerCaseName(properties, getMethod, property);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    private static String getLowerCaseName(Properties p, Method get, String key) {
        String name = p.getProperty(key);
        if (name == null) {
            try {
                name = (String)get.invoke(null, key);
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        }
        if (name != null) {
            name = name.toLowerCase();
        }
        return name;
    }

    private static void startSettingPage(Activity activity) {
        try {
            Intent intent = new Intent("android.settings.SETTINGS");
            activity.startActivity(intent);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"startSettingPage", (Throwable)e, (Object[])new Object[0]);
        }
    }

    private static void startAppSettingPage(Activity activity) {
        try {
            Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
            Uri uri = Uri.fromParts((String)"package", (String)RuntimeContext.sPackageName, null);
            intent.setData(uri);
            activity.startActivity(intent);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"startAppSettingPage", (Throwable)e, (Object[])new Object[0]);
        }
    }
}

