/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.preconnect;

import android.net.Uri;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.unifyconfig.config.HostPreConnectConfig;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.GraceWrapper;
import com.yy.base.utils.SettingFlags;
import com.yy.grace.NetworkConverter;
import com.yy.hiyo.login.account.AccountModel;
import java.util.List;

public class HostPreConnectManager {
    private static final String TAG = "HostPreConnectManager";
    private static final long PRE_CONNECT_TIME_INTERVAL = 300000L;
    private long mStartChannelPreConnectTime = 0L;
    private long mStartRechargePreConnectTime = 0L;

    private HostPreConnectManager() {
    }

    public static HostPreConnectManager getInstance() {
        return SingleHolder.INSTANCE;
    }

    public void preConnectLogin() {
        if (AccountModel.isExistLoginedAccount()) {
            MLog.info((Object)TAG, (String)"preConnectLogin cancel, logined", (Object[])new Object[0]);
            return;
        }
        if (HostPreConnectManager.isNotEnablePreConnect()) {
            return;
        }
        List lists = HostPreConnectConfig.getLoginHostNetWorkMapArrayList();
        if (lists.size() == 0) {
            NetworkConverter.Factory.HostNetWorkMap hostNetWorkMap = new NetworkConverter.Factory.HostNetWorkMap();
            String loginHost = UriProvider.getLoginHost() + "";
            Uri loginUri = Uri.parse((String)loginHost);
            MLog.info((Object)TAG, (String)("preConnectLogin host: " + loginUri.getHost()), (Object[])new Object[0]);
            hostNetWorkMap.host = loginUri.getHost();
            hostNetWorkMap.networkList.add(GraceWrapper.okhttpNetwork());
            lists.add(hostNetWorkMap);
            MLog.info((Object)TAG, (String)"using default login host", (Object[])new Object[0]);
        }
        GraceWrapper.getGrace().preConnectionStreams(1, lists);
    }

    public void preConnectChannel() {
        if (HostPreConnectManager.isNotEnablePreConnect()) {
            return;
        }
        long interval = System.currentTimeMillis() - this.mStartChannelPreConnectTime;
        if (interval > 300000L) {
            this.mStartChannelPreConnectTime = System.currentTimeMillis();
            GraceWrapper.getGrace().preConnectionStreams(1, HostPreConnectConfig.getChannelHostNetWorkMapArrayList());
        }
    }

    public void preConnectRecharge() {
        if (HostPreConnectManager.isNotEnablePreConnect()) {
            return;
        }
        long interval = System.currentTimeMillis() - this.mStartRechargePreConnectTime;
        if (interval > 300000L) {
            this.mStartRechargePreConnectTime = System.currentTimeMillis();
            GraceWrapper.getGrace().preConnectionStreams(1, HostPreConnectConfig.getRechargeHostNetWorkMapArrayList());
        }
    }

    public static boolean isNotEnablePreConnect() {
        return !SettingFlags.getBoolean((String)"key_pre_connect_enable", (boolean)true);
    }

    private static final class SingleHolder {
        private static final HostPreConnectManager INSTANCE = new HostPreConnectManager();

        private SingleHolder() {
        }
    }
}

