/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.performancemonitor.perfcollect.yytask;

import android.os.Debug;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.unifyconfig.config.taskopt.TaskOptConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.logger.PathLog;
import com.yy.base.taskexecutor.IIdleExecutor;
import com.yy.base.taskexecutor.SdkNormalExecutorAdapter;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import java.util.ArrayList;

public class IdleExecutor
implements IIdleExecutor,
INotify {
    private SdkNormalExecutorAdapter executorAdapter;
    private ArrayList<MyRunnable> mRunnablesToPost = new ArrayList(10);
    private ArrayList<RunnableEx> mDelayRunnables = new ArrayList(5);
    private boolean mHasAfterTimeOutCheck = false;
    private static PathLog.IPathLogItem sLogItem;

    public IdleExecutor(String id2) {
        this.executorAdapter = new SdkNormalExecutorAdapter(1, id2);
        Runnable command = new Runnable(){

            @Override
            public void run() {
                NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED_AFTER_1_SECONDS, (INotify)IdleExecutor.this);
                NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED_AFTER_3_SECONDS, (INotify)IdleExecutor.this);
                NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED_AFTER_5_SECONDS, (INotify)IdleExecutor.this);
            }
        };
        if (YYTaskExecutor.isMainThread()) {
            command.run();
        } else {
            YYTaskExecutor.postToMainThread((Runnable)command);
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                IdleExecutor.this.handleToPostRunnables();
                IdleExecutor.this.mHasAfterTimeOutCheck = true;
                MLog.info((Object)"IdleExecutor", (String)"TimeOutCheck!", (Object[])new Object[0]);
                IdleExecutor.this.addPathLog("TimeOutCheck!", new Object[0]);
                if (SystemUtils.isShowEnvSetting()) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            IdleExecutor.getPathLogger().end("TimeOut", new Object[0]);
                        }
                    }, (long)30000L);
                }
            }
        }, (long)20000L);
        MLog.info((Object)"IdleExecutor", (String)"init!", (Object[])new Object[0]);
        this.addPathLog("init!", new Object[0]);
    }

    public void execute(Runnable task) {
        this.execute(task, 0L);
    }

    public void execute(Runnable task, long delayTime) {
        this.execute(task, delayTime, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(final Runnable task, final long delayTime, long maxWaitTime) {
        if (!SystemUtils.isShowEnvSetting() && !TaskOptConfig.isIdleExecuteSwitch() || !RuntimeContext.sIsMainProcess) {
            YYTaskExecutor.execute((Runnable)task, (long)delayTime);
            return;
        }
        if (SystemUtils.isShowEnvSetting()) {
            this.addPathLog("start execute task:%s, delayTime:%s!", task, delayTime);
        }
        if (delayTime > 0L) {
            Runnable runnable;
            final RunnableEx item = new RunnableEx(task, null);
            item.taskSubmit = runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (SystemUtils.isShowEnvSetting()) {
                        IdleExecutor.this.addPathLog("delay Runnable executed:%s, originTask:%s, delayTime:%s!", new Object[]{this, task, delayTime});
                    }
                    ArrayList arrayList = IdleExecutor.this.mDelayRunnables;
                    synchronized (arrayList) {
                        IdleExecutor.this.mDelayRunnables.remove(item);
                    }
                    IdleExecutor.this.executereal(task);
                }
            };
            ArrayList<RunnableEx> arrayList = this.mDelayRunnables;
            synchronized (arrayList) {
                this.mDelayRunnables.add(item);
            }
            YYTaskExecutor.execute((Runnable)runnable, (long)delayTime);
            if (SystemUtils.isShowEnvSetting()) {
                this.addPathLog("start execute delay Runnable:%s, originTask:%s, delayTime:%s!", runnable, task, delayTime);
            }
            if (SystemUtils.isShowEnvSetting() && !RuntimeContext.isLocalBuild() && !Debug.isDebuggerConnected()) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ArrayList arrayList = IdleExecutor.this.mDelayRunnables;
                        synchronized (arrayList) {
                            if (IdleExecutor.this.mDelayRunnables.contains(item)) {
                                IdleExecutor.getPathLogger().end("happen exception", new Object[0]);
                                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        throw new RuntimeException("Why delayRunnable " + item.taskSubmit + " not run after 30000!");
                                    }
                                }, (long)5000L);
                            }
                        }
                    }
                }, (long)(delayTime + 30000L));
            }
        } else if (RuntimeContext.sIsAppStartFinishAfterOneSecond || this.mHasAfterTimeOutCheck || AccountUtil.getUid() <= 0L) {
            this.executereal(task);
        } else {
            if (SystemUtils.isShowEnvSetting()) {
                this.addPathLog("add task to RunnablesToPost:%s, delayTime:%s!", task, delayTime);
            }
            ArrayList<MyRunnable> arrayList = this.mRunnablesToPost;
            synchronized (arrayList) {
                this.mRunnablesToPost.add(new MyRunnable(task, delayTime, maxWaitTime));
            }
        }
        if (SystemUtils.isShowEnvSetting() && !RuntimeContext.isLocalBuild() && !Debug.isDebuggerConnected()) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ArrayList arrayList = IdleExecutor.this.mDelayRunnables;
                    synchronized (arrayList) {
                        if (IdleExecutor.this.executorAdapter.isTaskToRun(task)) {
                            IdleExecutor.getPathLogger().end("happen exception", new Object[0]);
                            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    throw new RuntimeException("Why " + task + " not run after 30000, still in queue!");
                                }
                            }, (long)5000L);
                        }
                    }
                }
            }, (long)(delayTime + 30000L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Runnable task) {
        if (SystemUtils.isShowEnvSetting()) {
            this.addPathLog("remove task:%s!", task);
        }
        ArrayList<Object> arrayList = this.mDelayRunnables;
        synchronized (arrayList) {
            if (this.mDelayRunnables.size() > 0) {
                for (RunnableEx runnableEx : this.mDelayRunnables) {
                    if (runnableEx.taskOringin != task) continue;
                    this.mDelayRunnables.remove(runnableEx);
                    this.executorAdapter.remove(runnableEx.taskSubmit);
                    break;
                }
            }
        }
        arrayList = this.mRunnablesToPost;
        synchronized (arrayList) {
            if (this.mRunnablesToPost.size() > 0) {
                for (MyRunnable myRunnable : this.mRunnablesToPost) {
                    if (myRunnable.task != task) continue;
                    this.mRunnablesToPost.remove(myRunnable);
                    break;
                }
            }
        }
        this.executorAdapter.remove(task);
    }

    private void executereal(Runnable task) {
        this.executorAdapter.execute(task);
        if (SystemUtils.isShowEnvSetting()) {
            this.addPathLog(" post task to executorAdapter queue:%s", task.toString());
        }
    }

    public void notify(Notification notification) {
        if (notification != null && (notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_1_SECONDS || notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_3_SECONDS || notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_5_SECONDS)) {
            if (SystemUtils.isShowEnvSetting()) {
                this.addPathLog("handleNotify:%d!", notification.id);
            }
            if (RuntimeContext.getPhoneType() != 1 || notification.id != NotificationDef.N_STARTUP_FINISHED_AFTER_1_SECONDS) {
                this.handleToPostRunnables();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleToPostRunnables() {
        MLog.info((Object)"IdleExecutor", (String)"handleToPostRunnables!", (Object[])new Object[0]);
        this.addPathLog("handleToPostRunnables!", new Object[0]);
        ArrayList<MyRunnable> arrayList = this.mRunnablesToPost;
        synchronized (arrayList) {
            if (this.mRunnablesToPost.size() > 0) {
                for (MyRunnable task : this.mRunnablesToPost) {
                    this.executereal(task.task);
                }
                this.mRunnablesToPost.clear();
            }
        }
    }

    private void addPathLog(String msgFormat, Object ... args) {
        if (!SystemUtils.isShowEnvSetting()) {
            return;
        }
        IdleExecutor.getPathLogger().add(msgFormat, args);
    }

    public static PathLog.IPathLogItem getPathLogger() {
        if (sLogItem != null) {
            return sLogItem;
        }
        sLogItem = PathLog.startWithInfoLevel((String)"IdleExecutor", (String)"onStart!", (Object[])new Object[0]);
        return sLogItem;
    }

    private static class RunnableEx {
        Runnable taskOringin;
        Runnable taskSubmit;

        RunnableEx(Runnable taskOringin, Runnable taskSubmit) {
            this.taskOringin = taskOringin;
            this.taskSubmit = taskSubmit;
        }
    }

    private static class MyRunnable {
        Runnable task;
        long maxWaitTime;
        long delayTime;

        MyRunnable(Runnable task, long delayTime, long maxWaitTime) {
            this.task = task;
            this.delayTime = delayTime;
            this.maxWaitTime = maxWaitTime;
        }
    }
}

