/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.performancemonitor.perfcollect.network.prevent;

import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.http.IHttpRequestSender;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.unifyconfig.config.NetPreventDuplicateConfig;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import com.yy.hiyo.module.performancemonitor.perfcollect.network.prevent.HttpRequestPreventDuplicateUtil;
import com.yy.hiyo.module.performancemonitor.perfcollect.network.prevent.ProtoRequestPreventDuplicateUtil;
import com.yy.hiyo.proto.callback.DefaultCacheEffectiveTimeUtil;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.preventduplicater.IProtoRequestRealSender;
import com.yy.hiyo.proto.rpc.RpcMethod;
import java.util.Map;

public class RequestPreventDuplicater {
    private static final String TAG = "RequestPreventDuplicater";

    public static <Data> void httpReq(String url, byte[] postContent, Map<String, String> param, int type2, INetRespCallback<Data> callback, Map<String, String> headDataToAdd, IHttpRequestSender sender) {
        HttpRequestPreventDuplicateUtil.httpReq(url, postContent, param, type2, callback, headDataToAdd, sender);
    }

    public static <REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> void sendProtoRequest(String roomId, REQ proto, RpcMethod<REQ, RES> rpcMethod, @Nullable IProtoCallback<RES> callback, boolean isWsRequest, IProtoRequestRealSender sender) {
        ProtoRequestPreventDuplicateUtil.sendProtoRequest(roomId, proto, rpcMethod, callback, isWsRequest, sender);
    }

    public static <REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> boolean isProtoRequestNeedPrevent(String roomId, REQ proto, RpcMethod<REQ, RES> rpcMethod, @Nullable IProtoCallback<RES> callback, boolean isWsRequest) {
        return ProtoRequestPreventDuplicateUtil.isProtoRequestNeedPrevent(roomId, proto, rpcMethod, callback, isWsRequest);
    }

    public static void init() {
        RequestPreventDuplicater.onConfigUpdate();
        HttpRequestPreventDuplicateUtil.registerNotifys();
        ProtoRequestPreventDuplicateUtil.init();
    }

    public static void onConfigUpdate() {
        if (SettingFlags.containKey((String)"netduplicater")) {
            SettingFlags.removeKey((String)"netduplicater");
        }
        if (SystemUtils.isShowEnvSetting()) {
            DefaultCacheEffectiveTimeUtil.setDefaultHttpCacheEffectiveTime((long)3000L);
            DefaultCacheEffectiveTimeUtil.setDefaultProtoCacheEffectiveTime((long)3000L);
        } else {
            DefaultCacheEffectiveTimeUtil.setDefaultHttpCacheEffectiveTime((long)NetPreventDuplicateConfig.getDefaultCacheEffectiveTime((int)1));
            DefaultCacheEffectiveTimeUtil.setDefaultProtoCacheEffectiveTime((long)NetPreventDuplicateConfig.getDefaultCacheEffectiveTime((int)2));
        }
    }
}

