/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.performancemonitor.perfcollect.network.prevent;

import android.os.SystemClock;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.unifyconfig.config.NetPreventDuplicateConfig;
import com.yy.appbase.unifyconfig.config.NetPreventDuplicateConfigItem;
import com.yy.base.env.RuntimeContext;
import com.yy.base.env.TargetBuildConstant;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.preventduplicater.BaseProtoPreventDuplicater;
import com.yy.hiyo.proto.preventduplicater.IProtoRequestRealSender;
import com.yy.hiyo.proto.preventduplicater.ProtoPreventDuplicateSender;
import com.yy.hiyo.proto.rpc.RpcMethod;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import net.ihago.channel.srv.mgr.GetBannedStatusReq;

public class ProtoRequestPreventDuplicateUtil {
    public static <REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> void sendProtoRequest(String roomId, REQ proto, RpcMethod<REQ, RES> rpcMethod, @Nullable IProtoCallback<RES> callback, boolean isWsRequest, IProtoRequestRealSender sender) {
        if (isWsRequest) {
            ProtoPreventDuplicateSender.getRpcSender(proto.getClass()).send(roomId, proto, rpcMethod, callback, ProtoRequestPreventDuplicateUtil.createRequestCompare(proto, rpcMethod), sender);
        } else {
            ProtoPreventDuplicateSender.getHttpSender(proto.getClass()).send(roomId, proto, rpcMethod, callback, ProtoRequestPreventDuplicateUtil.createRequestCompare(proto, rpcMethod), sender);
        }
    }

    private static <REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> BaseProtoPreventDuplicater.IRequestCompare<REQ> createRequestCompare(REQ proto, final RpcMethod<REQ, RES> rpcMethod) {
        return new BaseProtoPreventDuplicater.IRequestCompare<REQ>(){

            public boolean equal(REQ one, REQ two) {
                boolean result;
                boolean bl = result = one != null && two != null && one.equals(two);
                if (!result && RuntimeContext.sIsDebuggable) {
                    String[] strTwos;
                    String str = one.toString();
                    String strTwo = two.toString();
                    if (str.length() <= 0) {
                        return false;
                    }
                    String[] strs = str.split(",");
                    if (strs.length != (strTwos = strTwo.split(",")).length) {
                        return false;
                    }
                    for (int i = 0; i < strs.length; ++i) {
                        if (StringUtils.equal((String)strs[i], (String)strTwos[i]) || strs[i].replaceAll(" ", "").startsWith("seqid=")) continue;
                        return false;
                    }
                    MLog.error((Object)"ProtoPreventDuplicater", (String)"httpRpc find request just because seqid no equal:%s", (Object[])new Object[]{strTwo});
                }
                return result;
            }

            public String serviceName() {
                if (rpcMethod == null) {
                    return "";
                }
                return rpcMethod.sName;
            }

            public String methodName() {
                if (rpcMethod == null) {
                    return "";
                }
                return rpcMethod.methodName;
            }
        };
    }

    static void test() {
        if (!SystemUtils.isShowEnvSetting()) {
            return;
        }
        ArrayList<Integer> one = new ArrayList<Integer>();
        one.add(808080);
        GetBannedStatusReq req2 = new GetBannedStatusReq.Builder().cid("1111").uids(one).build();
        GetBannedStatusReq reqTwo = new GetBannedStatusReq.Builder().cid("2222").uids(one).build();
        ArrayList<Integer> two = new ArrayList<Integer>();
        two.add(808080);
        two.add(808080);
        GetBannedStatusReq reqThree = new GetBannedStatusReq.Builder().cid("2222").uids(two).build();
        if (req2.equals((Object)reqTwo)) {
            throw new RuntimeException("happen error!");
        }
        if (reqThree.equals((Object)reqTwo)) {
            throw new RuntimeException("happen error!");
        }
    }

    public static <REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> boolean isProtoRequestNeedPrevent(String roomId, REQ proto, RpcMethod<REQ, RES> rpcMethod, @Nullable IProtoCallback<RES> callback, boolean isWsRequest) {
        if (!NetPreventDuplicateConfig.isNetPreventDuplicateSwitchOn((int)2)) {
            if (SystemUtils.isShowEnvSetting()) {
                MLog.info((Object)"ProtoPreventDuplicateSender", (String)"PreventDuplicate switch is false!", (Object[])new Object[0]);
            }
            return false;
        }
        NetPreventDuplicateConfigItem item = NetPreventDuplicateConfig.getItem((int)2, (String)"", (String)rpcMethod.sName, (String)rpcMethod.methodName);
        long result = -1L;
        if (callback != null && callback.getCacheEffectiveTime() == Long.MIN_VALUE) {
            return false;
        }
        if (item != null) {
            result = item.swtichOn ? (long)item.cacheEffectiveTime : 0L;
        } else {
            long l = result = callback != null ? callback.getCacheEffectiveTime() : 0L;
        }
        return result > 0L;
    }

    public static void init() {
        ProtoPreventDuplicateSender.setCallback((BaseProtoPreventDuplicater.IProtoPreventDuplicaterCallback)new BaseProtoPreventDuplicater.IProtoPreventDuplicaterCallback(){

            public long getDefaultProtoCacheEffectiveTime(@Nullable IProtoCallback callback, BaseProtoPreventDuplicater.IRequestCompare compare) {
                NetPreventDuplicateConfigItem item = NetPreventDuplicateConfig.getItem((int)2, (String)"", (String)compare.serviceName(), (String)compare.methodName());
                long result = -1L;
                if (item != null) {
                    result = item.swtichOn ? (long)item.cacheEffectiveTime : 0L;
                } else {
                    long l = result = callback != null ? callback.getCacheEffectiveTime() : 0L;
                }
                if (SystemUtils.isShowEnvSetting()) {
                    MLog.info((Object)"ProtoPreventDuplicateSender", (String)"getCacheEffectiveTime:%s, method:%s, result:%d", (Object[])new Object[]{compare.serviceName(), compare.methodName(), result});
                }
                return result;
            }

            public void onDuplicateRequest(boolean isRequesting, BaseProtoPreventDuplicater.IRequestCompare compare, int preventNum, int totalNum, int preventNumInCacheTime) {
                if (compare == null || StringUtils.isEmpty((String)compare.serviceName())) {
                    return;
                }
                if (preventNumInCacheTime > 80 && !RuntimeContext.sIsAutoTesting && !TargetBuildConstant.auto_test && !TargetBuildConstant.autoLogin && SystemUtils.isShowEnvSetting()) {
                    throw new RuntimeException("maybe happen \u6b7b\u5faa\u73af\u8bf7\u6c42\uff0c\u77ed\u65f6\u95f4\u53d1\u9001\u4e86100\u6b21\u540c\u6837\u7684\u8bf7\u6c42:" + compare.serviceName() + ", method:" + compare.methodName());
                }
                if (!SystemUtils.isShowEnvSetting() && !NetPreventDuplicateConfig.isStatSwitchOn()) {
                    return;
                }
                StatisContent statContent = new StatisContent();
                statContent.put("act", "hagoperf");
                statContent.put("ifield", isRequesting ? 1 : 0);
                if (preventNumInCacheTime > 5) {
                    statContent.put("ifieldtwo", preventNumInCacheTime);
                }
                statContent.put("sfield", "proto");
                statContent.put("sfieldtwo", "prevent");
                statContent.put("sfieldthree", compare.serviceName() + "_" + compare.methodName());
                statContent.put("sfieldfour", String.valueOf(AccountUtil.getUid()));
                statContent.put("sfieldfive", RuntimeContext.getChannelId());
                statContent.put("perftype", "net_prevent_duplicate");
                HiidoStatis.reportContent((StatisContent)statContent);
            }

            public void maybeDuplicateRequest(BaseProtoPreventDuplicater preventDuplicater, long lastReqStartTime, BaseProtoPreventDuplicater.IRequestCompare compare, AndroidMessage req2, AndroidMessage reqCompare) {
                if (compare == null || StringUtils.isEmpty((String)compare.serviceName())) {
                    return;
                }
                if (!SystemUtils.isShowEnvSetting() && !NetPreventDuplicateConfig.isStatSwitchOn()) {
                    return;
                }
                boolean statCalculationTime = NetPreventDuplicateConfig.isStatCalculationTimeSwitchOn();
                long lastTime = statCalculationTime ? SystemClock.uptimeMillis() : 0L;
                long curTime = 0L;
                boolean isEqual = compare.equal(req2, reqCompare);
                if (statCalculationTime) {
                    curTime = SystemClock.uptimeMillis();
                }
                if (isEqual) {
                    if (curTime == 0L) {
                        curTime = SystemClock.uptimeMillis();
                    }
                    long cachedTime = curTime - lastReqStartTime;
                    StatisContent statContent = new StatisContent();
                    statContent.put("act", "hagoperf");
                    statContent.put("ifield", (int)cachedTime);
                    if (statCalculationTime) {
                        statContent.put("ifieldtwo", (int)(curTime - lastTime));
                    }
                    statContent.put("sfield", "proto");
                    statContent.put("sfieldtwo", "maybeCanPrevent");
                    statContent.put("sfieldthree", compare.serviceName() + "_" + compare.methodName());
                    statContent.put("sfieldfour", String.valueOf(AccountUtil.getUid()));
                    statContent.put("perftype", "net_prevent_duplicate");
                    HiidoStatis.reportContent((StatisContent)statContent);
                    if (SystemUtils.isShowEnvSetting()) {
                        MLog.info((Object)"ProtoPreventDuplicateSender", (String)"hit cache:0, uri:%s, cache is expired, cached timeLength:%d", (Object[])new Object[]{compare.serviceName() + "_" + compare.methodName(), (int)cachedTime});
                    }
                }
            }
        });
        ProtoPreventDuplicateSender.registerNotifys();
        ProtoRequestPreventDuplicateUtil.test();
    }
}

