/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.performancemonitor.perfcollect.network.notify;

import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.unifyconfig.config.NotifyFrequencyConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.env.TargetBuildConstant;
import com.yy.base.utils.SystemUtils;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.notify.INotifyMonitor;
import com.yy.hiyo.proto.notify.NotifyData;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.List;

public class NotifyFrequencyController
implements INotifyMonitor {
    private Runnable configUpdateCommand;
    private Runnable lowMemeryCommand;

    public void init() {
        ProtoManager.setNotifyMonitor((INotifyMonitor)this);
    }

    public void onConfigUpdate() {
        if (this.configUpdateCommand != null) {
            this.configUpdateCommand.run();
        }
    }

    public void onLowMemery() {
        if (this.lowMemeryCommand != null) {
            this.lowMemeryCommand.run();
        }
    }

    private boolean support(String sname) {
        if ("ikxd_gameproxy_d".equals(sname)) {
            return false;
        }
        if (SystemUtils.isShowEnvSetting()) {
            return true;
        }
        return NotifyFrequencyConfig.isTotalSwitchOn();
    }

    public boolean isFrequencyLimitSwitchOn(String sname) {
        if (!this.support(sname)) {
            return false;
        }
        if (NotifyFrequencyConfig.isFrequencyLimitSwitchOn((String)sname)) {
            return true;
        }
        return SystemUtils.isShowEnvSetting();
    }

    public boolean isFrequencyLimitSwitchOn(String sname, int uri) {
        if (!this.support(sname)) {
            return false;
        }
        return NotifyFrequencyConfig.isFrequencyLimitSwitchOn((String)sname, (int)uri);
    }

    public long getFrequencyTime(String sname, int uri) {
        if (!this.support(sname)) {
            return 0L;
        }
        long value = NotifyFrequencyConfig.getFrequencyTime((String)sname, (int)uri);
        if (value <= 0L) {
            if (SystemUtils.isShowEnvSetting()) {
                return 200L;
            }
            return 0L;
        }
        return value;
    }

    public boolean isReplaceable(String sname, int uri) {
        return NotifyFrequencyConfig.isReplaceable((String)sname, (int)uri);
    }

    public boolean canNotifyList(String sname, int uri) {
        if (!this.support(sname)) {
            return false;
        }
        boolean value = NotifyFrequencyConfig.canNotifyList((String)sname, (int)uri);
        if (!value) {
            return SystemUtils.isShowEnvSetting();
        }
        return false;
    }

    public int getForceClearThreshold(String sname, int uri) {
        if (!this.support(sname)) {
            return Integer.MAX_VALUE;
        }
        return NotifyFrequencyConfig.getForceClearThreshold((String)sname, (int)uri);
    }

    public void setConfigUpdateCommand(Runnable command) {
        this.configUpdateCommand = command;
    }

    public void setLowMemeryCommand(Runnable command) {
        this.lowMemeryCommand = command;
    }

    public List<NotifyData> intercept(List<NotifyData> originData) {
        return originData;
    }

    public boolean isNeedStatCacheExceedNumLimit() {
        return NotifyFrequencyConfig.isStatSwitchOn() || SystemUtils.isShowEnvSetting();
    }

    public int getCacheNumLimit(String name) {
        if (SystemUtils.isShowEnvSetting()) {
            return 5;
        }
        return NotifyFrequencyConfig.getCacheExceedLimitNum();
    }

    public void onCacheExceedNumLimit(String name, long cacheNum, List<Integer> uris) {
        if (NotifyFrequencyConfig.isStatSwitchOn() || SystemUtils.isShowEnvSetting()) {
            if (RuntimeContext.sIsAutoTesting || TargetBuildConstant.auto_test || TargetBuildConstant.autoLogin || RuntimeContext.sIsDebuggable) {
                return;
            }
            StatisContent statContent = new StatisContent();
            statContent.put("act", "hagoperf");
            statContent.put("ifield", cacheNum);
            statContent.put("sfield", name);
            statContent.put("sfieldtwo", uris.toString());
            statContent.put("sfieldthree", String.valueOf(AccountUtil.getUid()));
            statContent.put("sfieldfour", RuntimeContext.getChannelId());
            statContent.put("perftype", "notify_frequency_control");
            HiidoStatis.reportContent((StatisContent)statContent);
        }
    }
}

