/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.performancemonitor.perfcollect.network;

import android.os.SystemClock;
import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.proto.IHeartMonitor;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class HeartMonitor {
    private static final int HEART_MONITOR_TIMES_IN_THREEE_MIN = 25;
    private static int hasSendTimes = 0;
    private static long lastCalTime = 0L;
    private static int heartTimeoutNum = -1;

    public static void initHeartMonitor() {
        ProtoManager.setHeartMonitor((IHeartMonitor)new IHeartMonitor(){

            public void beforeSendHeart(long heartTimeGap) {
                YYTaskExecutor.postToMainThread(() -> NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.HEART_BEAT_START, (Object)heartTimeGap)));
                if (SettingFlags.getIntValue((String)"heart_monitor_times_in_three_min", (int)25) <= 15) {
                    return;
                }
                HeartMonitor.monitorHeartSend(heartTimeGap, SettingFlags.getIntValue((String)"heart_monitor_times_in_three_min", (int)25));
            }

            public void onHeartBeatResp(long heartTimeGap, boolean isRetryed) {
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.HEART_BEAT_RESP, (Object)heartTimeGap));
                if (isRetryed) {
                    HeartMonitor.statHeartRetry(true);
                }
            }

            public boolean needRetryWhenError(boolean isRetryed, String reason, int code) {
                if (isRetryed) {
                    HeartMonitor.statHeartRetry(false);
                    return false;
                }
                return SettingFlags.getBoolean((String)"heart_monitor_open_retry", (boolean)true);
            }

            public int getHeartBeatTimeoutNum() {
                if (heartTimeoutNum == -1) {
                    IAB abValue = NewABDefine.HEART_TIMEOUT_NUM.getTest();
                    if (NewABDefine.HEART_TIMEOUT_NUM.isValid()) {
                        if (NAB.A.equals((Object)abValue)) {
                            heartTimeoutNum = 3;
                        } else if (NAB.B.equals((Object)abValue)) {
                            heartTimeoutNum = 3;
                        } else if (NAB.C.equals((Object)abValue)) {
                            heartTimeoutNum = 2;
                        } else if (NAB.D.equals((Object)abValue)) {
                            heartTimeoutNum = 4;
                        } else if (NAB.E.equals((Object)abValue)) {
                            heartTimeoutNum = 1;
                        }
                    }
                }
                return heartTimeoutNum > 0 ? heartTimeoutNum : 3;
            }
        });
    }

    private static void statHeartRetry(boolean success) {
        if (!SettingFlags.getBoolean((String)"heart_monitor_stat_retry", (boolean)true)) {
            return;
        }
        StatisContent statContent = new StatisContent();
        statContent.put("act", "hagoperf");
        statContent.put("ifield", success ? 1 : 0);
        statContent.put("ifieldtwo", RuntimeContext.sIsForeground ? 1 : 0);
        statContent.put("perftype", "heartsendretry");
        HiidoStatis.reportContent((StatisContent)statContent);
    }

    private static void monitorHeartSend(long heartTimeGap, long timesMonitor) {
        if (timesMonitor < 15L) {
            return;
        }
        if (hasSendTimes == 0) {
            lastCalTime = SystemClock.elapsedRealtime();
            ++hasSendTimes;
        } else if ((long)hasSendTimes > timesMonitor) {
            long now = SystemClock.elapsedRealtime();
            if (now - lastCalTime > 0L && now - lastCalTime < 180000L) {
                if (SystemUtils.isShowEnvSetting()) {
                    throw new RuntimeException("find OnlineProto Send Frequency Exception!");
                }
                StatisContent statContent = new StatisContent();
                statContent.put("act", "hagoperf");
                statContent.put("sfield", String.valueOf(heartTimeGap));
                statContent.put("sfieldtwo", RuntimeContext.getChannelId());
                statContent.put("sfieldthree", RuntimeContext.getChannelPluginId());
                if (RuntimeContext.getCoexistenceChannel() != null) {
                    statContent.put("sfieldfour", RuntimeContext.getCoexistenceChannel().getRoomId());
                    statContent.put("sfieldfive", RuntimeContext.getCoexistenceChannel().getChannelPluginId());
                } else {
                    statContent.put("sfieldfour", "");
                    statContent.put("sfieldfive", "");
                }
                statContent.put("perftype", "heartsendmonitor");
                HiidoStatis.reportContent((StatisContent)statContent);
                MLog.error((Object)"PerfCollecter", (String)"find OnlineProto Send Frequency Exception:%s", (Object[])new Object[]{statContent});
            }
            lastCalTime = SystemClock.elapsedRealtime();
            hasSendTimes = 1;
        } else {
            ++hasSendTimes;
        }
    }
}

