/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.performancemonitor.perfcollect.network;

import android.os.SystemClock;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import java.util.ArrayList;

public class ErrorTimesJudger {
    private static final int ERROR_TIMES_TO_TEST = 5;
    private final ArrayList<ErrorItem> mNetErrorItems = new ArrayList(5);

    public void addItem(String url, boolean wsError, long curTime, String errorHost) {
        this.mNetErrorItems.add(ErrorItem.obtain(curTime, url, wsError, errorHost));
    }

    public void deleteItem(String url) {
        ErrorItem find;
        if (this.mNetErrorItems.size() > 0 && (find = this.inErrorList(url)) != null) {
            this.mNetErrorItems.remove(find);
        }
    }

    public boolean isContinuityErrorInTimeGap() {
        long curTime = SystemClock.uptimeMillis();
        int errorTimesToTest = SettingFlags.getIntValue((String)"netdiag_errortimes", (int)5);
        if (errorTimesToTest < 3) {
            errorTimesToTest = 3;
        }
        if (this.mNetErrorItems.size() > errorTimesToTest) {
            this.mNetErrorItems.remove(0);
        }
        if (this.mNetErrorItems.size() >= errorTimesToTest) {
            int timeGap = 120000;
            boolean allInTimeGap = true;
            ErrorItem value = null;
            for (int i = 0; i < errorTimesToTest; ++i) {
                value = this.mNetErrorItems.get(i);
                if (value == null || curTime - value.time <= (long)timeGap) continue;
                allInTimeGap = false;
                this.mNetErrorItems.remove(value);
                break;
            }
            return allInTimeGap;
        }
        return false;
    }

    public boolean isExceedErrorTimesInTimeGap(String errorHost) {
        long curTime = SystemClock.uptimeMillis();
        int errorTimesToTest = SettingFlags.getIntValue((String)"netdiag_errortimes", (int)5);
        if (errorTimesToTest < 3) {
            errorTimesToTest = 3;
        }
        if (this.mNetErrorItems.size() > errorTimesToTest + 5) {
            this.mNetErrorItems.remove(0);
        }
        if (this.mNetErrorItems.size() >= errorTimesToTest) {
            int timeGap = 60000;
            int errorTimes = 0;
            ErrorItem value = null;
            for (int i = 0; i < this.mNetErrorItems.size(); ++i) {
                value = this.mNetErrorItems.get(i);
                if (value == null || !StringUtils.isEmpty((String)errorHost) && !StringUtils.equal((String)errorHost, (String)value.errorHost) || curTime - value.time >= (long)timeGap) continue;
                ++errorTimes;
            }
            return errorTimes >= errorTimesToTest;
        }
        return false;
    }

    public synchronized void clearErrorList() {
        this.mNetErrorItems.clear();
    }

    private synchronized ErrorItem inErrorList(String url) {
        if (StringUtils.isEmpty((String)url)) {
            return null;
        }
        for (ErrorItem item : this.mNetErrorItems) {
            if (!StringUtils.equal((String)item.url, (String)url)) continue;
            return item;
        }
        return null;
    }

    private static class ErrorItem {
        public long time;
        public boolean wsError;
        public String url;
        public String errorHost;

        private ErrorItem() {
        }

        private static ErrorItem obtain(long time, String url, boolean wsError, String errorHost) {
            ErrorItem item = new ErrorItem();
            item.time = time;
            item.url = url;
            item.wsError = wsError;
            if (StringUtils.isNotEmpty((String)errorHost)) {
                item.errorHost = errorHost;
            }
            return item;
        }
    }
}

